/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.base.Enums;
import com.google.common.base.Function;
import forge.StaticData;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.game.player.RegisteredPlayer;
import forge.util.Aggregates;
import forge.util.Localizer;
import java.util.EnumSet;
import java.util.Set;

public enum GameType {
    Sealed(DeckFormat.Limited, true, true, true, "lblSealed", ""),
    Draft(DeckFormat.Limited, true, true, true, "lblDraft", ""),
    Winston(DeckFormat.Limited, true, true, true, "lblWinston", ""),
    Gauntlet(DeckFormat.Constructed, false, true, true, "lblGauntlet", ""),
    Tournament(DeckFormat.Constructed, false, true, true, "lblTournament", ""),
    CommanderGauntlet(DeckFormat.Commander, false, false, false, "lblCommander", "lblCommanderDesc"),
    Quest(DeckFormat.QuestDeck, true, true, false, "lblQuest", ""),
    QuestDraft(DeckFormat.Limited, true, true, true, "lblQuestDraft", ""),
    PlanarConquest(DeckFormat.PlanarConquest, true, false, false, "lblPlanarConquest", ""),
    Adventure(DeckFormat.Adventure, true, false, false, "lblAdventure", ""),
    AdventureEvent(DeckFormat.Limited, true, true, true, "lblAdventure", ""),
    Puzzle(DeckFormat.Puzzle, false, false, false, "lblPuzzle", "lblPuzzleDesc"),
    Constructed(DeckFormat.Constructed, false, true, true, "lblConstructed", ""),
    DeckManager(DeckFormat.Constructed, false, true, true, "lblDeckManager", ""),
    Vanguard(DeckFormat.Vanguard, true, true, true, "lblVanguard", "lblVanguardDesc"),
    Commander(DeckFormat.Commander, false, false, false, "lblCommander", "lblCommanderDesc"),
    Oathbreaker(DeckFormat.Oathbreaker, false, false, false, "lblOathbreaker", "lblOathbreakerDesc"),
    TinyLeaders(DeckFormat.TinyLeaders, false, false, false, "lblTinyLeaders", "lblTinyLeadersDesc"),
    Brawl(DeckFormat.Brawl, false, false, false, "lblBrawl", "lblBrawlDesc"),
    Planeswalker(DeckFormat.PlanarConquest, false, false, true, "lblPlaneswalker", "lblPlaneswalkerDesc"),
    Planechase(DeckFormat.Planechase, false, false, true, "lblPlanechase", "lblPlanechaseDesc"),
    Archenemy(DeckFormat.Archenemy, false, false, true, "lblArchenemy", "lblArchenemyDesc"),
    ArchenemyRumble(DeckFormat.Archenemy, false, false, true, "lblArchenemyRumble", "lblArchenemyRumbleDesc"),
    MomirBasic(DeckFormat.Constructed, false, false, false, "lblMomirBasic", "lblMomirBasicDesc", player -> {
        Deck deck = new Deck();
        CardPool mainDeck = deck.getMain();
        String setcode = Aggregates.random(StaticData.instance().getBlockLands());
        mainDeck.add("Plains", setcode, 12, true);
        mainDeck.add("Island", setcode, 12, true);
        mainDeck.add("Swamp", setcode, 12, true);
        mainDeck.add("Mountain", setcode, 12, true);
        mainDeck.add("Forest", setcode, 12, true);
        deck.getOrCreate(DeckSection.Avatar).add(StaticData.instance().getVariantCards().getCard("Momir Vig, Simic Visionary Avatar"), 1);
        return deck;
    }),
    MoJhoSto(DeckFormat.Constructed, false, false, false, "lblMoJhoSto", "lblMoJhoStoDesc", player -> {
        Deck deck = new Deck();
        CardPool mainDeck = deck.getMain();
        String setcode = Aggregates.random(StaticData.instance().getBlockLands());
        mainDeck.add("Plains", setcode, 12, true);
        mainDeck.add("Island", setcode, 12, true);
        mainDeck.add("Swamp", setcode, 12, true);
        mainDeck.add("Mountain", setcode, 12, true);
        mainDeck.add("Forest", setcode, 12, true);
        deck.getOrCreate(DeckSection.Avatar).add(StaticData.instance().getVariantCards().getCard("Momir Vig, Simic Visionary Avatar"), 1);
        deck.getOrCreate(DeckSection.Avatar).add(StaticData.instance().getVariantCards().getCard("Jhoira of the Ghitu Avatar"), 1);
        deck.getOrCreate(DeckSection.Avatar).add(StaticData.instance().getVariantCards().getCard("Stonehewer Giant Avatar"), 1);
        return deck;
    });

    private final DeckFormat deckFormat;
    private final boolean isCardPoolLimited;
    private final boolean canSideboard;
    private final boolean addWonCardsMidGame;
    private final String name;
    private final String englishName;
    private final String description;
    private final Function<RegisteredPlayer, Deck> deckAutoGenerator;

    private GameType(DeckFormat deckFormat0, boolean isCardPoolLimited0, boolean canSideboard0, boolean addWonCardsMidgame0, String name0, String description0) {
        this(deckFormat0, isCardPoolLimited0, canSideboard0, addWonCardsMidgame0, name0, description0, null);
    }

    private GameType(DeckFormat deckFormat0, boolean isCardPoolLimited0, boolean canSideboard0, boolean addWonCardsMidgame0, String name0, String description0, Function<RegisteredPlayer, Deck> deckAutoGenerator0) {
        Localizer localizer = Localizer.getInstance();
        this.deckFormat = deckFormat0;
        this.isCardPoolLimited = isCardPoolLimited0;
        this.canSideboard = canSideboard0;
        this.addWonCardsMidGame = addWonCardsMidgame0;
        this.name = localizer.getMessage(name0, new Object[0]);
        this.englishName = localizer.getEnglishMessage(name0, new Object[0]);
        if (description0.length() > 0) {
            description0 = localizer.getMessage(description0, new Object[0]);
        }
        this.description = description0;
        this.deckAutoGenerator = deckAutoGenerator0;
    }

    public DeckFormat getDeckFormat() {
        return this.deckFormat;
    }

    public boolean isAutoGenerated() {
        return this.deckAutoGenerator != null;
    }

    public Deck autoGenerateDeck(RegisteredPlayer player) {
        return this.deckAutoGenerator.apply(player);
    }

    public boolean isCardPoolLimited() {
        return this.isCardPoolLimited;
    }

    public boolean isSideboardingAllowed() {
        return this.canSideboard;
    }

    public boolean canAddWonCardsMidGame() {
        return this.addWonCardsMidGame;
    }

    public boolean isCommandZoneNeeded() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String getDescription() {
        return this.description;
    }

    public static GameType smartValueOf(String name) {
        return Enums.getIfPresent(GameType.class, name).orNull();
    }

    public static Set<GameType> listValueOf(String values) {
        EnumSet<GameType> result = EnumSet.noneOf(GameType.class);
        for (String s2 : values.split(",")) {
            GameType g2 = GameType.smartValueOf(s2);
            if (g2 == null) continue;
            result.add(g2);
        }
        return result;
    }
}

