/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Iterables;
import com.google.common.eventbus.Subscribe;
import forge.LobbyPlayer;
import forge.game.GameEntity;
import forge.game.GameLog;
import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.game.GameOutcome;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.event.GameEvent;
import forge.game.event.GameEventAttackersDeclared;
import forge.game.event.GameEventBlockersDeclared;
import forge.game.event.GameEventCardDamaged;
import forge.game.event.GameEventCardModeChosen;
import forge.game.event.GameEventGameOutcome;
import forge.game.event.GameEventLandPlayed;
import forge.game.event.GameEventMulligan;
import forge.game.event.GameEventPlayerControl;
import forge.game.event.GameEventPlayerDamaged;
import forge.game.event.GameEventPlayerPoisoned;
import forge.game.event.GameEventPlayerRadiation;
import forge.game.event.GameEventRandomLog;
import forge.game.event.GameEventScry;
import forge.game.event.GameEventSpellAbilityCast;
import forge.game.event.GameEventSpellResolved;
import forge.game.event.GameEventSurveil;
import forge.game.event.GameEventTurnBegan;
import forge.game.event.GameEventTurnPhase;
import forge.game.event.IGameEventVisitor;
import forge.game.player.Player;
import forge.game.player.RegisteredPlayer;
import forge.game.spellability.TargetChoices;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.maps.MapOfLists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GameLogFormatter
extends IGameEventVisitor.Base<GameLogEntry> {
    private final Localizer localizer = Localizer.getInstance();
    private final GameLog log;

    public GameLogFormatter(GameLog gameLog) {
        this.log = gameLog;
    }

    @Override
    public GameLogEntry visit(GameEventGameOutcome ev) {
        int lastTurn = (int)Math.ceil((double)ev.result.getLastTurnNumber() / 2.0);
        this.log.add(GameLogEntryType.GAME_OUTCOME, this.localizer.getMessage("lblTurn", new Object[0]) + " " + lastTurn);
        for (String outcome : ev.result.getOutcomeStrings()) {
            this.log.add(GameLogEntryType.GAME_OUTCOME, outcome);
        }
        return GameLogFormatter.generateSummary(ev.history);
    }

    @Override
    public GameLogEntry visit(GameEventScry ev) {
        String scryOutcome = "";
        scryOutcome = ev.toTop > 0 && ev.toBottom > 0 ? this.localizer.getMessage("lblLogScryTopBottomLibrary", new Object[0]).replace("%s", ev.player.toString()).replace("%top", String.valueOf(ev.toTop)).replace("%bottom", String.valueOf(ev.toBottom)) : (ev.toBottom == 0 ? this.localizer.getMessage("lblLogScryTopLibrary", new Object[0]).replace("%s", ev.player.toString()).replace("%top", String.valueOf(ev.toTop)) : this.localizer.getMessage("lblLogScryBottomLibrary", new Object[0]).replace("%s", ev.player.toString()).replace("%bottom", String.valueOf(ev.toBottom)));
        return new GameLogEntry(GameLogEntryType.STACK_RESOLVE, scryOutcome);
    }

    @Override
    public GameLogEntry visit(GameEventSurveil ev) {
        String surveilOutcome = "";
        surveilOutcome = ev.toLibrary > 0 && ev.toGraveyard > 0 ? this.localizer.getMessage("lblLogSurveiledToLibraryGraveyard", ev.player.toString(), String.valueOf(ev.toLibrary), String.valueOf(ev.toGraveyard)) : (ev.toGraveyard == 0 ? this.localizer.getMessage("lblLogSurveiledToLibrary", ev.player.toString(), String.valueOf(ev.toLibrary)) : this.localizer.getMessage("lblLogSurveiledToGraveyard", ev.player.toString(), String.valueOf(ev.toGraveyard)));
        return new GameLogEntry(GameLogEntryType.STACK_RESOLVE, surveilOutcome);
    }

    @Override
    public GameLogEntry visit(GameEventSpellResolved ev) {
        String messageForLog = ev.hasFizzled ? this.localizer.getMessage("lblLogCardAbilityFizzles", ev.spell.getHostCard().toString()) : ev.spell.getStackDescription();
        return new GameLogEntry(GameLogEntryType.STACK_RESOLVE, messageForLog);
    }

    @Override
    public GameLogEntry visit(GameEventSpellAbilityCast event) {
        String player = event.sa.getActivatingPlayer().getName();
        String action = event.sa.isSpell() ? this.localizer.getMessage("lblCast", new Object[0]) : (event.sa.isTrigger() ? this.localizer.getMessage("lblTriggered", new Object[0]) : this.localizer.getMessage("lblActivated", new Object[0]));
        String object = event.si.getStackDescription().startsWith("Morph ") ? this.localizer.getMessage("lblMorph", new Object[0]) : event.sa.getHostCard().toString();
        String messageForLog = "";
        if (event.sa.getTargetRestrictions() != null) {
            StringBuilder sb = new StringBuilder();
            for (TargetChoices ch : event.sa.getAllTargetChoices()) {
                if (null == ch) continue;
                sb.append(ch);
            }
            messageForLog = this.localizer.getMessage("lblLogPlayerActionObjectWitchTarget", player, action, object, sb.toString());
        } else {
            messageForLog = this.localizer.getMessage("lblLogPlayerActionObject", player, action, object);
        }
        return new GameLogEntry(GameLogEntryType.STACK_ADD, messageForLog);
    }

    @Override
    public GameLogEntry visit(GameEventCardModeChosen ev) {
        if (!ev.log) {
            return null;
        }
        String modeChoiceOutcome = ev.random ? this.localizer.getMessage("lblLogRandomMode", ev.cardName, ev.mode) : this.localizer.getMessage("lblLogPlayerChosenModeForCard", ev.player.toString(), ev.mode, ev.cardName);
        String name = CardTranslation.getTranslatedName(ev.cardName);
        modeChoiceOutcome = TextUtil.fastReplace(modeChoiceOutcome, "CARDNAME", name);
        modeChoiceOutcome = TextUtil.fastReplace(modeChoiceOutcome, "NICKNAME", Lang.getInstance().getNickName(name));
        return new GameLogEntry(GameLogEntryType.STACK_RESOLVE, modeChoiceOutcome);
    }

    @Override
    public GameLogEntry visit(GameEventRandomLog ev) {
        return new GameLogEntry(GameLogEntryType.STACK_RESOLVE, ev.message);
    }

    private static GameLogEntry generateSummary(Collection<GameOutcome> gamesPlayed) {
        int amount;
        GameOutcome outcome1 = Iterables.getFirst(gamesPlayed, null);
        HashMap<RegisteredPlayer, String> players = outcome1.getPlayerNames();
        HashMap<RegisteredPlayer, Integer> winCount = new HashMap<RegisteredPlayer, Integer>();
        for (GameOutcome game : gamesPlayed) {
            RegisteredPlayer player = game.getWinningPlayer();
            amount = winCount.getOrDefault(player, 0);
            winCount.put(player, amount + 1);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<RegisteredPlayer, String> entry : players.entrySet()) {
            amount = winCount.getOrDefault(entry.getKey(), 0);
            sb.append(entry.getValue()).append(": ").append(amount).append(" ");
        }
        return new GameLogEntry(GameLogEntryType.MATCH_RESULTS, sb.toString());
    }

    @Override
    public GameLogEntry visit(GameEventPlayerControl event) {
        LobbyPlayer newLobbyPlayer = event.newLobbyPlayer;
        Player p = event.player;
        String message = newLobbyPlayer == null ? this.localizer.getMessage("lblLogPlayerHasRestoredControlThemself", p.getName()) : this.localizer.getMessage("lblLogPlayerControlledTargetPlayer", p.getName(), newLobbyPlayer.getName());
        return new GameLogEntry(GameLogEntryType.PLAYER_CONTROL, message);
    }

    @Override
    public GameLogEntry visit(GameEventTurnPhase ev) {
        Player p = ev.playerTurn;
        return new GameLogEntry(GameLogEntryType.PHASE, ev.phaseDesc + Lang.getInstance().getPossessedObject(p.getName(), ev.phase.nameForUi));
    }

    @Override
    public GameLogEntry visit(GameEventCardDamaged event) {
        String additionalLog = "";
        if (event.type == GameEventCardDamaged.DamageType.Deathtouch) {
            additionalLog = this.localizer.getMessage("lblDeathtouch", new Object[0]);
        }
        if (event.type == GameEventCardDamaged.DamageType.M1M1Counters) {
            additionalLog = this.localizer.getMessage("lblAsM1M1Counters", new Object[0]);
        }
        if (event.type == GameEventCardDamaged.DamageType.LoyaltyLoss) {
            additionalLog = this.localizer.getMessage("lblRemovingNLoyaltyCounter", String.valueOf(event.amount));
        }
        String message = this.localizer.getMessage("lblSourceDealsNDamageToDest", event.source.toString(), String.valueOf(event.amount), additionalLog, event.card.toString());
        return new GameLogEntry(GameLogEntryType.DAMAGE, message);
    }

    @Override
    public GameLogEntry visit(GameEventLandPlayed ev) {
        String message = this.localizer.getMessage("lblLogPlayerPlayedLand", ev.player.toString(), ev.land.toString());
        return new GameLogEntry(GameLogEntryType.LAND, message);
    }

    @Override
    public GameLogEntry visit(GameEventTurnBegan event) {
        String message = this.localizer.getMessage("lblLogTurnNOwnerByPlayer", String.valueOf(event.turnNumber), event.turnOwner.toString());
        return new GameLogEntry(GameLogEntryType.TURN, message);
    }

    @Override
    public GameLogEntry visit(GameEventPlayerDamaged ev) {
        String extra = ev.infect ? this.localizer.getMessage("lblLogAsPoisonCounters", new Object[0]) : "";
        String damageType = ev.combat ? this.localizer.getMessage("lblCombat", new Object[0]) : this.localizer.getMessage("lblNonCombat", new Object[0]);
        String message = this.localizer.getMessage("lblLogSourceDealsNDamageOfTypeToDest", ev.source.toString(), String.valueOf(ev.amount), damageType, ev.target.toString(), extra);
        return new GameLogEntry(GameLogEntryType.DAMAGE, message);
    }

    @Override
    public GameLogEntry visit(GameEventPlayerPoisoned ev) {
        String message = this.localizer.getMessage("lblLogPlayerReceivesNPosionCounterFrom", ev.receiver.toString(), String.valueOf(ev.amount), ev.source.toString());
        return new GameLogEntry(GameLogEntryType.DAMAGE, message);
    }

    @Override
    public GameLogEntry visit(GameEventPlayerRadiation ev) {
        int change = ev.change;
        String radCtr = CounterEnumType.RAD.getName().toLowerCase() + " " + Localizer.getInstance().getMessage("lblCounter", new Object[0]).toLowerCase();
        String message = change >= 0 ? this.localizer.getMessage("lblLogPlayerRadiation", ev.receiver.toString(), Lang.nounWithNumeralExceptOne(String.valueOf(change), radCtr), ev.source.toString()) : this.localizer.getMessage("lblLogPlayerRadRemove", ev.receiver.toString(), Lang.nounWithNumeralExceptOne(String.valueOf(Math.abs(change)), radCtr));
        return new GameLogEntry(GameLogEntryType.DAMAGE, message);
    }

    @Override
    public GameLogEntry visit(GameEventAttackersDeclared ev) {
        StringBuilder sb = new StringBuilder();
        for (GameEntity k : ev.attackersMap.keySet()) {
            Collection<Card> attackers = ev.attackersMap.get(k);
            if (attackers == null || attackers.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(this.localizer.getMessage("lblLogPlayerAssignedAttackerToAttackTarget", ev.player, Lang.joinHomogenous(attackers), k));
        }
        if (sb.length() == 0) {
            sb.append(this.localizer.getMessage("lblPlayerDidntAttackThisTurn", new Object[0]).replace("%s", ev.player.toString()));
        }
        return new GameLogEntry(GameLogEntryType.COMBAT, sb.toString());
    }

    @Override
    public GameLogEntry visit(GameEventBlockersDeclared ev) {
        StringBuilder sb = new StringBuilder();
        Collection blockers = null;
        for (Map.Entry<GameEntity, MapOfLists<Card, Card>> kv : ev.blockers.entrySet()) {
            Card c;
            GameEntity defender = kv.getKey();
            MapOfLists<Card, Card> attackers = kv.getValue();
            if (attackers == null || attackers.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            String controllerName = defender instanceof Card ? ((c = (Card)defender).isBattle() ? c.getProtectingPlayer().getName() : c.getController().getName()) : defender.getName();
            boolean firstAttacker = true;
            for (Map.Entry att : attackers.entrySet()) {
                if (!firstAttacker) {
                    sb.append("\n");
                }
                if ((blockers = (Collection)att.getValue()).isEmpty()) {
                    sb.append(this.localizer.getMessage("lblLogPlayerDidntBlockAttacker", controllerName, att.getKey()));
                } else {
                    sb.append(this.localizer.getMessage("lblLogPlayerAssignedBlockerToBlockAttacker", controllerName, Lang.joinHomogenous(blockers), att.getKey()));
                }
                firstAttacker = false;
            }
        }
        return new GameLogEntry(GameLogEntryType.COMBAT, sb.toString());
    }

    @Override
    public GameLogEntry visit(GameEventMulligan ev) {
        String message = this.localizer.getMessage("lblPlayerHasMulliganedDownToNCards", new Object[0]).replace("%d", String.valueOf(ev.player.getZone(ZoneType.Hand).size())).replace("%s", ev.player.toString());
        return new GameLogEntry(GameLogEntryType.MULLIGAN, message);
    }

    @Subscribe
    public void recieve(GameEvent ev) {
        GameLogEntry le = ev.visit(this);
        if (le != null) {
            this.log.add(le);
        }
    }
}

