/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.game.GameLogFormatter;
import forge.game.event.IGameEventVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class GameLog
extends Observable
implements Serializable {
    private static final long serialVersionUID = 6465283802022948827L;
    private final List<GameLogEntry> log = new ArrayList<GameLogEntry>();
    private final transient GameLogFormatter formatter = new GameLogFormatter(this);
    private final boolean quiet = false;

    public void add(GameLogEntryType type, String message) {
        this.add(new GameLogEntry(type, message));
    }

    void add(GameLogEntry entry) {
        this.log.add(entry);
        this.setChanged();
        this.notifyObservers();
    }

    public List<GameLogEntry> getLogEntries(GameLogEntryType logLevel) {
        ArrayList<GameLogEntry> result = new ArrayList<GameLogEntry>();
        for (int i = this.log.size() - 1; i >= 0; --i) {
            GameLogEntry le = this.log.get(i);
            if (logLevel != null && le.type.compareTo(logLevel) > 0) continue;
            result.add(le);
        }
        return result;
    }

    public List<GameLogEntry> getLogEntriesExact(GameLogEntryType logLevel) {
        ArrayList<GameLogEntry> result = new ArrayList<GameLogEntry>();
        for (int i = this.log.size() - 1; i >= 0; --i) {
            GameLogEntry le = this.log.get(i);
            if (logLevel != null && le.type.compareTo(logLevel) != 0) continue;
            result.add(le);
        }
        return result;
    }

    public IGameEventVisitor<?> getEventVisitor() {
        return this.formatter;
    }
}

