/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import forge.game.GameEntity;
import forge.game.GameEntityView;
import forge.trackable.TrackableCollection;
import java.util.List;
import java.util.Map;

public class GameEntityViewMap<Entity extends GameEntity, View extends GameEntityView>
extends ForwardingMap<View, Entity> {
    private Map<View, Entity> dataMap = Maps.newLinkedHashMap();

    @Override
    protected Map<View, Entity> delegate() {
        return this.dataMap;
    }

    public void put(Entity e) {
        this.put(((GameEntity)e).getView(), e);
    }

    public void putAll(Iterable<Entity> entities) {
        for (GameEntity e : entities) {
            this.put(e);
        }
    }

    @Override
    public void remove(Entity e) {
        this.remove(((GameEntity)e).getView());
    }

    public void removeAll(Iterable<Entity> entities) {
        for (GameEntity e : entities) {
            this.remove((Entity)e);
        }
    }

    public List<Entity> addToList(Iterable<View> views, List<Entity> list) {
        if (views == null) {
            return list;
        }
        for (GameEntityView view : views) {
            GameEntity entity = (GameEntity)this.get(view);
            if (entity == null) continue;
            list.add(entity);
        }
        return list;
    }

    public TrackableCollection<View> getTrackableKeys() {
        return new TrackableCollection(this.keySet());
    }
}

