/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.base.Optional;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class GameEntityCounterTable
extends ForwardingTable<Optional<Player>, GameEntity, Map<CounterType, Integer>> {
    private Table<Optional<Player>, GameEntity, Map<CounterType, Integer>> dataMap = HashBasedTable.create();

    public GameEntityCounterTable() {
    }

    public GameEntityCounterTable(Table<Optional<Player>, GameEntity, Map<CounterType, Integer>> counterTable) {
        this.putAll(counterTable);
    }

    @Override
    protected Table<Optional<Player>, GameEntity, Map<CounterType, Integer>> delegate() {
        return this.dataMap;
    }

    public Integer put(Player putter, GameEntity object, CounterType type, Integer value) {
        Optional<Player> o = Optional.fromNullable(putter);
        HashMap<CounterType, Integer> map = (HashMap<CounterType, Integer>)this.get(o, object);
        if (map == null) {
            map = Maps.newHashMap();
            this.put(o, object, map);
        }
        return map.put(type, ObjectUtils.firstNonNull((Integer)map.get(type), 0) + value);
    }

    public int get(Player putter, GameEntity object, CounterType type) {
        Optional<Player> o = Optional.fromNullable(putter);
        Map map = (Map)this.get(o, object);
        if (map == null || !map.containsKey(type)) {
            return 0;
        }
        return ObjectUtils.firstNonNull((Integer)map.get(type), 0);
    }

    public int totalValues() {
        int result = 0;
        for (Map m4 : this.values()) {
            for (Integer i : m4.values()) {
                result += i.intValue();
            }
        }
        return result;
    }

    public Map<CounterType, Integer> filterToRemove(GameEntity ge) {
        HashMap<CounterType, Integer> result = Maps.newHashMap();
        if (!this.containsColumn(ge)) {
            result.putAll(ge.getCounters());
            return result;
        }
        Map alreadyRemoved = (Map)this.column(ge).get(Optional.absent());
        for (Map.Entry<CounterType, Integer> e : ge.getCounters().entrySet()) {
            int rest = e.getValue() - alreadyRemoved.getOrDefault(e.getKey(), 0);
            if (rest <= 0) continue;
            result.put(e.getKey(), rest);
        }
        return result;
    }

    public Map<GameEntity, Integer> filterTable(CounterType type, String valid, Card host, CardTraitBase sa) {
        HashMap<GameEntity, Integer> result = Maps.newHashMap();
        for (Map.Entry gm : this.columnMap().entrySet()) {
            if (!((GameEntity)gm.getKey()).isValid(valid, host.getController(), host, sa)) continue;
            for (Map cm : gm.getValue().values()) {
                Integer old = ObjectUtils.firstNonNull((Integer)result.get(gm.getKey()), 0);
                Integer v = ObjectUtils.firstNonNull((Integer)cm.get(type), 0);
                if (old + v <= 0) continue;
                result.put((GameEntity)gm.getKey(), old + v);
            }
        }
        return result;
    }

    public void triggerCountersPutAll(Game game) {
        if (this.isEmpty()) {
            return;
        }
        for (Table.Cell c : this.cellSet()) {
            if (((Map)c.getValue()).isEmpty()) continue;
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Source, ((Optional)c.getRowKey()).get());
            runParams.put(AbilityKey.Object, c.getColumnKey());
            runParams.put(AbilityKey.CounterMap, c.getValue());
            game.getTriggerHandler().runTrigger(TriggerType.CounterPlayerAddedAll, runParams, false);
        }
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Objects, this);
        game.getTriggerHandler().runTrigger(TriggerType.CounterAddedAll, runParams, false);
    }

    public void replaceCounterEffect(Game game, SpellAbility cause, boolean effect) {
        this.replaceCounterEffect(game, cause, effect, false, null);
    }

    public boolean replaceCounterEffect(Game game, SpellAbility cause, boolean effect, boolean etb, Map<AbilityKey, Object> params) {
        if (this.isEmpty()) {
            return false;
        }
        GameEntityCounterTable result = new GameEntityCounterTable();
        block4: for (Map.Entry gm : this.columnMap().entrySet()) {
            Map values = gm.getValue();
            if (!etb) {
                Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected((GameEntity)gm.getKey());
                repParams.put(AbilityKey.Cause, cause);
                repParams.put(AbilityKey.EffectOnly, effect);
                repParams.put(AbilityKey.CounterMap, values);
                repParams.put(AbilityKey.ETB, etb);
                if (params != null) {
                    repParams.putAll(params);
                }
                switch (game.getReplacementHandler().run(ReplacementType.AddCounter, repParams)) {
                    case NotReplaced: {
                        break;
                    }
                    case Updated: {
                        values = (Map)repParams.get((Object)AbilityKey.CounterMap);
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cause, cause);
            if (params != null) {
                runParams.putAll(params);
            }
            for (Map.Entry e : values.entrySet()) {
                boolean remember = cause != null && cause.hasParam("RememberPut");
                for (Map.Entry ec : ((Map)e.getValue()).entrySet()) {
                    Integer value = (Integer)ec.getValue();
                    if (value == null) continue;
                    if (cause != null && cause.hasParam("MaxFromEffect")) {
                        value = Math.min(value, Integer.parseInt(cause.getParam("MaxFromEffect")) - ((GameEntity)gm.getKey()).getCounters((CounterType)ec.getKey()));
                    }
                    ((GameEntity)gm.getKey()).addCounterInternal((CounterType)ec.getKey(), (int)value, (Player)((Optional)e.getKey()).orNull(), true, result, runParams);
                    if (!remember || (Integer)ec.getValue() < 1) continue;
                    cause.getHostCard().addRemembered((GameEntity)gm.getKey());
                }
            }
        }
        result.triggerCountersPutAll(game);
        return !result.isEmpty();
    }
}

