/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.card.GamePieceType;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardPlayOption;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostPayment;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.AlternativeCost;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityAlternativeCost;
import forge.game.staticability.StaticAbilityLayer;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class GameActionUtil {
    private GameActionUtil() {
        throw new AssertionError();
    }

    public static List<SpellAbility> getAlternativeCosts(SpellAbility sa, Player activator, boolean altCostOnly) {
        ArrayList<SpellAbility> alternatives = Lists.newArrayList();
        Card source = sa.getHostCard();
        Game game = source.getGame();
        if (sa.isSpell() && source.isInPlay()) {
            return alternatives;
        }
        if (sa.isSpell() || sa.isLandAbility()) {
            boolean lkicheck = false;
            Card newHost = sa.getAlternateHost(source);
            if (newHost != null) {
                source = newHost;
                lkicheck = true;
            }
            if (lkicheck) {
                game.getTracker().freeze();
                source.clearStaticChangedCardKeywords(false);
                Iterator<KeywordInterface> preList = new CardCollection(source);
                game.getAction().checkStaticAbilities(false, (Set<Card>)Sets.newHashSet(source), (CardCollectionView)((Object)preList));
            }
            if (sa.isBasicSpell()) {
                for (SpellAbility newSA : StaticAbilityAlternativeCost.alternativeCosts(sa, source, activator)) {
                    alternatives.add(newSA);
                    alternatives.addAll(GameActionUtil.getMayPlaySpellOptions(newSA, source, activator, altCostOnly));
                }
            }
            alternatives.addAll(GameActionUtil.getMayPlaySpellOptions(sa, source, activator, altCostOnly));
            if (sa.isBasicSpell()) {
                for (KeywordInterface inst : source.getKeywords()) {
                    String[] k;
                    String keyword = inst.getOriginal();
                    if (keyword.startsWith("Escape")) {
                        if (!source.isInZone(ZoneType.Graveyard)) continue;
                        String[] k2 = keyword.split(":");
                        Cost escapeCost = new Cost(k2[1], true);
                        SpellAbility newSA = sa.copyWithManaCostReplaced(activator, escapeCost);
                        newSA.putParam("PrecostDesc", "Escape\u2014");
                        newSA.putParam("CostDesc", escapeCost.toString());
                        StringBuilder desc = new StringBuilder();
                        desc.append(newSA.getCostDescription());
                        desc.append("(").append(inst.getReminderText()).append(")");
                        newSA.setDescription(desc.toString());
                        newSA.putParam("AfterDescription", "(Escaped)");
                        newSA.setAlternativeCost(AlternativeCost.Escape);
                        newSA.getRestrictions().setZone(ZoneType.Graveyard);
                        newSA.setIntrinsic(inst.isIntrinsic());
                        alternatives.add(newSA);
                        continue;
                    }
                    if (keyword.startsWith("Flashback")) {
                        if (!source.isInZone(ZoneType.Graveyard) || keyword.equals("Flashback") && source.getManaCost().isNoCost()) continue;
                        SpellAbility flashback = null;
                        if (keyword.contains(":")) {
                            String extraParams;
                            k = keyword.split(":");
                            flashback = sa.copyWithManaCostReplaced(activator, new Cost(k[1], false));
                            String string = extraParams = k.length > 2 ? k[2] : "";
                            if (!extraParams.isEmpty()) {
                                for (Map.Entry<String, String> param : AbilityFactory.getMapParams(extraParams).entrySet()) {
                                    flashback.putParam(param.getKey(), param.getValue());
                                }
                            }
                        } else {
                            flashback = sa.copy(activator);
                        }
                        flashback.setAlternativeCost(AlternativeCost.Flashback);
                        flashback.getRestrictions().setZone(ZoneType.Graveyard);
                        flashback.setKeyword(inst);
                        flashback.setIntrinsic(inst.isIntrinsic());
                        alternatives.add(flashback);
                        continue;
                    }
                    if (!keyword.startsWith("Foretell") || !source.isInZone(ZoneType.Exile) || !source.isForetold() || source.enteredThisTurn() || !activator.equals(source.getOwner()) || keyword.equals("Foretell")) continue;
                    SpellAbility foretold = sa.copy(activator);
                    foretold.setAlternativeCost(AlternativeCost.Foretold);
                    foretold.getRestrictions().setZone(ZoneType.Exile);
                    foretold.putParam("AfterDescription", "(Foretold)");
                    k = keyword.split(":");
                    foretold.setPayCosts(new Cost(k[1], false));
                    alternatives.add(foretold);
                }
                if (source.isForetoldCostByEffect() && source.isInZone(ZoneType.Exile) && activator.equals(source.getOwner()) && source.isForetold() && !source.enteredThisTurn() && !source.getManaCost().isNoCost()) {
                    SpellAbility foretold = sa.copy(activator);
                    int reduced = Math.min(2, sa.getPayCosts().getCostMana().getMana().getGenericCost());
                    foretold.putParam("ReduceCost", Integer.toString(reduced));
                    foretold.setAlternativeCost(AlternativeCost.Foretold);
                    foretold.getRestrictions().setZone(ZoneType.Exile);
                    foretold.putParam("AfterDescription", "(Foretold)");
                    alternatives.add(foretold);
                }
                if (activator.canCastSorcery() && source.isPlotted() && source.isInZone(ZoneType.Exile) && activator.equals(source.getOwner()) && !source.enteredThisTurn()) {
                    SpellAbility plotted = sa.copyWithNoManaCost(activator);
                    plotted.setAlternativeCost(AlternativeCost.Plotted);
                    plotted.getRestrictions().setZone(ZoneType.Exile);
                    plotted.putParam("AfterDescription", "(Plotted)");
                    alternatives.add(plotted);
                }
                if (game.getAction().hasStaticAbilityAffectingZone(ZoneType.Stack, StaticAbilityLayer.ABILITIES)) {
                    Map<StaticAbility, CardPlayOption> oldMayPlay = source.getMayPlay();
                    Zone oldZone = source.getLastKnownZone();
                    Card stackCopy = source;
                    if (!source.isLKI()) {
                        stackCopy = CardCopyService.getLKICopy(source);
                    }
                    stackCopy.setLastKnownZone(game.getStackZone());
                    stackCopy.setCastFrom(oldZone);
                    lkicheck = true;
                    stackCopy.clearStaticChangedCardKeywords(false);
                    CardCollection preList = new CardCollection(stackCopy);
                    game.getAction().checkStaticAbilities(false, Sets.newHashSet(stackCopy), preList);
                    stackCopy.setMayPlay(oldMayPlay);
                    for (KeywordInterface inst : stackCopy.getUnhiddenKeywords()) {
                        for (SpellAbility iSa : inst.getAbilities()) {
                            if (!iSa.isSpell() || iSa.isIntrinsic()) continue;
                            alternatives.add(iSa);
                            alternatives.addAll(GameActionUtil.getMayPlaySpellOptions(iSa, stackCopy, activator, altCostOnly));
                        }
                    }
                    stackCopy.setLastKnownZone(oldZone);
                }
            }
            if (lkicheck) {
                game.getAction().checkStaticAbilities(false);
                game.getTracker().clearDelayed();
                game.getTracker().unfreeze();
            }
        } else {
            if (sa.isManaAbility() && sa.isActivatedAbility() && activator.hasKeyword("Piracy") && source.isLand() && source.isInPlay() && !activator.equals(source.getController()) && sa.getPayCosts().hasTapCost()) {
                SpellAbility newSA = sa.copy(activator);
                newSA.getRestrictions().setActivator("Player");
                for (AbilityManaPart mp : newSA.getAllManaParts()) {
                    mp.setExtraManaRestriction("Spell");
                }
                alternatives.add(newSA);
            }
            alternatives.addAll(StaticAbilityAlternativeCost.alternativeCosts(sa, source, activator));
        }
        return alternatives;
    }

    public static List<SpellAbility> getMayPlaySpellOptions(SpellAbility sa, Card source, Player activator, boolean altCostOnly) {
        ArrayList<SpellAbility> alternatives = Lists.newArrayList();
        if (sa.isSpell() && source.isInPlay()) {
            return alternatives;
        }
        for (CardPlayOption o : source.mayPlay(activator)) {
            if (o.getAbility().hasParam("MayPlayNotSorcerySpeed") && activator.canCastSorcery() || (!sa.isBasicSpell() || sa.costHasManaX() && sa.getPayCosts().getCostMana() != null && sa.getPayCosts().getCostMana().getXMin() > 0) && o.getPayManaCost() == CardPlayOption.PayManaCost.NO) continue;
            Card host = o.getHost();
            SpellAbility newSA = null;
            if (o.getPayManaCost() == CardPlayOption.PayManaCost.NO) {
                newSA = sa.copyWithNoManaCost(activator);
                newSA.setBasicSpell(false);
            } else if (o.getAltManaCost() != null) {
                newSA = sa.copyWithManaCostReplaced(activator, o.getAltManaCost());
                newSA.setBasicSpell(false);
            } else {
                if (altCostOnly) continue;
                newSA = sa.copy(activator);
            }
            if (o.getAbility().hasParam("ValidAfterStack")) {
                newSA.getMapParams().put("ValidAfterStack", o.getAbility().getParam("ValidAfterStack"));
            }
            if (o.getAbility().hasParam("RaiseCost")) {
                String raise = o.getAbility().getParam("RaiseCost");
                if (o.getAbility().hasSVar(raise)) {
                    raise = Integer.toString(AbilityUtils.calculateAmount(host, raise, o.getAbility()));
                }
                newSA.getMapParams().put("RaiseCost", raise);
            }
            SpellAbilityRestriction sar = newSA.getRestrictions();
            if (o.isWithFlash()) {
                sar.setInstantSpeed(true);
            }
            sar.setZone(null);
            newSA.setMayPlay(o);
            StringBuilder sb = new StringBuilder(sa.getDescription());
            if (!source.equals(host) && host.getCardForUi() != null) {
                sb.append(" by ");
                if (host.isImmutable() && host.getEffectSource() != null) {
                    sb.append(host.getEffectSource());
                } else {
                    sb.append(host);
                }
            }
            if (o.getAbility().hasParam("MayPlayText")) {
                sb.append(" (").append(o.getAbility().getParam("MayPlayText")).append(")");
            }
            sb.append(o.toString(false));
            newSA.setDescription(sb.toString());
            alternatives.add(newSA);
        }
        return alternatives;
    }

    public static List<OptionalCostValue> getOptionalCostValues(SpellAbility sa) {
        ArrayList<OptionalCostValue> costs = Lists.newArrayList();
        if (sa == null || !sa.isSpell()) {
            return costs;
        }
        sa.clearPipsToReduce();
        Card source = sa.getHostCard();
        Game game = source.getGame();
        boolean lkicheck = false;
        Card newHost = ((Spell)sa).getAlternateHost(source);
        if (newHost != null) {
            source = newHost;
            lkicheck = true;
        }
        if (lkicheck) {
            game.getTracker().freeze();
            source.clearStaticChangedCardKeywords(false);
            CardCollection preList = new CardCollection(source);
            game.getAction().checkStaticAbilities(false, Sets.newHashSet(source), preList);
        }
        CardCollection costSources = new CardCollection(source);
        costSources.addAll(game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        for (Card ca : costSources) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions("OptionalCost") || !stAb.matchesValidParam("ValidCard", source) || !stAb.matchesValidParam("ValidSA", sa) || !stAb.matchesValidParam("Activator", sa.getActivatingPlayer())) continue;
                Cost cost = new Cost(stAb.getParam("Cost"), false);
                if (stAb.hasParam("ReduceColor")) {
                    if (stAb.getParam("ReduceColor").equals("W")) {
                        costs.add(new OptionalCostValue(OptionalCost.ReduceW, cost));
                        continue;
                    }
                    if (stAb.getParam("ReduceColor").equals("U")) {
                        costs.add(new OptionalCostValue(OptionalCost.ReduceU, cost));
                        continue;
                    }
                    if (stAb.getParam("ReduceColor").equals("B")) {
                        costs.add(new OptionalCostValue(OptionalCost.ReduceB, cost));
                        continue;
                    }
                    if (stAb.getParam("ReduceColor").equals("R")) {
                        costs.add(new OptionalCostValue(OptionalCost.ReduceR, cost));
                        continue;
                    }
                    if (!stAb.getParam("ReduceColor").equals("G")) continue;
                    costs.add(new OptionalCostValue(OptionalCost.ReduceG, cost));
                    continue;
                }
                costs.add(new OptionalCostValue(OptionalCost.Generic, cost));
            }
        }
        for (KeywordInterface inst : source.getKeywords()) {
            String[] k;
            Cost cost;
            String keyword = inst.getOriginal();
            if (keyword.equals("Bargain")) {
                cost = new Cost("Sac<1/Artifact;Enchantment;Card.token/artifact, enchantment or token>", false);
                costs.add(new OptionalCostValue(OptionalCost.Bargain, cost));
                continue;
            }
            if (keyword.startsWith("Buyback")) {
                cost = new Cost(keyword.substring(8), false);
                costs.add(new OptionalCostValue(OptionalCost.Buyback, cost));
                continue;
            }
            if (keyword.startsWith("Entwine")) {
                k = keyword.split(":");
                Cost cost2 = new Cost(k[1], false);
                costs.add(new OptionalCostValue(OptionalCost.Entwine, cost2));
                continue;
            }
            if (keyword.startsWith("Gift")) {
                cost = new Cost("PromiseGift", false);
                costs.add(new OptionalCostValue(OptionalCost.PromiseGift, cost));
                continue;
            }
            if (keyword.startsWith("Kicker")) {
                String[] sCosts = TextUtil.split(keyword.substring(6), ':');
                int numKickers = sCosts.length;
                for (int j = 0; j < numKickers; ++j) {
                    Cost cost3 = new Cost(sCosts[j], false);
                    OptionalCost type = null;
                    type = j == 0 ? OptionalCost.Kicker1 : OptionalCost.Kicker2;
                    costs.add(new OptionalCostValue(type, cost3));
                }
                continue;
            }
            if (keyword.equals("Retrace")) {
                if (!source.isInZone(ZoneType.Graveyard)) continue;
                cost = new Cost("Discard<1/Land>", false);
                costs.add(new OptionalCostValue(OptionalCost.Retrace, cost));
                continue;
            }
            if (keyword.equals("Jump-start")) {
                if (!source.isInZone(ZoneType.Graveyard)) continue;
                cost = new Cost("Discard<1/Card>", false);
                costs.add(new OptionalCostValue(OptionalCost.Jumpstart, cost));
                continue;
            }
            if (!keyword.startsWith("MayFlashCost")) continue;
            k = keyword.split(":");
            Cost cost4 = new Cost(k[1], false);
            costs.add(new OptionalCostValue(OptionalCost.Flash, cost4));
        }
        if (lkicheck) {
            game.getAction().checkStaticAbilities(false);
            game.getTracker().clearDelayed();
            game.getTracker().unfreeze();
        }
        return costs;
    }

    public static SpellAbility addOptionalCosts(SpellAbility sa, List<OptionalCostValue> list) {
        if (sa == null || list.isEmpty()) {
            return sa;
        }
        SpellAbility result = sa.copy();
        if (sa.hasParam("ReduceCost")) {
            result.putParam("ReduceCost", sa.getParam("ReduceCost"));
        }
        if (sa.hasParam("RaiseCost")) {
            result.putParam("RaiseCost", sa.getParam("RaiseCost"));
        }
        for (OptionalCostValue v : list) {
            result.getPayCosts().add(v.getCost());
            result.addOptionalCost(v.getType());
            switch (v.getType()) {
                case Retrace: 
                case Jumpstart: {
                    result.getRestrictions().setZone(ZoneType.Graveyard);
                    break;
                }
                case Flash: {
                    result.getRestrictions().setInstantSpeed(true);
                    break;
                }
            }
        }
        return result;
    }

    public static List<SpellAbility> getAdditionalCostSpell(SpellAbility sa) {
        ArrayList<SpellAbility> abilities = Lists.newArrayList(sa);
        if (sa.isSpell()) {
            Card source = sa.getHostCard();
            for (KeywordInterface inst : source.getKeywords()) {
                String keyword = inst.getOriginal();
                if (!keyword.startsWith("AlternateAdditionalCost")) continue;
                abilities.clear();
                for (String s2 : keyword.split(":", 2)[1].split(":")) {
                    SpellAbility newSA = sa.copy();
                    newSA.setBasicSpell(false);
                    Cost cost = new Cost(s2, false);
                    newSA.setDescription(sa.getDescription() + " (Additional cost: " + cost.toSimpleString() + ")");
                    newSA.setPayCosts(cost.add(sa.getPayCosts()));
                    if (!newSA.canPlay()) continue;
                    abilities.add(newSA);
                }
            }
        } else if (sa.isActivatedAbility() && sa.hasParam("AlternateCost")) {
            abilities.clear();
            SpellAbility newSA = sa.copy();
            newSA.removeParam("AlternateCost");
            newSA.rebuiltDescription();
            if (newSA.canPlay()) {
                abilities.add(newSA);
            }
            Cost alternateCost = new Cost(sa.getParam("AlternateCost"), sa.isAbility());
            SpellAbility newSA2 = sa.copyWithDefinedCost(alternateCost);
            newSA2.removeParam("AlternateCost");
            newSA2.rebuiltDescription();
            if (newSA2.canPlay()) {
                abilities.add(newSA2);
            }
        }
        return abilities;
    }

    public static SpellAbility addExtraKeywordCost(SpellAbility sa) {
        String str;
        Cost cost;
        int v;
        if (!sa.isSpell() || sa.isCopied()) {
            return sa;
        }
        SpellAbility result = null;
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Player activator = sa.getActivatingPlayer();
        PlayerController pc = activator.getController();
        game.getAction().checkStaticAbilities(false);
        boolean reset = false;
        for (KeywordInterface ki : host.getKeywords()) {
            int i;
            String costStr;
            String str2;
            Cost cost2;
            String o = ki.getOriginal();
            if (o.startsWith("Casualty")) {
                String casualtyCost;
                String n = o.split(":")[1];
                if (host.wasCast() && n.equals("X")) {
                    CardCollection creatures = activator.getCreaturesInPlay();
                    int max = Aggregates.max(creatures, Card::getNetPower);
                    n = Integer.toString(pc.chooseNumber(sa, "Choose X for Casualty", 0, max));
                }
                if ((v = pc.addKeywordCost(sa, cost = new Cost(casualtyCost = "Sac<1/Creature.powerGE" + n + "/creature with power " + n + " or greater>", false), ki, str = "Pay for Casualty? " + cost.toSimpleString())) == 0) continue;
                if (result == null) {
                    result = sa.copy();
                }
                result.getPayCosts().add(cost);
                reset = true;
                result.setOptionalKeywordAmount(ki, Integer.parseInt(n));
                continue;
            }
            if (o.equals("Conspire")) {
                String conspireCost = "tapXType<2/Creature.SharesColorWith/creature that shares a color with " + host.getName() + ">";
                cost2 = new Cost(conspireCost, false);
                if (!pc.addKeywordCost(sa, cost2, ki, str2 = "Pay for Conspire? " + cost2.toSimpleString())) continue;
                if (result == null) {
                    result = sa.copy();
                }
                result.getPayCosts().add(cost2);
                result.setOptionalKeywordAmount(ki, 1);
                reset = true;
                continue;
            }
            if (o.startsWith("Multikicker")) {
                costStr = o.split(":")[1];
                cost2 = new Cost(costStr, false);
                str2 = "Choose Amount for Multikicker: " + cost2.toSimpleString();
                int v2 = pc.chooseNumberForKeywordCost(sa, cost2, ki, str2, Integer.MAX_VALUE);
                for (i = 0; i < v2; ++i) {
                    if (result == null) {
                        result = sa.copy();
                    }
                    result.getPayCosts().add(cost2);
                    reset = true;
                }
                if (result == null) continue;
                result.setOptionalKeywordAmount(ki, v2);
                continue;
            }
            if (o.startsWith("Offspring")) {
                String[] k = o.split(":");
                cost2 = new Cost(k[1], false);
                boolean v3 = pc.addKeywordCost(sa, cost2, ki, str2 = "Pay for Offspring? " + cost2.toSimpleString());
                if (!v3) continue;
                if (result == null) {
                    result = sa.copy();
                }
                result.getPayCosts().add(cost2);
                reset = true;
                result.setOptionalKeywordAmount(ki, 1);
                continue;
            }
            if (o.startsWith("Replicate")) {
                costStr = o.split(":")[1];
                cost2 = new Cost(costStr, false);
                str2 = "Choose Amount for Replicate: " + cost2.toSimpleString();
                int v4 = pc.chooseNumberForKeywordCost(sa, cost2, ki, str2, Integer.MAX_VALUE);
                for (i = 0; i < v4; ++i) {
                    if (result == null) {
                        result = sa.copy();
                    }
                    result.getPayCosts().add(cost2);
                    reset = true;
                }
                if (result == null) continue;
                result.setOptionalKeywordAmount(ki, v4);
                continue;
            }
            if (!o.startsWith("Squad")) continue;
            costStr = o.split(":")[1];
            cost2 = new Cost(costStr, false);
            str2 = "Choose amount for Squad: " + cost2.toSimpleString();
            int v5 = pc.chooseNumberForKeywordCost(sa, cost2, ki, str2, Integer.MAX_VALUE);
            for (i = 0; i < v5; ++i) {
                if (result == null) {
                    result = sa.copy();
                }
                result.getPayCosts().add(cost2);
                reset = true;
            }
            if (result == null) continue;
            result.setOptionalKeywordAmount(ki, v5);
        }
        if (host.isCreature()) {
            String kw = "As an additional cost to cast creature spells, you may pay any amount of mana. If you do, that creature enters with that many additional +1/+1 counters on it.";
            for (Card c : activator.getZone(ZoneType.Battlefield)) {
                for (KeywordInterface ki : c.getKeywords()) {
                    if (!kw.equals(ki.getOriginal()) || (v = pc.chooseNumberForKeywordCost(sa, cost = new Cost(ManaCost.ONE, false), ki, str = "Choose Amount for " + c.getName() + ": " + cost.toSimpleString(), Integer.MAX_VALUE)) <= 0) continue;
                    Card eff = GameActionUtil.createETBCountersEffect(c, host, activator, "P1P1", String.valueOf(v));
                    if (result == null) {
                        result = sa.copy();
                    }
                    result.addRollbackEffect(eff);
                    for (int i = 0; i < v; ++i) {
                        result.getPayCosts().add(cost);
                    }
                }
            }
        }
        if (reset) {
            host.getGame().getTriggerHandler().resetActiveTriggers(false);
        }
        return result != null ? result : sa;
    }

    public static Card createETBCountersEffect(Card sourceCard, Card c, Player controller, String counter, String amount) {
        Game game = sourceCard.getGame();
        Card eff = new Card(game.nextCardId(), game);
        eff.setGameTimestamp(game.getNextTimestamp());
        eff.setName(sourceCard + "'s Effect");
        eff.setOwner(controller);
        eff.setImageKey(sourceCard.getImageKey());
        eff.setColor((byte)0);
        eff.setGamePieceType(GamePieceType.EFFECT);
        eff.addRemembered(c);
        String abStr = "DB$ PutCounter | Defined$ ReplacedCard | CounterType$ " + counter + " | ETB$ True | CounterNum$ " + amount;
        SpellAbility sa = AbilityFactory.getAbility(abStr, c);
        if (!StringUtils.isNumeric(amount)) {
            sa.setSVar(amount, sourceCard.getSVar(amount));
        }
        String desc = "It enters with ";
        desc = desc + Lang.nounWithNumeral(amount, CounterType.getType(counter).getName() + " counter");
        desc = desc + " on it.";
        String repeffstr = "Event$ Moved | ValidCard$ Card.IsRemembered | Destination$ Battlefield | ReplacementResult$ Updated | Description$ " + desc;
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
        re.setLayer(ReplacementLayer.Other);
        re.setOverridingAbility(sa);
        re.setActiveZone(EnumSet.of(ZoneType.Command));
        eff.addReplacementEffect(re);
        SpellAbilityEffect.addForgetOnMovedTrigger(eff, "Stack");
        eff.updateStateForView();
        game.getAction().moveToCommand(eff, sa);
        return eff;
    }

    public static String generatedTotalMana(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        for (SpellAbility tail = sa; tail != null; tail = tail.getSubAbility()) {
            String value = GameActionUtil.generatedMana(tail);
            if (value.isEmpty() || "0".equals(value)) continue;
            sb.append(value).append(" ");
        }
        return sb.toString().trim();
    }

    public static String generatedMana(SpellAbility sa) {
        String baseMana;
        AbilityManaPart abMana = sa.getManaPart();
        if (abMana == null) {
            return "";
        }
        int amount = sa.amountOfManaGenerated(false);
        if (abMana.isComboMana()) {
            baseMana = abMana.getExpressChoice();
            if (baseMana.isEmpty()) {
                baseMana = abMana.getOrigProduced();
            }
        } else if (abMana.isAnyMana()) {
            baseMana = abMana.getExpressChoice();
            if (baseMana.isEmpty()) {
                baseMana = "Any";
            }
        } else {
            baseMana = sa.getApi() == ApiType.ManaReflected ? abMana.getExpressChoice() : (abMana.isSpecialMana() ? abMana.getExpressChoice() : abMana.mana(sa));
        }
        if (sa.getSubAbility() != null) {
            sa.setUndoable(false);
        } else if (sa.hasParam("Amount") && !StringUtils.isNumeric(sa.getParam("Amount"))) {
            sa.setUndoable(false);
        }
        StringBuilder sb = new StringBuilder();
        if (amount <= 0) {
            sb.append("0");
        } else if (abMana.isComboMana()) {
            sb.append(baseMana);
        } else if (StringUtils.isNumeric(baseMana)) {
            sb.append(amount * Integer.parseInt(baseMana));
        } else {
            sb.append(baseMana);
            for (int i = 1; i < amount; ++i) {
                sb.append(" ").append(baseMana);
            }
        }
        return sb.toString();
    }

    public static CardCollectionView orderCardsByTheirOwners(Game game, CardCollectionView list, ZoneType dest, SpellAbility sa) {
        if (list.size() <= 1) {
            return list;
        }
        CardCollection completeList = new CardCollection();
        PlayerCollection players = game.getPlayersInTurnOrder(game.getPhaseHandler().getPlayerTurn());
        for (Player p : players) {
            CardCollection subList = new CardCollection();
            for (Card c : list) {
                Player decider;
                Player player = decider = dest == ZoneType.Battlefield ? c.getController() : c.getOwner();
                if (sa != null && sa.hasParam("GainControl")) {
                    decider = (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("GainControl"), sa).get(false);
                }
                if (!decider.equals(p)) continue;
                subList.add(c);
            }
            CardCollectionView subListView = subList;
            if (subList.size() > 1) {
                subListView = p.getController().orderMoveToZoneList(subList, dest, sa);
            }
            completeList.addAll(subListView);
        }
        return completeList;
    }

    public static void checkStaticAfterPaying(Card c) {
        c.getGame().getAction().checkStaticAbilities(false);
        c.updateKeywords();
        c.getGame().getTriggerHandler().resetActiveTriggers();
    }

    public static void rollbackAbility(SpellAbility ability, Zone fromZone, int zonePosition, CostPayment payment, Card oldCard) {
        Game game = ability.getActivatingPlayer().getGame();
        if (game.restoreGameState()) {
            System.out.println("Restored state from snapshot! Rolled back: " + ability.getHostCard().getName() + " - " + ability.getActivatingPlayer());
            return;
        }
        if (fromZone != null && !fromZone.is(ZoneType.None)) {
            oldCard = ability.getCardState().getCard();
            oldCard.setCastSA(null);
            oldCard.setCastFrom(null);
            oldCard.getZone().remove(oldCard);
            Integer newPosition = zonePosition >= 0 ? Integer.valueOf(Math.min(zonePosition, fromZone.size())) : null;
            fromZone.add(oldCard, newPosition, null, true);
            ability.setHostCard(oldCard);
            ability.setXManaCostPaid(null);
            ability.setSpendPhyrexianMana(false);
            ability.clearPipsToReduce();
            ability.setPaidLife(0);
            if (ability.hasParam("Announce")) {
                for (String aVar : ability.getParam("Announce").split(",")) {
                    String varName = aVar.trim();
                    if (varName.equals("X")) continue;
                    ability.setSVar(varName, "0");
                }
            }
            for (SpellAbility sa : oldCard.getSpells()) {
                sa.setHostCard(oldCard);
            }
            ability.rollback();
            oldCard.setBackSide(false);
            oldCard.setState(oldCard.getFaceupCardStateName(), true);
            oldCard.unanimateBestow();
            if (ability.isDisturb() || ability.hasParam("CastTransformed")) {
                oldCard.undoIncrementTransformedTimestamp();
            }
            if (ability.hasParam("Prototype")) {
                oldCard.removeCloneState(oldCard.getPrototypeTimestamp());
            }
            for (Card c : ability.getTappedForConvoke()) {
                c.setTapped(false);
            }
        }
        if (ability.getApi() == ApiType.Charm) {
            ability.setSubAbility(null);
            ability.setChosenList(null);
        }
        ability.clearTargets();
        ability.resetOnceResolved();
        payment.refundPayment();
        game.getStack().clearFrozen();
        game.getTriggerHandler().clearWaitingTriggers();
    }
}

