/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import forge.GameCommand;
import forge.StaticData;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.GamePieceType;
import forge.card.MagicColor;
import forge.deck.DeckSection;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEndReason;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.GameObject;
import forge.game.GameOutcome;
import forge.game.GameStage;
import forge.game.GameType;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardDamageMap;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.event.GameEventCardChangeZone;
import forge.game.event.GameEventCardDestroyed;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.event.GameEventCardTapped;
import forge.game.event.GameEventFlipCoin;
import forge.game.event.GameEventGameStarted;
import forge.game.event.GameEventScry;
import forge.game.extrahands.BackupPlanService;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mulligan.MulliganService;
import forge.game.player.GameLossReason;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.SpellPermanent;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.staticability.StaticAbilityLayer;
import forge.game.trigger.TriggerType;
import forge.game.zone.PlayerZone;
import forge.game.zone.PlayerZoneBattlefield;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Expressions;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.ThreadUtil;
import forge.util.Visitor;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GameAction {
    private final Game game;
    private boolean holdCheckingStaticAbilities = false;

    public GameAction(Game game0) {
        this.game = game0;
    }

    public final void resetActivationsPerTurn() {
        for (Card card : this.game.getCardsInGame()) {
            card.resetActivationsPerTurn();
        }
    }

    public Card changeZone(Zone zoneFrom, Zone zoneTo, Card c, Integer position, SpellAbility cause) {
        return this.changeZone(zoneFrom, zoneTo, c, position, cause, null);
    }

    private Card changeZone(Zone zoneFrom, Zone zoneTo, Card c, Integer position, SpellAbility cause, Map<AbilityKey, Object> params) {
        Card revealLKI;
        Comparable<Integer> saTargeting;
        Object cards;
        ReplacementEffect re;
        if (c.isCopiedSpell() && zoneTo.is(ZoneType.Battlefield) && c.isPermanent() && cause != null && cause.isSpell() && c.equals(cause.getHostCard())) {
            c.setGamePieceType(GamePieceType.TOKEN);
        }
        if (c.isCopiedSpell() || c.isImmutable() && zoneTo.is(ZoneType.Exile)) {
            if (zoneFrom != null) {
                zoneFrom.remove(c);
            }
            return c;
        }
        if (zoneFrom == null && !c.isToken()) {
            zoneTo.add(c, position, CardCopyService.getLKICopy(c));
            this.checkStaticAbilities();
            this.game.getTriggerHandler().registerActiveTrigger(c, true);
            this.game.fireEvent(new GameEventCardChangeZone(c, zoneFrom, zoneTo));
            return c;
        }
        boolean toBattlefield = zoneTo.is(ZoneType.Battlefield) || zoneTo.is(ZoneType.Merged);
        boolean fromBattlefield = zoneFrom != null && zoneFrom.is(ZoneType.Battlefield);
        boolean fromGraveyard = zoneFrom != null && zoneFrom.is(ZoneType.Graveyard);
        boolean wasFacedown = c.isFaceDown();
        if (!(c.isSpell() || !c.isToken() || fromBattlefield || zoneFrom == null || zoneFrom.is(ZoneType.Stack) || cause != null && (cause instanceof SpellPermanent || cause.isCastFaceDown()) && cause.isCastFromPlayEffect())) {
            return c;
        }
        if (toBattlefield && !c.isPermanent()) {
            return c;
        }
        CardCollectionView lastBattlefield = this.getLastState(AbilityKey.LastStateBattlefield, cause, params, false);
        CardCollectionView lastGraveyard = this.getLastState(AbilityKey.LastStateGraveyard, cause, params, false);
        if (c.isAura() && !c.isAttachedToEntity() && toBattlefield && (zoneFrom == null || !zoneFrom.is(ZoneType.Stack))) {
            boolean found = false;
            if (Iterables.any(this.game.getPlayers(), PlayerPredicates.canBeAttached(c, null))) {
                found = true;
            }
            if (!found && Iterables.any(lastBattlefield, CardPredicates.canBeAttached(c, null))) {
                found = true;
            }
            if (!found && Iterables.any(lastGraveyard, CardPredicates.canBeAttached(c, null))) {
                found = true;
            }
            if (!found) {
                c.clearControllers();
                if (cause != null) {
                    GameAction.unanimateOnAbortedChange(cause, c);
                }
                return c;
            }
        }
        if (!(c.getGamePieceType() != GamePieceType.ATTRACTION || toBattlefield || zoneTo.getZoneType().isPartOfCommandZone() || zoneTo.is(ZoneType.Exile))) {
            return this.moveToJunkyard(c, cause, params);
        }
        boolean suppress = !c.isToken() && zoneFrom.equals(zoneTo);
        Card copied = null;
        Card lastKnownInfo = null;
        if (params != null && params.containsKey((Object)AbilityKey.CardLKI)) {
            lastKnownInfo = (Card)params.get((Object)AbilityKey.CardLKI);
        } else if (toBattlefield && cause != null && cause.isReplacementAbility() && ReplacementType.Moved.equals((Object)(re = cause.getReplacementEffect()).getMode()) && cause.getReplacingObject(AbilityKey.CardLKI).equals(c)) {
            lastKnownInfo = (Card)cause.getReplacingObject(AbilityKey.CardLKI);
        }
        if (c.isSplitCard()) {
            boolean resetToOriginal = false;
            if (c.isManifested() || c.isCloaked()) {
                if (fromBattlefield) {
                    resetToOriginal = true;
                }
            } else if (zoneTo.is(ZoneType.Battlefield) && c.isRoom()) {
                if (c.getCastSA() == null) {
                    c.updateRooms();
                }
            } else if (!zoneTo.is(ZoneType.Stack) && !zoneTo.is(ZoneType.Battlefield)) {
                resetToOriginal = true;
            }
            if (resetToOriginal) {
                c.setState(CardStateName.Original, true);
            }
        }
        if (fromBattlefield && !toBattlefield) {
            c.getController().setRevolt(true);
        }
        if (toBattlefield || suppress && zoneTo.getZoneType().isHidden()) {
            copied = c;
            if (lastKnownInfo == null) {
                lastKnownInfo = CardCopyService.getLKICopy(c);
            }
            if (!lastKnownInfo.hasKeyword("Counters remain on CARDNAME as it moves to any zone other than a player's hand or library.")) {
                copied.clearCounters();
            }
        } else {
            int idx;
            if (fromBattlefield && (idx = lastBattlefield.indexOf(c)) != -1) {
                lastKnownInfo = (Card)lastBattlefield.get(idx);
            }
            if (fromGraveyard && (idx = lastGraveyard.indexOf(c)) != -1) {
                lastKnownInfo = (Card)lastGraveyard.get(idx);
            }
            if (lastKnownInfo == null) {
                lastKnownInfo = CardCopyService.getLKICopy(c);
            }
            if (fromBattlefield && !zoneTo.is(ZoneType.Stack) && !zoneTo.is(ZoneType.Flashback)) {
                this.game.addChangeZoneLKIInfo(lastKnownInfo);
            }
            copied = new CardCopyService(c).copyCard(false);
            if (zoneTo.is(ZoneType.Stack) && c.isRealToken()) {
                copied.setCopiedPermanent(c.getCopiedPermanent());
            }
            copied.setGameTimestamp(c.getGameTimestamp());
            if (zoneTo.is(ZoneType.Stack)) {
                copied.setExiledWith(c.getExiledWith());
                copied.setExiledBy(c.getExiledBy());
                copied.setDrawnThisTurn(c.getDrawnThisTurn());
                if (c.isTransformed()) {
                    copied.incrementTransformedTimestamp();
                }
                if (cause != null && cause.isSpell() && c.equals(cause.getHostCard())) {
                    copied.setCastSA(cause);
                    copied.setSplitStateToPlayAbility(cause);
                    copied.setController(cause.getActivatingPlayer(), 0L);
                    KeywordInterface kw = cause.getKeyword();
                    if (kw != null) {
                        copied.addKeywordForStaticAbility(kw);
                    }
                }
            } else {
                copied.setState(CardStateName.Original, false);
                copied.setBackSide(false);
            }
            copied.setUnearthed(c.isUnearthed());
            if (lastKnownInfo.hasKeyword("Counters remain on CARDNAME as it moves to any zone other than a player's hand or library.") && !zoneTo.is(ZoneType.Hand) && !zoneTo.is(ZoneType.Library)) {
                copied.setCounters(Maps.newHashMap(lastKnownInfo.getCounters()));
            }
        }
        if (c.hasIntensity()) {
            copied.setIntensity(c.getIntensity(false));
        }
        if (c.isSpecialized()) {
            copied.setState(c.getCurrentStateName(), false);
        }
        if (c.hasPerpetual()) {
            copied.setPerpetual(c);
        }
        copied.updateStateForView();
        GameEntityCounterTable table = params != null && params.containsKey((Object)AbilityKey.CounterTable) ? (GameEntityCounterTable)params.get((Object)AbilityKey.CounterTable) : new GameEntityCounterTable();
        if (!suppress) {
            ReplacementResult repres;
            if (fromBattlefield && !toBattlefield && c.isCommander() && c.hasMergedCard()) {
                c.getOwner().setCommanderReplacementSuppressed(true);
            }
            if (zoneFrom == null || zoneFrom.is(ZoneType.None)) {
                copied.getOwner().addInboundToken(copied);
            }
            Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(copied);
            repParams.put(AbilityKey.CardLKI, lastKnownInfo);
            repParams.put(AbilityKey.Cause, cause);
            repParams.put(AbilityKey.Origin, (Object)(zoneFrom != null ? zoneFrom.getZoneType() : null));
            repParams.put(AbilityKey.Destination, (Object)zoneTo.getZoneType());
            if (toBattlefield) {
                repParams.put(AbilityKey.EffectOnly, true);
                repParams.put(AbilityKey.CounterTable, table);
                repParams.put(AbilityKey.CounterMap, table.column(copied));
            }
            if (params != null) {
                repParams.putAll(params);
            }
            if ((repres = this.game.getReplacementHandler().run(ReplacementType.Moved, repParams)) != ReplacementResult.NotReplaced && repres != ReplacementResult.Updated) {
                if ((c.isManifested() || c.isCloaked()) && !c.isInPlay()) {
                    c.forceTurnFaceUp();
                }
                copied.getOwner().removeInboundToken(copied);
                if (repres == ReplacementResult.Prevented) {
                    c.clearControllers();
                    if (cause != null) {
                        GameAction.unanimateOnAbortedChange(cause, c);
                        if (cause.hasParam("Transformed") || cause.hasParam("FaceDown")) {
                            c.setBackSide(false);
                            c.changeToState(CardStateName.Original);
                        }
                        GameAction.unattachCardLeavingBattlefield(c);
                    }
                    if (c.isInZone(ZoneType.Stack) && !zoneTo.is(ZoneType.Graveyard)) {
                        return this.moveToGraveyard(c, cause, params);
                    }
                    copied.clearDevoured();
                    copied.clearDelved();
                    copied.clearExploited();
                } else if (toBattlefield && !c.isInPlay() && c.removeChangedState()) {
                    c.updateStateForView();
                }
                return c;
            }
        }
        if (!zoneTo.is(ZoneType.Stack)) {
            copied.setGameTimestamp(this.game.getNextTimestamp());
        }
        copied.getOwner().removeInboundToken(copied);
        if (copied.isAura() && !copied.isAttachedToEntity() && toBattlefield) {
            if (zoneFrom != null && zoneFrom.is(ZoneType.Stack) && this.game.getStack().isResolving(c)) {
                boolean found = false;
                if (Iterables.any(this.game.getPlayers(), PlayerPredicates.canBeAttached(copied, null))) {
                    found = true;
                }
                if (Iterables.any(lastBattlefield, CardPredicates.canBeAttached(copied, null))) {
                    found = true;
                }
                if (Iterables.any(lastGraveyard, CardPredicates.canBeAttached(copied, null))) {
                    found = true;
                }
                if (!found) {
                    return this.moveToGraveyard(copied, cause, params);
                }
            }
            GameAction.attachAuraOnIndirectEnterBattlefield(copied, params);
        }
        Object mergedCards = null;
        if (fromBattlefield && !toBattlefield && c.hasMergedCard()) {
            cards = new CardCollection(c.getMergedCards());
            ((FCollection)cards).set(((FCollection)cards).indexOf(c), copied);
            cards = cause != null && zoneTo.getZoneType() == ZoneType.Exile ? (CardCollection)cause.getHostCard().getController().getController().orderMoveToZoneList((CardCollectionView)cards, zoneTo.getZoneType(), cause) : (CardCollection)c.getOwner().getController().orderMoveToZoneList((CardCollectionView)cards, zoneTo.getZoneType(), cause);
            ((FCollection)cards).set(((FCollection)cards).indexOf(copied), c);
            mergedCards = cards;
            if (cause != null) {
                saTargeting = cause.getSATargetingCard();
                if (saTargeting != null) {
                    ((SpellAbility)saTargeting).getTargets().replaceTargetCard(c, (CardCollectionView)cards);
                }
                Card card = cause.getHostCard();
                if (!cause.hasParam("RememberLKI") && card.isRemembered(c)) {
                    card.removeRemembered(c);
                    card.addRemembered(cards);
                }
            }
        }
        if (suppress) {
            this.game.getTriggerHandler().suppressMode(TriggerType.ChangesZone);
        }
        if (zoneFrom != null) {
            Card e;
            if (fromBattlefield && this.game.getCombat() != null) {
                if (!toBattlefield) {
                    this.game.getCombat().saveLKI(lastKnownInfo);
                }
                this.game.getCombat().removeFromCombat(c);
            }
            if (zoneFrom.getZoneType().isDeck() && zoneFrom == zoneTo && position.equals(zoneFrom.size()) && position != 0) {
                cards = position;
                position = position - 1;
                saTargeting = position;
            }
            if (mergedCards != null) {
                cards = ((FCollection)mergedCards).iterator();
                while (cards.hasNext()) {
                    Card card = (Card)cards.next();
                    c.getOwner().getZone(ZoneType.Merged).remove(card);
                }
            }
            zoneFrom.remove(c);
            if (c.hasEncodedCard()) {
                for (Iterator<Object> e2 : c.getEncodedCards()) {
                    ((Card)((Object)e2)).setEncodingCard(null);
                }
            }
            if (zoneFrom.is(ZoneType.Exile) && (e = c.getEncodingCard()) != null) {
                e.removeEncodedCard(c);
            }
            if (zoneFrom.is(ZoneType.Stack) && toBattlefield) {
                if (c.getCastSA() != null && !c.getCastSA().isIntrinsic() && c.getCastSA().getKeyword() != null) {
                    KeywordInterface ki = c.getCastSA().getKeyword();
                    ki.setHostCard(copied);
                    copied.addChangedCardKeywordsInternal(ImmutableList.of(ki), null, false, copied.getGameTimestamp(), null, true);
                }
                Multimap addKw = MultimapBuilder.hashKeys().arrayListValues().build();
                for (KeywordInterface keywordInterface : c.getKeywords(Keyword.OFFSPRING)) {
                    if (keywordInterface.isIntrinsic()) continue;
                    addKw.put(keywordInterface.getStatic(), keywordInterface);
                }
                if (!addKw.isEmpty()) {
                    for (Map.Entry entry : addKw.asMap().entrySet()) {
                        copied.addChangedCardKeywordsInternal((Collection)entry.getValue(), null, false, copied.getGameTimestamp(), (StaticAbility)entry.getKey(), true);
                    }
                }
                copied.addExiledCards(c.getExiledCards());
            }
            if (cause != null && cause.isCraft() && toBattlefield) {
                copied.retainPaidList(cause, "ExiledCards");
            }
        }
        if (mergedCards != null) {
            Iterator<Object> e2;
            boolean wasToken = c.isToken();
            c.getOwner().setCommanderReplacementSuppressed(false);
            c.setZone(zoneTo);
            e2 = ((FCollection)mergedCards).iterator();
            while (e2.hasNext()) {
                Card card = (Card)e2.next();
                if (card.isRealCommander()) {
                    card.setMoveToCommandZone(true);
                }
                if (wasToken && !card.isRealToken() || card.isRealCommander()) {
                    ReplacementResult repres;
                    Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(card);
                    repParams.put(AbilityKey.CardLKI, card);
                    repParams.put(AbilityKey.Cause, cause);
                    repParams.put(AbilityKey.Origin, (Object)(zoneFrom != null ? zoneFrom.getZoneType() : null));
                    repParams.put(AbilityKey.Destination, (Object)zoneTo.getZoneType());
                    if (params != null) {
                        repParams.putAll(params);
                    }
                    if ((repres = this.game.getReplacementHandler().run(ReplacementType.Moved, repParams)) != ReplacementResult.NotReplaced) continue;
                }
                if (card == c) {
                    this.storeChangesZoneAll(copied, zoneFrom, zoneTo, params);
                    zoneTo.add(copied, position, toBattlefield ? null : lastKnownInfo);
                } else {
                    this.storeChangesZoneAll(card, zoneFrom, zoneTo, params);
                    zoneTo.add(card, position, CardCopyService.getLKICopy(card));
                    card.setState(CardStateName.Original, false);
                    card.setBackSide(false);
                    card.updateStateForView();
                }
                card.setZone(zoneTo);
            }
        } else {
            this.storeChangesZoneAll(copied, zoneFrom, zoneTo, params);
            zoneTo.add(copied, position, toBattlefield ? null : lastKnownInfo);
            c.setZone(zoneTo);
        }
        if (fromBattlefield) {
            this.game.addLeftBattlefieldThisTurn(lastKnownInfo);
            GameAction.unattachCardLeavingBattlefield(c);
            copied.setEntityAttachedTo(null);
            copied.clearAttachedCards();
            c.runLeavesPlayCommands();
        }
        if (fromGraveyard) {
            this.game.addLeftGraveyardThisTurn(lastKnownInfo);
        }
        if (!suppress && toBattlefield && !table.isEmpty()) {
            this.game.getTriggerHandler().registerActiveTrigger(copied, false);
        }
        copied.updateStateForView();
        if (fromBattlefield) {
            copied.setDamage(0);
            copied.setHasBeenDealtDeathtouchDamage(false);
            if (copied.isTapped()) {
                copied.setTapped(false);
                this.game.fireEvent(new GameEventCardTapped(c, false));
            }
        }
        if (!table.isEmpty()) {
            this.game.getTriggerHandler().suppressMode(TriggerType.Always);
            this.checkStaticAbilities();
        }
        table.replaceCounterEffect(this.game, null, true, true, params);
        this.game.getTriggerHandler().clearSuppression(TriggerType.Always);
        this.checkStaticAbilities();
        if (zoneTo.is(ZoneType.Stack) && cause != null && cause.isSpell() && !cause.isIntrinsic() && c.equals(cause.getHostCard()) && cause.getKeyword() != null && !copied.getKeywords().contains(cause.getKeyword())) {
            copied.addChangedCardKeywordsInternal(ImmutableList.of(cause.getKeyword()), null, false, this.game.getNextTimestamp(), null, true);
        }
        if (toBattlefield) {
            zoneTo.saveLKI(copied, lastKnownInfo);
            if (copied.isRoom() && copied.getCastSA() != null) {
                copied.unlockRoom(copied.getCastSA().getActivatingPlayer(), copied.getCastSA().getCardStateName());
            }
        }
        if (!zoneTo.is(ZoneType.Stack)) {
            c.cleanupExiledWith();
        }
        this.game.getTriggerHandler().clearActiveTriggers(copied, null);
        this.game.getTriggerHandler().registerActiveTrigger(copied, false);
        this.game.fireEvent(new GameEventCardChangeZone(c, zoneFrom, zoneTo));
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(copied);
        runParams.put(AbilityKey.CardLKI, lastKnownInfo);
        runParams.put(AbilityKey.Cause, cause);
        runParams.put(AbilityKey.Origin, zoneFrom != null ? zoneFrom.getZoneType().name() : null);
        runParams.put(AbilityKey.Destination, zoneTo.getZoneType().name());
        runParams.put(AbilityKey.IndividualCostPaymentInstance, this.game.costPaymentStack.peek());
        runParams.put(AbilityKey.MergedCards, mergedCards);
        if (params != null) {
            runParams.putAll(params);
        }
        this.game.getTriggerHandler().runTrigger(TriggerType.ChangesZone, runParams, true);
        if (fromBattlefield && !zoneFrom.getPlayer().equals(zoneTo.getPlayer())) {
            Map<AbilityKey, Object> runParams2 = AbilityKey.mapFromCard(lastKnownInfo);
            runParams2.put(AbilityKey.OriginalController, zoneFrom.getPlayer());
            if (params != null) {
                runParams2.putAll(params);
            }
            this.game.getTriggerHandler().runTrigger(TriggerType.ChangesController, runParams2, false);
        }
        if (suppress) {
            this.game.getTriggerHandler().clearSuppression(TriggerType.ChangesZone);
        }
        if (zoneFrom == null) {
            return copied;
        }
        if (!c.isRealToken() && !toBattlefield) {
            copied.clearDevoured();
            copied.clearDelved();
            copied.clearExploited();
        }
        if (zoneFrom != null && zoneTo != null && zoneFrom.is(ZoneType.Stack) && !zoneTo.is(ZoneType.Battlefield) && wasFacedown) {
            revealLKI = CardCopyService.getLKICopy(c);
            revealLKI.forceTurnFaceUp();
            this.reveal(new CardCollection(revealLKI), revealLKI.getOwner(), true, "Face-down card moves from the stack: ");
        }
        if (fromBattlefield) {
            if (!c.isRealToken() && !c.isSpecialized()) {
                copied.setState(CardStateName.Original, true);
            }
            if (c.isPaired()) {
                c.getPairedWith().setPairedWith(null);
                if (!c.isRealToken()) {
                    c.setPairedWith(null);
                }
            }
            if (c.getMeldedWith() != null) {
                Card unmeld = c.getMeldedWith();
                ((PlayerZoneBattlefield)zoneFrom).removeFromMelded(unmeld);
                Integer n = position;
                if (n != null && (zoneTo.is(ZoneType.Library) || zoneTo.is(ZoneType.Graveyard))) {
                    Integer n2;
                    Integer n3 = n;
                    Integer n4 = n2 = Integer.valueOf(n + 1);
                }
                this.changeZone(null, zoneTo, unmeld, position, cause, params);
            }
            if (wasFacedown) {
                revealLKI = CardCopyService.getLKICopy(c);
                revealLKI.forceTurnFaceUp();
                this.reveal(new CardCollection(revealLKI), revealLKI.getOwner(), true, "Face-down card leaves the battlefield: ");
                copied.setState(CardStateName.Original, true);
            }
        } else if (toBattlefield) {
            for (Player player : this.game.getPlayers()) {
                copied.getDamageHistory().setNotAttackedSinceLastUpkeepOf(player);
                copied.getDamageHistory().setNotBlockedSinceLastUpkeepOf(player);
                copied.getDamageHistory().setNotBeenBlockedSinceLastUpkeepOf(player);
            }
        } else if ((zoneTo.is(ZoneType.Graveyard) || zoneTo.is(ZoneType.Hand) || zoneTo.is(ZoneType.Library) || zoneTo.is(ZoneType.Exile)) && copied.isFaceDown()) {
            copied.setState(CardStateName.Original, true);
        }
        if (!zoneTo.is(ZoneType.Battlefield) && !zoneTo.is(ZoneType.Stack)) {
            copied.clearControllers();
        }
        return copied;
    }

    private void storeChangesZoneAll(Card c, Zone zoneFrom, Zone zoneTo, Map<AbilityKey, Object> params) {
        if (params != null && params.containsKey((Object)AbilityKey.InternalTriggerTable)) {
            ((CardZoneTable)params.get((Object)AbilityKey.InternalTriggerTable)).put(zoneFrom != null ? zoneFrom.getZoneType() : null, zoneTo.getZoneType(), c);
        }
    }

    private static void unattachCardLeavingBattlefield(Card copied) {
        copied.unAttachAllCards();
        if (copied.isAttachedToEntity()) {
            copied.unattachFromEntity(copied.getEntityAttachedTo());
        }
    }

    public final Card moveTo(Zone zoneTo, Card c, SpellAbility cause) {
        return this.moveTo(zoneTo, c, cause, AbilityKey.newMap());
    }

    public final Card moveTo(Zone zoneTo, Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.moveTo(zoneTo, c, null, cause, params);
    }

    public final Card moveTo(ZoneType name, Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.moveTo(name, c, 0, cause, params);
    }

    public final Card moveTo(ZoneType name, Card c, int libPosition, SpellAbility cause, Map<AbilityKey, Object> params) {
        switch (name) {
            case Hand: {
                return this.moveToHand(c, cause, params);
            }
            case Library: {
                return this.moveToLibrary(c, libPosition, cause, params);
            }
            case Battlefield: {
                return this.moveToPlay(c, c.getController(), cause, params);
            }
            case Graveyard: {
                return this.moveToGraveyard(c, cause, params);
            }
            case Exile: {
                if (!c.canExiledBy(cause, true)) {
                    return null;
                }
                return this.exile(c, cause, params);
            }
            case Stack: {
                return this.moveToStack(c, cause, params);
            }
            case PlanarDeck: {
                return this.moveToVariantDeck(c, ZoneType.PlanarDeck, libPosition, cause, params);
            }
            case SchemeDeck: {
                return this.moveToVariantDeck(c, ZoneType.SchemeDeck, libPosition, cause, params);
            }
            case AttractionDeck: {
                return this.moveToVariantDeck(c, ZoneType.AttractionDeck, libPosition, cause, params);
            }
            case Junkyard: {
                return this.moveToJunkyard(c, cause, params);
            }
        }
        return this.moveTo(c.getOwner().getZone(name), c, cause);
    }

    private Card moveTo(Zone zoneTo, Card c, Integer position, SpellAbility cause, Map<AbilityKey, Object> params) {
        Card maingameCard;
        Zone zoneFrom = this.game.getZoneOf(c);
        if (zoneTo.is(ZoneType.Subgame) && (c.hasMergedCard() || c.isMerged())) {
            c.moveMergedToSubgame(cause);
        }
        c = this.changeZone(zoneFrom, zoneTo, c, position, cause, params);
        for (StaticAbility stAb : c.getStaticAbilities()) {
            if (!stAb.checkConditions()) continue;
            if (stAb.checkMode("CantBlockBy")) {
                if (!stAb.hasParam("ValidAttacker") || stAb.hasParam("ValidBlocker") && stAb.getParam("ValidBlocker").equals("Creature.Self")) continue;
                for (Card creature : Iterables.filter(this.game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES)) {
                    if (!stAb.matchesValidParam("ValidAttacker", creature)) continue;
                    creature.updateAbilityTextForView();
                }
            }
            if (!stAb.checkMode(StaticAbilityCantAttackBlock.MinMaxBlockerMode)) continue;
            for (Card creature : Iterables.filter(this.game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES)) {
                if (!stAb.matchesValidParam("ValidCard", creature)) continue;
                creature.updateAbilityTextForView();
            }
        }
        if (zoneFrom != null && zoneFrom.is(ZoneType.Sideboard) && this.game.getMaingame() != null && (maingameCard = c.getOwner().getMappingMaingameCard(c)) != null) {
            if (maingameCard.getZone().is(ZoneType.Stack)) {
                this.game.getMaingame().getStack().remove(maingameCard);
            }
            this.game.getMaingame().getAction().moveTo(ZoneType.Subgame, maingameCard, null, params);
        }
        if (zoneTo.is(ZoneType.Stack)) {
            c.setCastFrom(zoneFrom);
            if (cause != null && cause.isSpell() && c.equals(cause.getHostCard())) {
                c.setCastSA(cause);
            } else {
                c.setCastSA(null);
            }
        } else if (zoneFrom == null || !zoneFrom.is(ZoneType.Stack) || !zoneTo.is(ZoneType.Battlefield) && !zoneTo.is(ZoneType.Merged)) {
            c.setCastFrom(null);
            c.setCastSA(null);
        }
        if (c.isRealCommander()) {
            c.setMoveToCommandZone(true);
        }
        return c;
    }

    public final Card moveToStack(Card c, SpellAbility cause) {
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        params.put(AbilityKey.LastStateBattlefield, this.game.getLastStateBattlefield());
        params.put(AbilityKey.LastStateGraveyard, this.game.getLastStateGraveyard());
        return this.moveToStack(c, cause, params);
    }

    public final Card moveToStack(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.moveTo(this.game.getStackZone(), c, cause, params);
    }

    public final Card moveToGraveyard(Card c, SpellAbility cause) {
        return this.moveToGraveyard(c, cause, AbilityKey.newMap());
    }

    public final Card moveToGraveyard(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        PlayerZone grave = c.getOwner().getZone(ZoneType.Graveyard);
        return this.moveTo(grave, c, cause, params);
    }

    public final Card moveToHand(Card c, SpellAbility cause) {
        return this.moveToHand(c, cause, AbilityKey.newMap());
    }

    public final Card moveToHand(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        PlayerZone hand = c.getOwner().getZone(ZoneType.Hand);
        return this.moveTo(hand, c, cause, params);
    }

    public final Card moveToPlay(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.moveToPlay(c, c.getController(), cause, params);
    }

    public final Card moveToPlay(Card c, Player p, SpellAbility cause, Map<AbilityKey, Object> params) {
        PlayerZone play = p.getZone(ZoneType.Battlefield);
        return this.moveTo(play, c, cause, params);
    }

    public final Card moveToBottomOfLibrary(Card c, SpellAbility cause) {
        return this.moveToBottomOfLibrary(c, cause, AbilityKey.newMap());
    }

    public final Card moveToBottomOfLibrary(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.moveToLibrary(c, -1, cause, params);
    }

    public final Card moveToLibrary(Card c, SpellAbility cause) {
        return this.moveToLibrary(c, cause, AbilityKey.newMap());
    }

    public final Card moveToLibrary(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.moveToLibrary(c, 0, cause, params);
    }

    public final Card moveToLibrary(Card c, int libPosition, SpellAbility cause) {
        return this.moveToLibrary(c, libPosition, cause, null);
    }

    public final Card moveToLibrary(Card c, int libPosition, SpellAbility cause, Map<AbilityKey, Object> params) {
        PlayerZone library = c.getOwner().getZone(ZoneType.Library);
        if (libPosition == -1 || libPosition > library.size()) {
            libPosition = library.size();
        }
        return this.changeZone(this.game.getZoneOf(c), library, c, libPosition, cause, params);
    }

    public final Card moveToVariantDeck(Card c, ZoneType zone, int deckPosition, SpellAbility cause, Map<AbilityKey, Object> params) {
        PlayerZone deck = c.getOwner().getZone(zone);
        if (deckPosition == -1 || deckPosition > deck.size()) {
            deckPosition = deck.size();
        }
        return this.changeZone(this.game.getZoneOf(c), deck, c, deckPosition, cause, params);
    }

    public final Card moveToJunkyard(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        PlayerZone junkyard = c.getOwner().getZone(ZoneType.Junkyard);
        return this.moveTo(junkyard, c, cause, params);
    }

    public final CardCollection exile(CardCollection cards, SpellAbility cause, Map<AbilityKey, Object> params) {
        CardCollection result = new CardCollection();
        for (Card card : cards) {
            result.add(this.exile(card, cause, params));
        }
        return result;
    }

    public final Card exile(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        Zone origin = c.getZone();
        PlayerZone removed = c.getOwner().getZone(ZoneType.Exile);
        Card copied = this.moveTo(removed, c, cause, params);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
        runParams.put(AbilityKey.Cause, cause);
        if (origin != null) {
            runParams.put(AbilityKey.Origin, origin.getZoneType().name());
        }
        if (params != null) {
            runParams.putAll(params);
        }
        runParams.put(AbilityKey.CostStack, this.game.costPaymentStack);
        runParams.put(AbilityKey.IndividualCostPaymentInstance, this.game.costPaymentStack.peek());
        this.game.getTriggerHandler().runTrigger(TriggerType.Exiled, runParams, false);
        return copied;
    }

    public final Card exileEffect(Card effect) {
        return this.exile(effect, null, null);
    }

    public final void moveToCommand(Card effect, SpellAbility sa) {
        this.moveToCommand(effect, sa, AbilityKey.newMap());
    }

    public final void moveToCommand(Card effect, SpellAbility sa, Map<AbilityKey, Object> params) {
        this.game.getTriggerHandler().suppressMode(TriggerType.ChangesZone);
        this.moveTo(ZoneType.Command, effect, sa, params);
        effect.updateStateForView();
        this.game.getTriggerHandler().clearSuppression(TriggerType.ChangesZone);
    }

    public void ceaseToExist(Card c, boolean skipTrig) {
        Zone z;
        if (c.isInZone(ZoneType.Stack)) {
            c.getGame().getStack().remove(c);
        }
        if ((z = c.getZone()) != null) {
            z.remove(c);
            if (z.is(ZoneType.Battlefield)) {
                c.runLeavesPlayCommands();
            }
        }
        if (!skipTrig) {
            CardCollectionView lastBattlefield = this.game.getLastStateBattlefield();
            int idx = lastBattlefield.indexOf(c);
            Card lki = null;
            if (idx != -1) {
                lki = (Card)lastBattlefield.get(idx);
            }
            if (lki == null) {
                lki = CardCopyService.getLKICopy(c);
            }
            this.game.addChangeZoneLKIInfo(lki);
            if (lki.isInPlay()) {
                if (this.game.getCombat() != null) {
                    this.game.getCombat().saveLKI(lki);
                    this.game.getCombat().removeFromCombat(c);
                }
                if (!lki.getController().equals(lki.getOwner())) {
                    this.game.getTriggerHandler().registerActiveLTBTrigger(lki);
                }
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
                runParams.put(AbilityKey.CardLKI, lki);
                runParams.put(AbilityKey.Origin, c.getZone().getZoneType().name());
                this.game.getTriggerHandler().runTrigger(TriggerType.ChangesZone, runParams, false);
            }
        }
    }

    public final void controllerChangeZoneCorrection(Card c) {
        System.out.println("Correcting zone for " + c.toString());
        Zone oldBattlefield = this.game.getZoneOf(c);
        if (oldBattlefield == null || oldBattlefield.is(ZoneType.Stack)) {
            return;
        }
        Player original = oldBattlefield.getPlayer();
        Player controller = c.getController();
        if (original == null || controller == null || original.equals(controller)) {
            return;
        }
        PlayerZone newBattlefield = controller.getZone(oldBattlefield.getZoneType());
        if (newBattlefield == null || oldBattlefield.equals(newBattlefield)) {
            return;
        }
        if (c.isPaired()) {
            Card partner = c.getPairedWith();
            c.setPairedWith(null);
            partner.setPairedWith(null);
            partner.updateStateForView();
        }
        c.runChangeControllerCommands();
        this.game.getTriggerHandler().suppressMode(TriggerType.ChangesZone);
        oldBattlefield.remove(c);
        newBattlefield.add(c);
        if (this.game.getPhaseHandler().inCombat()) {
            this.game.getCombat().removeFromCombat(c);
        }
        c.setCameUnderControlSinceLastUpkeep(true);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
        runParams.put(AbilityKey.OriginalController, original);
        this.game.getTriggerHandler().runTrigger(TriggerType.ChangesController, runParams, false);
        this.game.getTriggerHandler().clearSuppression(TriggerType.ChangesZone);
    }

    private void setHoldCheckingStaticAbilities(boolean mode) {
        this.holdCheckingStaticAbilities = mode;
    }

    private boolean isCheckingStaticAbilitiesOnHold() {
        return this.holdCheckingStaticAbilities;
    }

    public boolean hasStaticAbilityAffectingZone(ZoneType zone, StaticAbilityLayer layer) {
        for (Card ca : this.game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions("Continuous") || layer != null && !stAb.getLayers().contains((Object)layer) || !ZoneType.listValueOf(stAb.getParamOrDefault("AffectedZone", ZoneType.Battlefield.toString())).contains((Object)zone)) continue;
                return true;
            }
        }
        return false;
    }

    public final void checkStaticAbilities() {
        this.checkStaticAbilities(true);
    }

    public final void checkStaticAbilities(boolean runEvents) {
        this.checkStaticAbilities(runEvents, Sets.newHashSet(), CardCollection.EMPTY);
    }

    public final void checkStaticAbilities(boolean runEvents, Set<Card> affectedCards, final CardCollectionView preList) {
        if (this.isCheckingStaticAbilitiesOnHold()) {
            return;
        }
        if (this.game.isGameOver()) {
            return;
        }
        this.game.getTracker().freeze();
        this.game.getStaticEffects().clearStaticEffects(affectedCards);
        for (Player p : this.game.getPlayers()) {
            p.clearStaticAbilities();
        }
        final FCollection<StaticAbility> staticAbilities = new FCollection<StaticAbility>();
        final CardCollection staticList = new CardCollection();
        this.game.forEachCardInGame(new Visitor<Card>(){

            @Override
            public boolean visit(Card c) {
                Card co = preList.get(c);
                for (StaticAbility stAb : co.getStaticAbilities()) {
                    if (!stAb.checkMode("Continuous")) continue;
                    staticAbilities.add(stAb);
                }
                if (!co.getStaticCommandList().isEmpty()) {
                    staticList.add(co);
                }
                return true;
            }
        }, true);
        Comparator comp = (a, b) -> ComparisonChain.start().compareTrueFirst(a.hasParam("CharacteristicDefining"), b.hasParam("CharacteristicDefining")).compare(a.getHostCard().getLayerTimestamp(), b.getHostCard().getLayerTimestamp()).result();
        staticAbilities.sort(comp);
        HashMap<StaticAbility, CardCollectionView> affectedPerAbility = Maps.newHashMap();
        for (StaticAbilityLayer layer : StaticAbilityLayer.CONTINUOUS_LAYERS) {
            ArrayList<StaticAbility> toAdd = Lists.newArrayList();
            for (StaticAbility stAb : staticAbilities) {
                CardCollectionView affectedHere;
                CardCollectionView previouslyAffected = (CardCollectionView)affectedPerAbility.get(stAb);
                if (previouslyAffected == null) {
                    affectedHere = stAb.applyContinuousAbilityBefore(layer, preList);
                    if (affectedHere != null) {
                        affectedPerAbility.put(stAb, affectedHere);
                    }
                } else {
                    affectedHere = previouslyAffected;
                    stAb.applyContinuousAbility(layer, previouslyAffected);
                }
                if (affectedHere == null) continue;
                for (Card c : affectedHere) {
                    for (StaticAbility st2 : c.getStaticAbilities()) {
                        if (staticAbilities.contains(st2)) continue;
                        toAdd.add(st2);
                        st2.applyContinuousAbilityBefore(layer, preList);
                    }
                }
            }
            staticAbilities.addAll((Collection<StaticAbility>)toAdd);
        }
        for (CardCollectionView affected : affectedPerAbility.values()) {
            if (affected == null) continue;
            Iterables.addAll(affectedCards, affected);
        }
        for (Card c : staticList) {
            ArrayList<Object[]> toRemove = Lists.newArrayList();
            for (Object[] staticCheck : c.getStaticCommandList()) {
                String svarOperand;
                int operandValue;
                String svarOperator;
                String leftVar = (String)staticCheck[0];
                String rightVar = (String)staticCheck[1];
                Card affected = (Card)staticCheck[2];
                int sVar = AbilityUtils.calculateAmount(affected, leftVar, null);
                if (!Expressions.compare(sVar, svarOperator = rightVar.substring(0, 2), operandValue = AbilityUtils.calculateAmount(c, svarOperand = rightVar.substring(2), null))) continue;
                ((GameCommand)staticCheck[3]).run();
                toRemove.add(staticCheck);
                affectedCards.add(c);
            }
            c.getStaticCommandList().removeAll(toRemove);
        }
        if (preList.isEmpty()) {
            for (Player p : this.game.getPlayers()) {
                for (Card c : p.getCardsIn(ZoneType.Battlefield).threadSafeIterable()) {
                    Card partner;
                    if (!c.getController().equals(p)) {
                        this.controllerChangeZoneCorrection(c);
                        affectedCards.add(c);
                    }
                    if (!c.isCreature() || !c.isPaired() || (partner = c.getPairedWith()).isCreature() && c.getController() == partner.getController() && c.isInPlay()) continue;
                    c.setPairedWith(null);
                    partner.setPairedWith(null);
                    affectedCards.add(c);
                }
            }
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            this.game.getTriggerHandler().runTrigger(TriggerType.Always, runParams, false);
            this.game.getTriggerHandler().runTrigger(TriggerType.Immediate, runParams, false);
        }
        for (Card c : affectedCards) {
            c.updateNameforView();
            c.updatePowerToughnessForView();
            c.updateTypesForView();
            c.updateAbilityTextForView();
        }
        if (runEvents && !affectedCards.isEmpty()) {
            this.game.fireEvent(new GameEventCardStatsChanged(affectedCards));
        }
        this.game.getTracker().unfreeze();
    }

    public final boolean checkStateEffects(boolean runEvents) {
        return this.checkStateEffects(runEvents, Sets.newHashSet());
    }

    public boolean checkStateEffects(boolean runEvents, Set<Card> affectedCards) {
        if (this.game.getStack().isResolving()) {
            return false;
        }
        if (this.game.isGameOver()) {
            return false;
        }
        boolean refreeze = this.game.getStack().isFrozen();
        this.game.getStack().setFrozen(true);
        this.game.getTracker().freeze();
        this.checkGameOverCondition();
        boolean performedSBA = false;
        boolean orderedDesCreats = false;
        boolean orderedNoRegCreats = false;
        boolean orderedSacrificeList = false;
        for (int q = 0; q < 9; ++q) {
            boolean checkAgain = false;
            CardCollection cardsToUpdateLKI = new CardCollection();
            this.checkStaticAbilities(false, affectedCards, CardCollection.EMPTY);
            CardZoneTable table = new CardZoneTable(this.game.getLastStateBattlefield(), this.game.getLastStateGraveyard());
            EnumMap<AbilityKey, Object> mapParams = AbilityKey.newMap();
            AbilityKey.addCardZoneTableParams(mapParams, table);
            for (Player p : this.game.getPlayers()) {
                for (ZoneType zt : ZoneType.values()) {
                    if (zt == ZoneType.Command) {
                        p.checkKeywordCard();
                    }
                    if (zt == ZoneType.Battlefield) continue;
                    for (Card c : p.getCardsIn(zt).threadSafeIterable()) {
                        checkAgain |= this.stateBasedAction704_5d(c);
                        this.stateBasedAction_Dungeon(c);
                        this.stateBasedAction_Scheme(c);
                    }
                }
            }
            CardCollection noRegCreats = new CardCollection();
            FCollection desCreats = null;
            CardCollection unAttachList = new CardCollection();
            CardCollection sacrificeList = new CardCollection();
            PlayerCollection spaceSculptors = new PlayerCollection();
            for (Card c : this.game.getCardsIn(ZoneType.Battlefield)) {
                boolean checkAgainCard = false;
                if (c.hasKeyword(Keyword.SPACE_SCULPTOR)) {
                    spaceSculptors.add(c.getController());
                }
                if (c.isCreature()) {
                    if (c.getNetToughness() <= 0) {
                        noRegCreats.add(c);
                        checkAgainCard = true;
                    } else if (!c.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                        if (c.hasKeyword("CARDNAME can't be destroyed by lethal damage unless lethal damage dealt by a single source is marked on it.")) {
                            if (c.getLethal() <= c.getMaxDamageFromSource() || c.hasBeenDealtDeathtouchDamage()) {
                                if (desCreats == null) {
                                    desCreats = new CardCollection();
                                }
                                desCreats.add(c);
                                c.setHasBeenDealtDeathtouchDamage(false);
                                checkAgainCard = true;
                            }
                        } else if (c.hasBeenDealtDeathtouchDamage() || c.getDamage() > 0 && c.getLethal() <= c.getDamage()) {
                            if (desCreats == null) {
                                desCreats = new CardCollection();
                            }
                            desCreats.add(c);
                            c.setHasBeenDealtDeathtouchDamage(false);
                            checkAgainCard = true;
                        }
                    }
                }
                checkAgainCard |= this.stateBasedAction_Saga(c, sacrificeList);
                checkAgainCard |= this.stateBasedAction_Battle(c, noRegCreats);
                checkAgainCard |= this.stateBasedAction_Role(c, unAttachList);
                checkAgainCard |= this.stateBasedAction704_attach(c, unAttachList);
                checkAgainCard |= this.stateBasedAction704_5r(c);
                CounterType dreamType = CounterType.get(CounterEnumType.DREAM);
                if (c.getCounters(dreamType) > 7 && c.hasKeyword("CARDNAME can't have more than seven dream counters on it.")) {
                    c.subtractCounter(dreamType, c.getCounters(dreamType) - 7, null);
                    checkAgainCard = true;
                }
                if (c.hasKeyword("The number of loyalty counters on CARDNAME is equal to the number of Beebles you control.")) {
                    int beeble = CardLists.getValidCardCount(this.game.getCardsIn(ZoneType.Battlefield), "Beeble.YouCtrl", c.getController(), c, null);
                    int loyal = c.getCounters(CounterEnumType.LOYALTY);
                    if (loyal < beeble) {
                        GameEntityCounterTable counterTable = new GameEntityCounterTable();
                        c.addCounter(CounterEnumType.LOYALTY, beeble - loyal, c.getController(), counterTable);
                        counterTable.replaceCounterEffect(this.game, null, false);
                    } else if (loyal > beeble) {
                        c.subtractCounter(CounterEnumType.LOYALTY, loyal - beeble, null);
                    }
                    if (c.getCounters(CounterEnumType.LOYALTY) != loyal) {
                        checkAgainCard = true;
                    }
                }
                if (c.isAura() && c.isInPlay() && !c.isEnchanting()) {
                    noRegCreats.add(c);
                    checkAgainCard = true;
                }
                if (!checkAgainCard) continue;
                cardsToUpdateLKI.add(c);
                checkAgain = true;
            }
            for (Card u : unAttachList) {
                u.unattachFromEntity(u.getEntityAttachedTo());
                if (!u.isAura() || !u.isInPlay() || u.isEnchanting()) continue;
                noRegCreats.add(u);
                checkAgain = true;
            }
            for (Player p : this.game.getPlayers()) {
                if (!spaceSculptors.isEmpty() && !spaceSculptors.contains(p)) {
                    checkAgain |= this.stateBasedAction704_5u(p);
                }
                if (this.handleLegendRule(p, noRegCreats)) {
                    checkAgain = true;
                }
                if ((this.game.getRules().hasAppliedVariant(GameType.Commander) || this.game.getRules().hasAppliedVariant(GameType.Brawl) || this.game.getRules().hasAppliedVariant(GameType.Planeswalker)) && !checkAgain) {
                    for (Card c : p.getCardsIn(ZoneType.Graveyard).threadSafeIterable()) {
                        checkAgain |= this.stateBasedAction_Commander(c, mapParams);
                    }
                    for (Card c : p.getCardsIn(ZoneType.Exile).threadSafeIterable()) {
                        checkAgain |= this.stateBasedAction_Commander(c, mapParams);
                    }
                }
                if (!this.handlePlaneswalkerRule(p, noRegCreats)) continue;
                checkAgain = true;
            }
            for (Player p : spaceSculptors) {
                checkAgain |= this.stateBasedAction704_5u(p);
            }
            checkAgain |= this.handleWorldRule(noRegCreats);
            this.setHoldCheckingStaticAbilities(true);
            if (noRegCreats.size() > 1 && !orderedNoRegCreats) {
                noRegCreats = (CardCollection)GameActionUtil.orderCardsByTheirOwners(this.game, noRegCreats, ZoneType.Graveyard, null);
                orderedNoRegCreats = true;
            }
            for (Card c : noRegCreats) {
                c.updateWasDestroyed(true);
                this.sacrificeDestroy(c, null, mapParams);
            }
            if (desCreats != null) {
                if (desCreats.size() > 1 && !orderedDesCreats) {
                    if (!(desCreats = CardLists.filter((Iterable<Card>)desCreats, CardPredicates.Presets.CAN_BE_DESTROYED)).isEmpty()) {
                        desCreats = (CardCollection)GameActionUtil.orderCardsByTheirOwners(this.game, (CardCollectionView)((Object)desCreats), ZoneType.Graveyard, null);
                    }
                    orderedDesCreats = true;
                }
                for (Card c : desCreats) {
                    this.destroy(c, null, true, mapParams);
                }
            }
            if (sacrificeList.size() > 1 && !orderedSacrificeList) {
                sacrificeList = (CardCollection)GameActionUtil.orderCardsByTheirOwners(this.game, sacrificeList, ZoneType.Graveyard, null);
                orderedSacrificeList = true;
            }
            this.sacrifice(sacrificeList, null, true, mapParams);
            this.setHoldCheckingStaticAbilities(false);
            table.triggerChangesZoneAll(this.game, null);
            this.game.getTriggerHandler().collectTriggerForWaiting();
            if (this.game.getTriggerHandler().runWaitingTriggers()) {
                checkAgain = true;
            }
            if (this.game.getCombat() != null) {
                this.game.getCombat().removeAbsentCombatants();
            }
            for (Card c : cardsToUpdateLKI) {
                this.game.updateLastStateForCard(c);
            }
            if (!checkAgain) break;
            performedSBA = true;
        }
        this.game.getTracker().unfreeze();
        if (runEvents && !affectedCards.isEmpty()) {
            this.game.fireEvent(new GameEventCardStatsChanged(affectedCards));
        }
        if (!this.game.isGameOver()) {
            this.checkGameOverCondition();
        }
        if (this.game.getAge() != GameStage.Play) {
            return false;
        }
        this.game.getTriggerHandler().resetActiveTriggers();
        this.checkStaticAbilities(false, affectedCards, CardCollection.EMPTY);
        if (!refreeze) {
            this.game.getStack().unfreezeStack();
        }
        this.game.runSBACheckedCommands();
        return performedSBA;
    }

    private boolean stateBasedAction_Saga(Card c, CardCollection sacrificeList) {
        boolean checkAgain = false;
        if (!c.isSaga()) {
            return false;
        }
        if (!c.canBeSacrificedBy(null, true)) {
            return false;
        }
        if (c.getCounters(CounterEnumType.LORE) < c.getFinalChapterNr()) {
            return false;
        }
        if (!this.game.getStack().hasSourceOnStack(c, SpellAbilityPredicates.isChapter())) {
            sacrificeList.add(c);
            checkAgain = true;
        }
        return checkAgain;
    }

    private boolean stateBasedAction_Battle(Card c, CardCollection removeList) {
        boolean checkAgain = false;
        if (!c.getType().isBattle()) {
            return false;
        }
        if (c.getCounters(CounterEnumType.DEFENSE) > 0) {
            return false;
        }
        if (!this.game.getStack().hasSourceOnStack(c, SpellAbilityPredicates.isTrigger())) {
            removeList.add(c);
            checkAgain = true;
        }
        return checkAgain;
    }

    private boolean stateBasedAction_Role(Card c, CardCollection removeList) {
        if (!c.hasCardAttachments()) {
            return false;
        }
        boolean checkAgain = false;
        CardCollection roles = CardLists.filter((Iterable<Card>)c.getAttachedCards(), CardPredicates.isType("Role"));
        if (roles.isEmpty()) {
            return false;
        }
        for (Player p : this.game.getPlayers()) {
            CardCollection rolesByPlayer = CardLists.filterControlledBy((Iterable<Card>)roles, p);
            if (rolesByPlayer.size() <= 1) continue;
            rolesByPlayer.sort(CardPredicates.compareByGameTimestamp());
            removeList.addAll(rolesByPlayer.subList(0, rolesByPlayer.size() - 1));
            checkAgain = true;
        }
        return checkAgain;
    }

    private void stateBasedAction_Dungeon(Card c) {
        if (!c.getType().isDungeon() || !c.isInLastRoom()) {
            return;
        }
        if (!this.game.getStack().hasSourceOnStack(c, null)) {
            this.completeDungeon(c.getController(), c);
        }
    }

    private void stateBasedAction_Scheme(Card c) {
        if (!c.isScheme() || c.getType().hasSupertype(CardType.Supertype.Ongoing)) {
            return;
        }
        if (!this.game.getStack().hasSourceOnStack(c, null)) {
            this.moveTo(ZoneType.SchemeDeck, c, null, AbilityKey.newMap());
        }
    }

    private boolean stateBasedAction704_attach(Card c, CardCollection unAttachList) {
        boolean checkAgain = false;
        if (c.isAttachedToEntity()) {
            GameEntity ge = c.getEntityAttachedTo();
            if (c.isCreature() || c.isBattle() || !ge.canBeAttached(c, null, true)) {
                unAttachList.add(c);
                checkAgain = true;
            }
        }
        if (c.hasCardAttachments()) {
            for (Card attach : c.getAttachedCards()) {
                if (attach.isInPlay()) continue;
                unAttachList.add(attach);
                checkAgain = true;
            }
        }
        return checkAgain;
    }

    private boolean stateBasedAction704_5u(Player p) {
        boolean checkAgain = false;
        CardCollection toAssign = new CardCollection();
        for (Card c : p.getCreaturesInPlay().threadSafeIterable()) {
            if (c.hasSector()) continue;
            toAssign.add(c);
            if (checkAgain) continue;
            checkAgain = true;
        }
        StringBuilder sb = new StringBuilder();
        for (Card assignee : toAssign) {
            String sector = p.getController().chooseSector(assignee, "Assign");
            assignee.assignSector(sector);
            if (sb.length() == 0) {
                sb.append(p).append(" ").append(Localizer.getInstance().getMessage("lblAssigns", new Object[0])).append("\n");
            }
            String creature = CardTranslation.getTranslatedName(assignee.getName()) + " (" + assignee.getId() + ")";
            sb.append(creature).append(" ").append(sector).append("\n");
        }
        if (sb.length() > 0) {
            this.notifyOfValue(null, p, sb.toString(), p);
        }
        return checkAgain;
    }

    private boolean stateBasedAction_Commander(Card c, Map<AbilityKey, Object> mapParams) {
        if (c.isRealCommander() && c.canMoveToCommandZone()) {
            c.getGame().getTracker().flush();
            c.setMoveToCommandZone(false);
            if (c.getOwner().getController().confirmAction(c.getFirstSpellAbility(), PlayerActionConfirmMode.ChangeZoneToAltDestination, c.getName() + ": If a commander is in a graveyard or in exile and that card was put into that zone since the last time state-based actions were checked, its owner may put it into the command zone.", null)) {
                this.moveTo(c.getOwner().getZone(ZoneType.Command), c, null, mapParams);
                return true;
            }
        }
        return false;
    }

    private boolean stateBasedAction704_5r(Card c) {
        boolean checkAgain = false;
        CounterType p1p1 = CounterType.get(CounterEnumType.P1P1);
        CounterType m1m1 = CounterType.get(CounterEnumType.M1M1);
        int plusOneCounters = c.getCounters(p1p1);
        int minusOneCounters = c.getCounters(m1m1);
        if (plusOneCounters > 0 && minusOneCounters > 0) {
            int remove = Math.min(plusOneCounters, minusOneCounters);
            c.subtractCounter(p1p1, remove, null);
            c.subtractCounter(m1m1, remove, null);
            checkAgain = true;
        }
        return checkAgain;
    }

    private boolean stateBasedAction704_5d(Card c) {
        boolean checkAgain = false;
        if (c.isRealToken()) {
            Zone zoneFrom = this.game.getZoneOf(c);
            if (zoneFrom.is(ZoneType.Stack) && c.getCopiedPermanent() != null) {
                return false;
            }
            if (!zoneFrom.is(ZoneType.Battlefield)) {
                zoneFrom.remove(c);
                checkAgain = true;
            }
        }
        return checkAgain;
    }

    public void checkGameOverCondition() {
        ArrayList<Player> losers = null;
        PlayerCollection allPlayers = this.game.getPlayers();
        for (Object p : allPlayers) {
            if (!((Player)p).checkLoseCondition()) continue;
            if (losers == null) {
                losers = Lists.newArrayListWithCapacity(3);
            }
            losers.add((Player)p);
        }
        GameEndReason reason = null;
        for (Player p : allPlayers) {
            if (!p.hasWon()) continue;
            reason = GameEndReason.WinsGameSpellEffect;
            for (Player pl : allPlayers) {
                if (pl.equals(p)) continue;
                if (!pl.loseConditionMet(GameLossReason.OpponentWon, p.getOutcome().altWinSourceName)) {
                    reason = null;
                    continue;
                }
                if (losers == null) {
                    losers = Lists.newArrayListWithCapacity(3);
                }
                losers.add(pl);
            }
        }
        if (losers != null) {
            for (Player p : allPlayers) {
                if (losers.contains(p) || !p.cantWin() || !losers.containsAll(p.getOpponents())) continue;
                System.err.println(p.toString() + " is about to win, but can't!");
            }
        }
        if (losers != null) {
            for (Player p : losers) {
                this.game.onPlayerLost(p);
            }
        }
        if (reason == null) {
            ArrayList<Player> notLost = Lists.newArrayList();
            HashSet<Integer> teams = Sets.newHashSet();
            for (Player p : allPlayers) {
                if (p.getOutcome() != null && !p.getOutcome().hasWon()) continue;
                notLost.add(p);
                teams.add(p.getTeam());
            }
            int cntNotLost = notLost.size();
            if (cntNotLost == 1) {
                reason = GameEndReason.AllOpponentsLost;
            } else if (cntNotLost == 0) {
                reason = GameEndReason.Draw;
            } else if (teams.size() == 1) {
                reason = GameEndReason.AllOpposingTeamsLost;
            } else {
                return;
            }
        }
        this.game.setGameOver(reason);
        this.game.getStack().clearSimultaneousStack();
    }

    private boolean handlePlaneswalkerRule(Player p, CardCollection noRegCreats) {
        CardCollection list = p.getPlaneswalkersInPlay();
        boolean recheck = false;
        for (Card c : list) {
            if (c.getCounters(CounterEnumType.LOYALTY) > 0) continue;
            noRegCreats.add(c);
            recheck = true;
        }
        return recheck;
    }

    private boolean handleLegendRule(Player p, CardCollection noRegCreats) {
        ArrayList<Card> a = Lists.newArrayList();
        for (Card c : CardLists.getType(p.getCardsIn(ZoneType.Battlefield), "Legendary")) {
            if (c.ignoreLegendRule()) continue;
            a.add(c);
        }
        if (a.isEmpty()) {
            return false;
        }
        boolean recheck = false;
        CardCollection nonLegendaryNames = CardLists.filter(a, Card::hasNonLegendaryCreatureNames);
        ImmutableListMultimap<String, Card> uniqueLegends = Multimaps.index(a, Card::getName);
        CardCollection removed = new CardCollection();
        for (String name : uniqueLegends.keySet()) {
            if (name.isEmpty()) continue;
            CardCollection cc = new CardCollection((Iterable<Card>)uniqueLegends.get(name));
            if (!name.isEmpty() && StaticData.instance().getCommonCards().isNonLegendaryCreatureName(name)) {
                cc.addAll(nonLegendaryNames);
            }
            if (cc.size() < 2) continue;
            recheck = true;
            Card toKeep = p.getController().chooseSingleEntityForEffect(cc, new SpellAbility.EmptySa(ApiType.InternalLegendaryRule, new Card(-1, this.game), p), "You have multiple legendary permanents named \"" + name + "\" in play.\n\nChoose the one to stay on battlefield (the rest will be moved to graveyard)", null);
            cc.remove(toKeep);
            removed.addAll(cc);
        }
        CardCollection emptyNameAllNonLegendary = new CardCollection(nonLegendaryNames);
        emptyNameAllNonLegendary.removeAll(removed);
        if (emptyNameAllNonLegendary.size() > 1) {
            recheck = true;
            Card toKeep = p.getController().chooseSingleEntityForEffect(emptyNameAllNonLegendary, new SpellAbility.EmptySa(ApiType.InternalLegendaryRule, new Card(-1, this.game), p), "You have multiple legendary permanents with non legendary creature names in play.\n\nChoose the one to stay on battlefield (the rest will be moved to graveyard)", null);
            emptyNameAllNonLegendary.remove(toKeep);
            removed.addAll(emptyNameAllNonLegendary);
        }
        noRegCreats.addAll(removed);
        return recheck;
    }

    private boolean handleWorldRule(CardCollection noRegCreats) {
        CardCollection worlds = CardLists.getType(this.game.getCardsIn(ZoneType.Battlefield), "World");
        if (worlds.size() <= 1) {
            return false;
        }
        ArrayList<Card> toKeep = Lists.newArrayList();
        long ts = 0L;
        for (Card crd : worlds) {
            long crdTs = crd.getGameTimestamp();
            if (crdTs > ts) {
                ts = crdTs;
                toKeep.clear();
            }
            if (crdTs != ts) continue;
            toKeep.add(crd);
        }
        if (toKeep.size() == 1) {
            worlds.removeAll((Collection<?>)toKeep);
        }
        noRegCreats.addAll(worlds);
        return true;
    }

    public final CardCollection sacrifice(Iterable<Card> list, SpellAbility source, boolean effect, Map<AbilityKey, Object> params) {
        Multimap lki = MultimapBuilder.hashKeys().arrayListValues().build();
        boolean showRevealDialog = source != null && source.hasParam("ShowSacrificedCards");
        CardCollection result = new CardCollection();
        for (Card card : list) {
            if (card == null || !card.canBeSacrificedBy(source, effect)) continue;
            Card lkiCopy = ((CardCollection)params.get((Object)AbilityKey.LastStateBattlefield)).get(card);
            card.getController().addSacrificedThisTurn(lkiCopy, source);
            lki.put(card.getController(), lkiCopy);
            card.updateWasDestroyed(true);
            Card changed = this.sacrificeDestroy(card, source, params);
            if (changed != null) {
                result.add(changed);
            }
            if (!showRevealDialog) continue;
            String message = Localizer.getInstance().getMessage("lblSacrifice", new Object[0]);
            this.game.getAction().reveal(result, ZoneType.Graveyard, card.getOwner(), false, message, false);
        }
        for (Map.Entry entry : lki.asMap().entrySet()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer((Player)entry.getKey());
            runParams.put(AbilityKey.Cards, new CardCollection((Iterable)entry.getValue()));
            runParams.put(AbilityKey.Cause, source);
            this.game.getTriggerHandler().runTrigger(TriggerType.SacrificedOnce, runParams, false);
        }
        return result;
    }

    public final boolean destroy(Card c, SpellAbility sa, boolean regenerate, Map<AbilityKey, Object> params) {
        if (!c.canBeDestroyed()) {
            return false;
        }
        Map<AbilityKey, Object> repRunParams = AbilityKey.mapFromAffected(c);
        repRunParams.put(AbilityKey.Cause, sa);
        repRunParams.put(AbilityKey.Regeneration, regenerate);
        if (params != null) {
            repRunParams.putAll(params);
        }
        if (this.game.getReplacementHandler().run(ReplacementType.Destroy, repRunParams) != ReplacementResult.NotReplaced) {
            return false;
        }
        Player activator = null;
        if (sa != null) {
            activator = sa.getActivatingPlayer();
        }
        c.updateWasDestroyed(true);
        this.game.fireEvent(new GameEventCardDestroyed());
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
        runParams.put(AbilityKey.Causer, activator);
        if (params != null) {
            runParams.putAll(params);
        }
        this.game.getTriggerHandler().runTrigger(TriggerType.Destroyed, runParams, false);
        Card sacrificed = this.sacrificeDestroy(c, sa, params);
        return sacrificed != null;
    }

    protected final Card sacrificeDestroy(Card c, SpellAbility cause, Map<AbilityKey, Object> params) {
        if (!c.isInPlay()) {
            return null;
        }
        Card newCard = this.moveToGraveyard(c, cause, params);
        return newCard;
    }

    public void revealTo(Card card, Player to) {
        this.revealTo(card, Collections.singleton(to));
    }

    public void revealTo(CardCollectionView cards, Player to) {
        this.revealTo(cards, to, null);
    }

    public void revealTo(CardCollectionView cards, Player to, String messagePrefix) {
        this.revealTo(cards, Collections.singleton(to), messagePrefix, true);
    }

    public void revealTo(Card card, Iterable<Player> to) {
        this.revealTo((CardCollectionView)new CardCollection(card), to);
    }

    public void revealTo(CardCollectionView cards, Iterable<Player> to) {
        this.revealTo(cards, to, null, true);
    }

    public void revealTo(CardCollectionView cards, Iterable<Player> to, String messagePrefix, boolean addSuffix) {
        if (cards.isEmpty()) {
            return;
        }
        ZoneType zone = ((Card)cards.getFirst()).getZone().getZoneType();
        Player owner = ((Card)cards.getFirst()).getOwner();
        for (Player p : to) {
            p.getController().reveal(cards, zone, owner, messagePrefix, addSuffix);
        }
    }

    public void reveal(CardCollectionView cards, Player cardOwner) {
        this.reveal(cards, cardOwner, true);
    }

    public void reveal(CardCollectionView cards, Player cardOwner, boolean dontRevealToOwner) {
        this.reveal(cards, cardOwner, dontRevealToOwner, null);
    }

    public void reveal(CardCollectionView cards, Player cardOwner, boolean dontRevealToOwner, String messagePrefix) {
        this.reveal(cards, cardOwner, dontRevealToOwner, messagePrefix, true);
    }

    public void reveal(CardCollectionView cards, Player cardOwner, boolean dontRevealToOwner, String messagePrefix, boolean msgAddSuffix) {
        Card firstCard = Iterables.getFirst(cards, null);
        if (firstCard == null) {
            return;
        }
        this.reveal(cards, this.game.getZoneOf(firstCard).getZoneType(), cardOwner, dontRevealToOwner, messagePrefix, msgAddSuffix);
    }

    public void reveal(CardCollectionView cards, ZoneType zt, Player cardOwner, boolean dontRevealToOwner, String messagePrefix) {
        this.reveal(cards, zt, cardOwner, dontRevealToOwner, messagePrefix, true);
    }

    public void reveal(CardCollectionView cards, ZoneType zt, Player cardOwner, boolean dontRevealToOwner, String messagePrefix, boolean msgAddSuffix) {
        for (Player p : this.game.getPlayers()) {
            if (dontRevealToOwner && cardOwner == p) continue;
            p.getController().reveal(cards, zt, cardOwner, messagePrefix, msgAddSuffix);
        }
    }

    public void revealUnplayableByAI(String title, Map<Player, Map<DeckSection, List<? extends PaperCard>>> unplayableCards) {
        for (Player p : this.game.getPlayers()) {
            p.getController().revealAISkipCards(title, unplayableCards);
        }
    }

    public void revealAnte(String title, Multimap<Player, PaperCard> removedAnteCards) {
        for (Player p : this.game.getPlayers()) {
            p.getController().revealAnte(title, removedAnteCards);
        }
    }

    public void notifyOfValue(SpellAbility saSource, GameObject relatedTarget, String value, Player playerExcept) {
        if (saSource != null) {
            String name = CardTranslation.getTranslatedName(saSource.getHostCard().getName());
            value = TextUtil.fastReplace(value, "CARDNAME", name);
            value = TextUtil.fastReplace(value, "NICKNAME", Lang.getInstance().getNickName(name));
        }
        for (Player p : this.game.getPlayers()) {
            if (playerExcept == p) continue;
            p.getController().notifyOfValue(saSource, relatedTarget, value);
        }
    }

    private void drawStartingHand(Player p1) {
        ArrayList<Card> lib1 = Lists.newArrayList(p1.getZone(ZoneType.Library).getCards().threadSafeIterable());
        List<Card> hand1 = lib1.subList(0, p1.getMaxHandSize());
        ArrayList<Card> shuffledCards = Lists.newArrayList(p1.getZone(ZoneType.Library).getCards().threadSafeIterable());
        Collections.shuffle(shuffledCards);
        List<Card> hand2 = shuffledCards.subList(0, p1.getMaxHandSize());
        float averageLandRatio = this.getLandRatio(lib1);
        if (this.getHandScore(hand1, averageLandRatio) > this.getHandScore(hand2, averageLandRatio)) {
            p1.getZone(ZoneType.Library).setCards(shuffledCards);
        }
        p1.drawCards(p1.getMaxHandSize());
    }

    private float getLandRatio(List<Card> deck) {
        int landCount = 0;
        for (Card c : deck) {
            if (!c.isLand()) continue;
            ++landCount;
        }
        if (landCount == 0) {
            return 0.0f;
        }
        return (float)landCount / (float)deck.size();
    }

    private float getHandScore(List<Card> hand, float landRatio) {
        int landCount = 0;
        for (Card c : hand) {
            if (!c.isLand()) continue;
            ++landCount;
        }
        float averageCount = landRatio * (float)hand.size();
        return Math.abs(averageCount - (float)landCount);
    }

    public void startGame(GameOutcome lastGameOutcome) {
        this.startGame(lastGameOutcome, null);
    }

    public void startGame(GameOutcome lastGameOutcome, Runnable startGameHook) {
        Player first = this.determineFirstTurnPlayer(lastGameOutcome);
        GameType gameType = this.game.getRules().getGameType();
        while (!this.game.isGameOver()) {
            this.game.fireEvent(new GameEventGameStarted(gameType, first, this.game.getPlayers()));
            this.runPreOpeningHandActions(first);
            this.game.setAge(GameStage.Mulligan);
            for (Player p1 : this.game.getPlayers()) {
                BackupPlanService backupPlans;
                if (StaticData.instance().getFilteredHandsEnabled()) {
                    this.drawStartingHand(p1);
                } else {
                    p1.drawCards(p1.getStartingHandSize());
                }
                if (!(backupPlans = new BackupPlanService(p1)).initializeExtraHands()) continue;
                backupPlans.chooseHand();
            }
            if (this.game.getRules().getGameType() != GameType.Puzzle) {
                new MulliganService(first).perform();
            }
            if (this.game.isGameOver()) break;
            this.game.setAge(GameStage.Play);
            if (this.game.getRules().hasAppliedVariant(GameType.Planechase)) {
                first.initPlane();
                for (Player p1 : this.game.getPlayers()) {
                    p1.createPlanechaseEffects(this.game);
                }
            }
            first = this.runOpeningHandActions(first);
            this.checkStateEffects(true);
            this.game.getTriggerHandler().runTrigger(TriggerType.NewGame, AbilityKey.newMap(), true);
            this.game.setStartingPlayer(first);
            this.game.getPhaseHandler().startFirstTurn(first, startGameHook);
            for (Player p : this.game.getRegisteredPlayers()) {
                p.setNumCardsInHandStartedThisTurnWith(p.getCardsIn(ZoneType.Hand).size());
                p.getController().autoPassCancel();
            }
            first = this.game.getPhaseHandler().getPlayerTurn();
            if (this.game.getAge() == GameStage.RestartedByKarn) continue;
        }
    }

    private Player determineFirstTurnPlayer(GameOutcome lastGameOutcome) {
        boolean isFirstGame;
        Player goesFirst = null;
        if (this.game != null) {
            if (this.game.getRules().getGameType().equals((Object)GameType.Puzzle)) {
                return (Player)this.game.getPlayers().get(false);
            }
            if (this.game.getRules().hasAppliedVariant(GameType.Archenemy)) {
                for (Object p : this.game.getPlayers()) {
                    if (!((Player)p).isArchenemy()) continue;
                    return p;
                }
            }
        }
        HashSet<Player> powerPlayers = Sets.newHashSet();
        for (Card c : this.game.getCardsIn(ZoneType.Command)) {
            if (!c.getName().equals("Power Play")) continue;
            powerPlayers.add(c.getOwner());
        }
        if (!powerPlayers.isEmpty()) {
            ArrayList players = Lists.newArrayList(powerPlayers);
            Collections.shuffle(players, MyRandom.getRandom());
            return (Player)players.get(0);
        }
        boolean bl = isFirstGame = lastGameOutcome == null;
        if (isFirstGame) {
            this.game.fireEvent(new GameEventFlipCoin());
            goesFirst = Aggregates.random(this.game.getPlayers());
        } else {
            for (Player p : this.game.getPlayers()) {
                if (lastGameOutcome.isWinner(p.getRegisteredPlayer())) continue;
                goesFirst = p;
                break;
            }
        }
        if (goesFirst == null) {
            goesFirst = (Player)this.game.getPlayers().get(false);
        }
        for (Player p : this.game.getPlayers()) {
            if (p == goesFirst) continue;
            p.getController().awaitNextInput();
        }
        goesFirst = goesFirst.getController().chooseStartingPlayer(isFirstGame);
        return goesFirst;
    }

    private void runPreOpeningHandActions(Player first) {
        Player takesAction = first;
        do {
            CardCollection ploys = CardLists.filter((Iterable<Card>)takesAction.getCardsIn(ZoneType.Command), input -> input.getName().equals("Emissary's Ploy"));
            CardCollection all = CardLists.filterControlledBy((Iterable<Card>)this.game.getCardsInGame(), takesAction);
            CardCollection spires = CardLists.filter((Iterable<Card>)all, input -> input.getName().equals("Cryptic Spires"));
            int chosen = 1;
            ArrayList<Integer> cmc = Lists.newArrayList(1, 2, 3);
            for (Card c : ploys) {
                if (!cmc.isEmpty()) {
                    SpellAbility.EmptySa sa = new SpellAbility.EmptySa(ApiType.ChooseNumber, c, takesAction);
                    chosen = takesAction.getController().chooseNumber((SpellAbility)sa, "Emissary's Ploy", cmc, c.getOwner());
                    cmc.remove((Object)chosen);
                }
                c.setChosenNumber(chosen);
            }
            for (Card c : spires) {
                if (c.hasChosenColor()) continue;
                ArrayList<String> colorChoices = new ArrayList<String>(MagicColor.Constant.ONLY_COLORS);
                String prompt = CardTranslation.getTranslatedName(c.getName()) + ": " + Localizer.getInstance().getMessage("lblChooseNColors", Lang.getNumeral(2));
                SpellAbility.EmptySa sa = new SpellAbility.EmptySa(ApiType.ChooseColor, c, takesAction);
                sa.putParam("AILogic", "MostProminentInComputerDeck");
                List<String> chosenColors = takesAction.getController().chooseColors(prompt, sa, 2, 2, colorChoices);
                c.setChosenColors(chosenColors);
            }
        } while ((takesAction = this.game.getNextPlayerAfter(takesAction)) != first);
    }

    private Player runOpeningHandActions(Player first) {
        Player takesAction = first;
        Player newFirst = first;
        do {
            List<SpellAbility> usableFromOpeningHand = Lists.newArrayList();
            for (Card c : takesAction.getCardsIn(ZoneType.Hand)) {
                for (KeywordInterface inst : c.getKeywords()) {
                    String kw = inst.getOriginal();
                    if (!kw.startsWith("MayEffectFromOpeningHand")) continue;
                    String[] split = kw.split(":");
                    String effName = split[1];
                    if (split.length > 2 && split[2].equalsIgnoreCase("!PlayFirst") && first == takesAction) continue;
                    SpellAbility effect = AbilityFactory.getAbility(c.getSVar(effName), c);
                    effect.setActivatingPlayer(takesAction);
                    usableFromOpeningHand.add(effect);
                }
            }
            if (!usableFromOpeningHand.isEmpty()) {
                usableFromOpeningHand = takesAction.getController().chooseSaToActivateFromOpeningHand(usableFromOpeningHand);
            }
            for (SpellAbility sa : usableFromOpeningHand) {
                if (!takesAction.getZone(ZoneType.Hand).contains(sa.getHostCard())) continue;
                takesAction.getController().playSpellAbilityNoStack(sa, true);
                if (!sa.hasParam("BecomeStartingPlayer")) continue;
                newFirst = takesAction;
            }
        } while ((takesAction = this.game.getNextPlayerAfter(takesAction)) != first);
        return newFirst;
    }

    public void invoke(Runnable proc) {
        if (ThreadUtil.isGameThread()) {
            proc.run();
        } else {
            ThreadUtil.invokeInGameThread(proc);
        }
    }

    public void becomeMonarch(Player p, String set) {
        Player previous = this.game.getMonarch();
        if (p == null || p.equals(previous)) {
            return;
        }
        if (previous != null) {
            previous.removeMonarchEffect();
        }
        if (!p.canBecomeMonarch()) {
            return;
        }
        p.createMonarchEffect(set);
        this.game.setMonarch(p);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(p);
        this.game.getTriggerHandler().runTrigger(TriggerType.BecomeMonarch, runParams, false);
    }

    public void takeInitiative(Player p, String set) {
        Player previous = this.game.getHasInitiative();
        if (p == null) {
            return;
        }
        if (!p.equals(previous)) {
            if (previous != null) {
                previous.removeInitiativeEffect();
            }
            if (p.hasLost()) {
                this.takeInitiative(this.game.getNextPlayerAfter(p), set);
            }
            this.game.setHasInitiative(p);
            p.createInitiativeEffect(set);
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(p);
        this.game.getTriggerHandler().runTrigger(TriggerType.TakesInitiative, runParams, false);
    }

    public void scry(List<Player> players, int numScry, SpellAbility cause) {
        Player p;
        CardCollection topN;
        if (numScry <= 0) {
            return;
        }
        LinkedHashMap<Player, Integer> actualPlayers = Maps.newLinkedHashMap();
        block4: for (Player p2 : players) {
            int playerScry = numScry;
            Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(p2);
            repParams.put(AbilityKey.Source, cause);
            repParams.put(AbilityKey.Num, playerScry);
            switch (this.game.getReplacementHandler().run(ReplacementType.Scry, repParams)) {
                case NotReplaced: {
                    break;
                }
                case Updated: {
                    playerScry = (Integer)repParams.get((Object)AbilityKey.Num);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (playerScry <= 0) continue;
            actualPlayers.put(p2, playerScry);
            if (players.size() <= 1) continue;
            topN = new CardCollection(p2.getCardsIn(ZoneType.Library, playerScry));
            this.revealTo((CardCollectionView)topN, p2);
        }
        LinkedHashMap<Player, ImmutablePair<CardCollection, CardCollection>> decisions = Maps.newLinkedHashMap();
        for (Map.Entry e : actualPlayers.entrySet()) {
            p = (Player)e.getKey();
            topN = new CardCollection(p.getCardsIn(ZoneType.Library, (Integer)e.getValue()));
            ImmutablePair<CardCollection, CardCollection> decision = p.getController().arrangeForScry(topN);
            decisions.put(p, decision);
            int numToTop = decision.getLeft() == null ? 0 : decision.getLeft().size();
            int numToBottom = decision.getRight() == null ? 0 : decision.getRight().size();
            this.game.fireEvent(new GameEventScry(p, numToTop, numToBottom));
        }
        for (Map.Entry e : decisions.entrySet()) {
            p = (Player)e.getKey();
            CardCollection toTop = (CardCollection)((ImmutablePair)e.getValue()).getLeft();
            CardCollection toBottom = (CardCollection)((ImmutablePair)e.getValue()).getRight();
            int numLookedAt = 0;
            if (toTop != null) {
                numLookedAt += toTop.size();
                Collections.reverse(toTop);
                for (Card c : toTop) {
                    this.moveToLibrary(c, cause, null);
                }
            }
            if (toBottom != null) {
                numLookedAt += toBottom.size();
                for (Card c : toBottom) {
                    this.moveToBottomOfLibrary(c, cause, null);
                }
            }
            if (cause == null) continue;
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(p);
            runParams.put(AbilityKey.ScryNum, numLookedAt);
            runParams.put(AbilityKey.ScryBottom, toBottom == null ? 0 : toBottom.size());
            this.game.getTriggerHandler().runTrigger(TriggerType.Scry, runParams, false);
        }
    }

    public CardCollection mill(PlayerCollection millers, int numCards, ZoneType destination, SpellAbility sa, Map<AbilityKey, Object> moveParams) {
        boolean reveal = sa != null && !sa.hasParam("NoReveal");
        boolean showRevealDialog = sa != null && sa.hasParam("ShowMilledCards");
        CardCollection milled = new CardCollection();
        for (Player p : millers) {
            String toZoneStr;
            if (!p.isInGame()) continue;
            CardCollectionView milledPlayer = p.mill(numCards, destination, sa, moveParams);
            milled.addAll(milledPlayer);
            if (!reveal) continue;
            String string = toZoneStr = destination.equals((Object)ZoneType.Graveyard) ? "" : " (" + Localizer.getInstance().getMessage("lblMilledToZone", destination.getTranslatedName()) + ")";
            if (showRevealDialog) {
                String message = Localizer.getInstance().getMessage("lblMilledCards", new Object[0]);
                boolean addSuffix = !toZoneStr.isEmpty();
                this.game.getAction().reveal(milledPlayer, destination, p, false, message, addSuffix);
            }
            this.game.getGameLog().add(GameLogEntryType.ZONE_CHANGE, p + " milled " + Lang.joinHomogenous(milled) + toZoneStr + ".");
        }
        if (!milled.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, milled);
            this.game.getTriggerHandler().runTrigger(TriggerType.MilledAll, runParams, false);
        }
        return milled;
    }

    public void dealDamage(boolean isCombat, CardDamageMap damageMap, CardDamageMap preventMap, GameEntityCounterTable counterTable, SpellAbility cause) {
        if (isCombat) {
            for (Map.Entry et : damageMap.columnMap().entrySet()) {
                GameEntity ge = (GameEntity)et.getKey();
                if (!(ge instanceof Card)) continue;
                ((Card)ge).clearAssignedDamage();
            }
        }
        this.game.getReplacementHandler().runReplaceDamage(isCombat, damageMap, preventMap, counterTable, cause);
        HashMap<Card, Integer> lethalDamage = Maps.newHashMap();
        HashMap<Integer, Card> lkiCache = Maps.newHashMap();
        for (Map.Entry entry : damageMap.rowMap().entrySet()) {
            Card sourceLKI = (Card)entry.getKey();
            int sum = 0;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if ((Integer)entry2.getValue() <= 0) continue;
                if (entry2.getKey() instanceof Card && !lethalDamage.containsKey(entry2.getKey())) {
                    Card c = (Card)entry2.getKey();
                    lethalDamage.put(c, c.getExcessDamageValue(false));
                }
                entry2.setValue(((GameEntity)entry2.getKey()).addDamageAfterPrevention((Integer)entry2.getValue(), sourceLKI, cause, isCombat, counterTable));
                sum += ((Integer)entry2.getValue()).intValue();
                sourceLKI.getDamageHistory().registerDamage((Integer)entry2.getValue(), isCombat, sourceLKI, (GameEntity)entry2.getKey(), lkiCache);
            }
            if (sum <= 0 || !sourceLKI.hasKeyword(Keyword.LIFELINK)) continue;
            sourceLKI.getController().gainLife(sum, sourceLKI, cause);
        }
        damageMap.triggerExcessDamage(isCombat, lethalDamage, this.game, cause, lkiCache);
        HashMap<Player, Integer> lifeLostAllDamageMap = Maps.newHashMap();
        for (Player p : this.game.getPlayers()) {
            int lost = p.processDamage();
            if (lost <= 0) continue;
            lifeLostAllDamageMap.put(p, lost);
        }
        if (isCombat) {
            this.game.getTriggerHandler().runWaitingTriggers();
        }
        if (!lifeLostAllDamageMap.isEmpty()) {
            Map<AbilityKey, Object> map = AbilityKey.mapFromPIMap(lifeLostAllDamageMap);
            this.game.getTriggerHandler().runTrigger(TriggerType.LifeLostAll, map, false);
        }
        if (cause != null) {
            boolean rememberPlayer;
            Card card = this.game.getChangeZoneLKIInfo(cause.getHostCard());
            boolean rememberCard = cause.hasParam("RememberDamaged") || cause.hasParam("RememberDamagedCreature");
            boolean bl = rememberPlayer = cause.hasParam("RememberDamaged") || cause.hasParam("RememberDamagedPlayer");
            if (rememberCard || rememberPlayer) {
                for (GameEntity gameEntity : damageMap.row(card).keySet()) {
                    if (gameEntity instanceof Card && rememberCard) {
                        cause.getHostCard().addRemembered(gameEntity);
                        continue;
                    }
                    if (!(gameEntity instanceof Player) || !rememberPlayer) continue;
                    cause.getHostCard().addRemembered(gameEntity);
                }
            }
            if (cause.hasParam("RememberAmount")) {
                cause.getHostCard().addRemembered(damageMap.totalAmount());
            }
        }
        preventMap.triggerPreventDamage(isCombat);
        preventMap.clear();
        damageMap.triggerDamageDoneOnce(isCombat, this.game);
        damageMap.clear();
        counterTable.replaceCounterEffect(this.game, cause, !isCombat);
        counterTable.clear();
    }

    public void completeDungeon(Player player, Card dungeon) {
        player.addCompletedDungeon(dungeon);
        this.ceaseToExist(dungeon, true);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(dungeon);
        runParams.put(AbilityKey.Player, player);
        this.game.getTriggerHandler().runTrigger(TriggerType.DungeonCompleted, runParams, false);
    }

    public static boolean attachAuraOnIndirectEnterBattlefield(Card source, Map<AbilityKey, Object> params) {
        SpellAbility aura = source.getFirstAttachSpell();
        if (aura == null) {
            return false;
        }
        aura.setActivatingPlayer(source.getController());
        Game game = source.getGame();
        TargetRestrictions tgt = aura.getTargetRestrictions();
        Player p = source.getController();
        if (tgt.canTgtPlayer()) {
            PlayerCollection players = game.getPlayers().filter(PlayerPredicates.canBeAttached(source, aura));
            Player pa = p.getController().chooseSingleEntityForEffect(players, aura, Localizer.getInstance().getMessage("lblSelectAPlayerAttachSourceTo", CardTranslation.getTranslatedName(source.getName())), null);
            if (pa != null) {
                source.attachToEntity(pa, null, true);
                return true;
            }
        } else {
            ArrayList<ZoneType> zones = Lists.newArrayList(tgt.getZone());
            CardCollection list = new CardCollection();
            if (params != null) {
                if (zones.contains((Object)ZoneType.Battlefield)) {
                    list.addAll((CardCollectionView)params.get((Object)AbilityKey.LastStateBattlefield));
                    zones.remove((Object)ZoneType.Battlefield);
                }
                if (zones.contains((Object)ZoneType.Graveyard)) {
                    list.addAll((CardCollectionView)params.get((Object)AbilityKey.LastStateGraveyard));
                    zones.remove((Object)ZoneType.Graveyard);
                }
            }
            list.addAll(game.getCardsIn(zones));
            list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeAttached(source, aura));
            if (list.isEmpty()) {
                return false;
            }
            Card o = p.getController().chooseSingleEntityForEffect(list, aura, Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", CardTranslation.getTranslatedName(source.getName())), null);
            if (o != null) {
                source.attachToEntity(game.getCardState(o), null, true);
                return true;
            }
        }
        return false;
    }

    private static void unanimateOnAbortedChange(SpellAbility cause, Card c) {
        if (cause.hasParam("AnimateSubAbility")) {
            long unanimateTimestamp = Long.parseLong(cause.getAdditionalAbility("AnimateSubAbility").getSVar("unanimateTimestamp"));
            c.removeChangedCardKeywords(unanimateTimestamp, 0L);
            c.removeChangedCardTypes(unanimateTimestamp, 0L);
            c.removeChangedName(unanimateTimestamp, 0L);
            c.removeNewPT(unanimateTimestamp, 0L);
            if (c.removeChangedCardTraits(unanimateTimestamp, 0L)) {
                c.updateStateForView();
            }
        }
    }

    public CardCollectionView getLastState(AbilityKey key, SpellAbility cause, Map<AbilityKey, Object> params, boolean refreshIfEmpty) {
        CardCollectionView lastState = null;
        if (params != null) {
            lastState = (CardCollectionView)params.get((Object)key);
        }
        if (lastState == null && cause != null) {
            if (key == AbilityKey.LastStateBattlefield) {
                lastState = cause.getLastStateBattlefield();
            }
            if (key == AbilityKey.LastStateGraveyard) {
                lastState = cause.getLastStateGraveyard();
            }
        }
        if (lastState == null) {
            if (key == AbilityKey.LastStateBattlefield) {
                lastState = refreshIfEmpty ? this.game.copyLastStateBattlefield() : this.game.getLastStateBattlefield();
            }
            if (key == AbilityKey.LastStateGraveyard) {
                lastState = refreshIfEmpty ? this.game.copyLastStateGraveyard() : this.game.getLastStateGraveyard();
            }
        }
        return lastState;
    }
}

