/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import forge.card.CardTypeView;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.card.CounterEnumType;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.mana.Mana;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCastWithFlash;
import forge.game.staticability.StaticAbilityColorlessDamageSource;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class ForgeScript {
    public static boolean cardStateHasProperty(CardState cardState, String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        boolean withSource = property.endsWith("Source");
        ColorSet colors = withSource && StaticAbilityColorlessDamageSource.colorlessDamageSource(cardState) ? ColorSet.getNullColor() : cardState.getCard().getColor(cardState);
        CardTypeView type = cardState.getTypeWithChanges();
        if (property.contains("White") || property.contains("Blue") || property.contains("Black") || property.contains("Red") || property.contains("Green")) {
            boolean mustHave = !property.startsWith("non");
            String colorName = property.substring(mustHave ? 0 : 3, property.length() - (withSource ? 6 : 0));
            byte desiredColor = MagicColor.fromName(colorName);
            boolean hasColor = colors.hasAnyColor(desiredColor);
            return mustHave == hasColor;
        }
        if (property.contains("Colorless")) {
            boolean non = property.startsWith("non");
            return non != colors.isColorless();
        }
        if (property.startsWith("MultiColor")) {
            return colors.isMulticolor();
        }
        if (property.startsWith("EnemyColor")) {
            if (colors.countColors() != 2) {
                return false;
            }
            for (byte pair : Arrays.copyOfRange(MagicColor.COLORPAIR, 5, 10)) {
                if (!colors.hasExactlyColor(pair)) continue;
                return true;
            }
            return false;
        }
        if (property.startsWith("AllColors")) {
            return colors.isAllColors();
        }
        if (property.startsWith("MonoColor")) {
            return colors.isMonoColor();
        }
        if (property.startsWith("ChosenColor")) {
            return source.hasChosenColor() && colors.hasAnyColor(MagicColor.fromName(source.getChosenColor()));
        }
        if (property.startsWith("AnyChosenColor")) {
            return source.hasChosenColor() && colors.hasAnyColor(ColorSet.fromNames(source.getChosenColors()).getColor());
        }
        if (property.equals("AssociatedWithChosenColor")) {
            String color;
            switch (color = source.getChosenColor()) {
                case "white": {
                    return type.hasSubtype("Plains");
                }
                case "blue": {
                    return type.hasSubtype("Island");
                }
                case "black": {
                    return type.hasSubtype("Swamp");
                }
                case "red": {
                    return type.hasSubtype("Mountain");
                }
                case "green": {
                    return type.hasSubtype("Forest");
                }
            }
            return false;
        }
        if (property.equals("Outlaw")) {
            return type.isOutlaw();
        }
        if (property.startsWith("non")) {
            return !type.hasStringType(property.substring(3));
        }
        if (property.equals("CostsPhyrexianMana")) {
            return cardState.getManaCost().hasPhyrexian();
        }
        if (property.startsWith("HasSVar")) {
            String svar = property.substring(8);
            return cardState.hasSVar(svar);
        }
        if (property.equals("ChosenType")) {
            String chosenType = source.getChosenType();
            if (chosenType.startsWith("Non")) {
                return !type.hasStringType(StringUtils.capitalize(chosenType.substring(3)));
            }
            return type.hasStringType(chosenType);
        }
        if (property.equals("IsNotChosenType")) {
            return !type.hasStringType(source.getChosenType());
        }
        if (property.equals("ChosenType2")) {
            return type.hasStringType(source.getChosenType2());
        }
        if (property.equals("IsNotChosenType2")) {
            return !type.hasStringType(source.getChosenType2());
        }
        if (property.equals("NotedType")) {
            boolean found = false;
            for (String s2 : source.getNotedTypes()) {
                if (!type.hasStringType(s2)) continue;
                found = true;
                break;
            }
            return found;
        }
        if (property.equals("hasActivatedAbilityWithTapCost")) {
            for (SpellAbility sa : cardState.getSpellAbilities()) {
                if (!sa.isActivatedAbility() || !sa.getPayCosts().hasTapCost()) continue;
                return true;
            }
            return false;
        }
        if (property.equals("hasActivatedAbility")) {
            for (SpellAbility sa : cardState.getSpellAbilities()) {
                if (!sa.isActivatedAbility()) continue;
                return true;
            }
            return false;
        }
        if (property.equals("hasOtherActivatedAbility")) {
            for (SpellAbility sa : cardState.getSpellAbilities()) {
                if (!sa.isActivatedAbility() || sa.equals(spellAbility)) continue;
                return true;
            }
            return false;
        }
        if (property.equals("hasManaAbility")) {
            if (!cardState.getManaAbilities().isEmpty()) {
                return true;
            }
            for (Trigger trig : cardState.getTriggers()) {
                SpellAbility sa = trig.getOverridingAbility();
                if (sa == null) continue;
                if (!sa.isTrigger()) {
                    sa.setTrigger(trig);
                }
                if (!sa.isManaAbility()) continue;
                return true;
            }
            return false;
        }
        if (property.equals("hasNonManaActivatedAbility")) {
            for (SpellAbility sa : cardState.getNonManaAbilities()) {
                if (!sa.isActivatedAbility()) continue;
                return true;
            }
            return false;
        }
        if (property.startsWith("cmc")) {
            String rhs = property.substring(5);
            int y = cardState.getManaCost().getCMC();
            int x = AbilityUtils.calculateAmount(source, rhs, spellAbility);
            return Expressions.compare(y, property, x);
        }
        return type.hasStringType(property);
    }

    public static boolean spellAbilityHasProperty(SpellAbility sa, String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        if (property.equals("ManaAbility")) {
            return sa.isManaAbility();
        }
        if (property.equals("nonManaAbility")) {
            return !sa.isManaAbility();
        }
        if (property.equals("withoutXCost")) {
            return !sa.costHasManaX();
        }
        if (property.startsWith("XCost")) {
            String comparator = property.substring(5, 7);
            int y = AbilityUtils.calculateAmount(sa.getHostCard(), property.substring(7), sa);
            return Expressions.compare(sa.getXManaCostPaid() == null ? 0 : sa.getXManaCostPaid(), comparator, y);
        }
        if (property.equals("hasTapCost")) {
            Cost cost = sa.getPayCosts();
            return cost != null && cost.hasTapCost();
        }
        if (property.equals("Bargain")) {
            return sa.isBargained();
        }
        if (property.equals("Backup")) {
            return sa.isBackup();
        }
        if (property.equals("Bestow")) {
            return sa.isBestow();
        }
        if (property.equals("Blitz")) {
            return sa.isBlitz();
        }
        if (property.equals("Buyback")) {
            return sa.isBuyback();
        }
        if (property.equals("Craft")) {
            return sa.isCraft();
        }
        if (property.equals("Crew")) {
            return sa.isCrew();
        }
        if (property.equals("Cycling")) {
            return sa.isCycling();
        }
        if (property.equals("Dash")) {
            return sa.isDash();
        }
        if (property.equals("Disturb")) {
            return sa.isDisturb();
        }
        if (property.equals("Embalm")) {
            return sa.isEmbalm();
        }
        if (property.equals("Eternalize")) {
            return sa.isEternalize();
        }
        if (property.equals("Flashback")) {
            return sa.isFlashback();
        }
        if (property.equals("Jumpstart")) {
            return sa.isJumpstart();
        }
        if (property.equals("Kicked")) {
            return sa.isKicked();
        }
        if (property.equals("Loyalty")) {
            return sa.isPwAbility();
        }
        if (property.equals("Aftermath")) {
            return sa.isAftermath();
        }
        if (property.equals("MorphUp")) {
            return sa.isMorphUp();
        }
        if (property.equals("ManifestUp")) {
            return sa.isManifestUp();
        }
        if (property.equals("Unlock")) {
            return sa.isUnlock();
        }
        if (property.equals("isTurnFaceUp")) {
            return sa.isTurnFaceUp();
        }
        if (property.equals("isCastFaceDown")) {
            return sa.isCastFaceDown();
        }
        if (property.equals("Modular")) {
            return sa.isKeyword(Keyword.MODULAR);
        }
        if (property.equals("Equip")) {
            return sa.isEquip();
        }
        if (property.equals("Boast")) {
            return sa.isBoast();
        }
        if (property.equals("Mutate")) {
            return sa.isMutate();
        }
        if (property.equals("Ninjutsu")) {
            return sa.isNinjutsu();
        }
        if (property.equals("Foretelling")) {
            return sa.isForetelling();
        }
        if (property.equals("Foretold")) {
            return sa.isForetold();
        }
        if (property.equals("Plotting")) {
            return sa.isPlotting();
        }
        if (property.equals("Outlast")) {
            return sa.isOutlast();
        }
        if (property.equals("Modal")) {
            return sa.getApi() == ApiType.Charm;
        }
        if (property.equals("ClassLevelUp")) {
            return sa.getApi() == ApiType.ClassLevelUp;
        }
        if (property.equals("Daybound")) {
            return sa.isKeyword(Keyword.DAYBOUND);
        }
        if (property.equals("Nightbound")) {
            return sa.isKeyword(Keyword.NIGHTBOUND);
        }
        if (property.equals("Ward")) {
            return sa.isKeyword(Keyword.WARD);
        }
        if (property.equals("CumulativeUpkeep")) {
            return sa.isCumulativeUpkeep();
        }
        if (property.equals("ChapterNotLore")) {
            if (!sa.isChapter()) {
                return false;
            }
            if (sa.getChapter().intValue() == sa.getHostCard().getCounters(CounterEnumType.LORE)) {
                return false;
            }
        } else {
            if (property.equals("LastChapter")) {
                return sa.isLastChapter();
            }
            if (property.equals("paidPhyrexianMana")) {
                return sa.getSpendPhyrexianMana() > 0;
            }
            if (property.startsWith("ManaSpent")) {
                String[] k = property.split(" ", 2);
                String comparator = k[1].substring(0, 2);
                int y = AbilityUtils.calculateAmount(source, k[1].substring(2), spellAbility);
                return Expressions.compare(sa.getTotalManaSpent(), comparator, y);
            }
            if (property.startsWith("ManaFrom")) {
                Mana m4;
                Card manaSource;
                String fromWhat = property.substring(8);
                String[] parts = null;
                if (fromWhat.contains("_")) {
                    parts = fromWhat.split("_");
                    fromWhat = parts[0];
                }
                int toFind = parts != null ? AbilityUtils.calculateAmount(source, parts[1], spellAbility) : 1;
                int found = 0;
                Iterator<Mana> iterator = sa.getPayingMana().iterator();
                while (iterator.hasNext() && ((manaSource = (m4 = iterator.next()).getSourceCard()) == null || !manaSource.isValid(fromWhat, sourceController, source, spellAbility) || ++found != toFind)) {
                }
                return found == toFind;
            }
            if (property.equals("MayPlaySource")) {
                StaticAbility m5 = sa.getMayPlay();
                if (m5 == null) {
                    return false;
                }
                return source.equals(m5.getHostCard());
            }
            if (property.startsWith("singleTarget")) {
                int num = 0;
                for (TargetChoices tc : sa.getAllTargetChoices()) {
                    if ((num += tc.size()) <= 1) continue;
                    return false;
                }
                if (num != 1) {
                    return false;
                }
            } else {
                if (property.startsWith("numTargets")) {
                    HashSet<GameObject> targets = new HashSet<GameObject>();
                    for (TargetChoices tc : sa.getAllTargetChoices()) {
                        targets.addAll(tc);
                    }
                    String[] k = property.split(" ", 2);
                    String comparator = k[1].substring(0, 2);
                    int y = AbilityUtils.calculateAmount(sa.getHostCard(), k[1].substring(2), sa);
                    return Expressions.compare(targets.size(), comparator, y);
                }
                if (property.startsWith("IsTargeting")) {
                    String[] k = property.split(" ", 2);
                    String unescaped = k[1].replace("~", "+");
                    boolean found = false;
                    for (GameObject o : AbilityUtils.getDefinedObjects(source, unescaped, spellAbility)) {
                        if (!sa.getRootAbility().isTargeting(o)) continue;
                        found = true;
                        break;
                    }
                    return found;
                }
                if (property.equals("YouCtrl")) {
                    return sa.getActivatingPlayer().equals(sourceController);
                }
                if (property.equals("OppCtrl")) {
                    return sa.getActivatingPlayer().isOpponentOf(sourceController);
                }
                if (property.startsWith("cmc")) {
                    int x;
                    int y = 0;
                    y = sa.getHostCard().isInZone(ZoneType.Stack) ? sa.getHostCard().getCMC() : sa.getPayCosts().getTotalMana().getCMC();
                    if (!Expressions.compare(y, property, x = AbilityUtils.calculateAmount(source, property.substring(5), spellAbility))) {
                        return false;
                    }
                } else if (property.equals("ManaAbilityCantPaidFor")) {
                    SpellAbility paidFor = sourceController.getPaidForSA();
                    if (paidFor == null) {
                        return false;
                    }
                    ManaCostBeingPaid manaCost = paidFor.getManaCostBeingPaid();
                    byte colorCanUse = 0;
                    for (byte color : ManaAtom.MANATYPES) {
                        if (!manaCost.isAnyPartPayableWith(color, sourceController.getManaPool())) continue;
                        colorCanUse = (byte)(colorCanUse | color);
                    }
                    if (manaCost.isAnyPartPayableWith((byte)64, sourceController.getManaPool())) {
                        colorCanUse = (byte)(colorCanUse | 0x40);
                    }
                    if (sa.isManaAbilityFor(paidFor, colorCanUse)) {
                        return false;
                    }
                } else {
                    if (property.equals("NamedSpell")) {
                        boolean found = false;
                        for (String name : source.getNamedCards()) {
                            if (!sa.cardState.getName().equals(name)) continue;
                            found = true;
                            break;
                        }
                        return found;
                    }
                    if (property.equals("otherAbility")) {
                        if (sa.equals(spellAbility)) {
                            return false;
                        }
                        if (spellAbility instanceof SpellAbility) {
                            SpellAbility sourceSpell = (SpellAbility)spellAbility;
                            if (sa.getRootAbility().equals(sourceSpell.getRootAbility())) {
                                return false;
                            }
                        }
                    } else {
                        if (property.equals("CouldCastTiming")) {
                            Card host = sa.getHostCard();
                            Game game = host.getGame();
                            if (game.getStack().isSplitSecondOnStack()) {
                                return false;
                            }
                            if (sourceController.canCastSorcery() || sa.getRestrictions().isInstantSpeed()) {
                                return true;
                            }
                            if (sa.isSpell()) {
                                return host.isInstant() || host.hasKeyword(Keyword.FLASH) || StaticAbilityCastWithFlash.anyWithFlash(sa, host, sourceController);
                            }
                            if (sa.isActivatedAbility()) {
                                return !sa.isPwAbility() && !sa.getRestrictions().isSorcerySpeed();
                            }
                            return true;
                        }
                        if (sa.getHostCard() != null) {
                            return sa.getHostCard().hasProperty(property, sourceController, source, spellAbility);
                        }
                    }
                }
            }
        }
        return true;
    }
}

