/*
 * Decompiled with CFR 0.152.
 */
package forge.error;

import forge.gui.WrapLayout;
import forge.gui.error.BugReporter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class BugReportDialog {
    private static boolean dialogShown;

    public static void show(String title, String text, boolean showExitAppBtn) {
        if (dialogShown) {
            return;
        }
        JTextArea area = new JTextArea(text);
        area.setFont(new Font("Monospaced", 0, 10));
        area.setEditable(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        JPanel helpPanel = new JPanel(new WrapLayout(0, 4, 2));
        JPanel p = new JPanel(new MigLayout("wrap"));
        p.add((Component)helpPanel, "w 600");
        p.add((Component)new JScrollPane(area), "w 100%, h 100%, gaptop 5");
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(new JButton(new _Report()));
        options.add(new JCheckBox(new _ActivateSentry()));
        options.add(new JLabel(BugReporter.SENTRY));
        options.add(new JButton(new _SaveAction(area)));
        options.add(BugReporter.DISCARD);
        if (showExitAppBtn) {
            options.add(new JButton(new _ExitAction()));
        }
        JOptionPane pane = new JOptionPane(p, -1, -1, null, options.toArray(), options.get(0));
        JDialog dlg = pane.createDialog(JOptionPane.getRootFrame(), title);
        dlg.setSize(showExitAppBtn ? 780 : 600, 400);
        dlg.setResizable(true);
        dialogShown = true;
        dlg.setVisible(true);
        dlg.dispose();
        dialogShown = false;
    }

    private BugReportDialog() {
    }

    private static class _ExitAction
    extends AbstractAction {
        public _ExitAction() {
            super(BugReporter.EXIT);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    private static class _SaveAction
    extends AbstractAction {
        private final JTextArea area;

        public _SaveAction(JTextArea areaParam) {
            super(BugReporter.SAVE);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.area = areaParam;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BugReporter.saveToFile(this.area.getText());
        }
    }

    private static class _Report
    extends AbstractAction {
        public _Report() {
            super(BugReporter.REPORT);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BugReporter.sendSentry();
            JOptionPane.getRootFrame().dispose();
        }
    }

    private static class _ActivateSentry
    extends AbstractAction {
        private _ActivateSentry() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox checkBox = (JCheckBox)actionEvent.getSource();
            FModel.getPreferences().setPref(ForgePreferences.FPref.USE_SENTRY, checkBox.isSelected());
            FModel.getPreferences().save();
        }
    }
}

