/*
 * Decompiled with CFR 0.152.
 */
package forge.download;

import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.download.GuiDownloadService;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FProgressBar;
import forge.toolbox.FRadioButton;
import forge.toolbox.FSkin;
import forge.toolbox.FTextField;
import forge.toolbox.JXButtonPanel;
import forge.util.Callback;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class GuiDownloader
extends DefaultBoundedRangeModel {
    private final FPanel pnlDialog = new FPanel(new MigLayout("insets 0, gap 0, wrap, ax center, ay center"));
    private final FProgressBar progressBar = new FProgressBar();
    private final FButton btnStart = new FButton("Start");
    private final FTextField txtAddress = new FTextField.Builder().ghostText("Proxy Address").build();
    private final FTextField txtPort = new FTextField.Builder().ghostText("Proxy Port").build();
    private final UiCommand cmdClose = new UiCommand(){

        @Override
        public void run() {
            GuiDownloader.this.service.setCancel(true);
            SOverlayUtils.hideOverlay();
            if (GuiDownloader.this.callback != null) {
                GuiDownloader.this.callback.run(GuiDownloader.this.btnStart.getText() == "OK");
            }
        }
    };
    private final FLabel btnClose = new FLabel.Builder().text("X").hoverable(true).fontAlign(0).cmdClick(this.cmdClose).build();
    private final FRadioButton radProxyNone = new FRadioButton("No Proxy");
    private final FRadioButton radProxySocks = new FRadioButton("SOCKS Proxy");
    private final FRadioButton radProxyHTTP = new FRadioButton("HTTP Proxy");
    private final GuiDownloadService service;
    private final Callback<Boolean> callback;

    public GuiDownloader(GuiDownloadService service0) {
        this(service0, null);
    }

    public GuiDownloader(GuiDownloadService service0, Callback<Boolean> callback0) {
        this.service = service0;
        this.callback = callback0;
        String radConstraints = "w 100%!, h 30px!, gap 2% 0 0 10px";
        JXButtonPanel grpPanel = new JXButtonPanel();
        grpPanel.add((Component)this.radProxyNone, "w 100%!, h 30px!, gap 2% 0 0 10px");
        grpPanel.add((Component)this.radProxyHTTP, "w 100%!, h 30px!, gap 2% 0 0 10px");
        grpPanel.add((Component)this.radProxySocks, "w 100%!, h 30px!, gap 2% 0 0 10px");
        this.radProxyNone.addChangeListener(new ProxyHandler(0));
        this.radProxyHTTP.addChangeListener(new ProxyHandler(1));
        this.radProxySocks.addChangeListener(new ProxyHandler(2));
        this.radProxyNone.setSelected(true);
        this.btnClose.setBorder(new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_TEXT)));
        this.btnStart.setFont(FSkin.getRelativeFont(18));
        this.btnStart.setEnabled(false);
        this.progressBar.reset();
        this.progressBar.setString("Scanning for existing items...");
        this.pnlDialog.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        this.pnlDialog.add((Component)grpPanel, "w 50%!");
        this.pnlDialog.add((Component)this.txtAddress, "w 95%!, h 30px!, gap 2% 0 0 10px");
        this.pnlDialog.add((Component)this.txtPort, "w 95%!, h 30px!, gap 2% 0 0 10px");
        this.pnlDialog.add((Component)this.progressBar, "w 95%!, h 40px!, gap 2% 0 20px 0");
        this.pnlDialog.add((Component)this.btnStart, "w 200px!, h 40px!, gap 0 0 20px 0, ax center");
        this.pnlDialog.add((Component)this.btnClose, "w 20px!, h 20px!, pos 370px 10px");
    }

    public void show() {
        FSkin.SkinnedPanel pnl = FOverlay.SINGLETON_INSTANCE.getPanel();
        pnl.removeAll();
        pnl.setLayout(new MigLayout("insets 0, gap 0, wrap, ax center, ay center"));
        pnl.add((Component)this.pnlDialog, "w 400px!, h 350px!, ax center, ay center");
        SOverlayUtils.showOverlay();
        this.service.initialize(this.txtAddress, this.txtPort, this.progressBar, this.btnStart, this.cmdClose, null, this::fireStateChanged);
    }

    private class ProxyHandler
    implements ChangeListener {
        private final int type;

        public ProxyHandler(int type) {
            this.type = type;
        }

        @Override
        public final void stateChanged(ChangeEvent e) {
            if (((AbstractButton)e.getSource()).isSelected()) {
                GuiDownloader.this.service.setType(this.type);
                GuiDownloader.this.txtAddress.setEnabled(this.type != 0);
                GuiDownloader.this.txtPort.setEnabled(this.type != 0);
            }
        }
    }
}

