/*
 * Decompiled with CFR 0.152.
 */
package forge.download;

import com.google.common.collect.ImmutableList;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadZipService;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.BuildInfo;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.WaitCallback;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class AutoUpdater {
    private final String SNAPSHOT_VERSION_INDEX = "https://downloads.cardforge.org/dailysnapshots/";
    private final String RELEASE_VERSION_INDEX = "https://releases.cardforge.org/";
    private static final boolean VERSION_FROM_METADATA = true;
    private static final Localizer localizer = Localizer.getInstance();
    public static String[] updateChannels = new String[]{"none", "snapshot", "release"};
    private final boolean isLoading;
    private String updateChannel;
    private String version;
    private final String buildVersion;
    private String versionUrlString;
    private String packageUrl;
    private String packagePath;

    public AutoUpdater(boolean loading) {
        this.isLoading = loading;
        this.updateChannel = FModel.getPreferences().getPref(ForgePreferences.FPref.AUTO_UPDATE);
        this.buildVersion = BuildInfo.getVersionString();
    }

    public boolean updateAvailable() {
        return this.verifyUpdateable();
    }

    public boolean attemptToUpdate() {
        if (!this.verifyUpdateable()) {
            return false;
        }
        try {
            if (this.downloadUpdate()) {
                this.extractAndRestart();
            }
        }
        catch (IOException | URISyntaxException e) {
            return false;
        }
        return true;
    }

    private void extractAndRestart() {
        this.extractUpdate();
        this.restartForge();
    }

    private boolean verifyUpdateable() {
        if (this.buildVersion.contains("GIT")) {
            // empty if block
        }
        if (this.isLoading) {
            return false;
        }
        if (this.updateChannel.equals("none")) {
            String message = localizer.getMessage("lblYouHaventSetUpdateChannel", new Object[0]);
            ImmutableList<String> options = ImmutableList.of("Cancel", "release", "snapshot");
            int option = SOptionPane.showOptionDialog(message, localizer.getMessage("lblManualCheck", new Object[0]), null, options, 0);
            if (option < 1) {
                return false;
            }
            this.updateChannel = (String)options.get(option);
        }
        if (this.buildVersion.contains("SNAPSHOT")) {
            if (!this.updateChannel.equals("snapshot")) {
                System.out.println("Snapshot build versions must use snapshot update channel to work");
                return false;
            }
            this.versionUrlString = "https://downloads.cardforge.org/dailysnapshots/version.txt";
        } else {
            if (!this.updateChannel.equals("release")) {
                System.out.println("Release build versions must use release update channel to work");
                return false;
            }
            this.versionUrlString = "https://releases.cardforge.org/forge/forge-gui-desktop/version.txt";
        }
        if (!this.testNetConnection()) {
            return false;
        }
        return this.compareBuildWithLatestChannelVersion();
    }

    private boolean testNetConnection() {
        boolean bl;
        Socket socket = new Socket();
        try {
            InetSocketAddress address = new InetSocketAddress("releases.cardforge.org", 443);
            socket.connect(address, 1000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private boolean compareBuildWithLatestChannelVersion() {
        try {
            this.retrieveVersion();
            if (StringUtils.isEmpty(this.version)) {
                return false;
            }
            if (this.buildVersion.equals(this.version)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void retrieveVersion() throws MalformedURLException {
        if (this.updateChannel.equals("release")) {
            this.extractVersionFromMavenRelease();
        } else {
            URL versionUrl = new URL(this.versionUrlString);
            this.version = FileUtil.readFileToString(versionUrl);
        }
        this.packageUrl = this.updateChannel.equals("release") ? "https://releases.cardforge.org/forge/forge-gui-desktop/" + this.version + "/forge-gui-desktop-" + this.version + ".tar.bz2" : "https://downloads.cardforge.org/dailysnapshots/forge-gui-desktop-" + this.version + ".tar.bz2";
    }

    private void extractVersionFromMavenRelease() throws MalformedURLException {
        String RELEASE_MAVEN_METADATA = "https://releases.cardforge.org/forge/forge-gui-desktop/maven-metadata.xml";
        URL metadataUrl = new URL(RELEASE_MAVEN_METADATA);
        String xml = FileUtil.readFileToString(metadataUrl);
        Pattern p = Pattern.compile("<release>(.*)</release>");
        Matcher m4 = p.matcher(xml);
        while (m4.find()) {
            this.version = m4.group(1);
        }
    }

    private boolean downloadUpdate() throws URISyntaxException, IOException {
        if (this.isLoading) {
            return this.downloadFromBrowser();
        }
        String message = localizer.getMessage("lblNewVersionForgeAvailableUpdateConfirm", this.version, this.buildVersion);
        ImmutableList<String> options = ImmutableList.of(localizer.getMessage("lblUpdateNow", new Object[0]), localizer.getMessage("lblUpdateLater", new Object[0]));
        if (SOptionPane.showOptionDialog(message, localizer.getMessage("lblNewVersionAvailable", new Object[0]), null, options, 0) == 0) {
            return this.downloadFromForge();
        }
        return false;
    }

    private boolean downloadFromBrowser() throws URISyntaxException, IOException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(this.packageUrl));
            return true;
        }
        System.out.println("Download latest version: " + this.packageUrl);
        return false;
    }

    private boolean downloadFromForge() {
        System.out.println("Downloading update from " + this.packageUrl + " to tmp/");
        WaitCallback<Boolean> callback = new WaitCallback<Boolean>(){

            @Override
            public void run() {
                GuiBase.getInterface().download(new GuiDownloadZipService("Auto Updater", localizer.getMessage("lblNewVersionDownloading", new Object[0]), AutoUpdater.this.packageUrl, "tmp/", null, null){

                    @Override
                    public void downloadAndUnzip() {
                        AutoUpdater.this.packagePath = this.download(AutoUpdater.this.version + "-upgrade.tar.bz2");
                        if (AutoUpdater.this.packagePath != null) {
                            AutoUpdater.this.extractAndRestart();
                        }
                    }
                }, this);
            }
        };
        SwingUtilities.invokeLater(callback);
        return false;
    }

    private void extractUpdate() {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null) {
            try {
                desktop.open(new File(this.packagePath).getParentFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(this.packagePath);
        }
    }

    private void restartForge() {
        if (this.isLoading || SOptionPane.showConfirmDialog(localizer.getMessage("lblForgeHasBeenUpdateRestartForgeToUseNewVersion", new Object[0]), localizer.getMessage("lblExitNowConfirm", new Object[0]))) {
            System.exit(0);
        }
    }
}

