/*
 * Decompiled with CFR 0.152.
 */
package forge.deckchooser;

import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.card.CardView;
import forge.gui.CardDetailPanel;
import forge.gui.CardPicturePanel;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerContainer;
import forge.itemmanager.ItemManagerModel;
import forge.itemmanager.views.ImageView;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.FButton;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import forge.view.FDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class FDeckViewer
extends FDialog {
    private final Deck deck;
    private final List<DeckSection> sections = new ArrayList<DeckSection>();
    private final CardManager cardManager;
    private DeckSection currentSection;
    private final CardDetailPanel cardDetail = new CardDetailPanel();
    private final CardPicturePanel cardPicture = new CardPicturePanel();
    private final FButton btnCopyToClipboard = new FButton(Localizer.getInstance().getMessage("btnCopyToClipboard", new Object[0]));
    private final FButton btnChangeSection = new FButton(Localizer.getInstance().getMessage("lblChangeSection", new Object[0]));
    private final FButton btnClose = new FButton(Localizer.getInstance().getMessage("lblClose", new Object[0]));

    public static void show(Deck deck) {
        if (deck == null) {
            return;
        }
        FDeckViewer deckViewer = new FDeckViewer(deck);
        deckViewer.setVisible(true);
        deckViewer.dispose();
    }

    private FDeckViewer(Deck deck0) {
        int height;
        int width;
        this.deck = deck0;
        this.setTitle(this.deck.getName());
        this.cardManager = new CardManager(null, false, false, false){

            @Override
            protected ImageView<PaperCard> createImageView(ItemManagerModel<PaperCard> model0) {
                return new ImageView<PaperCard>((ItemManager)this, model0, false){

                    @Override
                    protected void showHoveredItem(PaperCard item) {
                        CardView card = CardView.getCardForUi(item);
                        if (card == null) {
                            return;
                        }
                        FDeckViewer.this.cardDetail.setCard(card);
                        FDeckViewer.this.cardPicture.setCard(card.getCurrentState());
                    }
                };
            }
        };
        this.cardManager.setPool(this.deck.getMain());
        this.cardManager.addSelectionListener(e -> {
            IPaperCard paperCard = (IPaperCard)this.cardManager.getSelectedItem();
            if (paperCard == null) {
                return;
            }
            CardView card = CardView.getCardForUi(paperCard);
            if (card == null) {
                return;
            }
            this.cardDetail.setCard(card);
            this.cardPicture.setCard(card.getCurrentState());
        });
        for (Map.Entry<DeckSection, CardPool> entry : this.deck) {
            this.sections.add(entry.getKey());
        }
        this.currentSection = DeckSection.Main;
        this.updateCaption();
        this.btnCopyToClipboard.setFocusable(false);
        this.btnCopyToClipboard.addActionListener(arg0 -> this.copyToClipboard());
        this.btnChangeSection.setFocusable(false);
        if (this.sections.size() > 1) {
            this.btnChangeSection.addActionListener(arg0 -> this.changeSection());
        } else {
            this.btnChangeSection.setEnabled(false);
        }
        this.btnClose.setFocusable(false);
        this.btnClose.addActionListener(arg0 -> this.setVisible(false));
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SMALL_DECK_VIEWER)) {
            width = 800;
            height = 600;
        } else {
            GraphicsDevice gd = this.getGraphicsConfiguration().getDevice();
            width = (int)((double)gd.getDisplayMode().getWidth() * 0.7);
            height = (int)((double)gd.getDisplayMode().getHeight() * 0.8);
        }
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
        this.cardPicture.setOpaque(false);
        JPanel cardPanel = new JPanel(new MigLayout("insets 0, gap 0, wrap"));
        cardPanel.setOpaque(false);
        cardPanel.add((Component)this.cardDetail, "w 225px, h 240px, gapbottom 10px");
        cardPanel.add((Component)this.cardPicture, "w 225px, h 350px, gapbottom 10px");
        JPanel buttonPanel = new JPanel(new MigLayout("insets 0, gap 0"));
        buttonPanel.setOpaque(false);
        buttonPanel.add((Component)this.btnCopyToClipboard, "w 200px!, h 26px!, gapright 5px");
        buttonPanel.add((Component)this.btnChangeSection, "w 200px!, h 26px!");
        this.add((Component)new ItemManagerContainer(this.cardManager), "push, grow, gapright 10px, gapbottom 10px");
        this.add((Component)cardPanel, "wrap");
        this.add(buttonPanel);
        this.add((Component)this.btnClose, "w 120px!, h 26px!, ax right");
        this.cardManager.setup(ItemManagerConfig.DECK_VIEWER);
        this.setDefaultFocus(this.cardManager.getCurrentView().getComponent());
    }

    private void changeSection() {
        int index = this.sections.indexOf((Object)this.currentSection);
        index = (index + 1) % this.sections.size();
        this.currentSection = this.sections.get(index);
        this.cardManager.setPool(this.deck.get(this.currentSection));
        this.updateCaption();
    }

    private void updateCaption() {
        this.cardManager.setCaption(this.deck.getName() + " - " + this.currentSection.name());
    }

    private void copyToClipboard() {
        String nl = System.lineSeparator();
        StringBuilder deckList = new StringBuilder();
        String dName = this.deck.getName();
        if (dName.startsWith("[Commander") || dName.contains("Commander")) {
            dName = "";
        }
        deckList.append(dName == null ? "" : "Deck: " + dName + nl + nl);
        for (DeckSection s2 : DeckSection.values()) {
            CardPool cp = this.deck.get(s2);
            if (cp == null || cp.isEmpty()) continue;
            deckList.append(s2.toString()).append(": ");
            TreeMap<String, Integer> sectionCards = new TreeMap<String, Integer>();
            deckList.append(nl);
            for (Map.Entry entry : cp) {
                String cardName = ((PaperCard)entry.getKey()).getCardName();
                if (sectionCards.containsKey(cardName)) {
                    sectionCards.put(cardName, (Integer)sectionCards.get(cardName) + entry.getValue());
                    continue;
                }
                sectionCards.put(cardName, entry.getValue());
            }
            for (Map.Entry<Object, Integer> entry : sectionCards.entrySet()) {
                deckList.append(entry.getValue()).append(" ").append((String)entry.getKey()).append(nl);
            }
            deckList.append(nl);
        }
        StringSelection ss = new StringSelection(deckList.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
        FOptionPane.showMessageDialog(Localizer.getInstance().getMessage("lblDeckListCopiedClipboard", this.deck.getName()));
    }
}

