/*
 * Decompiled with CFR 0.152.
 */
package forge.deckchooser;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import forge.deck.ArchetypeDeckGenerator;
import forge.deck.ColorDeckGenerator;
import forge.deck.CommanderDeckGenerator;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckProxy;
import forge.deck.DeckType;
import forge.deck.DeckgenUtil;
import forge.deck.NetDeckArchiveBlock;
import forge.deck.NetDeckArchiveLegacy;
import forge.deck.NetDeckArchiveModern;
import forge.deck.NetDeckArchivePauper;
import forge.deck.NetDeckArchivePioneer;
import forge.deck.NetDeckArchiveStandard;
import forge.deck.NetDeckArchiveVintage;
import forge.deck.NetDeckCategory;
import forge.deck.RandomDeckGenerator;
import forge.deckchooser.DecksComboBox;
import forge.deckchooser.DecksComboBoxEvent;
import forge.deckchooser.FDeckViewer;
import forge.deckchooser.IDecksComboBoxListener;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.gui.UiCommand;
import forge.item.PaperCard;
import forge.itemmanager.DeckManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.ItemManagerContainer;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.controllers.CDetailPicture;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class FDeckChooser
extends JPanel
implements IDecksComboBoxListener {
    private DecksComboBox decksComboBox;
    private DeckType selectedDeckType;
    private ItemManagerContainer lstDecksContainer;
    private NetDeckCategory netDeckCategory;
    private NetDeckArchiveStandard NetDeckArchiveStandard;
    private NetDeckArchivePioneer NetDeckArchivePioneer;
    private NetDeckArchiveModern NetDeckArchiveModern;
    private NetDeckArchivePauper NetDeckArchivePauper;
    private NetDeckArchiveLegacy NetDeckArchiveLegacy;
    private NetDeckArchiveVintage NetDeckArchiveVintage;
    private NetDeckArchiveBlock NetDeckArchiveBlock;
    private boolean refreshingDeckType;
    private boolean isForCommander;
    private final DeckManager lstDecks;
    final Localizer localizer = Localizer.getInstance();
    private final FLabel btnViewDeck = new FLabel.ButtonBuilder().text(this.localizer.getMessage("lblViewDeck", new Object[0])).fontSize(14).build();
    private final FLabel btnRandom = new FLabel.ButtonBuilder().fontSize(14).build();
    private boolean isAi;
    private final ForgePreferences prefs = FModel.getPreferences();
    private ForgePreferences.FPref stateSetting = null;
    private final String SELECTED_DECK_DELIMITER = "::";

    public static Deck promptForDeck(CDetailPicture cDetailPicture, String title, DeckType defaultDeckType, boolean forAi) {
        FThreads.assertExecutedByEdt(true);
        FDeckChooser chooser = new FDeckChooser(cDetailPicture, forAi, GameType.Constructed, false);
        chooser.initialize(defaultDeckType);
        chooser.populate();
        Dimension parentSize = JOptionPane.getRootFrame().getSize();
        chooser.setMinimumSize(new Dimension((int)(parentSize.getWidth() / 2.0), (int)parentSize.getHeight() - 200));
        Localizer localizer = Localizer.getInstance();
        FOptionPane optionPane = new FOptionPane(null, title, null, chooser, ImmutableList.of(localizer.getMessage("lblOK", new Object[0]), localizer.getMessage("lblCancel", new Object[0])), 0);
        optionPane.setDefaultFocus(chooser);
        chooser.lstDecks.setItemActivateCommand(() -> optionPane.setResult(0));
        optionPane.setVisible(true);
        int dialogResult = optionPane.getResult();
        optionPane.dispose();
        if (dialogResult == 0) {
            return chooser.getDeck();
        }
        return null;
    }

    public FDeckChooser(CDetailPicture cDetailPicture, boolean forAi, GameType gameType, boolean forCommander) {
        this.lstDecks = new DeckManager(gameType, cDetailPicture);
        this.setOpaque(false);
        this.isAi = forAi;
        this.isForCommander = forCommander;
        UiCommand cmdViewDeck = () -> {
            if (this.selectedDeckType != DeckType.COLOR_DECK && this.selectedDeckType != DeckType.THEME_DECK) {
                FDeckViewer.show(this.getDeck());
            }
        };
        this.lstDecks.setItemActivateCommand(cmdViewDeck);
        this.btnViewDeck.setCommand(cmdViewDeck);
    }

    public void initialize() {
        this.initialize(DeckType.COLOR_DECK);
    }

    public void initialize(DeckType defaultDeckType) {
        this.initialize(null, defaultDeckType);
    }

    public void initialize(ForgePreferences.FPref savedStateSetting, DeckType defaultDeckType) {
        this.stateSetting = savedStateSetting;
        this.selectedDeckType = defaultDeckType;
    }

    public DeckType getSelectedDeckType() {
        return this.selectedDeckType;
    }

    public void setSelectedDeckType(DeckType selectedDeckType0) {
        this.refreshDecksList(selectedDeckType0, false, null);
    }

    public DeckManager getLstDecks() {
        return this.lstDecks;
    }

    private void updateDecks(Iterable<DeckProxy> decks, ItemManagerConfig config) {
        this.lstDecks.setAllowMultipleSelections(false);
        this.lstDecks.setPool(decks);
        this.lstDecks.setup(config);
        this.btnRandom.setText(this.localizer.getMessage("lblRandomDeck", new Object[0]));
        this.btnRandom.setCommand(() -> DeckgenUtil.randomSelect(this.lstDecks));
        this.lstDecks.setSelectedIndex(0);
    }

    private void updateCustom() {
        DeckFormat deckFormat = this.lstDecks.getGameType().getDeckFormat();
        switch (deckFormat) {
            case Commander: {
                this.updateDecks(DeckProxy.getAllCommanderDecks(), ItemManagerConfig.COMMANDER_DECKS);
                break;
            }
            case Oathbreaker: {
                this.updateDecks(DeckProxy.getAllOathbreakerDecks(), ItemManagerConfig.COMMANDER_DECKS);
                break;
            }
            case Brawl: {
                this.updateDecks(DeckProxy.getAllBrawlDecks(), ItemManagerConfig.COMMANDER_DECKS);
                break;
            }
            case TinyLeaders: {
                this.updateDecks(DeckProxy.getAllTinyLeadersDecks(), ItemManagerConfig.COMMANDER_DECKS);
                break;
            }
            default: {
                this.updateDecks(DeckProxy.getAllConstructedDecks(), ItemManagerConfig.CONSTRUCTED_DECKS);
            }
        }
    }

    private void updateColors(Predicate<PaperCard> formatFilter) {
        this.lstDecks.setAllowMultipleSelections(true);
        this.lstDecks.setPool(ColorDeckGenerator.getColorDecks(this.lstDecks, formatFilter, this.isAi));
        this.lstDecks.setup(ItemManagerConfig.STRING_ONLY);
        this.btnRandom.setText(this.localizer.getMessage("lblRandomColors", new Object[0]));
        this.btnRandom.setCommand(() -> DeckgenUtil.randomSelectColors(this.lstDecks));
        this.lstDecks.setSelectedIndices(new Integer[]{0, 1});
    }

    private void updateMatrix(GameFormat format) {
        this.lstDecks.setAllowMultipleSelections(false);
        this.lstDecks.setPool(ArchetypeDeckGenerator.getMatrixDecks(format, this.isAi));
        this.lstDecks.setup(ItemManagerConfig.STRING_ONLY);
        this.btnRandom.setText("Random");
        this.btnRandom.setCommand(() -> DeckgenUtil.randomSelect(this.lstDecks));
        this.lstDecks.setSelectedIndices(new Integer[]{0});
    }

    private void updateRandomCommander() {
        DeckFormat deckFormat = this.lstDecks.getGameType().getDeckFormat();
        if (!deckFormat.hasCommander()) {
            return;
        }
        this.lstDecks.setAllowMultipleSelections(false);
        this.lstDecks.setPool(CommanderDeckGenerator.getCommanderDecks(deckFormat, this.isAi, false));
        this.lstDecks.setup(ItemManagerConfig.STRING_ONLY);
        this.btnRandom.setText("Random");
        this.btnRandom.setCommand(() -> DeckgenUtil.randomSelect(this.lstDecks));
        this.lstDecks.setSelectedIndices(new Integer[]{0});
    }

    private void updateRandomCardGenCommander() {
        DeckFormat deckFormat = this.lstDecks.getGameType().getDeckFormat();
        if (!deckFormat.hasCommander()) {
            return;
        }
        this.lstDecks.setAllowMultipleSelections(false);
        this.lstDecks.setPool(CommanderDeckGenerator.getCommanderDecks(deckFormat, this.isAi, true));
        this.lstDecks.setup(ItemManagerConfig.STRING_ONLY);
        this.btnRandom.setText("Random");
        this.btnRandom.setCommand(() -> DeckgenUtil.randomSelect(this.lstDecks));
        this.lstDecks.setSelectedIndices(new Integer[]{0});
    }

    private void updateThemes() {
        this.updateDecks(DeckProxy.getAllThemeDecks(), ItemManagerConfig.STRING_ONLY);
    }

    private void updatePrecons() {
        this.updateDecks(DeckProxy.getAllPreconstructedDecks(QuestController.getPrecons()), ItemManagerConfig.PRECON_DECKS);
    }

    private void updateCommanderPrecons() {
        this.updateDecks(DeckProxy.getAllCommanderPreconDecks(), ItemManagerConfig.COMMANDER_DECKS);
    }

    private void updateQuestEvents() {
        this.updateDecks(DeckProxy.getAllQuestEventAndChallenges(), ItemManagerConfig.QUEST_EVENT_DECKS);
    }

    private void updateRandom() {
        this.updateDecks(RandomDeckGenerator.getRandomDecks(this.lstDecks, this.isAi), ItemManagerConfig.STRING_ONLY);
    }

    private void updateNetDecks() {
        if (this.netDeckCategory != null) {
            this.decksComboBox.setText(this.netDeckCategory.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetDecks(this.netDeckCategory), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchiveStandardDecks() {
        if (this.NetDeckArchiveStandard != null) {
            this.decksComboBox.setText(this.NetDeckArchiveStandard.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchiveStandardDecks(this.NetDeckArchiveStandard), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchiveModernDecks() {
        if (this.NetDeckArchiveModern != null) {
            this.decksComboBox.setText(this.NetDeckArchiveModern.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchiveModernDecks(this.NetDeckArchiveModern), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchivePauperDecks() {
        if (this.NetDeckArchivePauper != null) {
            this.decksComboBox.setText(this.NetDeckArchivePauper.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchivePauperDecks(this.NetDeckArchivePauper), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchivePioneerDecks() {
        if (this.NetDeckArchivePioneer != null) {
            this.decksComboBox.setText(this.NetDeckArchivePioneer.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchivePioneerDecks(this.NetDeckArchivePioneer), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchiveLegacyDecks() {
        if (this.NetDeckArchiveLegacy != null) {
            this.decksComboBox.setText(this.NetDeckArchiveLegacy.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchiveLegacyDecks(this.NetDeckArchiveLegacy), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchiveVintageDecks() {
        if (this.NetDeckArchiveVintage != null) {
            this.decksComboBox.setText(this.NetDeckArchiveVintage.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchiveVintageDecks(this.NetDeckArchiveVintage), ItemManagerConfig.NET_DECKS);
    }

    private void updateNetArchiveBlockDecks() {
        if (this.NetDeckArchiveBlock != null) {
            this.decksComboBox.setText(this.NetDeckArchiveBlock.getDeckType());
        }
        this.updateDecks(DeckProxy.getNetArchiveBlockDecks(this.NetDeckArchiveBlock), ItemManagerConfig.NET_DECKS);
    }

    public Deck getDeck() {
        DeckProxy proxy = (DeckProxy)this.lstDecks.getSelectedItem();
        if (proxy == null) {
            return null;
        }
        return proxy.getDeck();
    }

    public RegisteredPlayer getPlayer() {
        if (this.lstDecks.getSelectedIndex() < 0) {
            return null;
        }
        if (this.selectedDeckType == DeckType.QUEST_OPPONENT_DECK) {
            QuestEvent event = DeckgenUtil.getQuestEvent(((DeckProxy)this.lstDecks.getSelectedItem()).getName());
            RegisteredPlayer result = new RegisteredPlayer(event.getEventDeck());
            if (event instanceof QuestEventChallenge) {
                result.setStartingLife(((QuestEventChallenge)event).getAiLife());
            }
            result.setCardsOnBattlefield(QuestUtil.getComputerStartingCards(event));
            return result;
        }
        return new RegisteredPlayer(this.getDeck());
    }

    public void populate() {
        if (this.decksComboBox == null) {
            this.decksComboBox = new DecksComboBox();
            this.lstDecksContainer = new ItemManagerContainer(this.lstDecks);
            this.decksComboBox.addListener(this);
            this.restoreSavedState();
        } else {
            this.removeAll();
        }
        this.setLayout(new MigLayout("insets 0, gap 0"));
        this.decksComboBox.addTo(this, "w 100%, h 30px!, gapbottom 5px, spanx 2, wrap");
        this.add((Component)this.lstDecksContainer, "w 100%, growy, pushy, spanx 2, wrap");
        this.add((Component)this.btnViewDeck, "w 50%-3px, h 30px!, gaptop 5px, gapright 6px");
        this.add((Component)this.btnRandom, "w 50%-3px, h 30px!, gaptop 5px");
        if (this.isShowing()) {
            this.revalidate();
            this.repaint();
        }
    }

    public final boolean isAi() {
        return this.isAi;
    }

    public void setIsAi(boolean isAiDeck) {
        this.isAi = isAiDeck;
    }

    @Override
    public void deckTypeSelected(DecksComboBoxEvent ev) {
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_STANDARD_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchiveStandard category = forge.deck.NetDeckArchiveStandard.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_STANDARD_DECK && this.NetDeckArchiveStandard != null) {
                            this.decksComboBox.setText(this.NetDeckArchiveStandard.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchiveStandard = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_PIONEER_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchivePioneer category = forge.deck.NetDeckArchivePioneer.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_PIONEER_DECK && this.NetDeckArchivePioneer != null) {
                            this.decksComboBox.setText(this.NetDeckArchivePioneer.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchivePioneer = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_MODERN_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchiveModern category = forge.deck.NetDeckArchiveModern.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_MODERN_DECK && this.NetDeckArchiveModern != null) {
                            this.decksComboBox.setText(this.NetDeckArchiveModern.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchiveModern = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_PAUPER_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchivePauper category = forge.deck.NetDeckArchivePauper.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_PAUPER_DECK && this.NetDeckArchivePauper != null) {
                            this.decksComboBox.setText(this.NetDeckArchivePauper.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchivePauper = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_LEGACY_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchiveLegacy category = forge.deck.NetDeckArchiveLegacy.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_LEGACY_DECK && this.NetDeckArchiveLegacy != null) {
                            this.decksComboBox.setText(this.NetDeckArchiveLegacy.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchiveLegacy = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_VINTAGE_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchiveVintage category = forge.deck.NetDeckArchiveVintage.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_VINTAGE_DECK && this.NetDeckArchiveVintage != null) {
                            this.decksComboBox.setText(this.NetDeckArchiveVintage.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchiveVintage = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (ev.getDeckType() == DeckType.NET_ARCHIVE_BLOCK_DECK && !this.refreshingDeckType) {
            if (this.lstDecks.getGameType() != GameType.Constructed) {
                return;
            }
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckArchiveBlock category = forge.deck.NetDeckArchiveBlock.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_ARCHIVE_BLOCK_DECK && this.NetDeckArchiveBlock != null) {
                            this.decksComboBox.setText(this.NetDeckArchiveBlock.getDeckType());
                        }
                        return;
                    }
                    this.NetDeckArchiveBlock = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        if (!(ev.getDeckType() != DeckType.NET_DECK && ev.getDeckType() != DeckType.NET_COMMANDER_DECK || this.refreshingDeckType)) {
            FThreads.invokeInBackgroundThread(() -> {
                NetDeckCategory category = NetDeckCategory.selectAndLoad(this.lstDecks.getGameType());
                FThreads.invokeInEdtLater(() -> {
                    if (category == null) {
                        this.decksComboBox.setDeckType(this.selectedDeckType);
                        if (this.selectedDeckType == DeckType.NET_DECK && this.netDeckCategory != null) {
                            this.decksComboBox.setText(this.netDeckCategory.getDeckType());
                        }
                        return;
                    }
                    this.netDeckCategory = category;
                    this.refreshDecksList(ev.getDeckType(), true, ev);
                });
            });
            return;
        }
        this.refreshDecksList(ev.getDeckType(), false, ev);
    }

    public void refreshDeckListForAI() {
        String currentName = ((DeckProxy)this.lstDecks.getSelectedItem()).getName();
        UiCommand selectCmd = this.lstDecks.getSelectCommand();
        this.lstDecks.setSelectCommand(null);
        this.refreshDecksList(this.selectedDeckType, true, null);
        this.lstDecks.setSelectedString(currentName);
        this.lstDecks.setSelectCommand(selectCmd);
        this.lstDecks.refresh();
        this.saveState();
    }

    private void refreshDecksList(DeckType deckType, boolean forceRefresh, DecksComboBoxEvent ev) {
        if (this.decksComboBox == null) {
            return;
        }
        if (this.selectedDeckType == deckType && !forceRefresh) {
            return;
        }
        this.selectedDeckType = deckType;
        if (ev == null) {
            this.refreshingDeckType = true;
            this.decksComboBox.refresh(deckType, this.isForCommander);
            this.refreshingDeckType = false;
        }
        this.lstDecks.setCaption(deckType.toString());
        switch (deckType) {
            case CUSTOM_DECK: {
                this.updateCustom();
                break;
            }
            case COMMANDER_DECK: {
                this.updateCustom();
                break;
            }
            case COLOR_DECK: {
                this.updateColors(null);
                break;
            }
            case STANDARD_COLOR_DECK: {
                this.updateColors(FModel.getFormats().getStandard().getFilterPrinted());
                break;
            }
            case MODERN_COLOR_DECK: {
                this.updateColors(FModel.getFormats().getModern().getFilterPrinted());
                break;
            }
            case PAUPER_COLOR_DECK: {
                this.updateColors(FModel.getFormats().getPauper().getFilterPrinted());
                break;
            }
            case STANDARD_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix(FModel.getFormats().getStandard());
                break;
            }
            case PIONEER_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix(FModel.getFormats().getPioneer());
                break;
            }
            case HISTORIC_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix(FModel.getFormats().getHistoric());
                break;
            }
            case MODERN_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix(FModel.getFormats().getModern());
                break;
            }
            case LEGACY_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix((GameFormat)FModel.getFormats().get("Legacy"));
                break;
            }
            case VINTAGE_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix((GameFormat)FModel.getFormats().get("Vintage"));
                break;
            }
            case PAUPER_CARDGEN_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateMatrix(FModel.getFormats().getPauper());
                break;
            }
            case RANDOM_COMMANDER_DECK: {
                this.updateRandomCommander();
                break;
            }
            case RANDOM_CARDGEN_COMMANDER_DECK: {
                if (!FModel.isdeckGenMatrixLoaded()) break;
                this.updateRandomCardGenCommander();
                break;
            }
            case THEME_DECK: {
                this.updateThemes();
                break;
            }
            case QUEST_OPPONENT_DECK: {
                this.updateQuestEvents();
                break;
            }
            case PRECONSTRUCTED_DECK: {
                this.updatePrecons();
                break;
            }
            case PRECON_COMMANDER_DECK: {
                this.updateCommanderPrecons();
                break;
            }
            case RANDOM_DECK: {
                this.updateRandom();
                break;
            }
            case NET_DECK: {
                this.updateNetDecks();
                break;
            }
            case NET_COMMANDER_DECK: {
                this.updateNetDecks();
                break;
            }
            case NET_ARCHIVE_STANDARD_DECK: {
                this.updateNetArchiveStandardDecks();
                break;
            }
            case NET_ARCHIVE_MODERN_DECK: {
                this.updateNetArchiveModernDecks();
                break;
            }
            case NET_ARCHIVE_PAUPER_DECK: {
                this.updateNetArchivePauperDecks();
                break;
            }
            case NET_ARCHIVE_PIONEER_DECK: {
                this.updateNetArchivePioneerDecks();
                break;
            }
            case NET_ARCHIVE_LEGACY_DECK: {
                this.updateNetArchiveLegacyDecks();
                break;
            }
            case NET_ARCHIVE_VINTAGE_DECK: {
                this.updateNetArchiveVintageDecks();
                break;
            }
            case NET_ARCHIVE_BLOCK_DECK: {
                this.updateNetArchiveBlockDecks();
                break;
            }
        }
    }

    public void saveState() {
        if (this.stateSetting == null) {
            throw new NullPointerException("State setting missing. Specify first using the initialize() method.");
        }
        this.prefs.setPref(this.stateSetting, this.getState());
        this.prefs.save();
    }

    private String getState() {
        StringBuilder state = new StringBuilder();
        DeckType selectedDeckType = this.selectedDeckType;
        if (selectedDeckType == DeckType.NET_ARCHIVE_STANDARD_DECK) {
            if (this.NetDeckArchiveStandard == null) {
                return "";
            }
            state.append("NET_ARCHIVE_STANDARD_DECK").append(this.NetDeckArchiveStandard.getName());
        } else if (selectedDeckType == DeckType.NET_ARCHIVE_PIONEER_DECK) {
            if (this.NetDeckArchivePioneer == null) {
                return "";
            }
            state.append("NET_ARCHIVE_PIONEER_DECK").append(this.NetDeckArchivePioneer.getName());
        } else if (selectedDeckType == DeckType.NET_ARCHIVE_MODERN_DECK) {
            if (this.NetDeckArchiveModern == null) {
                return "";
            }
            state.append("NET_ARCHIVE_MODERN_DECK").append(this.NetDeckArchiveModern.getName());
        } else if (selectedDeckType == DeckType.NET_ARCHIVE_PAUPER_DECK) {
            if (this.NetDeckArchivePauper == null) {
                return "";
            }
            state.append("NET_ARCHIVE_PAUPER_DECK").append(this.NetDeckArchivePauper.getName());
        } else if (selectedDeckType == DeckType.NET_ARCHIVE_LEGACY_DECK) {
            if (this.NetDeckArchiveLegacy == null) {
                return "";
            }
            state.append("NET_ARCHIVE_LEGACY_DECK").append(this.NetDeckArchiveLegacy.getName());
        } else if (selectedDeckType == DeckType.NET_ARCHIVE_VINTAGE_DECK) {
            if (this.NetDeckArchiveVintage == null) {
                return "";
            }
            state.append("NET_ARCHIVE_VINTAGE_DECK").append(this.NetDeckArchiveVintage.getName());
        } else if (selectedDeckType == DeckType.NET_ARCHIVE_BLOCK_DECK) {
            if (this.NetDeckArchiveBlock == null) {
                return "";
            }
            state.append("NET_ARCHIVE_BLOCK_DECK").append(this.NetDeckArchiveBlock.getName());
        } else if (selectedDeckType == null || selectedDeckType == DeckType.NET_DECK) {
            if (this.netDeckCategory == null) {
                return "";
            }
            state.append("NET_DECK_").append(this.netDeckCategory.getName());
        } else {
            state.append(selectedDeckType.name());
        }
        state.append(";");
        this.joinSelectedDecks(state, "::");
        return state.toString();
    }

    private void joinSelectedDecks(StringBuilder state, String delimiter) {
        Collection selectedDecks = this.lstDecks.getSelectedItems();
        boolean isFirst = true;
        if (selectedDecks != null) {
            for (DeckProxy deck : selectedDecks) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    state.append(delimiter);
                }
                state.append(deck.toString());
            }
        }
    }

    public void restoreSavedState() {
        DeckType oldDeckType = this.selectedDeckType;
        if (this.stateSetting == null) {
            this.refreshDecksList(oldDeckType, true, null);
            return;
        }
        String savedState = this.prefs.getPref(this.stateSetting);
        this.refreshDecksList(this.getDeckTypeFromSavedState(savedState), true, null);
        if (!this.lstDecks.setSelectedStrings(this.getSelectedDecksFromSavedState(savedState))) {
            this.refreshDecksList(oldDeckType, true, null);
        }
    }

    private DeckType getDeckTypeFromSavedState(String savedState) {
        try {
            if (StringUtils.isBlank(savedState)) {
                return this.selectedDeckType;
            }
            String deckType = savedState.split(";")[0];
            if (deckType.startsWith("NET_DECK_")) {
                this.netDeckCategory = NetDeckCategory.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_DECK_".length()));
                return DeckType.NET_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_STANDARD_DECK")) {
                this.NetDeckArchiveStandard = forge.deck.NetDeckArchiveStandard.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_STANDARD_DECK".length()));
                return DeckType.NET_ARCHIVE_STANDARD_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_PIONEER_DECK")) {
                this.NetDeckArchivePioneer = forge.deck.NetDeckArchivePioneer.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_PIONEER_DECK".length()));
                return DeckType.NET_ARCHIVE_PIONEER_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_MODERN_DECK")) {
                this.NetDeckArchiveModern = forge.deck.NetDeckArchiveModern.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_MODERN_DECK".length()));
                return DeckType.NET_ARCHIVE_MODERN_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_PAUPER_DECK")) {
                this.NetDeckArchivePauper = forge.deck.NetDeckArchivePauper.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_PAUPER_DECK".length()));
                return DeckType.NET_ARCHIVE_PAUPER_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_LEGACY_DECK")) {
                this.NetDeckArchiveLegacy = forge.deck.NetDeckArchiveLegacy.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_LEGACY_DECK".length()));
                return DeckType.NET_ARCHIVE_LEGACY_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_VINTAGE_DECK")) {
                this.NetDeckArchiveVintage = forge.deck.NetDeckArchiveVintage.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_VINTAGE_DECK".length()));
                return DeckType.NET_ARCHIVE_VINTAGE_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_BLOCK_DECK")) {
                this.NetDeckArchiveBlock = forge.deck.NetDeckArchiveBlock.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_BLOCK_DECK".length()));
                return DeckType.NET_ARCHIVE_BLOCK_DECK;
            }
            return DeckType.valueOf(deckType);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage() + ". Using default : " + (Object)((Object)this.selectedDeckType));
            return this.selectedDeckType;
        }
    }

    private List<String> getSelectedDecksFromSavedState(String savedState) {
        try {
            if (StringUtils.isBlank(savedState)) {
                return new ArrayList<String>();
            }
            String[] parts = savedState.split(";", -1);
            return Arrays.asList(parts[1].split("::"));
        }
        catch (Exception ex) {
            System.err.println(ex + " [savedState=" + savedState + "]");
            return new ArrayList<String>();
        }
    }

    public DecksComboBox getDecksComboBox() {
        return this.decksComboBox;
    }
}

