/*
 * Decompiled with CFR 0.152.
 */
package forge.deckchooser;

import com.google.common.collect.Lists;
import forge.deck.DeckType;
import forge.deckchooser.DecksComboBoxEvent;
import forge.deckchooser.IDecksComboBoxListener;
import forge.gui.MouseUtil;
import forge.toolbox.FComboBox;
import forge.toolbox.FComboBoxWrapper;
import forge.toolbox.FSkin;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class DecksComboBox
extends FComboBoxWrapper<DeckType> {
    private final List<IDecksComboBoxListener> _listeners = Lists.newArrayList();
    private DeckType selectedDeckType = null;

    public DecksComboBox() {
        this.setSkinFont(FSkin.getRelativeBoldFont(14));
        this.setTextAlignment(FComboBox.TextAlignment.CENTER);
        this.addActionListener(this.getDeckTypeComboListener());
    }

    public void refresh(DeckType deckType, boolean isForCommander) {
        if (isForCommander) {
            this.setModel(new DefaultComboBoxModel<DeckType>(DeckType.CommanderOptions));
        } else {
            this.setModel(new DefaultComboBoxModel<DeckType>(DeckType.ConstructedOptions));
        }
        this.setSelectedItem((Object)deckType);
    }

    private ActionListener getDeckTypeComboListener() {
        return e -> {
            Object selectedItem = this.getSelectedItem();
            if (selectedItem instanceof DeckType) {
                MouseUtil.setCursor(3);
                DeckType newDeckType = (DeckType)((Object)((Object)selectedItem));
                if (newDeckType != this.selectedDeckType) {
                    this.selectedDeckType = newDeckType;
                    this.notifyDeckTypeSelected(newDeckType);
                }
                MouseUtil.resetCursor();
            }
        };
    }

    public synchronized void addListener(IDecksComboBoxListener obj) {
        this._listeners.add(obj);
    }

    private synchronized void notifyDeckTypeSelected(DeckType deckType) {
        if (deckType != null) {
            for (IDecksComboBoxListener listener : this._listeners) {
                listener.deckTypeSelected(new DecksComboBoxEvent(this, deckType));
            }
        }
    }

    public DeckType getDeckType() {
        return this.selectedDeckType;
    }

    public void setDeckType(DeckType valueOf) {
        this.selectedDeckType = valueOf;
        this.setSelectedItem((Object)this.selectedDeckType);
    }

    @Override
    public void setText(String text0) {
        this.selectedDeckType = null;
        super.setText(text0);
    }
}

