/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.generation;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.item.PaperCard;
import forge.util.MyRandom;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeckGenerator4Color
extends DeckGeneratorBase {
    final List<ImmutablePair<DeckGeneratorBase.FilterCMC, Integer>> cmcLevels = Lists.newArrayList(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(0, 2), 12), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(3, 5), 9), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(6, 20), 3));

    @Override
    protected final float getLandPercentage() {
        return 0.44f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.33f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.23f;
    }

    public DeckGenerator4Color(IDeckGenPool pool0, DeckFormat format0, Predicate<PaperCard> formatFilter0, String clr1, String clr2, String clr3, String clr4) {
        super(pool0, format0, formatFilter0);
        this.initialize(format0, clr1, clr2, clr3, clr4);
    }

    public DeckGenerator4Color(IDeckGenPool pool0, DeckFormat format0, String clr1, String clr2, String clr3, String clr4) {
        super(pool0, format0);
        this.initialize(format0, clr1, clr2, clr3, clr4);
    }

    private void initialize(DeckFormat format0, String clr1, String clr2, String clr3, String clr4) {
        format0.adjustCMCLevels(this.cmcLevels);
        byte c1 = MagicColor.fromName(clr1);
        byte c2 = MagicColor.fromName(clr2);
        byte c3 = MagicColor.fromName(clr3);
        byte c4 = MagicColor.fromName(clr4);
        int rc = 0;
        int combo = c1 | c2 | c3 | c4;
        ColorSet param = ColorSet.fromMask(combo);
        switch (param.countColors()) {
            case 3: {
                this.colors = param;
                return;
            }
            case 0: {
                int color1 = MyRandom.getRandom().nextInt(5);
                int color2 = (color1 + 1 + MyRandom.getRandom().nextInt(4)) % 5;
                this.colors = ColorSet.fromMask(1 << color1 | 1 << color2).inverse();
                return;
            }
            case 1: {
                while ((rc = 1 << MyRandom.getRandom().nextInt(5)) == combo) {
                }
                combo |= rc;
            }
            case 2: {
                while (((rc = 1 << MyRandom.getRandom().nextInt(5)) & combo) != 0) {
                }
                combo |= rc;
            }
        }
        this.colors = ColorSet.fromMask(combo);
    }

    @Override
    public final CardPool getDeck(int size, boolean forAi) {
        this.addCreaturesAndSpells(size, this.cmcLevels, forAi);
        int numLands = Math.round((float)size * this.getLandPercentage());
        this.adjustDeckSize(size - numLands);
        this.trace.append("numLands:").append(numLands).append("\n");
        List<String> duals = this.getDualLandList(forAi);
        for (String s2 : duals) {
            this.cardCounts.put(s2, 0);
        }
        int dblsAdded = this.addSomeStr(numLands / 4, duals);
        this.addBasicLand(numLands -= dblsAdded);
        this.adjustDeckSize(size);
        this.trace.append("DeckSize:").append(this.tDeck.countAll()).append("\n");
        return this.tDeck;
    }
}

