/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.generation;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.item.PaperCard;
import forge.util.MyRandom;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeckGenerator2Color
extends DeckGeneratorBase {
    final List<ImmutablePair<DeckGeneratorBase.FilterCMC, Integer>> cmcLevels = Lists.newArrayList(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(0, 2), 6), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(3, 4), 4), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(5, 6), 2), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(7, 20), 1));

    @Override
    protected final float getLandPercentage() {
        return 0.42f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.34f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.24f;
    }

    public DeckGenerator2Color(IDeckGenPool pool0, DeckFormat format0, Predicate<PaperCard> formatFilter0, String clr1, String clr2) {
        super(pool0, format0, formatFilter0);
        this.initialize(format0, clr1, clr2);
    }

    public DeckGenerator2Color(IDeckGenPool pool0, DeckFormat format0, String clr1, String clr2) {
        super(pool0, format0);
        this.initialize(format0, clr1, clr2);
    }

    private void initialize(DeckFormat format0, String clr1, String clr2) {
        byte c1 = MagicColor.fromName(clr1);
        byte c2 = MagicColor.fromName(clr2);
        format0.adjustCMCLevels(this.cmcLevels);
        if (c1 == 0 && c2 == 0) {
            int color1 = MyRandom.getRandom().nextInt(5);
            int color2 = (color1 + 1 + MyRandom.getRandom().nextInt(4)) % 5;
            this.colors = ColorSet.fromMask(1 << color1 | 1 << color2);
        } else if (c1 == 0 || c2 == 0) {
            byte knownColor = (byte)(c1 | c2);
            int color1 = Arrays.binarySearch(MagicColor.WUBRG, knownColor);
            int color2 = (color1 + 1 + MyRandom.getRandom().nextInt(4)) % 5;
            this.colors = ColorSet.fromMask(1 << color1 | 1 << color2);
        } else {
            this.colors = ColorSet.fromMask(c1 | c2);
        }
    }

    @Override
    public final CardPool getDeck(int size, boolean forAi) {
        this.addCreaturesAndSpells(size, this.cmcLevels, forAi);
        int numLands = Math.round((float)size * this.getLandPercentage());
        this.adjustDeckSize(size - numLands);
        this.trace.append(String.format("Adjusted deck size to: %d, should add %d land(s)%n", size - numLands, numLands));
        List<String> duals = this.getDualLandList(forAi);
        for (String s2 : duals) {
            this.cardCounts.put(s2, 0);
        }
        int dblsAdded = this.addSomeStr(numLands / 6, duals);
        this.addBasicLand(numLands -= dblsAdded);
        this.adjustDeckSize(size);
        this.trace.append("DeckSize:").append(this.tDeck.countAll()).append("\n");
        return this.tDeck;
    }
}

