/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.collect.Iterables;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckProxy;
import forge.deck.DeckType;
import forge.deck.DeckgenUtil;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.game.IHasGameType;
import forge.gamemodes.quest.QuestController;
import forge.model.FModel;
import forge.util.Aggregates;
import java.util.ArrayList;
import java.util.List;

public class RandomDeckGenerator
extends DeckProxy
implements Comparable<RandomDeckGenerator> {
    private final String name;
    private final RandomDeckType type;
    private final IHasGameType lstDecks;
    private final boolean isAi;

    public static List<DeckProxy> getRandomDecks(IHasGameType lstDecks0, boolean isAi0) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        decks.add(new RandomDeckGenerator("Random Generated Deck", RandomDeckType.Generated, lstDecks0, isAi0));
        decks.add(new RandomDeckGenerator("Random User Deck", RandomDeckType.User, lstDecks0, isAi0));
        decks.add(new RandomDeckGenerator("Random Favorite Deck", RandomDeckType.Favorite, lstDecks0, isAi0));
        return decks;
    }

    public static Deck getRandomUserDeck(IHasGameType lstDecks0, boolean isAi0) {
        RandomDeckGenerator generator = new RandomDeckGenerator(null, RandomDeckType.User, lstDecks0, isAi0);
        return generator.getDeck();
    }

    private RandomDeckGenerator(String name0, RandomDeckType type0, IHasGameType lstDecks0, boolean isAi0) {
        this.name = name0;
        this.type = type0;
        this.lstDecks = lstDecks0;
        this.isAi = isAi0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(RandomDeckGenerator d) {
        return Integer.compare(this.type.ordinal(), d.type.ordinal());
    }

    @Override
    public Deck getDeck() {
        switch (this.type) {
            case Generated: {
                return this.getGeneratedDeck();
            }
            case User: {
                return this.getUserDeck();
            }
        }
        return this.getFavoriteDeck();
    }

    private Deck getGeneratedDeck() {
        switch (this.lstDecks.getGameType()) {
            case CommanderGauntlet: 
            case Commander: {
                return DeckgenUtil.generateCommanderDeck(this.isAi, GameType.Commander);
            }
            case Oathbreaker: {
                return DeckgenUtil.generateCommanderDeck(this.isAi, GameType.Oathbreaker);
            }
            case TinyLeaders: {
                return DeckgenUtil.generateCommanderDeck(this.isAi, GameType.TinyLeaders);
            }
            case Brawl: {
                return DeckgenUtil.generateCommanderDeck(this.isAi, GameType.Brawl);
            }
            case Archenemy: {
                return DeckgenUtil.generateSchemeDeck();
            }
            case Planechase: {
                return DeckgenUtil.generatePlanarDeck();
            }
        }
        while (true) {
            switch (Aggregates.random(DeckType.ConstructedOptions)) {
                case PRECONSTRUCTED_DECK: {
                    return Aggregates.random(DeckProxy.getAllPreconstructedDecks(QuestController.getPrecons())).getDeck();
                }
                case QUEST_OPPONENT_DECK: {
                    return Aggregates.random(DeckProxy.getAllQuestEventAndChallenges()).getDeck();
                }
                case COLOR_DECK: {
                    ArrayList<String> colors = new ArrayList<String>();
                    int count = Aggregates.randomInt(1, 3);
                    for (int i = 1; i <= count; ++i) {
                        colors.add("Random " + i);
                    }
                    return DeckgenUtil.buildColorDeck(colors, null, this.isAi);
                }
                case STANDARD_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getStandard(), this.isAi);
                }
                case PIONEER_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getPioneer(), this.isAi);
                }
                case HISTORIC_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getHistoric(), this.isAi);
                }
                case MODERN_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getModern(), this.isAi);
                }
                case LEGACY_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck((GameFormat)FModel.getFormats().get("Legacy"), this.isAi);
                }
                case VINTAGE_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck((GameFormat)FModel.getFormats().get("Vintage"), this.isAi);
                }
                case PAUPER_CARDGEN_DECK: {
                    return DeckgenUtil.buildLDACArchetypeDeck(FModel.getFormats().getPauper(), this.isAi);
                }
                case STANDARD_COLOR_DECK: {
                    return this.generateRandomColorDeckOfFormat(FModel.getFormats().getStandard());
                }
                case MODERN_COLOR_DECK: {
                    return this.generateRandomColorDeckOfFormat(FModel.getFormats().getModern());
                }
                case PAUPER_COLOR_DECK: {
                    return this.generateRandomColorDeckOfFormat(FModel.getFormats().getPauper());
                }
                case THEME_DECK: {
                    return Aggregates.random(DeckProxy.getAllThemeDecks()).getDeck();
                }
            }
        }
    }

    private Deck generateRandomColorDeckOfFormat(GameFormat format) {
        ArrayList<String> colors = new ArrayList<String>();
        int count = Aggregates.randomInt(1, 3);
        for (int i = 1; i <= count; ++i) {
            colors.add("Random " + i);
        }
        return DeckgenUtil.buildColorDeck(colors, format.getFilterPrinted(), this.isAi);
    }

    private Deck getUserDeck() {
        Iterable<DeckProxy> decks;
        GameType gameType = this.lstDecks.getGameType();
        switch (gameType) {
            case CommanderGauntlet: 
            case Commander: {
                decks = DeckProxy.getAllCommanderDecks(DeckFormat.Commander.isLegalDeckPredicate());
                break;
            }
            case Oathbreaker: {
                decks = DeckProxy.getAllOathbreakerDecks(DeckFormat.Oathbreaker.isLegalDeckPredicate());
                break;
            }
            case TinyLeaders: {
                decks = DeckProxy.getAllTinyLeadersDecks(DeckFormat.TinyLeaders.isLegalDeckPredicate());
                break;
            }
            case Brawl: {
                decks = DeckProxy.getAllBrawlDecks(DeckFormat.Brawl.isLegalDeckPredicate());
                break;
            }
            case Archenemy: {
                decks = DeckProxy.getAllSchemeDecks(DeckFormat.Archenemy.isLegalDeckPredicate());
                break;
            }
            case Planechase: {
                decks = DeckProxy.getAllPlanarDecks(DeckFormat.Planechase.isLegalDeckPredicate());
                break;
            }
            default: {
                decks = DeckProxy.getAllConstructedDecks(gameType.getDeckFormat().isLegalDeckPredicate());
            }
        }
        if (Iterables.isEmpty(decks)) {
            return this.getGeneratedDeck();
        }
        Iterable<DeckProxy> AIDecks = Iterables.filter(decks, deckProxy -> deckProxy.getAI().inMainDeck == 0);
        if (this.isAi && Iterables.size(AIDecks) > 10) {
            return Aggregates.random(AIDecks).getDeck();
        }
        return Aggregates.random(decks).getDeck();
    }

    private Deck getFavoriteDeck() {
        Iterable<DeckProxy> decks;
        switch (this.lstDecks.getGameType()) {
            case CommanderGauntlet: 
            case Commander: {
                decks = DeckProxy.getAllCommanderDecks();
                break;
            }
            case Oathbreaker: {
                decks = DeckProxy.getAllOathbreakerDecks();
                break;
            }
            case TinyLeaders: {
                decks = DeckProxy.getAllTinyLeadersDecks();
                break;
            }
            case Archenemy: {
                decks = DeckProxy.getAllSchemeDecks();
                break;
            }
            case Planechase: {
                decks = DeckProxy.getAllPlanarDecks();
                break;
            }
            default: {
                decks = DeckProxy.getAllConstructedDecks();
            }
        }
        decks = Iterables.filter(decks, DeckProxy::isFavoriteDeck);
        if (Iterables.isEmpty(decks)) {
            return this.getGeneratedDeck();
        }
        return Aggregates.random(decks).getDeck();
    }

    @Override
    public boolean isGeneratedDeck() {
        return true;
    }

    private static enum RandomDeckType {
        Generated,
        User,
        Favorite;

    }
}

