/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.deck.Deck;
import forge.deck.io.DeckSerializer;
import forge.deck.io.DeckStorage;
import forge.game.GameType;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadZipService;
import forge.gui.util.SGuiChoose;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import forge.util.WaitCallback;
import forge.util.storage.StorageBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetDeckCategory
extends StorageBase<Deck> {
    public static final String PREFIX = "NET_DECK_";
    private static Map<String, NetDeckCategory> constructed;
    private static Map<String, NetDeckCategory> commander;
    private static Map<String, NetDeckCategory> brawl;
    private static Map<String, NetDeckCategory> oathbreaker;
    private static Map<String, NetDeckCategory> tinyleaders;
    private final String url;

    private static Map<String, NetDeckCategory> loadCategories(String filename) {
        TreeMap<String, NetDeckCategory> categories = new TreeMap<String, NetDeckCategory>();
        if (FileUtil.doesFileExist(filename)) {
            List<String> lines = FileUtil.readFile(filename);
            for (String line : lines) {
                int idx = line.indexOf(124);
                if (idx == -1) continue;
                String name = line.substring(0, idx).trim();
                String url = line.substring(idx + 1).trim();
                categories.put(name, new NetDeckCategory(name, url));
            }
        }
        return categories;
    }

    public static NetDeckCategory selectAndLoad(GameType gameType) {
        return NetDeckCategory.selectAndLoad(gameType, null);
    }

    public static NetDeckCategory selectAndLoad(GameType gameType, String name) {
        WaitCallback<Boolean> callback;
        Map<String, NetDeckCategory> categories;
        switch (gameType) {
            case Constructed: 
            case Gauntlet: {
                if (constructed == null) {
                    constructed = NetDeckCategory.loadCategories(ForgeConstants.NET_DECKS_LIST_FILE);
                }
                categories = constructed;
                break;
            }
            case Commander: {
                if (commander == null) {
                    commander = NetDeckCategory.loadCategories(ForgeConstants.NET_DECKS_COMMANDER_LIST_FILE);
                }
                categories = commander;
                break;
            }
            case Brawl: {
                if (brawl == null) {
                    brawl = NetDeckCategory.loadCategories(ForgeConstants.NET_DECKS_BRAWL_LIST_FILE);
                }
                categories = brawl;
                break;
            }
            case Oathbreaker: {
                if (oathbreaker == null) {
                    oathbreaker = NetDeckCategory.loadCategories(ForgeConstants.NET_DECKS_OATHBREAKER_LIST_FILE);
                }
                categories = oathbreaker;
                break;
            }
            case TinyLeaders: {
                if (tinyleaders == null) {
                    tinyleaders = NetDeckCategory.loadCategories(ForgeConstants.NET_DECKS_TINYLEADERS_LIST_FILE);
                }
                categories = tinyleaders;
                break;
            }
            default: {
                return null;
            }
        }
        if (name != null) {
            File downloadDir;
            NetDeckCategory category = categories.get(name);
            if (category != null && category.map.isEmpty() && (downloadDir = new File(category.getFullPath())).exists()) {
                for (File file : NetDeckCategory.getAllFilesList(downloadDir, DeckStorage.DCK_FILE_FILTER)) {
                    Deck deck = DeckSerializer.fromFile(file);
                    if (deck == null) continue;
                    category.map.put(deck.getName(), deck);
                }
            }
            return category;
        }
        final NetDeckCategory c = SGuiChoose.oneOrNone("Select a Net Deck category", categories.values());
        if (c == null) {
            return null;
        }
        if (c.map.isEmpty() && !((Boolean)(callback = new WaitCallback<Boolean>(){

            @Override
            public void run() {
                String downloadLoc = c.getFullPath();
                GuiBase.getInterface().download(new GuiDownloadZipService(c.getName(), "decks", c.getUrl(), downloadLoc, downloadLoc, null){

                    @Override
                    protected void copyInputStream(InputStream in, String outPath) throws IOException {
                        super.copyInputStream(in, outPath);
                        Deck deck = DeckSerializer.fromFile(new File(outPath));
                        if (deck != null) {
                            c.map.put(deck.getName(), deck);
                        }
                    }
                }, this);
            }
        }).invokeAndWait()).booleanValue()) {
            return null;
        }
        return c;
    }

    private NetDeckCategory(String name0, String url0) {
        super(name0, ForgeConstants.DECK_NET_DIR + name0, new HashMap());
        this.url = url0;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDeckType() {
        return "Net Decks - " + this.name;
    }

    public String toString() {
        return this.name;
    }
}

