/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.deck.Deck;
import forge.deck.io.DeckSerializer;
import forge.deck.io.DeckStorage;
import forge.game.GameType;
import forge.gui.GuiBase;
import forge.gui.download.GuiDownloadZipService;
import forge.gui.util.SGuiChoose;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import forge.util.WaitCallback;
import forge.util.storage.StorageBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetDeckArchivePioneer
extends StorageBase<Deck> {
    public static final String PREFIX = "NET_ARCHIVE_PIONEER_DECK";
    private static Map<String, NetDeckArchivePioneer> constructed;
    private static Map<String, NetDeckArchivePioneer> commander;
    private static Map<String, NetDeckArchivePioneer> brawl;
    private final String url;

    private static Map<String, NetDeckArchivePioneer> loadCategories(String filename) {
        TreeMap<String, NetDeckArchivePioneer> categories = new TreeMap<String, NetDeckArchivePioneer>();
        if (FileUtil.doesFileExist(filename)) {
            List<String> lines = FileUtil.readFile(filename);
            for (String line : lines) {
                int idx = line.indexOf(124);
                if (idx == -1) continue;
                String name = line.substring(0, idx).trim();
                String url = line.substring(idx + 1).trim();
                categories.put(name, new NetDeckArchivePioneer(name, url));
            }
        }
        return categories;
    }

    public static NetDeckArchivePioneer selectAndLoad(GameType gameType) {
        return NetDeckArchivePioneer.selectAndLoad(gameType, null);
    }

    public static NetDeckArchivePioneer selectAndLoad(GameType gameType, String name) {
        WaitCallback<Boolean> callback;
        Map<String, NetDeckArchivePioneer> categories;
        switch (gameType) {
            case Constructed: 
            case Gauntlet: {
                if (constructed == null) {
                    constructed = NetDeckArchivePioneer.loadCategories(ForgeConstants.NET_ARCHIVE_PIONEER_DECKS_LIST_FILE);
                }
                categories = constructed;
                break;
            }
            default: {
                return null;
            }
        }
        if (name != null) {
            File downloadDir;
            NetDeckArchivePioneer category = categories.get(name);
            if (category != null && category.map.isEmpty() && (downloadDir = new File(category.getFullPath())).exists()) {
                for (File file : NetDeckArchivePioneer.getAllFilesList(downloadDir, DeckStorage.DCK_FILE_FILTER)) {
                    Deck deck = DeckSerializer.fromFile(file);
                    if (deck == null) continue;
                    category.map.put(deck.getName(), deck);
                }
            }
            return category;
        }
        ArrayList<NetDeckArchivePioneer> category = new ArrayList<NetDeckArchivePioneer>(categories.values());
        Collections.reverse(category);
        final NetDeckArchivePioneer c = SGuiChoose.oneOrNone("Select a Net Deck Archive Pioneer category", category);
        if (c == null) {
            return null;
        }
        if (c.map.isEmpty() && !((Boolean)(callback = new WaitCallback<Boolean>(){

            @Override
            public void run() {
                String downloadLoc = c.getFullPath();
                GuiBase.getInterface().download(new GuiDownloadZipService(c.getName(), "decks", c.getUrl(), downloadLoc, downloadLoc, null){

                    @Override
                    protected void copyInputStream(InputStream in, String outPath) throws IOException {
                        super.copyInputStream(in, outPath);
                        Deck deck = DeckSerializer.fromFile(new File(outPath));
                        if (deck != null) {
                            c.map.put(deck.getName(), deck);
                        }
                    }
                }, this);
            }
        }).invokeAndWait()).booleanValue()) {
            return null;
        }
        return c;
    }

    private NetDeckArchivePioneer(String name0, String url0) {
        super(name0, ForgeConstants.DECK_NET_ARCHIVE_DIR + name0, new HashMap());
        this.url = url0;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDeckType() {
        return "Net Archive Pioneer Decks - " + this.name;
    }

    public String toString() {
        return this.name;
    }
}

