/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.deck.CardArchetypeLDAGenerator;
import forge.deck.CardPool;
import forge.deck.CardRelationMatrixGenerator;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckProxy;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGenerator2Color;
import forge.deck.generation.DeckGenerator3Color;
import forge.deck.generation.DeckGenerator5Color;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.DeckGeneratorMonoColor;
import forge.deck.generation.IDeckGenPool;
import forge.deck.io.Archetype;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gamemodes.limited.ArchetypeDeckBuilder;
import forge.gamemodes.limited.CardThemedCommanderDeckBuilder;
import forge.gamemodes.limited.CardThemedConquestDeckBuilder;
import forge.gamemodes.limited.CardThemedDeckBuilder;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestEventDuel;
import forge.gui.util.SOptionPane;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.itemmanager.IItemManager;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.MyRandom;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class DeckgenUtil {
    private static List<DeckProxy> advPrecons = Lists.newArrayList();
    private static List<DeckProxy> advThemes = Lists.newArrayList();
    private static List<DeckProxy> geneticAI = Lists.newArrayList();

    public static Deck buildCardGenDeck(GameFormat format, boolean isForAI) {
        try {
            ArrayList<String> keys = new ArrayList<String>(CardArchetypeLDAGenerator.ldaPools.get(format.getName()).keySet());
            String randomKey = (String)keys.get(MyRandom.getRandom().nextInt(keys.size()));
            Predicate<PaperCard> cardFilter = Predicates.and(format.getFilterPrinted(), IPaperCard.Predicates.name(randomKey));
            PaperCard keyCard = (PaperCard)FModel.getMagicDb().getCommonCards().getAllCards((Predicate)cardFilter).get(0);
            return DeckgenUtil.buildCardGenDeck(keyCard, format, isForAI);
        }
        catch (Exception e) {
            e.printStackTrace();
            return DeckgenUtil.buildCardGenDeck(format, isForAI);
        }
    }

    public static Deck buildCardGenDeck(String cardName, GameFormat format, boolean isForAI) {
        try {
            Predicate<PaperCard> cardFilter = Predicates.and(format.getFilterPrinted(), IPaperCard.Predicates.name(cardName));
            return DeckgenUtil.buildCardGenDeck((PaperCard)FModel.getMagicDb().getCommonCards().getAllCards((Predicate)cardFilter).get(0), format, isForAI);
        }
        catch (Exception e) {
            e.printStackTrace();
            return DeckgenUtil.buildCardGenDeck(format, isForAI);
        }
    }

    public static Deck buildPlanarConquestDeck(PaperCard card, GameFormat format, DeckFormat deckFormat) {
        return DeckgenUtil.buildPlanarConquestDeck(card, null, format, deckFormat, false);
    }

    public static Deck buildPlanarConquestCommanderDeck(PaperCard card, GameFormat format, DeckFormat deckFormat) {
        Deck deck = DeckgenUtil.buildPlanarConquestDeck(card, null, format, deckFormat, true);
        deck.getMain().removeAll(card);
        deck.getOrCreate(DeckSection.Commander).add(card);
        return deck;
    }

    public static Deck buildPlanarConquestCommanderDeck(PaperCard card, PaperCard secondKeycard, GameFormat format, DeckFormat deckFormat) {
        Deck deck = DeckgenUtil.buildPlanarConquestDeck(card, secondKeycard, format, deckFormat, true);
        deck.getMain().removeAll(card);
        deck.getOrCreate(DeckSection.Commander).add(card);
        return deck;
    }

    public static Deck buildPlanarConquestDeck(PaperCard card, PaperCard secondKeycard, GameFormat format, DeckFormat deckFormat, boolean forCommander) {
        boolean isForAI = true;
        HashSet<String> uniqueCards = new HashSet<String>();
        ArrayList<PaperCard> selectedCards = new ArrayList<PaperCard>();
        List<List<Pair<String, Double>>> cardArchetypes = CardArchetypeLDAGenerator.ldaPools.get(FModel.getFormats().getStandard().getName()).get(card.getName());
        for (List<Pair<String, Double>> archetype : cardArchetypes) {
            for (Pair<String, Double> cardPair : archetype) {
                String cardName = cardPair.getLeft();
                uniqueCards.add(cardName);
            }
        }
        for (String cardName : uniqueCards) {
            selectedCards.add(StaticData.instance().getCommonCards().getUniqueByName(cardName));
        }
        CardThemedDeckBuilder dBuilder = forCommander ? new CardThemedConquestDeckBuilder(card, selectedCards, format, true, deckFormat) : new CardThemedDeckBuilder(card, secondKeycard, selectedCards, format, true, deckFormat);
        Deck deck = dBuilder.buildDeck();
        return deck;
    }

    public static Deck buildCardGenDeck(PaperCard card, GameFormat format, boolean isForAI) {
        return DeckgenUtil.buildCardGenDeck(card, null, format, isForAI);
    }

    public static Deck buildCardGenDeck(PaperCard card, PaperCard secondKeycard, GameFormat format, boolean isForAI) {
        return DeckgenUtil.buildLDACardGenDeck(card, format, isForAI);
    }

    private static boolean isCrucialCard(PaperCard pc) {
        return pc.getName().contains("Urza") || pc.getName().contains("Yawgmoth") || pc.getName().equalsIgnoreCase("Living End");
    }

    /*
     * WARNING - void declaration
     */
    public static Deck buildLDACardGenDeck(PaperCard card, GameFormat format, boolean isForAI) {
        void var12_24;
        void var12_22;
        void var10_16;
        List<List<Pair<String, Double>>> preSelectedCardLists = CardArchetypeLDAGenerator.ldaPools.get(format.getName()).get(card.getName());
        List<Pair<String, Double>> preSelectedCardNames = preSelectedCardLists.get(MyRandom.getRandom().nextInt(preSelectedCardLists.size()));
        ArrayList<Object> selectedCards = new ArrayList<Object>();
        for (Pair<String, Double> pair : preSelectedCardNames) {
            String name = pair.getLeft();
            PaperCard cardToAdd = (PaperCard)Aggregates.random(StaticData.instance().getCommonCards().getAllCards(name, (Predicate)format.getFilterPrinted()));
            if (cardToAdd == null || cardToAdd.getName().equals(card.getName())) continue;
            selectedCards.add(cardToAdd);
        }
        ArrayList<PaperCard> toRemove = new ArrayList<PaperCard>();
        int removeCount = 0;
        int i = 0;
        for (PaperCard paperCard : selectedCards) {
            if (MyRandom.getRandom().nextInt(100) > 70 + (15 - i / selectedCards.size() * selectedCards.size()) && removeCount < 4 && !DeckgenUtil.isCrucialCard(paperCard)) {
                toRemove.add(paperCard);
                ++removeCount;
            }
            if (paperCard.getName().equals(card.getName())) {
                toRemove.add(paperCard);
            }
            ++i;
        }
        selectedCards.removeAll(toRemove);
        ArrayList<PaperCard> playsetList = new ArrayList<PaperCard>();
        int n = 4;
        if (card.getRules().getMainPart().getManaCost().getCMC() > 7) {
            int n2 = 1 + MyRandom.getRandom().nextInt(4);
        } else if (card.getRules().getMainPart().getManaCost().getCMC() > 5) {
            int n3 = 2 + MyRandom.getRandom().nextInt(3);
        }
        for (int j = 0; j < var10_16; ++j) {
            playsetList.add(card);
        }
        for (PaperCard paperCard : selectedCards) {
            for (int j = 0; j < 4; ++j) {
                if (MyRandom.getRandom().nextInt(100) >= 90) continue;
                playsetList.add(paperCard);
            }
        }
        CardThemedDeckBuilder dBuilder = new CardThemedDeckBuilder(card, null, playsetList, format, isForAI);
        Deck deck = dBuilder.buildDeck();
        if (deck.getMain().countAll() != 60) {
            System.out.println(deck.getMain().countAll());
            System.out.println("Wrong card count " + deck.getMain().countAll());
            Deck deck2 = DeckgenUtil.buildLDACArchetypeDeck(format, isForAI);
        }
        if (var12_22.getMain().countAll(Predicates.compose(CardRulesPredicates.Presets.IS_LAND, PaperCard::getRules)) > 27) {
            System.out.println("Too many lands " + var12_22.getMain().countAll(Predicates.compose(CardRulesPredicates.Presets.IS_LAND, PaperCard::getRules)));
            Deck deck3 = DeckgenUtil.buildLDACArchetypeDeck(format, isForAI);
        }
        while (var12_24.get(DeckSection.Sideboard).countAll() > 15) {
            var12_24.get(DeckSection.Sideboard).remove(var12_24.get(DeckSection.Sideboard).get(0));
        }
        return var12_24;
    }

    public static Deck buildLDACArchetypeDeck(GameFormat format, boolean isForAI) {
        ArrayList keys = new ArrayList(CardArchetypeLDAGenerator.ldaArchetypes.get(format.getName()));
        Archetype randomKey = (Archetype)keys.get(MyRandom.getRandom().nextInt(keys.size()));
        return DeckgenUtil.buildLDACArchetypeDeck(randomKey, format, isForAI);
    }

    /*
     * WARNING - void declaration
     */
    public static Deck buildLDACArchetypeDeck(Archetype archetype, GameFormat format, boolean isForAI) {
        void var14_27;
        void var14_25;
        void var11_18;
        List<Pair<String, Double>> preSelectedCardNames = archetype.getCardProbabilities();
        PaperCard card = null;
        for (Pair<String, Double> pair : preSelectedCardNames) {
            card = StaticData.instance().getCommonCards().getUniqueByName(pair.getLeft());
            if (card == null || card.getRules().getType().isLand()) continue;
            break;
        }
        ArrayList<Object> selectedCards = new ArrayList<Object>();
        int cardCount = 0;
        for (Pair<String, Double> pair : preSelectedCardNames) {
            String name = pair.getLeft();
            PaperCard cardToAdd = (PaperCard)Aggregates.random(StaticData.instance().getCommonCards().getAllCards(name, (Predicate)format.getFilterPrinted()));
            if (cardToAdd != null && !cardToAdd.getName().equals(card.getName())) {
                selectedCards.add(cardToAdd);
                ++cardCount;
            }
            if (cardCount <= 120) continue;
            break;
        }
        ArrayList<PaperCard> toRemove = new ArrayList<PaperCard>();
        int removeCount = 0;
        int i = 0;
        for (PaperCard paperCard : selectedCards) {
            if (i > 4 && MyRandom.getRandom().nextInt(100) > 70 + (15 - i / selectedCards.size() * selectedCards.size()) && removeCount < 4 && !DeckgenUtil.isCrucialCard(paperCard)) {
                toRemove.add(paperCard);
                ++removeCount;
            }
            if (paperCard.getName().equals(card.getName())) {
                toRemove.add(paperCard);
            }
            ++i;
        }
        selectedCards.removeAll(toRemove);
        ArrayList<PaperCard> playsetList = new ArrayList<PaperCard>();
        int n = 4;
        if (card.getRules().getMainPart().getManaCost().getCMC() > 7) {
            int n2 = 1 + MyRandom.getRandom().nextInt(4);
        } else if (card.getRules().getMainPart().getManaCost().getCMC() > 5) {
            int n3 = 2 + MyRandom.getRandom().nextInt(3);
        }
        for (int j = 0; j < var11_18; ++j) {
            playsetList.add(card);
        }
        ArrayList<String> restrictedCardsAdded = new ArrayList<String>();
        for (PaperCard paperCard : selectedCards) {
            if (format.getRestrictedCards().contains(paperCard.getName()) && !restrictedCardsAdded.contains(paperCard.getName())) {
                playsetList.add(paperCard);
                restrictedCardsAdded.add(paperCard.getName());
                continue;
            }
            for (int j = 0; j < 4; ++j) {
                if (MyRandom.getRandom().nextInt(100) >= 90) continue;
                playsetList.add(paperCard);
            }
        }
        ArchetypeDeckBuilder dBuilder = new ArchetypeDeckBuilder(archetype, card, playsetList, format, isForAI);
        Deck deck = dBuilder.buildDeck();
        if (deck.getMain().countAll() != 60) {
            System.out.println(deck.getMain().countAll());
            System.out.println("Wrong card count " + deck.getMain().countAll());
            Deck deck2 = DeckgenUtil.buildLDACArchetypeDeck(format, isForAI);
        }
        if (var14_25.getMain().countAll(Predicates.compose(CardRulesPredicates.Presets.IS_LAND, PaperCard::getRules)) > 27) {
            System.out.println("Too many lands " + var14_25.getMain().countAll(Predicates.compose(CardRulesPredicates.Presets.IS_LAND, PaperCard::getRules)));
            Deck deck3 = DeckgenUtil.buildLDACArchetypeDeck(format, isForAI);
        }
        while (var14_27.get(DeckSection.Sideboard).countAll() > 15) {
            var14_27.get(DeckSection.Sideboard).remove(var14_27.get(DeckSection.Sideboard).get(0));
        }
        return var14_27;
    }

    public static Deck buildColorDeck(List<String> selection, Predicate<PaperCard> formatFilter, boolean forAi) {
        try {
            String deckName = null;
            DeckGeneratorBase gen = null;
            CardDb cardDb = FModel.getMagicDb().getCommonCards();
            if (formatFilter == null) {
                if (selection.size() == 1) {
                    gen = new DeckGeneratorMonoColor((IDeckGenPool)cardDb, DeckFormat.Constructed, selection.get(0));
                } else if (selection.size() == 2) {
                    gen = new DeckGenerator2Color(cardDb, DeckFormat.Constructed, selection.get(0), selection.get(1));
                } else if (selection.size() == 3) {
                    gen = new DeckGenerator3Color(cardDb, DeckFormat.Constructed, selection.get(0), selection.get(1), selection.get(2));
                } else {
                    gen = new DeckGenerator5Color(cardDb, DeckFormat.Constructed);
                    deckName = "5 colors";
                }
            } else if (selection.size() == 1) {
                gen = new DeckGeneratorMonoColor(cardDb, DeckFormat.Constructed, formatFilter, selection.get(0));
            } else if (selection.size() == 2) {
                gen = new DeckGenerator2Color(cardDb, DeckFormat.Constructed, formatFilter, selection.get(0), selection.get(1));
            } else if (selection.size() == 3) {
                gen = new DeckGenerator3Color(cardDb, DeckFormat.Constructed, formatFilter, selection.get(0), selection.get(1), selection.get(2));
            } else {
                gen = new DeckGenerator5Color(cardDb, DeckFormat.Constructed, formatFilter);
                deckName = "5 colors";
            }
            gen.setSingleton(FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_SINGLETONS));
            gen.setUseArtifacts(!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_ARTIFACTS));
            CardPool cards = ((DeckGeneratorBase)gen).getDeck(60, forAi);
            if (null == deckName) {
                deckName = Lang.joinHomogenous(Arrays.asList(selection));
            }
            Deck deck = new Deck("Random deck : " + deckName);
            deck.setDirectory("generated/color");
            deck.getMain().addAll(cards);
            return deck;
        }
        catch (Exception e) {
            e.printStackTrace();
            return DeckgenUtil.buildColorDeck(selection, formatFilter, forAi);
        }
    }

    public static QuestEvent getQuestEvent(String name) {
        QuestController qCtrl = FModel.getQuest();
        for (QuestEventChallenge challenge : qCtrl.getChallenges()) {
            if (!challenge.getTitle().equals(name)) continue;
            return challenge;
        }
        QuestEventDuel duel = Iterables.find(qCtrl.getDuelsManager().getAllDuels(), in -> in.getName().equals(name));
        return duel;
    }

    public static Deck getRandomColorDeck(Predicate<PaperCard> formatFilter, boolean forAi) {
        int[] colorCount = new int[]{1, 2, 3};
        int count = colorCount[MyRandom.getRandom().nextInt(colorCount.length)];
        ArrayList<String> selection = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            selection.add("Random");
        }
        return DeckgenUtil.buildColorDeck(selection, formatFilter, forAi);
    }

    public static Deck getRandomColorDeck(boolean forAi) {
        int[] colorCount = new int[]{1, 2, 3, 5};
        int count = colorCount[MyRandom.getRandom().nextInt(colorCount.length)];
        ArrayList<String> selection = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            selection.add("Random");
        }
        return DeckgenUtil.buildColorDeck(selection, null, forAi);
    }

    public static Deck getRandomCustomDeck() {
        IStorage<Deck> allDecks = FModel.getDecks().getConstructed();
        if (allDecks.size() == 0) {
            return null;
        }
        int rand = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allDecks.size());
        String name = allDecks.getItemNames().toArray(new String[0])[rand];
        return allDecks.get(name);
    }

    public static Deck getCommanderDeck() {
        IStorage<Deck> allDecks = FModel.getDecks().getCommander();
        if (allDecks.size() == 0) {
            return null;
        }
        int rand = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allDecks.size());
        String name = allDecks.getItemNames().toArray(new String[0])[rand];
        return allDecks.get(name);
    }

    public static Deck getRandomOrPreconOrThemeDeck(String colors, boolean forAi, boolean isTheme, boolean useGeneticAI) {
        ArrayList<String> selection = new ArrayList<String>();
        Deck deck = null;
        if (advPrecons.isEmpty()) {
            advPrecons.addAll(DeckProxy.getAllPreconstructedDecks(QuestController.getPrecons()));
        }
        if (advThemes.isEmpty()) {
            advThemes.addAll(DeckProxy.getAllPreconstructedDecks(QuestController.getPrecons()));
            advThemes.addAll(DeckProxy.getNonEasyQuestDuelDecks());
        }
        if (geneticAI.isEmpty()) {
            geneticAI.addAll(DeckProxy.getAllGeneticAIDecks());
        }
        if (!colors.isEmpty()) {
            for (char c : colors.toLowerCase().toCharArray()) {
                switch (c) {
                    case 'b': {
                        selection.add("black");
                    }
                    case 'r': {
                        selection.add("red");
                    }
                    case 'g': {
                        selection.add("green");
                    }
                    case 'u': {
                        selection.add("blue");
                    }
                    case 'w': {
                        selection.add("white");
                    }
                }
            }
        }
        try {
            if (useGeneticAI) {
                deck = !selection.isEmpty() ? Aggregates.random(Iterables.filter(geneticAI, deckProxy -> deckProxy.getColorIdentity().sharesColorWith(ColorSet.fromNames(colors.toCharArray())))).getDeck() : Aggregates.random(geneticAI).getDeck();
            } else if (!selection.isEmpty() && selection.size() < 4) {
                Predicate pred = Predicates.and(deckProxy -> deckProxy.getMainSize() <= 60, deckProxy -> deckProxy.getColorIdentity().hasAllColors(ColorSet.fromNames(colors.toCharArray()).getColor()));
                deck = isTheme ? Aggregates.random(Iterables.filter(advThemes, pred)).getDeck() : Aggregates.random(Iterables.filter(advPrecons, pred)).getDeck();
            } else {
                deck = isTheme ? Aggregates.random(Iterables.filter(advThemes, deckProxy -> deckProxy.getMainSize() <= 60)).getDeck() : Aggregates.random(Iterables.filter(advPrecons, deckProxy -> deckProxy.getMainSize() <= 60)).getDeck();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (deck != null) {
            return deck;
        }
        return DeckgenUtil.getRandomColorDeck(forAi);
    }

    public static Deck getRandomPreconDeck() {
        List<DeckProxy> allDecks = DeckProxy.getAllPreconstructedDecks(QuestController.getPrecons());
        int rand = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allDecks.size());
        return allDecks.get(rand).getDeck();
    }

    public static Deck getRandomCommanderPreconDeck() {
        Iterable<DeckProxy> allDecks = DeckProxy.getAllCommanderPreconDecks();
        return Aggregates.random(allDecks).getDeck();
    }

    public static Deck getRandomThemeDeck() {
        List<DeckProxy> allDecks = DeckProxy.getAllThemeDecks();
        int rand = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allDecks.size());
        return allDecks.get(rand).getDeck();
    }

    public static Deck getRandomQuestDeck() {
        ArrayList<Deck> allQuestDecks = new ArrayList<Deck>();
        QuestController qCtrl = FModel.getQuest();
        for (QuestEvent questEvent : qCtrl.getDuelsManager().getAllDuels()) {
            allQuestDecks.add(questEvent.getEventDeck());
        }
        for (QuestEvent questEvent : qCtrl.getChallenges()) {
            allQuestDecks.add(questEvent.getEventDeck());
        }
        int rand = (int)Math.floor(MyRandom.getRandom().nextDouble() * (double)allQuestDecks.size());
        return (Deck)allQuestDecks.get(rand);
    }

    public static void randomSelectColors(IItemManager<DeckProxy> deckManager) {
        int size = deckManager.getItemCount();
        if (size == 0) {
            return;
        }
        int nColors = MyRandom.getRandom().nextInt(3) + 1;
        Integer[] indices = new Integer[nColors];
        for (int i = 0; i < nColors; ++i) {
            int next = MyRandom.getRandom().nextInt(size);
            boolean isUnique = true;
            for (int j = 0; j < i; ++j) {
                if (indices[j] != next) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                indices[i] = next;
                continue;
            }
            --i;
        }
        deckManager.setSelectedIndices(indices);
    }

    public static void randomSelect(IItemManager<DeckProxy> deckManager) {
        int size = deckManager.getItemCount();
        if (size == 0) {
            return;
        }
        deckManager.setSelectedIndex(MyRandom.getRandom().nextInt(size));
    }

    public static boolean colorCheck(List<String> colors0) {
        boolean result = true;
        if (colors0.size() == 4) {
            SOptionPane.showMessageDialog("Sorry, four color generated decks aren't supported yet.\n\rPlease use 2, 3, or 5 colors for this deck.", "Generate deck: 4 colors", SOptionPane.ERROR_ICON);
            result = false;
        } else if (colors0.size() > 5) {
            SOptionPane.showMessageDialog("Generate deck: maximum five colors!", "Generate deck: too many colors", SOptionPane.ERROR_ICON);
            result = false;
        }
        return result;
    }

    public static Deck generateSchemeDeck() {
        Deck deck = new Deck("");
        deck.putSection(DeckSection.Schemes, DeckgenUtil.generateSchemePool());
        return deck;
    }

    public static CardPool generateSchemePool() {
        CardPool schemes = new CardPool();
        ArrayList<PaperCard> allSchemes = new ArrayList<PaperCard>();
        for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
            if (!c.getRules().getType().isScheme()) continue;
            allSchemes.add(c);
        }
        int schemesToAdd = 20;
        int attemptsLeft = 100;
        while (schemesToAdd > 0 && attemptsLeft > 0) {
            PaperCard cp = (PaperCard)Aggregates.random(allSchemes);
            int appearances = schemes.count(cp) + 1;
            if (appearances < 2) {
                schemes.add(cp);
                --schemesToAdd;
                continue;
            }
            --attemptsLeft;
        }
        return schemes;
    }

    public static Deck generatePlanarDeck() {
        Deck deck = new Deck("");
        deck.putSection(DeckSection.Planes, DeckgenUtil.generatePlanarPool());
        return deck;
    }

    public static CardPool generatePlanarPool() {
        CardPool res = new CardPool();
        ArrayList<PaperCard> allPlanars = new ArrayList<PaperCard>();
        for (PaperCard c : FModel.getMagicDb().getVariantCards().getAllCards()) {
            if (!c.getRules().getType().isPlane() && !c.getRules().getType().isPhenomenon()) continue;
            allPlanars.add(c);
        }
        int phenoms = 0;
        int targetsize = MyRandom.getRandom().nextInt(allPlanars.size() - 10) + 10;
        do {
            PaperCard rndPlane = (PaperCard)Aggregates.random(allPlanars);
            allPlanars.remove(rndPlane);
            if (rndPlane.getRules().getType().isPhenomenon() && phenoms < 2) {
                res.add(rndPlane);
                ++phenoms;
                continue;
            }
            if (!rndPlane.getRules().getType().isPlane()) continue;
            res.add(rndPlane);
        } while (!allPlanars.isEmpty() && res.countAll() != targetsize);
        return res;
    }

    public static Deck generateCommanderDeck(boolean forAi, GameType gameType) {
        CardDb cardDb = FModel.getMagicDb().getCommonCards();
        DeckFormat format = gameType.getDeckFormat();
        Predicate<CardRules> canPlay = forAi ? DeckGeneratorBase.AI_CAN_PLAY : CardRulesPredicates.IS_KEPT_IN_RANDOM_DECKS;
        Iterable<PaperCard> legends = cardDb.getAllCards(Predicates.and(format.isLegalCardPredicate(), format.isLegalCommanderPredicate(), Predicates.compose(canPlay, PaperCard::getRules)));
        PaperCard commander = Aggregates.random(legends);
        return DeckgenUtil.generateRandomCommanderDeck(commander, format, forAi, false);
    }

    public static Deck generateRandomCommanderDeck(PaperCard commander, DeckFormat format, boolean forAi, boolean isCardGen) {
        CardThemedCommanderDeckBuilder gen = null;
        PaperCard selectedPartner = null;
        ArrayList<PaperCard> preSelectedCards = new ArrayList<PaperCard>();
        if (isCardGen) {
            if (format.equals((Object)DeckFormat.Brawl)) {
                HashSet<String> uniqueCards = new HashSet<String>();
                List<List<Pair<String, Double>>> cardArchetypes = CardArchetypeLDAGenerator.ldaPools.get(FModel.getFormats().getStandard().getName()).get(commander.getName());
                for (List<Pair<String, Double>> list : cardArchetypes) {
                    for (Pair<String, Double> cardPair : list) {
                        String cardName = cardPair.getLeft();
                        uniqueCards.add(cardName);
                    }
                }
                for (String string : uniqueCards) {
                    PaperCard paperCard = StaticData.instance().getCommonCards().getUniqueByName(string);
                    if (!format.isLegalCard(paperCard)) continue;
                    preSelectedCards.add(paperCard);
                }
            } else {
                String matrixKey = (format.equals((Object)DeckFormat.TinyLeaders) ? DeckFormat.Commander : format).toString();
                Iterator potentialCards = new ArrayList(CardRelationMatrixGenerator.cardPools.get(matrixKey).get(commander.getName()));
                Collections.shuffle(potentialCards, MyRandom.getRandom());
                Iterator<List<Pair<String, Double>>> iterator = potentialCards.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)((Object)iterator.next());
                    if (!format.isLegalCard((PaperCard)entry.getKey())) continue;
                    preSelectedCards.add((PaperCard)entry.getKey());
                }
            }
            if (format.equals((Object)DeckFormat.Oathbreaker)) {
                ArrayList<PaperCard> signatureSpells = new ArrayList<PaperCard>();
                for (PaperCard c : preSelectedCards) {
                    if (!c.getRules().canBeSignatureSpell()) continue;
                    signatureSpells.add(c);
                }
                if (signatureSpells.size() > 0) {
                    selectedPartner = (PaperCard)signatureSpells.get(MyRandom.getRandom().nextInt(signatureSpells.size()));
                    preSelectedCards.removeAll(StaticData.instance().getCommonCards().getAllCards(selectedPartner.getName()));
                }
            } else if (commander.getRules().canBePartnerCommander()) {
                ArrayList<PaperCard> partners = new ArrayList<PaperCard>();
                for (PaperCard c : preSelectedCards) {
                    if (!c.getRules().canBePartnerCommanders(commander.getRules())) continue;
                    partners.add(c);
                }
                if (partners.size() > 0) {
                    selectedPartner = (PaperCard)partners.get(MyRandom.getRandom().nextInt(partners.size()));
                    preSelectedCards.removeAll(StaticData.instance().getCommonCards().getAllCards(selectedPartner.getName()));
                }
            }
            int removeCount = 0;
            int i = 0;
            ArrayList<PaperCard> toRemove = new ArrayList<PaperCard>();
            for (PaperCard c : preSelectedCards) {
                if (!format.isLegalCard(c)) {
                    toRemove.add(c);
                    ++removeCount;
                }
                if (preSelectedCards.size() < 75) break;
                if (MyRandom.getRandom().nextInt(100) > 60 + (15 - i / preSelectedCards.size() * preSelectedCards.size()) && removeCount < 4 && !c.getName().contains("Urza") && !c.getName().contains("Wastes")) {
                    toRemove.add(c);
                    ++removeCount;
                }
                ++i;
            }
            preSelectedCards.removeAll(toRemove);
            preSelectedCards.removeAll(StaticData.instance().getCommonCards().getAllCards(commander.getName()));
            gen = new CardThemedCommanderDeckBuilder(commander, selectedPartner, preSelectedCards, forAi, format);
        } else {
            CardDb cardDb = FModel.getMagicDb().getCommonCards();
            Iterable<PaperCard> colorList = Iterables.filter(format.getCardPool(cardDb).getAllCards(), Predicates.and(format.isLegalCardPredicate(), Predicates.compose(Predicates.or(new CardThemedDeckBuilder.MatchColorIdentity(commander.getRules().getColorIdentity()), DeckGeneratorBase.COLORLESS_CARDS), PaperCard::getRules)));
            switch (format) {
                case Brawl: {
                    colorList = Iterables.filter(colorList, FModel.getFormats().getStandard().getFilterPrinted());
                    break;
                }
                case Oathbreaker: {
                    ArrayList<PaperCard> signatureSpells = new ArrayList<PaperCard>();
                    for (PaperCard paperCard : colorList) {
                        if (!paperCard.getRules().canBeSignatureSpell()) continue;
                        signatureSpells.add(paperCard);
                    }
                    if (signatureSpells.size() <= 0) break;
                    selectedPartner = (PaperCard)signatureSpells.get(MyRandom.getRandom().nextInt(signatureSpells.size()));
                    break;
                }
                default: {
                    if (!commander.getRules().canBePartnerCommander()) break;
                    ArrayList<PaperCard> partners = new ArrayList<PaperCard>();
                    for (PaperCard c : colorList) {
                        if (!c.getRules().canBePartnerCommanders(commander.getRules())) continue;
                        partners.add(c);
                    }
                    if (partners.size() <= 0) break;
                    selectedPartner = (PaperCard)partners.get(MyRandom.getRandom().nextInt(partners.size()));
                }
            }
            ArrayList<PaperCard> cardList = Lists.newArrayList(colorList);
            Collections.shuffle(cardList, MyRandom.getRandom());
            int shortlistlength = 400;
            if (cardList.size() < shortlistlength) {
                shortlistlength = cardList.size();
            }
            List<PaperCard> list = cardList.subList(0, shortlistlength);
            list.remove(commander);
            list.removeAll(StaticData.instance().getCommonCards().getAllCards(commander.getName()));
            if (selectedPartner != null) {
                list.remove(selectedPartner);
                list.removeAll(StaticData.instance().getCommonCards().getAllCards(selectedPartner.getName()));
            }
            gen = new CardThemedCommanderDeckBuilder(commander, selectedPartner, list, forAi, format);
        }
        gen.setSingleton(true);
        gen.setUseArtifacts(!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DECKGEN_ARTIFACTS));
        CardPool cards = ((DeckGeneratorBase)gen).getDeck(format.getMainRange().getMaximum(), forAi);
        Deck deck = selectedPartner != null ? new Deck("Generated " + format.toString() + " deck (" + commander.getName() + "--" + selectedPartner.getName() + ")") : new Deck("Generated " + format.toString() + " deck (" + commander.getName() + ")");
        deck.setDirectory("generated/commander");
        deck.getMain().addAll(cards);
        deck.getOrCreate(DeckSection.Commander).add(commander);
        if (selectedPartner != null) {
            deck.get(DeckSection.Commander).add(selectedPartner);
        }
        return deck;
    }

    public static Map<ManaCostShard, Integer> suggestBasicLandCount(Deck d) {
        int W = 0;
        int U = 0;
        int R = 0;
        int B = 0;
        int G = 0;
        int total = 0;
        List cards = d.getOrCreate(DeckSection.Main).toFlatList();
        HashMap<ManaCostShard, Integer> suggestionMap = new HashMap<ManaCostShard, Integer>();
        int numLands = Iterables.size(Iterables.filter(cards, Predicates.compose(CardRulesPredicates.Presets.IS_LAND, PaperCard::getRules)));
        int sizeNoLands = cards.size() - numLands;
        int targetDeckSize = sizeNoLands < 30 ? 40 : (sizeNoLands > 60 ? 100 : 60);
        int numLandsToAdd = targetDeckSize - cards.size();
        if (numLandsToAdd == 0) {
            suggestionMap.put(ManaCostShard.WHITE, 0);
            suggestionMap.put(ManaCostShard.BLUE, 0);
            suggestionMap.put(ManaCostShard.RED, 0);
            suggestionMap.put(ManaCostShard.BLACK, 0);
            suggestionMap.put(ManaCostShard.GREEN, 0);
            return suggestionMap;
        }
        for (PaperCard c : d.getMain().toFlatList()) {
            ManaCost m4 = c.getRules().getManaCost();
            W += m4.getShardCount(ManaCostShard.WHITE);
            U += m4.getShardCount(ManaCostShard.BLUE);
            R += m4.getShardCount(ManaCostShard.RED);
            B += m4.getShardCount(ManaCostShard.BLACK);
            G += m4.getShardCount(ManaCostShard.GREEN);
        }
        total = W + U + R + B + G;
        int whiteSources = Math.max(0, Math.round((float)numLandsToAdd * ((float)W / (float)total)));
        if (W > 0) {
            whiteSources = Math.max(1, whiteSources);
        }
        int blueSources = Math.max(0, Math.round((float)(numLandsToAdd -= whiteSources) * ((float)U / (float)(total -= W))));
        if (U > 0) {
            blueSources = Math.max(1, blueSources);
        }
        int blackSources = Math.max(0, Math.round((float)(numLandsToAdd -= blueSources) * ((float)B / (float)(total -= U))));
        if (B > 0) {
            blackSources = Math.max(1, blackSources);
        }
        int redSources = Math.max(0, Math.round((float)(numLandsToAdd -= blackSources) * ((float)R / (float)(total -= B))));
        if (R > 0) {
            redSources = Math.max(1, redSources);
        }
        int greenSources = Math.max(0, Math.round((float)(numLandsToAdd -= redSources) * ((float)G / (float)(total -= R))));
        if (G > 0) {
            greenSources = Math.max(1, greenSources);
        }
        total -= G;
        if ((numLandsToAdd -= greenSources) > 0) {
            if (whiteSources > 0) {
                whiteSources += numLandsToAdd;
            } else if (blueSources > 0) {
                blueSources += numLandsToAdd;
            } else if (blackSources > 0) {
                blackSources += numLandsToAdd;
            } else if (redSources > 0) {
                redSources += numLandsToAdd;
            } else if (greenSources > 0) {
                greenSources += numLandsToAdd;
            }
        }
        suggestionMap.put(ManaCostShard.WHITE, whiteSources);
        suggestionMap.put(ManaCostShard.BLUE, blueSources);
        suggestionMap.put(ManaCostShard.RED, redSources);
        suggestionMap.put(ManaCostShard.BLACK, blackSources);
        suggestionMap.put(ManaCostShard.GREEN, greenSources);
        return suggestionMap;
    }
}

