/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.deck.Deck;
import forge.deck.DeckBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DeckGroup
extends DeckBase {
    private static final long serialVersionUID = -1628725522049635829L;
    private Deck humanDeck;
    private List<Deck> aiDecks = new ArrayList<Deck>();

    public DeckGroup() {
        this("");
    }

    public DeckGroup(String name0) {
        super(name0);
    }

    @Override
    public Deck getHumanDeck() {
        return this.humanDeck;
    }

    public final List<Deck> getAiDecks() {
        return this.aiDecks;
    }

    public final void setHumanDeck(Deck humanDeck0) {
        this.humanDeck = humanDeck0;
        if (this.humanDeck != null) {
            this.humanDeck.setDirectory(this.getDirectory());
        }
    }

    public final void rankAiDecks(Comparator<Deck> comparator) {
        if (this.aiDecks.size() < 2) {
            return;
        }
        this.aiDecks.sort(comparator);
    }

    @Override
    public String getItemType() {
        return "Group of decks";
    }

    @Override
    protected void cloneFieldsTo(DeckBase clone) {
        super.cloneFieldsTo(clone);
        DeckGroup myClone = (DeckGroup)clone;
        myClone.setHumanDeck((Deck)this.humanDeck.copyTo(this.getName()));
        for (Deck src : this.aiDecks) {
            myClone.addAiDeck((Deck)src.copyTo(src.getName()));
        }
    }

    public final void addAiDeck(Deck aiDeck) {
        if (aiDeck == null) {
            return;
        }
        aiDeck.setDirectory(this.getDirectory());
        this.aiDecks.add(aiDeck);
    }

    public void addAiDecks(Deck[] computer) {
        this.aiDecks.addAll(Arrays.asList(computer));
    }

    @Override
    protected DeckBase newInstance(String name0) {
        return new DeckGroup(name0);
    }

    @Override
    public boolean isEmpty() {
        return this.humanDeck == null || this.humanDeck.isEmpty();
    }

    @Override
    public String getImageKey(boolean altState) {
        return null;
    }
}

