/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.deck.CardPool;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.localinstance.properties.ForgeConstants;
import forge.util.FileUtil;
import forge.util.MyRandom;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DeckGeneratorTheme
extends DeckGeneratorBase {
    private int basicLandPercentage = 0;
    private String basicLandSet = null;
    private boolean testing = false;

    @Override
    protected final float getLandPercentage() {
        return 0.44f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.33f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.23f;
    }

    public DeckGeneratorTheme(IDeckGenPool pool0) {
        super(pool0, DeckFormat.Constructed);
        this.setBasicLandPool(null);
        this.maxDuplicates = 4;
    }

    public static final List<String> getThemeNames() {
        String[] fileList;
        ArrayList<String> ltNames = new ArrayList<String>();
        File file = new File(ForgeConstants.THEMES_DIR);
        if (!file.exists()) {
            throw new RuntimeException("ThemeDeckGenerator : getThemeNames error -- file not found -- filename is " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("ThemeDeckGenerator : getThemeNames error -- not a directory -- " + file.getAbsolutePath());
        }
        for (String element : fileList = file.list()) {
            if (!element.endsWith(".thm")) continue;
            ltNames.add(element.substring(0, element.indexOf(".thm")));
        }
        return ltNames;
    }

    public final CardPool getThemeDeck(String themeName, int size, StringBuilder errorBuilder) {
        String s2 = "";
        String tFileName = ForgeConstants.THEMES_DIR + "/" + themeName + ".thm";
        List<String> lines = FileUtil.readFile(tFileName);
        List<Grp> groups = this.readGroups(lines);
        for (int i = 0; i < groups.size(); ++i) {
            Grp g2 = groups.get(i);
            float p = (float)((double)g2.percentage * 0.01);
            int grpCnt = (int)(p * (float)size);
            int cnSize = g2.cardnames.size();
            errorBuilder.append("Group").append(i).append(":").append(grpCnt).append("\n");
            for (int j = 0; j < grpCnt; ++j) {
                s2 = (String)g2.cardnames.get(MyRandom.getRandom().nextInt(cnSize));
                String[] ss = s2.split("\\|");
                int lc = 0;
                while ((Integer)this.cardCounts.get(ss[0]) >= g2.maxCnt) {
                    s2 = (String)g2.cardnames.get(MyRandom.getRandom().nextInt(cnSize));
                    ss = s2.split("\\|");
                    if (lc <= 999) continue;
                    throw new RuntimeException("ThemeDeckGenerator : getThemeDeck -- looped too much -- filename is " + tFileName);
                }
                int n = (Integer)this.cardCounts.get(ss[0]);
                if (ss.length == 1) {
                    this.tDeck.add(this.pool.getCard(ss[0]));
                } else {
                    this.tDeck.add(this.pool.getCard(ss[0], ss[1]));
                }
                this.cardCounts.put(ss[0], n + 1);
                errorBuilder.append(s2).append("\n");
            }
        }
        int numBLands = this.basicLandPercentage > 0 ? (int)((float)(size * this.basicLandPercentage) / 100.0f) : size - this.tDeck.countAll();
        errorBuilder.append("numBLands:").append(numBLands).append("\n");
        this.addBasicLand(numBLands, this.basicLandSet);
        errorBuilder.append("DeckSize:").append(this.tDeck.countAll()).append("\n");
        this.adjustDeckSize(size);
        errorBuilder.append("DeckSize:").append(this.tDeck.countAll()).append("\n");
        if (!this.testing) {
            errorBuilder.delete(0, errorBuilder.length());
        }
        return this.tDeck;
    }

    private List<Grp> readGroups(List<String> lines) {
        ArrayList<Grp> groups = new ArrayList<Grp>();
        Grp g2 = null;
        for (String s2 : lines) {
            String[] ss;
            if (s2.equals("End")) break;
            if (s2.startsWith("[Group")) {
                g2 = new Grp();
                for (String element : ss = s2.replaceAll("[\\[\\]]", "").split(" ")) {
                    if (element.startsWith("Percentage")) {
                        String p = element.substring("Percentage".length() + 1);
                        g2.percentage = Integer.parseInt(p);
                    }
                    if (!element.startsWith("MaxCnt")) continue;
                    String m4 = element.substring("MaxCnt".length() + 1);
                    g2.maxCnt = Integer.parseInt(m4);
                }
                groups.add(g2);
                continue;
            }
            if (s2.equals("[/Group]")) {
                g2 = null;
            }
            if (s2.startsWith("BasicLandPercentage")) {
                ss = s2.split("\\|");
                this.basicLandPercentage = Integer.parseInt(ss[0].substring("BasicLandPercentage".length() + 1));
                if (ss.length <= 1) continue;
                this.basicLandSet = ss[1];
                continue;
            }
            if (s2.equals("Testing")) {
                this.testing = true;
                continue;
            }
            if (g2 == null) continue;
            g2.cardnames.add(s2);
            ss = s2.split("\\|");
            this.cardCounts.put(ss[0], 0);
        }
        return groups;
    }

    private class Grp {
        private final List<String> cardnames = new ArrayList<String>();
        private int maxCnt;
        private int percentage;

        private Grp() {
        }
    }
}

