/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.CardType;
import forge.deck.CardPool;
import forge.deck.DeckBase;
import forge.deck.DeckSection;
import forge.item.PaperCard;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Deck
extends DeckBase
implements Iterable<Map.Entry<DeckSection, CardPool>> {
    private final Map<DeckSection, CardPool> parts = new EnumMap<DeckSection, CardPool>(DeckSection.class);
    private final Set<String> tags = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> aiHints = new TreeSet<String>();
    private final Map<String, String> draftNotes = new HashMap<String, String>();
    private Map<String, List<String>> deferredSections = null;
    private Map<String, List<String>> loadedSections = null;
    private String lastCardArtPreferenceUsed = "";
    private Boolean lastCardArtOptimisationOptionUsed = null;
    private boolean includeCardsFromUnspecifiedSet = false;
    private transient UnplayableAICards unplayableAI = null;

    public Deck() {
        this("");
    }

    public Deck(String name0) {
        super(name0);
        this.getOrCreate(DeckSection.Main);
    }

    public Deck(Deck other) {
        this(other, other.getName());
    }

    public Deck(Deck other, String newName) {
        super(newName);
        other.cloneFieldsTo(this);
    }

    @Override
    public String getItemType() {
        return "Deck";
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public CardPool getMain() {
        this.loadDeferredSections();
        return this.parts.get((Object)DeckSection.Main);
    }

    public List<PaperCard> getCommanders() {
        ArrayList<PaperCard> result = Lists.newArrayList();
        CardPool cp = this.get(DeckSection.Commander);
        if (cp == null) {
            return result;
        }
        for (Map.Entry c2 : cp) {
            result.add((PaperCard)c2.getKey());
        }
        if (result.size() > 1) {
            result.sort(Comparator.comparing(c -> c.getRules().canBeSignatureSpell()));
        }
        return result;
    }

    public PaperCard getOathbreaker() {
        CardPool cp = this.get(DeckSection.Commander);
        if (cp == null) {
            return null;
        }
        for (Map.Entry c : cp) {
            PaperCard card = (PaperCard)c.getKey();
            if (!card.getRules().canBeOathbreaker()) continue;
            return card;
        }
        return null;
    }

    public PaperCard getSignatureSpell() {
        CardPool cp = this.get(DeckSection.Commander);
        if (cp == null) {
            return null;
        }
        for (Map.Entry c : cp) {
            PaperCard card = (PaperCard)c.getKey();
            if (!card.getRules().canBeSignatureSpell()) continue;
            return card;
        }
        return null;
    }

    public CardPool get(DeckSection deckSection) {
        this.loadDeferredSections();
        return this.parts.get((Object)deckSection);
    }

    public boolean has(DeckSection deckSection) {
        CardPool cp = this.get(deckSection);
        return cp != null && !cp.isEmpty();
    }

    public PaperCard removeCardName(String name) {
        for (Map.Entry<DeckSection, CardPool> kv : this.parts.entrySet()) {
            CardPool pool = kv.getValue();
            for (Map.Entry pc : pool) {
                if (!((PaperCard)pc.getKey()).getName().equalsIgnoreCase(name)) continue;
                PaperCard paperCard = (PaperCard)pc.getKey();
                pool.remove(paperCard);
                return paperCard;
            }
        }
        return null;
    }

    public CardPool getOrCreate(DeckSection deckSection) {
        CardPool p = this.get(deckSection);
        if (p != null) {
            return p;
        }
        p = new CardPool();
        this.parts.put(deckSection, p);
        return p;
    }

    public void putSection(DeckSection section, CardPool pool) {
        this.parts.put(section, pool);
    }

    public void setDeferredSections(Map<String, List<String>> deferredSections) {
        this.deferredSections = deferredSections;
    }

    @Override
    protected void cloneFieldsTo(DeckBase clone) {
        super.cloneFieldsTo(clone);
        Deck result = (Deck)clone;
        this.loadDeferredSections();
        for (Map.Entry<DeckSection, CardPool> kv : this.parts.entrySet()) {
            CardPool cp = new CardPool();
            result.parts.put(kv.getKey(), cp);
            cp.addAll(kv.getValue());
        }
        result.setAiHints(StringUtils.join(this.aiHints, " | "));
        result.setDraftNotes(this.draftNotes);
        this.tags.addAll(result.getTags());
    }

    @Override
    protected DeckBase newInstance(String name0) {
        return new Deck(name0);
    }

    private void loadDeferredSections() {
        HashMap<String, List<String>> referenceDeckLoadingMap;
        if (this.deferredSections == null && this.loadedSections == null) {
            return;
        }
        if (this.loadedSections != null && !this.includeCardsFromUnspecifiedSet) {
            return;
        }
        String cardArtPreference = StaticData.instance().getCardArtPreferenceName();
        boolean smartCardArtSelection = StaticData.instance().isEnabledCardArtSmartSelection();
        if (this.lastCardArtOptimisationOptionUsed == null) {
            this.lastCardArtOptimisationOptionUsed = smartCardArtSelection;
        }
        if (this.loadedSections != null && cardArtPreference.equals(this.lastCardArtPreferenceUsed) && this.lastCardArtOptimisationOptionUsed == smartCardArtSelection) {
            return;
        }
        if (this.deferredSections != null) {
            this.validateDeferredSections();
            referenceDeckLoadingMap = new HashMap<String, List<String>>(this.deferredSections);
        } else {
            referenceDeckLoadingMap = new HashMap<String, List<String>>(this.loadedSections);
        }
        this.loadedSections = new HashMap<String, List<String>>();
        this.lastCardArtPreferenceUsed = cardArtPreference;
        this.lastCardArtOptimisationOptionUsed = smartCardArtSelection;
        EnumMap<DeckSection, ArrayList<String>> cardsWithNoEdition = null;
        if (smartCardArtSelection) {
            cardsWithNoEdition = new EnumMap<DeckSection, ArrayList<String>>(DeckSection.class);
        }
        for (Map.Entry s2 : referenceDeckLoadingMap.entrySet()) {
            this.loadedSections.put((String)s2.getKey(), (List)s2.getValue());
            DeckSection sec = DeckSection.smartValueOf((String)s2.getKey());
            if (sec == null) continue;
            List cardsInSection = (List)s2.getValue();
            ArrayList<String> cardNamesWithNoEdition = this.getAllCardNamesWithNoSpecifiedEdition(cardsInSection);
            if (cardNamesWithNoEdition.size() > 0) {
                this.includeCardsFromUnspecifiedSet = true;
                if (smartCardArtSelection) {
                    cardsWithNoEdition.put(sec, cardNamesWithNoEdition);
                }
            }
            CardPool pool = CardPool.fromCardList(cardsInSection);
            this.putSection(sec, pool);
        }
        this.deferredSections = null;
        if (this.includeCardsFromUnspecifiedSet && smartCardArtSelection) {
            this.optimiseCardArtSelectionInDeckSections(cardsWithNoEdition);
        }
    }

    private void validateDeferredSections() {
        TreeMap<String, List<String>> validatedSections = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<String>> s2 : this.deferredSections.entrySet()) {
            DeckSection deckSection = DeckSection.smartValueOf(s2.getKey());
            if (deckSection == null) {
                validatedSections.put(s2.getKey(), s2.getValue());
                continue;
            }
            List<String> cardsInSection = s2.getValue();
            List<Pair<String, Integer>> originalCardRequests = CardPool.processCardList(cardsInSection);
            CardPool pool = CardPool.fromCardList(cardsInSection);
            if (pool.countDistinct() == 0) continue;
            CardPool filteredPool = pool.getFilteredPoolWithCardsCount(deckSection::validate);
            ArrayList<String> whiteList = validatedSections.getOrDefault(s2.getKey(), null);
            if (whiteList == null) {
                whiteList = new ArrayList<String>();
            }
            for (Map.Entry<PaperCard, Integer> entry : filteredPool) {
                String poolRequest = this.getPoolRequest(entry, originalCardRequests);
                whiteList.add(poolRequest);
            }
            validatedSections.put(s2.getKey(), whiteList);
            if (filteredPool.countDistinct() == pool.countDistinct()) continue;
            CardPool blackList = pool.getFilteredPoolWithCardsCount(input -> !deckSection.validate((PaperCard)input));
            for (Map.Entry<PaperCard, Integer> entry : blackList) {
                DeckSection cardSection = DeckSection.matchingSection((PaperCard)entry.getKey());
                String poolRequest = this.getPoolRequest(entry, originalCardRequests);
                ArrayList<String> sectionCardList = validatedSections.getOrDefault(cardSection.name(), null);
                if (sectionCardList == null) {
                    sectionCardList = new ArrayList<String>();
                }
                sectionCardList.add(poolRequest);
                validatedSections.put(cardSection.name(), sectionCardList);
            }
        }
        this.deferredSections = validatedSections;
    }

    private String getPoolRequest(Map.Entry<PaperCard, Integer> entry, List<Pair<String, Integer>> originalCardRequests) {
        PaperCard card = entry.getKey();
        int amount = entry.getValue();
        String poolCardRequest = CardDb.CardRequest.compose(card.isFoil() ? CardDb.CardRequest.compose(card.getName(), true) : card.getName(), card.getEdition(), card.getArtIndex());
        String originalRequestCandidate = null;
        for (Pair<String, Integer> originalRequest : originalCardRequests) {
            String cardRequest = originalRequest.getLeft();
            if (!StringUtils.startsWithIgnoreCase(poolCardRequest, cardRequest)) continue;
            originalRequestCandidate = cardRequest;
            int cardAmount = originalRequest.getRight();
            if (amount != cardAmount) continue;
            return String.format("%d %s", cardAmount, cardRequest);
        }
        if (originalRequestCandidate != null) {
            return String.format("%d %s", amount, originalRequestCandidate);
        }
        return String.format("%d %s", amount, poolCardRequest);
    }

    private ArrayList<String> getAllCardNamesWithNoSpecifiedEdition(List<String> cardsInSection) {
        ArrayList<String> cardNamesWithNoEdition = new ArrayList<String>();
        List<Pair<String, Integer>> cardRequests = CardPool.processCardList(cardsInSection);
        for (Pair<String, Integer> pair : cardRequests) {
            String requestString = pair.getLeft();
            CardDb.CardRequest request = CardDb.CardRequest.fromString(requestString);
            if (request.edition != null) continue;
            cardNamesWithNoEdition.add(request.cardName);
        }
        return cardNamesWithNoEdition;
    }

    private void optimiseCardArtSelectionInDeckSections(Map<DeckSection, ArrayList<String>> cardsWithNoEdition) {
        StaticData data = StaticData.instance();
        boolean isCardArtPreferenceLatestArt = data.cardArtPreferenceIsLatest();
        boolean cardArtPreferenceHasFilter = data.isCoreExpansionOnlyFilterSet();
        for (Map.Entry<DeckSection, CardPool> part : this.parts.entrySet()) {
            ArrayList cardNamesWithNoEditionInSection;
            DeckSection deckSection = part.getKey();
            if (deckSection != DeckSection.Main && deckSection != DeckSection.Sideboard && deckSection != DeckSection.Commander || (cardNamesWithNoEditionInSection = (ArrayList)cardsWithNoEdition.getOrDefault((Object)deckSection, null)) == null || cardNamesWithNoEditionInSection.size() == 0) continue;
            CardPool pool = part.getValue();
            boolean isExpansionTheMajorityInThePool = pool.getTheMostFrequentEditionType() == CardEdition.Type.EXPANSION;
            boolean isPoolModernFramed = pool.isModern();
            CardEdition pivotEdition = pool.getPivotCardEdition(isCardArtPreferenceLatestArt);
            if (pivotEdition == null) continue;
            Date releaseDatePivotEdition = pivotEdition.getDate();
            CardPool newPool = new CardPool();
            for (Map.Entry cp : pool) {
                PaperCard card = (PaperCard)cp.getKey();
                int totalToAddToPool = cp.getValue();
                if (!cardNamesWithNoEditionInSection.contains(card.getName())) {
                    this.addCardToPool(newPool, card, totalToAddToPool, card.isFoil());
                    continue;
                }
                boolean cardArtNeedsOptimisation = this.isCardArtUpdateRequired(card, releaseDatePivotEdition);
                if (!cardArtNeedsOptimisation) {
                    this.addCardToPool(newPool, card, totalToAddToPool, card.isFoil());
                    continue;
                }
                PaperCard alternativeCardPrint = data.getAlternativeCardPrint(card, releaseDatePivotEdition, isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter, isExpansionTheMajorityInThePool, isPoolModernFramed);
                if (alternativeCardPrint == null) {
                    this.addCardToPool(newPool, card, totalToAddToPool, card.isFoil());
                    continue;
                }
                this.addCardToPool(newPool, alternativeCardPrint, totalToAddToPool, card.isFoil());
            }
            this.parts.put(deckSection, newPool);
        }
    }

    private void addCardToPool(CardPool pool, PaperCard card, int totalToAdd, boolean isFoil) {
        StaticData data = StaticData.instance();
        if (card.getArtIndex() != -1 && card.getArtIndex() != 1) {
            pool.add(isFoil ? card.getFoiled() : card, totalToAdd);
        } else {
            int artCount = data.getCardArtCount(card);
            if (artCount > 1) {
                this.addAlternativeCardPrintInPoolWithMultipleArt(card, pool, totalToAdd, artCount);
            } else {
                pool.add(isFoil ? card.getFoiled() : card, totalToAdd);
            }
        }
    }

    private void addAlternativeCardPrintInPoolWithMultipleArt(PaperCard alternativeCardPrint, CardPool pool, int totalNrToAdd, int nrOfAvailableArts) {
        StaticData data = StaticData.instance();
        String cardName = alternativeCardPrint.getName();
        String setCode = alternativeCardPrint.getEdition();
        boolean isFoil = alternativeCardPrint.isFoil();
        int cardsPerArtIndex = totalNrToAdd / nrOfAvailableArts;
        int restOfCardsToAdd = cardsPerArtIndex > 0 ? totalNrToAdd % nrOfAvailableArts : 0;
        cardsPerArtIndex = Math.max(1, cardsPerArtIndex);
        int cardsAdded = 0;
        PaperCard alternativeCardArt = null;
        for (int artIndex = 1; artIndex <= nrOfAvailableArts; ++artIndex) {
            alternativeCardArt = data.getOrLoadCommonCard(cardName, setCode, artIndex, isFoil);
            pool.add(alternativeCardArt, cardsPerArtIndex);
            if ((cardsAdded += cardsPerArtIndex) == totalNrToAdd) break;
        }
        if (restOfCardsToAdd > 0) {
            pool.add(alternativeCardArt, restOfCardsToAdd);
        }
    }

    private boolean isCardArtUpdateRequired(PaperCard card, Date referenceReleaseDate) {
        if (card.getRules().isVariant()) {
            return false;
        }
        if (StaticData.instance().getCommonCards().hasPreferredArt(card.getName())) {
            CardDb.CardRequest request = CardDb.CardRequest.fromString(card.getName());
            if (request.edition.equals(card.getEdition()) && request.artIndex == card.getArtIndex()) {
                return false;
            }
        }
        boolean isLatestCardArtPreference = StaticData.instance().cardArtPreferenceIsLatest();
        CardEdition cardEdition = StaticData.instance().getCardEdition(card.getEdition());
        if (cardEdition == null) {
            return false;
        }
        Date releaseDate = cardEdition.getDate();
        if (releaseDate == null) {
            return false;
        }
        if (isLatestCardArtPreference) {
            return releaseDate.compareTo(referenceReleaseDate) > 0;
        }
        return releaseDate.compareTo(referenceReleaseDate) < 0;
    }

    @Override
    public Iterator<Map.Entry<DeckSection, CardPool>> iterator() {
        this.loadDeferredSections();
        return this.parts.entrySet().iterator();
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public CardPool getAllCardsInASinglePool() {
        return this.getAllCardsInASinglePool(true);
    }

    public CardPool getAllCardsInASinglePool(boolean includeCommander) {
        return this.getAllCardsInASinglePool(includeCommander, false);
    }

    public CardPool getAllCardsInASinglePool(boolean includeCommander, boolean includeExtras) {
        CardPool allCards = new CardPool();
        allCards.addAll(this.getMain());
        if (this.has(DeckSection.Sideboard)) {
            allCards.addAll(this.get(DeckSection.Sideboard));
        }
        if (includeCommander && this.has(DeckSection.Commander)) {
            allCards.addAll(this.get(DeckSection.Commander));
        }
        if (includeExtras) {
            for (DeckSection section : DeckSection.NONTRADITIONAL_SECTIONS) {
                if (!this.has(section)) continue;
                allCards.addAll(this.get(section));
            }
        }
        return allCards;
    }

    public int countByName(String cardName) {
        int sum = 0;
        for (Map.Entry<DeckSection, CardPool> section : this) {
            sum += section.getValue().countByName(cardName);
        }
        return sum;
    }

    public void setAiHints(String aiHintsInfo) {
        String[] hints;
        if (aiHintsInfo == null || aiHintsInfo.trim().isEmpty()) {
            return;
        }
        for (String hint : hints = aiHintsInfo.split("\\|")) {
            this.aiHints.add(hint.trim());
        }
    }

    public Set<String> getAiHints() {
        return this.aiHints;
    }

    public String getAiHint(String name) {
        for (String aiHint : this.aiHints) {
            if (!aiHint.toLowerCase().startsWith(name.toLowerCase() + "$")) continue;
            return aiHint.substring(aiHint.indexOf("$") + 1).trim();
        }
        return "";
    }

    public void setDraftNotes(Map<String, String> draftNotes) {
        if (draftNotes == null) {
            return;
        }
        for (String key : draftNotes.keySet()) {
            String notes = draftNotes.get(key);
            if (notes == null || notes.isEmpty()) continue;
            this.draftNotes.put(key, notes.trim());
        }
    }

    public Map<String, String> getDraftNotes() {
        return this.draftNotes;
    }

    public UnplayableAICards getUnplayableAICards() {
        if (this.unplayableAI == null) {
            this.unplayableAI = new UnplayableAICards(this);
        }
        return this.unplayableAI;
    }

    @Override
    public boolean isEmpty() {
        this.loadDeferredSections();
        for (CardPool part : this.parts.values()) {
            if (part.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getImageKey(boolean altState) {
        return null;
    }

    @Override
    public Deck getHumanDeck() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Deck) {
            CardPool otherPool;
            DeckBase dbase = (DeckBase)o;
            boolean deckBaseEquals = super.equals(dbase);
            if (!deckBaseEquals) {
                return false;
            }
            Deck d = (Deck)o;
            for (DeckSection deckSection : this.parts.keySet()) {
                otherPool = d.get(deckSection);
                CardPool thisPool = this.parts.get((Object)deckSection);
                if (thisPool.equals(otherPool)) continue;
                return false;
            }
            for (DeckSection deckSection : d.parts.keySet()) {
                otherPool = d.get(deckSection);
                if (this.parts.containsKey((Object)deckSection) || otherPool.countAll() <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int getAverageCMC(Deck deck) {
        int totalCMC = 0;
        int totalCount = 0;
        block3: for (Map.Entry<DeckSection, CardPool> deckEntry : deck) {
            switch (deckEntry.getKey()) {
                case Main: 
                case Commander: {
                    for (Map.Entry poolEntry : deckEntry.getValue()) {
                        CardRules rules = ((PaperCard)poolEntry.getKey()).getRules();
                        CardType type = rules.getType();
                        if (type.isLand() || !type.isArtifact() && !type.isCreature() && !type.isEnchantment() && !type.isPlaneswalker() && !type.isInstant() && !type.isSorcery()) continue;
                        totalCMC += rules.getManaCost().getCMC();
                        ++totalCount;
                    }
                    continue block3;
                }
            }
        }
        return totalCount == 0 ? 0 : Math.round(totalCMC / totalCount);
    }

    public static final class UnplayableAICards {
        public final Map<DeckSection, List<? extends PaperCard>> unplayable = new HashMap<DeckSection, List<? extends PaperCard>>();
        public final int inMainDeck;

        private UnplayableAICards(Deck myDeck) {
            int mainDeck = 0;
            for (Map.Entry<DeckSection, CardPool> ds : myDeck) {
                ArrayList<PaperCard> result = Lists.newArrayList();
                for (Map.Entry cp : ds.getValue()) {
                    if (!((PaperCard)cp.getKey()).getRules().getAiHints().getRemAIDecks()) continue;
                    result.add((PaperCard)cp.getKey());
                }
                if (ds.getKey().equals((Object)DeckSection.Main)) {
                    mainDeck = result.size();
                }
                if (result.isEmpty()) continue;
                this.unplayable.put(ds.getKey(), result);
            }
            this.inMainDeck = mainDeck;
        }
    }
}

