/*
 * Decompiled with CFR 0.152.
 */
package forge.control;

import forge.Singletons;
import forge.game.spellability.StackItemView;
import forge.gui.framework.EDocID;
import forge.gui.framework.SDisplayUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.home.settings.VSubmenuPreferences;
import forge.screens.match.CMatchUI;
import forge.toolbox.special.CardZoomer;
import forge.util.Localizer;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;

public class KeyboardShortcuts {
    public static List<Shortcut> getKeyboardShortcuts() {
        return KeyboardShortcuts.attachKeyboardShortcuts(null);
    }

    public static List<Shortcut> attachKeyboardShortcuts(final CMatchUI matchUI) {
        JLayeredPane c = Singletons.getView().getFrame().getLayeredPane();
        InputMap im = c.getInputMap(2);
        ActionMap am = c.getActionMap();
        ArrayList<Shortcut> list = new ArrayList<Shortcut>();
        AbstractAction actShowStack = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                SDisplayUtil.showTab(EDocID.REPORT_STACK.getDoc());
            }
        };
        AbstractAction actShowCombat = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                SDisplayUtil.showTab(EDocID.REPORT_COMBAT.getDoc());
            }
        };
        AbstractAction actShowConsole = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                SDisplayUtil.showTab(EDocID.REPORT_LOG.getDoc());
            }
        };
        AbstractAction actShowDev = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (ForgePreferences.DEV_MODE) {
                    SDisplayUtil.showTab(EDocID.DEV_MODE.getDoc());
                }
            }
        };
        AbstractAction actConcede = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                matchUI.concede();
            }
        };
        AbstractAction actEndTurn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                matchUI.getGameController().passPriorityUntilEndOfTurn();
            }
        };
        AbstractAction actAllAttack = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                matchUI.getGameController().alphaStrike();
            }
        };
        AbstractAction actTgtOverlay = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                matchUI.getCDock().toggleTargeting();
            }
        };
        AbstractAction actAutoYieldAndYes = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                StackItemView si = matchUI.getGameView().peekStack();
                if (si != null && si.isAbility()) {
                    matchUI.setShouldAutoYield(si.getKey(), true);
                    int triggerID = si.getSourceTrigger();
                    if (si.isOptionalTrigger() && matchUI.isLocalPlayer(si.getActivatingPlayer())) {
                        matchUI.setShouldAlwaysAcceptTrigger(triggerID);
                    }
                    matchUI.getGameController().passPriority();
                }
            }
        };
        AbstractAction actAutoYieldAndNo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                StackItemView si = matchUI.getGameView().peekStack();
                if (si != null && si.isAbility()) {
                    matchUI.setShouldAutoYield(si.getKey(), true);
                    int triggerID = si.getSourceTrigger();
                    if (si.isOptionalTrigger() && matchUI.isLocalPlayer(si.getActivatingPlayer())) {
                        matchUI.setShouldAlwaysDeclineTrigger(triggerID);
                    }
                    matchUI.getGameController().passPriority();
                }
            }
        };
        AbstractAction actMacroRecord = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                matchUI.getGameController().macros().setRememberedActions();
            }
        };
        AbstractAction actMacroNextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                matchUI.getGameController().macros().nextRememberedAction();
            }
        };
        AbstractAction actZoomCard = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Singletons.getControl().getCurrentScreen().isMatchScreen()) {
                    return;
                }
                if (matchUI == null) {
                    return;
                }
                if (!CardZoomer.SINGLETON_INSTANCE.isZoomerOpen()) {
                    CardZoomer.SINGLETON_INSTANCE.doMouseWheelZoom();
                } else {
                    CardZoomer.SINGLETON_INSTANCE.closeZoomer();
                }
            }
        };
        Localizer localizer = Localizer.getInstance();
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_SHOWSTACK, localizer.getMessage("lblSHORTCUT_SHOWSTACK", new Object[0]), actShowStack, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_SHOWCOMBAT, localizer.getMessage("lblSHORTCUT_SHOWCOMBAT", new Object[0]), actShowCombat, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_SHOWCONSOLE, localizer.getMessage("lblSHORTCUT_SHOWCONSOLE", new Object[0]), actShowConsole, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_SHOWDEV, localizer.getMessage("lblSHORTCUT_SHOWDEV", new Object[0]), actShowDev, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_CONCEDE, localizer.getMessage("lblSHORTCUT_CONCEDE", new Object[0]), actConcede, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_ENDTURN, localizer.getMessage("lblSHORTCUT_ENDTURN", new Object[0]), actEndTurn, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_ALPHASTRIKE, localizer.getMessage("lblSHORTCUT_ALPHASTRIKE", new Object[0]), actAllAttack, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_SHOWTARGETING, localizer.getMessage("lblSHORTCUT_SHOWTARGETING", new Object[0]), actTgtOverlay, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_AUTOYIELD_ALWAYS_YES, localizer.getMessage("lblSHORTCUT_AUTOYIELD_ALWAYS_YES", new Object[0]), actAutoYieldAndYes, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_AUTOYIELD_ALWAYS_NO, localizer.getMessage("lblSHORTCUT_AUTOYIELD_ALWAYS_NO", new Object[0]), actAutoYieldAndNo, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_MACRO_RECORD, localizer.getMessage("lblSHORTCUT_MACRO_RECORD", new Object[0]), actMacroRecord, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_MACRO_NEXT_ACTION, localizer.getMessage("lblSHORTCUT_MACRO_NEXT_ACTION", new Object[0]), actMacroNextAction, am, im));
        list.add(new Shortcut(ForgePreferences.FPref.SHORTCUT_CARD_ZOOM, localizer.getMessage("lblSHORTCUT_CARD_ZOOM", new Object[0]), actZoomCard, am, im));
        return list;
    }

    private static KeyStroke assembleKeystrokes(String[] keys0) {
        int[] inputEvents = new int[2];
        int modifier = 0;
        int keyEvent = 0;
        inputEvents[0] = 0;
        inputEvents[1] = 0;
        for (String s2 : keys0) {
            if (s2.equals("16")) {
                inputEvents[0] = 16;
                continue;
            }
            if (s2.equals("17")) {
                inputEvents[1] = 17;
                continue;
            }
            keyEvent = Integer.parseInt(s2);
        }
        if (inputEvents[0] == 16 && inputEvents[1] != 17) {
            modifier = 64;
        } else if (inputEvents[0] != 16 && inputEvents[1] == 17) {
            modifier = 128;
        } else if (inputEvents[0] != 0 && inputEvents[1] != 0) {
            modifier = 192;
        }
        return KeyStroke.getKeyStroke(keyEvent, modifier);
    }

    public static void addKeyCode(KeyEvent e) {
        VSubmenuPreferences.KeyboardShortcutField ksf = (VSubmenuPreferences.KeyboardShortcutField)e.getSource();
        String newCode = Integer.toString(e.getKeyCode());
        String codestring = ksf.getCodeString();
        ArrayList<Object> existingCodes = codestring != null ? new ArrayList<String>(Arrays.asList(codestring.split(" "))) : new ArrayList();
        if (e.getKeyCode() == 8) {
            existingCodes.remove(existingCodes.size() - 1);
        } else if (!existingCodes.contains(newCode)) {
            existingCodes.add(newCode);
        }
        ksf.setCodeString(StringUtils.join(existingCodes, ' '));
    }

    public static class Shortcut {
        private final ForgePreferences.FPref prefkeys;
        private final String description;
        private final Action handler;
        private final ActionMap actionMap;
        private final InputMap inputMap;
        private KeyStroke key;
        private String str;

        public Shortcut(ForgePreferences.FPref prefkey0, String description0, Action handler0, ActionMap am0, InputMap im0) {
            this.prefkeys = prefkey0;
            this.description = description0;
            this.handler = handler0;
            this.actionMap = am0;
            this.inputMap = im0;
            this.attach();
        }

        public String getDescription() {
            return this.description;
        }

        public ForgePreferences.FPref getPrefKey() {
            return this.prefkeys;
        }

        public void attach() {
            this.detach();
            this.str = FModel.getPreferences().getPref(this.prefkeys);
            if (!this.str.isEmpty()) {
                this.key = KeyboardShortcuts.assembleKeystrokes(this.str.split(" "));
                this.inputMap.put(this.key, this.str);
                this.actionMap.put(this.str, this.handler);
            }
        }

        public void detach() {
            this.inputMap.remove(this.key);
            this.actionMap.remove(this.str);
        }
    }
}

