/*
 * Decompiled with CFR 0.152.
 */
package forge.control;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.ImageCache;
import forge.LobbyPlayer;
import forge.Singletons;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.quest.data.QuestPreferences;
import forge.gamemodes.quest.io.QuestDataIO;
import forge.gui.GuiBase;
import forge.gui.SOverlayUtils;
import forge.gui.framework.FScreen;
import forge.gui.framework.InvalidLayoutFileException;
import forge.gui.framework.SLayoutIO;
import forge.gui.framework.SOverflowUtil;
import forge.gui.framework.SResizingUtil;
import forge.gui.util.SOptionPane;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.menus.ForgeMenu;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.RestartUtil;
import forge.view.FFrame;
import forge.view.FView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public enum FControl implements KeyEventDispatcher
{
    instance;

    private ForgeMenu forgeMenu;
    private JLayeredPane display;
    private FScreen currentScreen;
    private boolean altKeyLastDown;
    private CloseAction closeAction;
    private final List<HostedMatch> currentMatches = Lists.newArrayList();

    private boolean hasCurrentMatches() {
        this.cleanMatches();
        return !this.currentMatches.isEmpty();
    }

    public List<HostedMatch> getCurrentMatches() {
        this.cleanMatches();
        return Collections.unmodifiableList(this.currentMatches);
    }

    public void addMatch(HostedMatch match) {
        this.cleanMatches();
        this.currentMatches.add(match);
    }

    private void cleanMatches() {
        for (HostedMatch match : ImmutableList.copyOf(this.currentMatches)) {
            if (!match.isMatchOver()) continue;
            this.currentMatches.remove(match);
        }
    }

    private FControl() {
        final Localizer localizer = Localizer.getInstance();
        Singletons.getView().getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                switch (FControl.this.closeAction) {
                    case NONE: {
                        ImmutableList<String> options = ImmutableList.of(localizer.getMessage("lblCloseScreen", new Object[0]), localizer.getMessage("lblExitForge", new Object[0]), localizer.getMessage("lblCancel", new Object[0]));
                        int reply = FOptionPane.showOptionDialog(localizer.getMessage("txCloseAction1", new Object[0]) + "\n\n" + localizer.getMessage("txCloseAction2", new Object[0]), localizer.getMessage("titCloseAction", new Object[0]), FOptionPane.INFORMATION_ICON, options, 2);
                        switch (reply) {
                            case 0: {
                                FControl.this.setCloseAction(CloseAction.CLOSE_SCREEN);
                                this.windowClosing(e);
                                return;
                            }
                            case 1: {
                                FControl.this.setCloseAction(CloseAction.EXIT_FORGE);
                                this.windowClosing(e);
                                return;
                            }
                        }
                        break;
                    }
                    case CLOSE_SCREEN: {
                        Singletons.getView().getNavigationBar().closeSelectedTab();
                        break;
                    }
                    case EXIT_FORGE: {
                        if (!FControl.this.exitForge()) break;
                        return;
                    }
                }
                Singletons.getView().getFrame().setDefaultCloseOperation(0);
            }
        });
    }

    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(CloseAction closeAction0) {
        if (this.closeAction == closeAction0) {
            return;
        }
        this.closeAction = closeAction0;
        Singletons.getView().getNavigationBar().updateBtnCloseTooltip();
        ForgePreferences prefs = FModel.getPreferences();
        prefs.setPref(ForgePreferences.FPref.UI_CLOSE_ACTION, closeAction0.toString());
        prefs.save();
    }

    public boolean canExitForge(boolean forRestart) {
        Localizer localizer = Localizer.getInstance();
        String action = forRestart ? localizer.getMessage("lblRestart", new Object[0]) : localizer.getMessage("lblExit", new Object[0]);
        String userPrompt = forRestart ? localizer.getMessage("lblAreYouSureYouWishRestartForge", new Object[0]) : localizer.getMessage("lblAreYouSureYouWishExitForge", new Object[0]);
        boolean hasCurrentMatches = this.hasCurrentMatches();
        if (hasCurrentMatches) {
            userPrompt = localizer.getMessage("lblOneOrMoreGamesActive", new Object[0]) + ". " + userPrompt;
        }
        if (!FOptionPane.showConfirmDialog(userPrompt, action + " Forge", action, localizer.getMessage("lblCancel", new Object[0]), !hasCurrentMatches)) {
            return false;
        }
        return CDeckEditorUI.SINGLETON_INSTANCE.canSwitchAway(true);
    }

    public boolean restartForge() {
        if (!this.canExitForge(true)) {
            return false;
        }
        if (RestartUtil.prepareForRestart()) {
            System.exit(0);
            return true;
        }
        return false;
    }

    public boolean exitForge() {
        if (!this.canExitForge(false)) {
            return false;
        }
        Singletons.getView().getFrame().setDefaultCloseOperation(3);
        System.exit(0);
        return true;
    }

    public void initialize() {
        FSkin.loadFull(true);
        this.display = FView.SINGLETON_INSTANCE.getLpnDocument();
        ForgePreferences prefs = FModel.getPreferences();
        boolean propertyConfig = prefs != null && prefs.getPrefBoolean(ForgePreferences.FPref.UI_NETPLAY_COMPAT);
        GuiBase.enablePropertyConfig(propertyConfig);
        this.closeAction = CloseAction.valueOf(prefs.getPref(ForgePreferences.FPref.UI_CLOSE_ACTION));
        Localizer localizer = Localizer.getInstance();
        FView.SINGLETON_INSTANCE.setSplashProgessBarMessage(localizer.getMessage("lblLoadingQuest", new Object[0]));
        File dirQuests = new File(ForgeConstants.QUEST_SAVE_DIR);
        String questname = FModel.getQuestPreferences().getPref(QuestPreferences.QPref.CURRENT_QUEST);
        File data = new File(dirQuests.getPath(), questname);
        if (data.exists()) {
            try {
                FModel.getQuest().load(QuestDataIO.loadData(data));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.err.printf("Error loading quest data (%s).. skipping for now..%n", questname);
            }
        }
        final FFrame window = Singletons.getView().getFrame();
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FControl.this.sizeChildren();
                window.updateNormalBounds();
                SLayoutIO.saveWindowLayout();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                window.updateNormalBounds();
                SLayoutIO.saveWindowLayout();
            }
        });
        FView.SINGLETON_INSTANCE.getLpnDocument().addMouseListener(SOverflowUtil.getHideOverflowListener());
        FView.SINGLETON_INSTANCE.getLpnDocument().addComponentListener(SResizingUtil.getWindowResizeListener());
        this.setGlobalKeyboardHandler();
        FView.SINGLETON_INSTANCE.setSplashProgessBarMessage(localizer.getMessage("lblOpeningMainWindow", new Object[0]));
        SwingUtilities.invokeLater(() -> Singletons.getView().initialize());
    }

    private void setGlobalKeyboardHandler() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(this);
    }

    public ForgeMenu getForgeMenu() {
        if (this.forgeMenu == null) {
            this.forgeMenu = new ForgeMenu();
        }
        return this.forgeMenu;
    }

    public FScreen getCurrentScreen() {
        return this.currentScreen;
    }

    public boolean setCurrentScreen(FScreen screen) {
        return this.setCurrentScreen(screen, false);
    }

    public boolean setCurrentScreen(FScreen screen, boolean previousScreenClosed) {
        block12: {
            if (this.currentScreen != screen && !Singletons.getView().getNavigationBar().canSwitch(screen)) {
                return false;
            }
            if (this.currentScreen != null && this.currentScreen.isMatchScreen() && this.isMatchBackgroundImageVisible()) {
                FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(new ImageIcon());
            }
            this.clearChildren(JLayeredPane.DEFAULT_LAYER);
            SOverlayUtils.hideOverlay();
            ImageCache.clear();
            this.currentScreen = screen;
            screen.getController().register();
            try {
                SLayoutIO.loadLayout(null);
            }
            catch (InvalidLayoutFileException ex) {
                Localizer localizer = Localizer.getInstance();
                SOptionPane.showMessageDialog(String.format(localizer.getMessage("lblerrLoadingLayoutFile", new Object[0]), screen.getTabCaption()), "Warning!");
                if (!screen.deleteLayoutFile()) break block12;
                SLayoutIO.loadLayout(null);
            }
        }
        screen.getController().initialize();
        screen.getView().populate();
        if (screen.isMatchScreen()) {
            if (this.isMatchBackgroundImageVisible()) {
                if (screen.getDaytime() == null) {
                    FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_MATCH), true);
                } else if ("Day".equals(screen.getDaytime())) {
                    FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_DAY), true);
                } else {
                    FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage(FSkin.getIcon(FSkinProp.BG_NIGHT), true);
                }
            } else {
                FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage((Image)null);
            }
        } else {
            FView.SINGLETON_INSTANCE.getPnlInsets().setForegroundImage((Image)null);
        }
        Singletons.getView().getNavigationBar().updateSelectedTab();
        return true;
    }

    private boolean isMatchBackgroundImageVisible() {
        return FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_MATCH_IMAGE_VISIBLE);
    }

    public boolean ensureScreenActive(FScreen screen) {
        if (this.currentScreen == screen) {
            return true;
        }
        return this.setCurrentScreen(screen);
    }

    private void clearChildren(int layer0) {
        Component[] children;
        for (Component c : children = FView.SINGLETON_INSTANCE.getLpnDocument().getComponentsInLayer(layer0)) {
            this.display.remove(c);
        }
    }

    private void sizeChildren() {
        Component[] children = this.display.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
        if (children.length != 0) {
            children[0].setSize(this.display.getSize());
        }
        if ((children = this.display.getComponentsInLayer(FView.TARGETING_LAYER)).length != 0) {
            children[0].setSize(this.display.getSize());
        }
        if ((children = this.display.getComponentsInLayer(JLayeredPane.MODAL_LAYER)).length != 0) {
            children[0].setSize(this.display.getSize());
        }
    }

    public Dimension getDisplaySize() {
        return this.display.getSize();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            if (e.getID() == 402) {
                if (this.altKeyLastDown) {
                    this.forgeMenu.show(true);
                    return true;
                }
            } else if (e.getID() == 401 && e.getModifiersEx() == 512) {
                this.altKeyLastDown = true;
            }
        } else {
            this.altKeyLastDown = false;
            if (e.getID() == 401) {
                return this.forgeMenu.handleKeyEvent(e);
            }
            if (e.getID() == 402 && e.getKeyCode() == 525) {
                this.forgeMenu.show();
            }
        }
        return false;
    }

    public final LobbyPlayer getGuiPlayer() {
        return GamePlayerUtil.getGuiPlayer();
    }

    public static enum CloseAction {
        NONE,
        CLOSE_SCREEN,
        EXIT_FORGE;

    }
}

