/*
 * Decompiled with CFR 0.152.
 */
package forge.card.mana;

public abstract class ManaAtom {
    public static final int WHITE = 1;
    public static final int BLUE = 2;
    public static final int BLACK = 4;
    public static final int RED = 8;
    public static final int GREEN = 16;
    public static final int COLORLESS = 32;
    public static final byte[] MANACOLORS = new byte[]{1, 2, 4, 8, 16};
    public static final byte[] MANATYPES = new byte[]{1, 2, 4, 8, 16, 32};
    public static final byte ALL_MANA_COLORS = 31;
    public static final byte ALL_MANA_TYPES = 63;
    public static final int GENERIC = 64;
    public static final int IS_X = 256;
    public static final int OR_2_GENERIC = 512;
    public static final int OR_2_LIFE = 1024;
    public static final int IS_SNOW = 2048;

    public static byte fromName(char c) {
        switch (Character.toLowerCase(c)) {
            case 'w': {
                return 1;
            }
            case 'u': {
                return 2;
            }
            case 'b': {
                return 4;
            }
            case 'r': {
                return 8;
            }
            case 'g': {
                return 16;
            }
            case 'c': {
                return 32;
            }
        }
        return 0;
    }

    public static byte fromName(String s2) {
        if (s2 == null) {
            return 0;
        }
        if (s2.length() == 2) {
            return (byte)(ManaAtom.fromName(s2.charAt(0)) | ManaAtom.fromName(s2.charAt(1)));
        }
        if (s2.length() == 1) {
            return ManaAtom.fromName(s2.charAt(0));
        }
        switch (s2 = s2.toLowerCase()) {
            case "white": {
                return 1;
            }
            case "blue": {
                return 2;
            }
            case "black": {
                return 4;
            }
            case "red": {
                return 8;
            }
            case "green": {
                return 16;
            }
            case "colorless": {
                return 32;
            }
        }
        return 0;
    }

    public static byte fromConversion(String s2) {
        switch (s2) {
            case "AnyColor": {
                return 31;
            }
            case "AnyType": {
                return 63;
            }
        }
        if (s2.startsWith("non")) {
            return (byte)(ManaAtom.fromName(s2.substring(3)) ^ 0x3F);
        }
        byte b = 0;
        if (s2.length() > 2) {
            b = ManaAtom.fromName(s2);
        }
        if (b == 0) {
            for (char c : s2.toCharArray()) {
                b = (byte)(b | ManaAtom.fromName(c));
            }
        }
        return b;
    }

    public static int getIndexOfFirstManaType(byte color) {
        for (int i = 0; i < MANATYPES.length; ++i) {
            if ((color & MANATYPES[i]) == 0) continue;
            return i;
        }
        return -1;
    }

    public static int getIndexFromName(String s2) {
        return ManaAtom.getIndexOfFirstManaType(ManaAtom.fromName(s2));
    }
}

