/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.collect.ImmutableList;

public final class MagicColor {
    public static final byte WHITE = 1;
    public static final byte BLUE = 2;
    public static final byte BLACK = 4;
    public static final byte RED = 8;
    public static final byte GREEN = 16;
    public static final byte COLORLESS = 0;
    public static final byte ALL_COLORS = 31;
    public static final int NUMBER_OR_COLORS = 5;
    public static final byte[] WUBRG = new byte[]{1, 2, 4, 8, 16};
    public static final byte[] WUBRGC = new byte[]{1, 2, 4, 8, 16, 0};
    public static final byte[] COLORPAIR = new byte[]{3, 6, 12, 24, 17, 5, 10, 20, 9, 18};

    private MagicColor() {
    }

    public static byte fromName(String s2) {
        if (s2 == null) {
            return 0;
        }
        if (s2.equals("all")) {
            return 31;
        }
        if (s2.length() == 2) {
            return (byte)(MagicColor.fromName(s2.charAt(0)) | MagicColor.fromName(s2.charAt(1)));
        }
        if ((s2 = s2.toLowerCase()).length() == 1) {
            switch (s2) {
                case "w": {
                    return 1;
                }
                case "u": {
                    return 2;
                }
                case "b": {
                    return 4;
                }
                case "r": {
                    return 8;
                }
                case "g": {
                    return 16;
                }
                case "c": {
                    return 0;
                }
            }
        } else {
            switch (s2) {
                case "white": {
                    return 1;
                }
                case "blue": {
                    return 2;
                }
                case "black": {
                    return 4;
                }
                case "red": {
                    return 8;
                }
                case "green": {
                    return 16;
                }
                case "colorless": {
                    return 0;
                }
            }
        }
        return 0;
    }

    public static byte fromName(char c) {
        switch (Character.toLowerCase(c)) {
            case 'w': {
                return 1;
            }
            case 'u': {
                return 2;
            }
            case 'b': {
                return 4;
            }
            case 'r': {
                return 8;
            }
            case 'g': {
                return 16;
            }
        }
        return 0;
    }

    public static String toShortString(String color) {
        if (color.equalsIgnoreCase("snow")) {
            return "S";
        }
        return MagicColor.toShortString(MagicColor.fromName(color));
    }

    public static String toShortString(byte color) {
        switch (color) {
            case 1: {
                return "W";
            }
            case 2: {
                return "U";
            }
            case 4: {
                return "B";
            }
            case 8: {
                return "R";
            }
            case 16: {
                return "G";
            }
        }
        return "C";
    }

    public static String toLongString(byte color) {
        switch (color) {
            case 1: {
                return "white";
            }
            case 2: {
                return "blue";
            }
            case 4: {
                return "black";
            }
            case 8: {
                return "red";
            }
            case 16: {
                return "green";
            }
        }
        return "colorless";
    }

    public static String toSymbol(byte color) {
        return Color.fromByte(color).getSymbol();
    }

    public static String toSymbol(String color) {
        return MagicColor.toSymbol(MagicColor.fromName(color));
    }

    public static enum Color {
        WHITE("white", 1, "{W}"),
        BLUE("blue", 2, "{U}"),
        BLACK("black", 4, "{B}"),
        RED("red", 8, "{R}"),
        GREEN("green", 16, "{G}"),
        COLORLESS("colorless", 0, "{C}");

        private final String name;
        private final String symbol;
        private final byte colormask;

        private Color(String name0, byte colormask0, String symbol0) {
            this.name = name0;
            this.colormask = colormask0;
            this.symbol = symbol0;
        }

        public static Color fromByte(byte color) {
            switch (color) {
                case 1: {
                    return WHITE;
                }
                case 2: {
                    return BLUE;
                }
                case 4: {
                    return BLACK;
                }
                case 8: {
                    return RED;
                }
                case 16: {
                    return GREEN;
                }
            }
            return COLORLESS;
        }

        public String getName() {
            return this.name;
        }

        public byte getColormask() {
            return this.colormask;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Constant {
        public static final String WHITE = "white";
        public static final String BLUE = "blue";
        public static final String BLACK = "black";
        public static final String RED = "red";
        public static final String GREEN = "green";
        public static final String COLORLESS = "colorless";
        public static final ImmutableList<String> ONLY_COLORS = ImmutableList.of("white", "blue", "black", "red", "green");
        public static final ImmutableList<String> COLORS_AND_COLORLESS = ImmutableList.of("white", "blue", "black", "red", "green", "colorless");
        public static final String SNOW = "snow";
        public static final ImmutableList<String> BASIC_LANDS = ImmutableList.of("Plains", "Island", "Swamp", "Mountain", "Forest");
        public static final ImmutableList<String> SNOW_LANDS = ImmutableList.of("Snow-Covered Plains", "Snow-Covered Island", "Snow-Covered Swamp", "Snow-Covered Mountain", "Snow-Covered Forest");
        public static final String ANY_COLOR_CONVERSION = "AnyType->AnyColor";
        public static final String ANY_TYPE_CONVERSION = "AnyType->AnyType";

        private Constant() {
        }
    }
}

