/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.card.mana.ManaCost;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

final class CardFace
implements ICardFace,
Cloneable {
    private static final List<String> emptyList = Collections.unmodifiableList(new ArrayList());
    private static final Map<String, String> emptyMap = Collections.unmodifiableMap(new TreeMap());
    private static final Set<Integer> emptySet = Collections.unmodifiableSet(new HashSet());
    private String name;
    private String altName = null;
    private CardType type = null;
    private ManaCost manaCost = null;
    private ColorSet color = null;
    private String oracleText = null;
    private int iPower = Integer.MAX_VALUE;
    private int iToughness = Integer.MAX_VALUE;
    private String power = null;
    private String toughness = null;
    private String initialLoyalty = "";
    private String defense = "";
    private Set<Integer> attractionLights = null;
    private String nonAbilityText = null;
    private List<String> keywords = null;
    private List<String> abilities = null;
    private List<String> staticAbilities = null;
    private List<String> triggers = null;
    private List<String> draftActions = null;
    private List<String> replacements = null;
    private Map<String, String> variables = null;
    private Map<String, CardFace> functionalVariants = null;

    @Override
    public String getOracleText() {
        return this.oracleText;
    }

    @Override
    public int getIntPower() {
        return this.iPower;
    }

    @Override
    public int getIntToughness() {
        return this.iToughness;
    }

    @Override
    public String getPower() {
        return this.power;
    }

    @Override
    public String getToughness() {
        return this.toughness;
    }

    @Override
    public String getInitialLoyalty() {
        return this.initialLoyalty;
    }

    @Override
    public String getDefense() {
        return this.defense;
    }

    @Override
    public Set<Integer> getAttractionLights() {
        return this.attractionLights;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CardType getType() {
        return this.type;
    }

    @Override
    public ManaCost getManaCost() {
        return this.manaCost;
    }

    @Override
    public ColorSet getColor() {
        return this.color;
    }

    @Override
    public Iterable<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public Iterable<String> getAbilities() {
        return this.abilities;
    }

    @Override
    public Iterable<String> getStaticAbilities() {
        return this.staticAbilities;
    }

    @Override
    public Iterable<String> getTriggers() {
        return this.triggers;
    }

    @Override
    public Iterable<String> getDraftActions() {
        return this.draftActions;
    }

    @Override
    public Iterable<String> getReplacements() {
        return this.replacements;
    }

    @Override
    public String getNonAbilityText() {
        return this.nonAbilityText;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getVariables() {
        if (this.variables == null) {
            return null;
        }
        return this.variables.entrySet();
    }

    @Override
    public String getAltName() {
        return this.altName;
    }

    public CardFace(String name0) {
        this.name = name0;
        if (StringUtils.isBlank(name0)) {
            throw new RuntimeException("Card name is empty");
        }
    }

    void setName(String name) {
        this.name = name;
    }

    void setAltName(String name) {
        this.altName = name;
    }

    void setType(CardType type0) {
        this.type = type0;
    }

    void setManaCost(ManaCost manaCost0) {
        this.manaCost = manaCost0;
    }

    void setColor(ColorSet color0) {
        this.color = color0;
    }

    void setOracleText(String text) {
        this.oracleText = text;
    }

    void setInitialLoyalty(String value) {
        this.initialLoyalty = value;
    }

    void setDefense(String value) {
        this.defense = value;
    }

    void setAttractionLights(String value) {
        if (value == null) {
            this.attractionLights = null;
            return;
        }
        this.attractionLights = Arrays.stream(value.split(" ")).map(Integer::parseInt).collect(Collectors.toSet());
    }

    void setPtText(String value) {
        String[] k = value.split("/");
        if (k.length != 2) {
            throw new RuntimeException("Creature '" + this.getName() + "' has bad p/t stats");
        }
        this.power = k[0];
        this.toughness = k[1];
        this.iPower = CardFace.parsePT(k[0]);
        this.iToughness = CardFace.parsePT(k[1]);
    }

    static int parsePT(String val) {
        if (val.contains("*")) {
            val = val.replace("+*", "");
            val = val.replace("-*", "");
            val = val.replace("*+", "");
            val = val.replace("*", "0");
        }
        return Integer.parseInt(val);
    }

    void setNonAbilityText(String value) {
        this.nonAbilityText = value;
    }

    void addKeyword(String value) {
        if (null == this.keywords) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(value);
    }

    void addAbility(String value) {
        if (null == this.abilities) {
            this.abilities = new ArrayList<String>();
        }
        this.abilities.add(value);
    }

    void addTrigger(String value) {
        if (null == this.triggers) {
            this.triggers = new ArrayList<String>();
        }
        this.triggers.add(value);
    }

    void addDraftAction(String value) {
        if (null == this.draftActions) {
            this.draftActions = new ArrayList<String>();
        }
        this.draftActions.add(value);
    }

    void addStaticAbility(String value) {
        if (null == this.staticAbilities) {
            this.staticAbilities = new ArrayList<String>();
        }
        this.staticAbilities.add(value);
    }

    void addReplacementEffect(String value) {
        if (null == this.replacements) {
            this.replacements = new ArrayList<String>();
        }
        this.replacements.add(value);
    }

    void addSVar(String key, String value) {
        if (null == this.variables) {
            this.variables = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.variables.put(key, value);
    }

    @Override
    public boolean hasFunctionalVariants() {
        return this.functionalVariants != null;
    }

    @Override
    public ICardFace getFunctionalVariant(String variant) {
        if (this.functionalVariants == null) {
            return null;
        }
        return this.functionalVariants.get(variant);
    }

    @Override
    public Map<String, ? extends ICardFace> getFunctionalVariants() {
        return this.functionalVariants;
    }

    CardFace getOrCreateFunctionalVariant(String variant) {
        if (this.functionalVariants == null) {
            this.functionalVariants = new HashMap<String, CardFace>();
        }
        if (!this.functionalVariants.containsKey(variant)) {
            this.functionalVariants.put(variant, new CardFace(this.name));
        }
        return this.functionalVariants.get(variant);
    }

    void assignMissingFields() {
        if (null == this.oracleText) {
            System.err.println(this.name + " has no Oracle text.");
            this.oracleText = "";
        }
        if (this.manaCost == null && this.color == null) {
            System.err.println(this.name + " has neither ManaCost nor Color");
        }
        if (this.manaCost == null) {
            this.manaCost = ManaCost.NO_COST;
        }
        if (this.color == null) {
            this.color = ColorSet.fromManaCost(this.manaCost);
        }
        if (this.keywords == null) {
            this.keywords = emptyList;
        }
        if (this.abilities == null) {
            this.abilities = emptyList;
        }
        if (this.staticAbilities == null) {
            this.staticAbilities = emptyList;
        }
        if (this.triggers == null) {
            this.triggers = emptyList;
        }
        if (this.replacements == null) {
            this.replacements = emptyList;
        }
        if (this.variables == null) {
            this.variables = emptyMap;
        }
        if (null == this.nonAbilityText) {
            this.nonAbilityText = "";
        }
        if (this.attractionLights == null) {
            this.attractionLights = emptySet;
        }
        if (this.functionalVariants != null) {
            for (CardFace variant : this.functionalVariants.values()) {
                if (variant.oracleText == null) {
                    variant.oracleText = this.oracleText;
                }
                if (variant.manaCost == null) {
                    variant.manaCost = this.manaCost;
                }
                if (variant.color == null) {
                    variant.color = ColorSet.fromManaCost(variant.manaCost);
                }
                if (variant.type == null) {
                    variant.type = this.type;
                }
                if (variant.power == null) {
                    variant.power = this.power;
                    variant.iPower = this.iPower;
                }
                if (variant.toughness == null) {
                    variant.toughness = this.toughness;
                    variant.iToughness = this.iToughness;
                }
                if ("".equals(variant.initialLoyalty)) {
                    variant.initialLoyalty = this.initialLoyalty;
                }
                if ("".equals(variant.defense)) {
                    variant.defense = this.defense;
                }
                if (variant.keywords == null) {
                    variant.keywords = this.keywords;
                } else {
                    variant.keywords.addAll(0, this.keywords);
                }
                if (variant.abilities == null) {
                    variant.abilities = this.abilities;
                } else {
                    variant.abilities.addAll(0, this.abilities);
                }
                if (variant.staticAbilities == null) {
                    variant.staticAbilities = this.staticAbilities;
                } else {
                    variant.staticAbilities.addAll(0, this.staticAbilities);
                }
                if (variant.triggers == null) {
                    variant.triggers = this.triggers;
                } else {
                    variant.triggers.addAll(0, this.triggers);
                }
                if (variant.replacements == null) {
                    variant.replacements = this.replacements;
                } else {
                    variant.replacements.addAll(0, this.replacements);
                }
                if (variant.variables == null) {
                    variant.variables = this.variables;
                } else {
                    variant.variables.putAll(this.variables);
                }
                if (variant.nonAbilityText == null) {
                    variant.nonAbilityText = this.nonAbilityText;
                }
                if (variant.draftActions == null) {
                    variant.draftActions = this.draftActions;
                }
                if (variant.attractionLights == null) {
                    variant.attractionLights = this.attractionLights;
                }
                if (variant.altName != null) continue;
                variant.altName = this.altName;
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ICardFace o) {
        return this.getName().compareTo(o.getName());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new RuntimeException("CardFace : clone() error, " + ex);
        }
    }

    public static enum FaceSelectionMethod {
        USE_ACTIVE_FACE,
        USE_PRIMARY_FACE,
        COMBINE;

    }
}

