/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardRarity;
import forge.card.MagicColor;
import forge.card.PrintSheet;
import forge.deck.CardPool;
import forge.item.BoosterSlot;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.item.SealedTemplateWithSlots;
import forge.util.Aggregates;
import forge.util.CollectionSuppliers;
import forge.util.FileSection;
import forge.util.FileUtil;
import forge.util.IItemReader;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.storage.StorageBase;
import forge.util.storage.StorageReaderBase;
import forge.util.storage.StorageReaderFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class CardEdition
implements Comparable<CardEdition> {
    private static final List<String> reservedSectionNames = ImmutableList.of("metadata", "tokens", "other");
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    public static final CardEdition UNKNOWN = new CardEdition("1990-01-01", "???", "??", Type.UNKNOWN, "Undefined", FoilType.NOT_SUPPORTED, new CardInSet[0]);
    private Date date;
    private String code;
    private String code2;
    private String scryfallCode;
    private String cardsLanguage;
    private Type type;
    private String name;
    private String alias = null;
    private BorderColor borderColor = BorderColor.BLACK;
    private String prerelease = null;
    private int boosterBoxCount = 36;
    private int fatPackCount = 10;
    private String fatPackExtraSlots = "";
    private List<BoosterSlot> boosterSlots = null;
    private boolean smallSetOverride = false;
    private boolean foilAlwaysInCommonSlot = false;
    private FoilType foilType = FoilType.NOT_SUPPORTED;
    private double foilChanceInBooster = 0.0;
    private double chanceReplaceCommonWith = 0.0;
    private String slotReplaceCommonWith = "Common";
    private String additionalSheetForFoils = "";
    private String additionalUnlockSet = "";
    private String boosterMustContain = "";
    private String boosterReplaceSlotFromPrintSheet = "";
    private String sheetReplaceCardFromSheet = "";
    private String sheetReplaceCardFromSheet2 = "";
    private String doublePickDuringDraft = "";
    private String[] chaosDraftThemes = new String[0];
    private final ListMultimap<String, CardInSet> cardMap;
    private final List<CardInSet> cardsInSet;
    private final Map<String, Integer> tokenNormalized;
    private final Map<String, List<String>> customPrintSheetsToParse;
    private int boosterArts = 1;
    private SealedTemplate boosterTpl = null;
    private final Map<String, SealedTemplate> boosterTemplates = new HashMap<String, SealedTemplate>();
    private ListMultimap<String, CardInSet> cardsInSetLookupMap = null;

    private CardEdition(ListMultimap<String, CardInSet> cardMap, Map<String, Integer> tokens, Map<String, List<String>> customPrintSheetsToParse) {
        this.cardMap = cardMap;
        this.cardsInSet = new ArrayList(cardMap.values());
        Collections.sort(this.cardsInSet);
        this.tokenNormalized = tokens;
        this.customPrintSheetsToParse = customPrintSheetsToParse;
    }

    private CardEdition(CardInSet[] cards, Map<String, Integer> tokens) {
        List<CardInSet> cardsList = Arrays.asList(cards);
        this.cardMap = ArrayListMultimap.create();
        this.cardMap.replaceValues((Object)"cards", cardsList);
        this.cardsInSet = new ArrayList<CardInSet>(cardsList);
        Collections.sort(this.cardsInSet);
        this.tokenNormalized = tokens;
        this.customPrintSheetsToParse = new HashMap<String, List<String>>();
    }

    private CardEdition(String date, String code, String code2, Type type, String name, FoilType foil, CardInSet[] cards) {
        this(cards, new HashMap<String, Integer>());
        this.code = code;
        this.code2 = code2;
        this.type = type;
        this.name = name;
        this.date = CardEdition.parseDate(date);
        this.foilType = foil;
    }

    private static Date parseDate(String date) {
        if (date.length() <= 7) {
            date = date + "-01";
        }
        try {
            return formatter.parse(date);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public Date getDate() {
        return this.date;
    }

    public String getCode() {
        return this.code;
    }

    public String getCode2() {
        return this.code2;
    }

    public String getScryfallCode() {
        return this.scryfallCode.toLowerCase();
    }

    public String getCardsLangCode() {
        return this.cardsLanguage.toLowerCase();
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public int getBoosterBoxCount() {
        return this.boosterBoxCount;
    }

    public int getFatPackCount() {
        return this.fatPackCount;
    }

    public String getFatPackExtraSlots() {
        return this.fatPackExtraSlots;
    }

    public FoilType getFoilType() {
        return this.foilType;
    }

    public double getFoilChanceInBooster() {
        return this.foilChanceInBooster;
    }

    public boolean getFoilAlwaysInCommonSlot() {
        return this.foilAlwaysInCommonSlot;
    }

    public double getChanceReplaceCommonWith() {
        return this.chanceReplaceCommonWith;
    }

    public String getSlotReplaceCommonWith() {
        return this.slotReplaceCommonWith;
    }

    public String getAdditionalSheetForFoils() {
        return this.additionalSheetForFoils;
    }

    public String getAdditionalUnlockSet() {
        return this.additionalUnlockSet;
    }

    public boolean getSmallSetOverride() {
        return this.smallSetOverride;
    }

    public String getDoublePickDuringDraft() {
        return this.doublePickDuringDraft;
    }

    public String getBoosterMustContain() {
        return this.boosterMustContain;
    }

    public String getBoosterReplaceSlotFromPrintSheet() {
        return this.boosterReplaceSlotFromPrintSheet;
    }

    public String getSheetReplaceCardFromSheet() {
        return this.sheetReplaceCardFromSheet;
    }

    public String getSheetReplaceCardFromSheet2() {
        return this.sheetReplaceCardFromSheet2;
    }

    public String[] getChaosDraftThemes() {
        return this.chaosDraftThemes;
    }

    public List<CardInSet> getCards() {
        return this.cardMap.get((Object)EditionSectionWithCollectorNumbers.CARDS.getName());
    }

    public List<CardInSet> getRebalancedCards() {
        return this.cardMap.get((Object)EditionSectionWithCollectorNumbers.REBALANCED.getName());
    }

    public List<CardInSet> getFunnyEternalCards() {
        return this.cardMap.get((Object)EditionSectionWithCollectorNumbers.ETERNAL.getName());
    }

    public List<CardInSet> getAllCardsInSet() {
        return this.cardsInSet;
    }

    public List<CardInSet> getCardInSet(String cardName) {
        if (this.cardsInSetLookupMap == null) {
            this.cardsInSetLookupMap = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), CollectionSuppliers.arrayLists());
            List<CardInSet> cardsInSet = this.getAllCardsInSet();
            for (CardInSet cis : cardsInSet) {
                String key = cis.name;
                this.cardsInSetLookupMap.put(key, cis);
            }
        }
        return this.cardsInSetLookupMap.get((Object)cardName);
    }

    public boolean isRebalanced(String cardName) {
        for (CardInSet cis : this.getRebalancedCards()) {
            if (!cis.name.equals(cardName)) continue;
            return true;
        }
        return false;
    }

    public boolean isModern() {
        return this.getDate().after(CardEdition.parseDate("2003-07-27"));
    }

    public Map<String, Integer> getTokens() {
        return this.tokenNormalized;
    }

    @Override
    public int compareTo(CardEdition o) {
        if (o == null) {
            return 1;
        }
        int dateComp = this.date.compareTo(o.date);
        if (0 != dateComp) {
            return dateComp;
        }
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.code.hashCode() * 17 + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CardEdition other = (CardEdition)obj;
        return other.name.equals(this.name) && this.code.equals(other.code);
    }

    public String toString() {
        return this.name + " (" + this.code + ")";
    }

    public BorderColor getBorderColor() {
        return this.borderColor;
    }

    public boolean isLargeSet() {
        return this.cardsInSet.size() > 200 && !this.smallSetOverride;
    }

    public int getCntBoosterPictures() {
        return this.boosterArts;
    }

    public SealedTemplate getBoosterTemplate() {
        return this.getBoosterTemplate("Draft");
    }

    public SealedTemplate getBoosterTemplate(String boosterType) {
        return this.boosterTemplates.get(boosterType);
    }

    public String getRandomBoosterKind() {
        ArrayList<String> boosterTypes = Lists.newArrayList(this.boosterTemplates.keySet());
        if (boosterTypes.isEmpty()) {
            return null;
        }
        Collections.shuffle(boosterTypes);
        return (String)boosterTypes.get(0);
    }

    public Set<String> getAvailableBoosterTypes() {
        return this.boosterTemplates.keySet();
    }

    public boolean hasBoosterTemplate() {
        return this.boosterTemplates.containsKey("Draft");
    }

    public List<PrintSheet> getPrintSheetsBySection() {
        CardDb cardDb = StaticData.instance().getCommonCards();
        HashMap<String, Integer> cardToIndex = new HashMap<String, Integer>();
        ArrayList<PrintSheet> sheets = Lists.newArrayList();
        for (String sectionName : this.cardMap.keySet()) {
            PrintSheet sheet = new PrintSheet(String.format("%s %s", this.getCode(), sectionName));
            java.util.Collection cards = this.cardMap.get((Object)sectionName);
            for (CardInSet card : cards) {
                int index = 1;
                if (cardToIndex.containsKey(card.name)) {
                    index = (Integer)cardToIndex.get(card.name);
                }
                cardToIndex.put(card.name, index);
                PaperCard pCard = cardDb.getCard(card.name, this.getCode(), index);
                sheet.add(pCard);
            }
            sheets.add(sheet);
        }
        for (String sheetName : this.customPrintSheetsToParse.keySet()) {
            List<String> sheetToParse = this.customPrintSheetsToParse.get(sheetName);
            CardPool sheetPool = CardPool.fromCardList(sheetToParse);
            PrintSheet sheet = new PrintSheet(String.format("%s %s", this.getCode(), sheetName), sheetPool);
            sheets.add(sheet);
        }
        return sheets;
    }

    public static int getRandomFoil(String setCode) {
        FoilType foilType = FoilType.NOT_SUPPORTED;
        if (setCode != null && StaticData.instance().getEditions().get(setCode) != null) {
            foilType = StaticData.instance().getEditions().get(setCode).getFoilType();
        }
        if (foilType != FoilType.NOT_SUPPORTED) {
            return foilType == FoilType.MODERN ? MyRandom.getRandom().nextInt(9) + 1 : MyRandom.getRandom().nextInt(9) + 11;
        }
        return 0;
    }

    static /* synthetic */ String[] access$3302(CardEdition x0, String[] x1) {
        x0.chaosDraftThemes = x1;
        return x1;
    }

    public static class Predicates {
        public static final Predicate<CardEdition> CAN_MAKE_BOOSTER = new CanMakeBooster();
        public static final Predicate<CardEdition> HAS_TOURNAMENT_PACK = new CanMakeStarter();
        public static final Predicate<CardEdition> HAS_FAT_PACK = new CanMakeFatPack();
        public static final Predicate<CardEdition> HAS_BOOSTER_BOX = new CanMakeBoosterBox();
        public static final Predicate<CardEdition> hasBasicLands = ed -> {
            if (ed == null) {
                return false;
            }
            for (String landName : MagicColor.Constant.BASIC_LANDS) {
                if (null != StaticData.instance().getCommonCards().getCard(landName, ed.getCode(), 0)) continue;
                return false;
            }
            return true;
        };

        public static CardEdition getRandomSetWithAllBasicLands(Iterable<CardEdition> allEditions) {
            return Aggregates.random(Iterables.filter(allEditions, hasBasicLands));
        }

        public static CardEdition getPreferredArtEditionWithAllBasicLands() {
            CardDb.CardArtPreference artPreference = StaticData.instance().getCardArtPreference();
            Iterable<CardEdition> editionsWithBasicLands = Iterables.filter(StaticData.instance().getEditions().getOrderedEditions(), com.google.common.base.Predicates.and(hasBasicLands, artPreference::accept));
            Iterator<CardEdition> editionsIterator = editionsWithBasicLands.iterator();
            ArrayList<CardEdition> selectedEditions = new ArrayList<CardEdition>();
            while (editionsIterator.hasNext()) {
                selectedEditions.add(editionsIterator.next());
            }
            if (selectedEditions.isEmpty()) {
                return null;
            }
            int editionIndex = artPreference.latestFirst ? 0 : selectedEditions.size() - 1;
            return (CardEdition)selectedEditions.get(editionIndex);
        }

        private static class CanMakeBoosterBox
        implements Predicate<CardEdition> {
            private CanMakeBoosterBox() {
            }

            @Override
            public boolean apply(CardEdition subject) {
                return subject.getBoosterBoxCount() > 0;
            }
        }

        private static class CanMakeFatPack
        implements Predicate<CardEdition> {
            private CanMakeFatPack() {
            }

            @Override
            public boolean apply(CardEdition subject) {
                return subject.getFatPackCount() > 0;
            }
        }

        private static class CanMakeStarter
        implements Predicate<CardEdition> {
            private CanMakeStarter() {
            }

            @Override
            public boolean apply(CardEdition subject) {
                return StaticData.instance().getTournamentPacks().contains(subject.getCode());
            }
        }

        private static class CanMakeBooster
        implements Predicate<CardEdition> {
            private CanMakeBooster() {
            }

            @Override
            public boolean apply(CardEdition subject) {
                return subject.hasBoosterTemplate();
            }
        }
    }

    public static class Collection
    extends StorageBase<CardEdition> {
        private final Map<String, CardEdition> aliasToEdition = new TreeMap<String, CardEdition>(String.CASE_INSENSITIVE_ORDER);
        private boolean lock = false;
        public final Comparator<PaperCard> CARD_EDITION_COMPARATOR = Comparator.comparing(c -> this.get(c.getEdition()));

        public Collection(IItemReader<CardEdition> reader) {
            super("Card editions", reader);
            for (CardEdition ee : this) {
                this.initAliases(ee);
            }
        }

        private void initAliases(CardEdition E) {
            String alias = E.getAlias();
            if (null != alias) {
                this.aliasToEdition.put(alias, E);
            }
            this.aliasToEdition.put(E.getCode2(), E);
        }

        @Override
        public void add(CardEdition item) {
            if (this.lock) {
                throw new UnsupportedOperationException("This is a read-only storage");
            }
            this.map.put(item.getName(), item);
        }

        public void append(Collection C2) {
            if (this.lock) {
                throw new UnsupportedOperationException("This is a read-only storage");
            }
            for (CardEdition E : C2) {
                this.add(E);
                this.initAliases(E);
            }
            CardEdition customBucket = new CardEdition("2990-01-01", "USER", "USER", Type.CUSTOM_SET, "USER", FoilType.NOT_SUPPORTED, new CardInSet[0]);
            this.add(customBucket);
            this.initAliases(customBucket);
            this.lock = true;
        }

        @Override
        public CardEdition get(String code) {
            if (code == null) {
                return null;
            }
            CardEdition baseResult = (CardEdition)super.get(code);
            return baseResult == null ? this.aliasToEdition.get(code) : baseResult;
        }

        public Iterable<CardEdition> getOrderedEditions() {
            ArrayList<CardEdition> res = Lists.newArrayList(this);
            Collections.sort(res);
            Collections.reverse(res);
            return res;
        }

        public Iterable<CardEdition> getPrereleaseEditions() {
            ArrayList<CardEdition> res = Lists.newArrayList(this);
            return Iterables.filter(res, edition -> edition.getPrerelease() != null);
        }

        public CardEdition getEditionByCodeOrThrow(String code) {
            CardEdition set = this.get(code);
            if (null == set && code.equals("???")) {
                return UNKNOWN;
            }
            if (null == set) {
                throw new RuntimeException("Edition with code '" + code + "' not found");
            }
            return set;
        }

        public String getCode2ByCode(String code) {
            CardEdition set = this.get(code);
            return set == null ? "" : set.getCode2();
        }

        public IItemReader<SealedTemplate> getBoosterGenerator() {
            return new StorageReaderBase<SealedTemplate>(null){

                @Override
                public Map<String, SealedTemplate> readAll() {
                    TreeMap<String, SealedTemplate> map = new TreeMap<String, SealedTemplate>(String.CASE_INSENSITIVE_ORDER);
                    for (CardEdition ce : this) {
                        ArrayList<String> boosterTypes = Lists.newArrayList(ce.getAvailableBoosterTypes());
                        for (String type : boosterTypes) {
                            String setAffix = type.equals("Draft") ? "" : type;
                            map.put(ce.getCode() + setAffix, ce.getBoosterTemplate(type));
                        }
                    }
                    return map;
                }

                @Override
                public String getItemKey(SealedTemplate item) {
                    return item.getEdition();
                }

                @Override
                public String getFullPath() {
                    return null;
                }
            };
        }

        public CardEdition getTheLatestOfAllTheOriginalEditionsOfCardsIn(CardPool cards) {
            HashSet<String> minEditions = new HashSet<String>();
            CardDb db = StaticData.instance().getCommonCards();
            for (Map.Entry k : cards) {
                PaperCard cp = db.getCardFromEditions(((PaperCard)k.getKey()).getName(), CardDb.CardArtPreference.ORIGINAL_ART_CORE_EXPANSIONS_REPRINT_ONLY);
                if (cp == null) {
                    cp = (PaperCard)k.getKey();
                }
                minEditions.add(cp.getEdition());
            }
            for (CardEdition ed : this.getOrderedEditions()) {
                if (!minEditions.contains(ed.getCode())) continue;
                return ed;
            }
            return UNKNOWN;
        }
    }

    public static class Reader
    extends StorageReaderFolder<CardEdition> {
        private final boolean isCustomEditions;
        public static final FilenameFilter TXT_FILE_FILTER = (dir, name) -> name.endsWith(".txt");

        public Reader(File path) {
            super(path, CardEdition::getCode);
            this.isCustomEditions = false;
        }

        public Reader(File path, boolean isCustomEditions) {
            super(path, CardEdition::getCode);
            this.isCustomEditions = isCustomEditions;
        }

        @Override
        protected Map<String, CardEdition> createMap() {
            return new TreeMap<String, CardEdition>(String.CASE_INSENSITIVE_ORDER);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected CardEdition read(File file) {
            void var14_19;
            String[] boostertype;
            Map<String, List<String>> contents = FileSection.parseSections(FileUtil.readFile(file));
            Pattern pattern = Pattern.compile("(^(.?[0-9A-Z]+\\S?[A-Z]*)\\s)?(([SCURML])\\s)?([^@\\$]*)( @([^\\$]*))?( \\$(.+))?$");
            ArrayListMultimap<String, CardInSet> cardMap = ArrayListMultimap.create();
            ArrayList<BoosterSlot> boosterSlots = null;
            HashMap<String, Integer> tokenNormalized = new HashMap<String, Integer>();
            HashMap<String, List<String>> customPrintSheetsToParse = new HashMap<String, List<String>>();
            List<String> editionSectionsWithCollectorNumbers = EditionSectionWithCollectorNumbers.getNames();
            FileSection metadata = FileSection.parse((Iterable<String>)contents.get("metadata"), FileSection.EQUALS_KV_SEPARATOR);
            ArrayList<Object> boosterSlotsToParse = Lists.newArrayList();
            if (metadata.contains("BoosterSlots")) {
                boosterSlotsToParse = Lists.newArrayList(metadata.get("BoosterSlots").split(","));
                boosterSlots = Lists.newArrayList();
            }
            for (String sectionName : contents.keySet()) {
                if (reservedSectionNames.contains(sectionName)) continue;
                if (editionSectionsWithCollectorNumbers.contains(sectionName)) {
                    for (String string : contents.get(sectionName)) {
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.matches()) continue;
                        String collectorNumber = matcher.group(2);
                        CardRarity r = CardRarity.smartValueOf(matcher.group(4));
                        String cardName = matcher.group(5);
                        String artistName = matcher.group(7);
                        String functionalVariantName = matcher.group(9);
                        CardInSet cis = new CardInSet(cardName, collectorNumber, r, artistName, functionalVariantName);
                        cardMap.put(sectionName, cis);
                    }
                    continue;
                }
                if (boosterSlotsToParse.contains(sectionName)) {
                    boosterSlots.add(BoosterSlot.parseSlot(sectionName, contents.get(sectionName)));
                    continue;
                }
                customPrintSheetsToParse.put(sectionName, contents.get(sectionName));
            }
            if (contents.containsKey("tokens")) {
                for (String line : contents.get("tokens")) {
                    if (StringUtils.isBlank(line)) continue;
                    if (!tokenNormalized.containsKey(line)) {
                        tokenNormalized.put(line, 1);
                        continue;
                    }
                    tokenNormalized.put(line, (Integer)tokenNormalized.get(line) + 1);
                }
            }
            CardEdition res = new CardEdition(cardMap, tokenNormalized, customPrintSheetsToParse);
            res.boosterSlots = boosterSlots;
            res.name = metadata.get("name");
            res.date = CardEdition.parseDate(metadata.get("date"));
            res.code = metadata.get("code");
            res.code2 = metadata.get("code2");
            if (res.code2 == null) {
                res.code2 = res.code;
            }
            res.scryfallCode = metadata.get("ScryfallCode");
            if (res.scryfallCode == null) {
                res.scryfallCode = res.code;
            }
            res.cardsLanguage = metadata.get("CardLang");
            if (res.cardsLanguage == null) {
                res.cardsLanguage = "en";
            }
            res.boosterArts = metadata.getInt("BoosterCovers", 1);
            String boosterDesc = metadata.get("Booster");
            if (metadata.contains("Booster")) {
                if (res.boosterSlots != null) {
                    res.boosterTpl = new SealedTemplateWithSlots(res.code, SealedTemplate.Reader.parseSlots(boosterDesc), res.boosterSlots);
                } else {
                    res.boosterTpl = new SealedTemplate(res.code, SealedTemplate.Reader.parseSlots(boosterDesc));
                }
                res.boosterTemplates.put("Draft", res.boosterTpl);
            }
            for (String type : boostertype = new String[]{"Draft", "Collector", "Set"}) {
                String name = type + "Booster";
                if (!metadata.contains(name)) continue;
                res.boosterTemplates.put(type, new SealedTemplate(res.code, SealedTemplate.Reader.parseSlots(metadata.get(name))));
            }
            res.alias = metadata.get("alias");
            res.borderColor = BorderColor.valueOf(metadata.get("border", "Black").toUpperCase(Locale.ENGLISH));
            Type type = Type.UNKNOWN;
            if (this.isCustomEditions) {
                Type type2 = Type.CUSTOM_SET;
            } else {
                String type3 = metadata.get("type");
                if (null != type3 && !type3.isEmpty()) {
                    try {
                        Type type4 = Type.valueOf(type3.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException ignored) {
                        System.err.println("Ignoring unknown type in set definitions: name: " + res.name + "; type: " + type3);
                    }
                }
            }
            res.type = (Type)var14_19;
            res.prerelease = metadata.get("Prerelease", null);
            res.boosterBoxCount = Integer.parseInt(metadata.get("BoosterBox", var14_19.getBoosterBoxDefault()));
            res.fatPackCount = Integer.parseInt(metadata.get("FatPack", var14_19.getFatPackDefault()));
            res.fatPackExtraSlots = metadata.get("FatPackExtraSlots", "");
            switch (metadata.get("foil", "newstyle").toLowerCase()) {
                case "notsupported": {
                    res.foilType = FoilType.NOT_SUPPORTED;
                    break;
                }
                case "oldstyle": 
                case "classic": {
                    res.foilType = FoilType.OLD_STYLE;
                    break;
                }
                case "newstyle": 
                case "modern": {
                    res.foilType = FoilType.MODERN;
                    break;
                }
                default: {
                    res.foilType = FoilType.NOT_SUPPORTED;
                }
            }
            String[] replaceCommon = metadata.get("ChanceReplaceCommonWith", "0F Common").split(" ", 2);
            res.chanceReplaceCommonWith = Double.parseDouble(replaceCommon[0]);
            res.slotReplaceCommonWith = replaceCommon[1];
            res.foilChanceInBooster = metadata.getDouble("FoilChanceInBooster", 21.43f) / 100.0;
            res.foilAlwaysInCommonSlot = metadata.getBoolean("FoilAlwaysInCommonSlot", true);
            res.additionalSheetForFoils = metadata.get("AdditionalSheetForFoils", "");
            res.additionalUnlockSet = metadata.get("AdditionalSetUnlockedInQuest", "");
            res.smallSetOverride = metadata.getBoolean("TreatAsSmallSet", false);
            res.doublePickDuringDraft = metadata.get("DoublePick", "");
            res.boosterMustContain = metadata.get("BoosterMustContain", "");
            res.boosterReplaceSlotFromPrintSheet = metadata.get("BoosterReplaceSlotFromPrintSheet", "");
            res.sheetReplaceCardFromSheet = metadata.get("SheetReplaceCardFromSheet", "");
            res.sheetReplaceCardFromSheet2 = metadata.get("SheetReplaceCardFromSheet2", "");
            CardEdition.access$3302(res, metadata.get("ChaosDraftThemes", "").split(";"));
            return res;
        }

        @Override
        protected FilenameFilter getFileFilter() {
            return TXT_FILE_FILTER;
        }
    }

    public static class CardInSet
    implements Comparable<CardInSet> {
        public final CardRarity rarity;
        public final String collectorNumber;
        public final String name;
        public final String artistName;
        public final String functionalVariantName;
        private static final Map<String, String> sortableCollNumberLookup = new HashMap<String, String>();

        public CardInSet(String name, String collectorNumber, CardRarity rarity, String artistName, String functionalVariantName) {
            this.name = name;
            this.collectorNumber = collectorNumber;
            this.rarity = rarity;
            this.artistName = artistName;
            this.functionalVariantName = functionalVariantName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.collectorNumber != null) {
                sb.append(this.collectorNumber);
                sb.append(' ');
            }
            if (this.rarity != CardRarity.Unknown) {
                sb.append((Object)this.rarity);
                sb.append(' ');
            }
            sb.append(this.name);
            if (this.artistName != null) {
                sb.append(" @");
                sb.append(this.artistName);
            }
            if (this.functionalVariantName != null) {
                sb.append(" $");
                sb.append(this.functionalVariantName);
            }
            return sb.toString();
        }

        public static String getSortableCollectorNumber(String collectorNumber) {
            String sortableCollNr;
            String matchedCollNr;
            String inputCollNumber = collectorNumber;
            if (collectorNumber == null || collectorNumber.length() == 0) {
                inputCollNumber = "50000";
            }
            if ((matchedCollNr = (String)sortableCollNumberLookup.getOrDefault(inputCollNumber, null)) != null) {
                return matchedCollNr;
            }
            try {
                int collNr = Integer.parseInt(inputCollNumber);
                sortableCollNr = String.format("%05d", collNr);
            }
            catch (NumberFormatException ex) {
                int collNr;
                String nonNumSub = inputCollNumber.replaceAll("[0-9]", "");
                String onlyNumSub = inputCollNumber.replaceAll("[^0-9]", "");
                try {
                    collNr = Integer.parseInt(onlyNumSub);
                }
                catch (NumberFormatException exon) {
                    collNr = 0;
                }
                sortableCollNr = collNr > 0 && inputCollNumber.startsWith(onlyNumSub) ? String.format("%05d", collNr) + nonNumSub : nonNumSub + String.format("%05d", collNr);
            }
            sortableCollNumberLookup.put(inputCollNumber, sortableCollNr);
            return sortableCollNr;
        }

        @Override
        public int compareTo(CardInSet o) {
            String othrCollNr;
            int nameCmp = this.name.compareToIgnoreCase(o.name);
            if (0 != nameCmp) {
                return nameCmp;
            }
            String thisCollNr = CardInSet.getSortableCollectorNumber(this.collectorNumber);
            int collNrCmp = thisCollNr.compareTo(othrCollNr = CardInSet.getSortableCollectorNumber(o.collectorNumber));
            if (0 != collNrCmp) {
                return collNrCmp;
            }
            return this.rarity.compareTo(o.rarity);
        }
    }

    public static enum EditionSectionWithCollectorNumbers {
        CARDS("cards"),
        SPECIAL_SLOT("special slot"),
        PRECON_PRODUCT("precon product"),
        BORDERLESS("borderless"),
        BORDERLESS_PROFILE("borderless profile"),
        BORDERLESS_FRAME("borderless frame"),
        ETCHED("etched"),
        SHOWCASE("showcase"),
        FULL_ART("full art"),
        EXTENDED_ART("extended art"),
        ALTERNATE_ART("alternate art"),
        ALTERNATE_FRAME("alternate frame"),
        BUY_A_BOX("buy a box"),
        PROMO("promo"),
        BUNDLE("bundle"),
        BOX_TOPPER("box topper"),
        DUNGEONS("dungeons"),
        JUMPSTART("jumpstart"),
        REBALANCED("rebalanced"),
        ETERNAL("eternal");

        private final String name;

        private EditionSectionWithCollectorNumbers(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }

        public static List<String> getNames() {
            ArrayList<String> list = new ArrayList<String>();
            for (EditionSectionWithCollectorNumbers s2 : EditionSectionWithCollectorNumbers.values()) {
                String sName = s2.getName();
                list.add(sName);
            }
            return list;
        }
    }

    public static enum BorderColor {
        WHITE,
        BLACK,
        SILVER,
        GOLD;

    }

    public static enum FoilType {
        NOT_SUPPORTED,
        OLD_STYLE,
        MODERN;

    }

    public static enum Type {
        UNKNOWN,
        CORE,
        EXPANSION,
        STARTER,
        REPRINT,
        BOXED_SET,
        COLLECTOR_EDITION,
        DUEL_DECK,
        PROMO,
        ONLINE,
        DRAFT,
        COMMANDER,
        MULTIPLAYER,
        FUNNY,
        OTHER,
        CUSTOM_SET;


        public String getBoosterBoxDefault() {
            switch (this) {
                case CORE: 
                case EXPANSION: {
                    return "36";
                }
            }
            return "0";
        }

        public String getFatPackDefault() {
            switch (this) {
                case CORE: 
                case EXPANSION: {
                    return "10";
                }
            }
            return "0";
        }

        public String toString() {
            String[] names = TextUtil.splitWithParenthesis(this.name().toLowerCase(), '_');
            for (int i = 0; i < names.length; ++i) {
                names[i] = TextUtil.capitalize(names[i]);
            }
            return TextUtil.join(Arrays.asList(names), " ");
        }

        public static Type fromString(String label) {
            List<String> names = Arrays.asList(TextUtil.splitWithParenthesis(label.toUpperCase(), ' '));
            String value = TextUtil.join(names, "_");
            return Type.valueOf(value);
        }
    }
}

