/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import forge.ai.AiPlayDecision;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.ability.ChangeZoneAi;
import forge.ai.ability.LearnAi;
import forge.ai.simulation.GameSimulator;
import forge.ai.simulation.GameStateEvaluator;
import forge.ai.simulation.MultiTargetSelector;
import forge.ai.simulation.Plan;
import forge.ai.simulation.SimulationController;
import forge.ai.simulation.SpellAbilityChoicesIterator;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityCondition;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class SpellAbilityPicker {
    private Game game;
    private Player player;
    private GameStateEvaluator.Score bestScore;
    private boolean printOutput = false;
    private SpellAbilityChoicesIterator interceptor;
    private Plan plan;
    private int numSimulations;

    public SpellAbilityPicker(Game game, Player player) {
        this.game = game;
        this.player = player;
    }

    public void setInterceptor(SpellAbilityChoicesIterator in) {
        this.interceptor = in;
    }

    private void print(String str) {
        if (this.printOutput) {
            System.out.println(str);
        }
    }

    private void printPhaseInfo() {
        String phaseStr = this.game.getPhaseHandler().getPhase().toString();
        if (this.game.getPhaseHandler().getPlayerTurn() != this.player) {
            phaseStr = "opponent " + phaseStr;
        }
        this.print("---- choose ability  (phase = " + phaseStr + ")");
    }

    public List<SpellAbility> getCandidateSpellsAndAbilities() {
        CardCollection cards = ComputerUtilAbility.getAvailableCards(this.game, this.player);
        cards = ComputerUtilCard.dedupeCards(cards);
        List<SpellAbility> all = ComputerUtilAbility.getSpellAbilities(cards, this.player);
        List<SpellAbility> candidateSAs = ComputerUtilAbility.getOriginalAndAltCostAbilities(all, this.player);
        int writeIndex = 0;
        for (SpellAbility sa : candidateSAs) {
            if (sa.isManaAbility()) continue;
            sa.setActivatingPlayer(this.player, true);
            AiPlayDecision opinion = this.canPlayAndPayForSim(sa);
            if (opinion != AiPlayDecision.WillPlay) continue;
            candidateSAs.set(writeIndex, sa);
            ++writeIndex;
        }
        candidateSAs.subList(writeIndex, candidateSAs.size()).clear();
        return candidateSAs;
    }

    public SpellAbility chooseSpellAbilityToPlay(SimulationController controller) {
        if (!this.game.getStack().isEmpty() && this.game.getStack().peekAbility().getActivatingPlayer().equals(this.player)) {
            return null;
        }
        GameStateEvaluator.Score origGameScore = new GameStateEvaluator().getScoreForGameState(this.game, this.player);
        List<SpellAbility> candidateSAs = this.getCandidateSpellsAndAbilities();
        if (controller != null) {
            return this.chooseSpellAbilityToPlayImpl(controller, candidateSAs, origGameScore, null);
        }
        this.printPhaseInfo();
        SpellAbility sa = this.getPlannedSpellAbility(origGameScore, candidateSAs);
        if (sa != null) {
            return sa;
        }
        this.createNewPlan(origGameScore, candidateSAs);
        return this.getPlannedSpellAbility(origGameScore, candidateSAs);
    }

    private Plan formulatePlanWithPhase(GameStateEvaluator.Score origGameScore, List<SpellAbility> candidateSAs, PhaseType phase) {
        SimulationController controller = new SimulationController(origGameScore);
        SpellAbility sa = this.chooseSpellAbilityToPlayImpl(controller, candidateSAs, origGameScore, phase);
        if (sa != null) {
            return controller.getBestPlan();
        }
        return null;
    }

    private void printPlan(Plan plan, String intro) {
        if (plan == null) {
            this.print(intro + ": no plan!");
        }
        this.print(intro + " plan with score " + plan.getFinalScore() + ":");
        int i = 0;
        for (Plan.Decision d : plan.getDecisions()) {
            this.print(++i + ". " + d);
        }
    }

    private static boolean isSorcerySpeed(SpellAbility sa, Player player) {
        if (sa.isLandAbility()) {
            return true;
        }
        if (sa.isSpell()) {
            return !sa.withFlash(sa.getHostCard(), player);
        }
        if (sa.isPwAbility()) {
            return !sa.withFlash(sa.getHostCard(), player);
        }
        return sa.isActivatedAbility() && sa.getRestrictions().isSorcerySpeed();
    }

    private void createNewPlan(GameStateEvaluator.Score origGameScore, List<SpellAbility> candidateSAs) {
        this.plan = null;
        Plan bestPlan = this.formulatePlanWithPhase(origGameScore, candidateSAs, null);
        if (bestPlan == null) {
            this.print("No good plan at this time");
            return;
        }
        PhaseType currentPhase = this.game.getPhaseHandler().getPhase();
        if (currentPhase.isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            ArrayList<SpellAbility> candidateSAs2 = new ArrayList<SpellAbility>();
            for (SpellAbility sa : candidateSAs) {
                if (SpellAbilityPicker.isSorcerySpeed(sa, this.player)) continue;
                if (this.printOutput) {
                    System.err.println("Not sorcery: " + sa);
                }
                candidateSAs2.add(sa);
            }
            if (!candidateSAs2.isEmpty()) {
                Plan afterBlockersPlan;
                if (this.printOutput) {
                    System.err.println("Formula plan with phase bloom");
                }
                if ((afterBlockersPlan = this.formulatePlanWithPhase(origGameScore, candidateSAs2, PhaseType.COMBAT_DECLARE_BLOCKERS)) != null && afterBlockersPlan.getFinalScore().value >= bestPlan.getFinalScore().value) {
                    this.printPlan(afterBlockersPlan, "After blockers");
                    this.print("Deciding to wait until after declare blockers.");
                    return;
                }
            }
        }
        this.printPlan(bestPlan, "Current phase (" + (Object)((Object)currentPhase) + ")");
        this.plan = bestPlan;
    }

    private SpellAbility chooseSpellAbilityToPlayImpl(SimulationController controller, List<SpellAbility> candidateSAs, GameStateEvaluator.Score origGameScore, PhaseType phase) {
        long startTime = System.currentTimeMillis();
        SpellAbility bestSa = null;
        GameStateEvaluator.Score bestSaValue = origGameScore;
        this.print("Evaluating... (orig score = " + origGameScore + ")");
        for (int i = 0; i < candidateSAs.size(); ++i) {
            GameStateEvaluator.Score value = this.evaluateSa(controller, phase, candidateSAs, i);
            if (value.value <= bestSaValue.value) continue;
            bestSaValue = value;
            bestSa = candidateSAs.get(i);
        }
        if (bestSa != null && bestSaValue.summonSickValue <= origGameScore.summonSickValue) {
            bestSa = null;
        }
        long execTime = System.currentTimeMillis() - startTime;
        this.print("BEST: " + SpellAbilityPicker.abilityToString(bestSa) + " SCORE: " + bestSaValue.summonSickValue + " TIME: " + execTime);
        this.bestScore = bestSaValue;
        return bestSa;
    }

    public boolean hasActivePlan() {
        return this.plan != null && this.plan.hasNextDecision();
    }

    public Plan getPlan() {
        return this.plan;
    }

    private void printPlannedActionFailure(Plan.Decision decision, String cause) {
        this.print("Failed to continue planned action (" + decision.saRef + "). Cause:");
        this.print("  " + cause + "!");
        this.plan = null;
    }

    private SpellAbility getPlannedSpellAbility(GameStateEvaluator.Score origGameScore, List<SpellAbility> availableSAs) {
        MultiTargetSelector selector;
        if (!this.hasActivePlan()) {
            this.plan = null;
            return null;
        }
        PhaseType startPhase = this.plan.getStartPhase();
        if (startPhase != null && this.game.getPhaseHandler().getPhase().isBefore(startPhase)) {
            this.print("Waiting until phase " + (Object)((Object)startPhase) + " to proceed with the plan.");
            return null;
        }
        Plan.Decision decision = this.plan.selectNextDecision();
        if (!decision.initialScore.equals(origGameScore)) {
            this.printPlannedActionFailure(decision, "Unexpected game score (" + decision.initialScore + " vs. expected " + origGameScore + ")");
            return null;
        }
        SpellAbility sa = decision.saRef.findReferencedAbility(availableSAs);
        if (sa == null) {
            this.printPlannedActionFailure(decision, "Couldn't find spell/ability!");
            return null;
        }
        if (decision.modes == null && decision.targets != null && !(selector = new MultiTargetSelector(sa, null)).selectTargets(decision.targets)) {
            this.printPlannedActionFailure(decision, "Bad targets");
            return null;
        }
        if (decision.xMana != null) {
            sa.setXManaCostPaid(decision.xMana);
        }
        this.print("Planned decision " + this.plan.getNextDecisionIndex() + ": " + decision);
        return sa;
    }

    public GameStateEvaluator.Score getScoreForChosenAbility() {
        return this.bestScore;
    }

    public static String abilityToString(SpellAbility sa) {
        return SpellAbilityPicker.abilityToString(sa, true);
    }

    public static String abilityToString(SpellAbility sa, boolean withTargets) {
        StringBuilder saString = new StringBuilder("N/A");
        if (sa != null) {
            saString = new StringBuilder(sa.toString());
            String cardName = sa.getHostCard().getName();
            if (!cardName.isEmpty()) {
                saString = new StringBuilder(TextUtil.fastReplace(saString.toString(), cardName, "<$>"));
            }
            if (saString.length() > 40) {
                saString = new StringBuilder(saString.substring(0, 40) + "...");
            }
            if (withTargets) {
                SpellAbility saOrSubSa = sa;
                do {
                    if (!saOrSubSa.usesTargeting()) continue;
                    saString.append(" (targets: ").append(saOrSubSa.getTargets()).append(")");
                } while ((saOrSubSa = saOrSubSa.getSubAbility()) != null);
            }
            saString.insert(0, sa.getHostCard() + " -> ");
        }
        return saString.toString();
    }

    private boolean shouldWaitForLater(SpellAbility sa) {
        boolean isEarlyPhase;
        PhaseType phase = this.game.getPhaseHandler().getPhase();
        boolean bl = isEarlyPhase = phase == PhaseType.UNTAP || phase == PhaseType.UPKEEP || phase == PhaseType.DRAW;
        if (isEarlyPhase) {
            SpellAbilityCondition conditions = sa.getConditions();
            if (conditions == null) {
                return true;
            }
            Set<PhaseType> phases = conditions.getPhases();
            return phases.isEmpty() || phases.contains((Object)PhaseType.MAIN1);
        }
        return false;
    }

    private boolean atLeastOneConditionMet(SpellAbility saOrSubSa) {
        do {
            SpellAbilityCondition conditions;
            if ((conditions = saOrSubSa.getConditions()) != null && !conditions.areMet(saOrSubSa)) continue;
            return true;
        } while ((saOrSubSa = saOrSubSa.getSubAbility()) != null);
        return false;
    }

    private AiPlayDecision canPlayAndPayForSim(SpellAbility sa) {
        if (!sa.checkRestrictions(sa.getHostCard(), this.player)) {
            return AiPlayDecision.CantPlaySa;
        }
        if (sa.isLandAbility()) {
            return AiPlayDecision.WillPlay;
        }
        if (!sa.isLegalAfterStack()) {
            return AiPlayDecision.CantPlaySa;
        }
        if (!sa.canPlay()) {
            return AiPlayDecision.CantPlaySa;
        }
        if (!this.atLeastOneConditionMet(sa)) {
            return AiPlayDecision.CantPlaySa;
        }
        if (!ComputerUtilCost.canPayCost(sa, this.player, sa.isTrigger())) {
            return AiPlayDecision.CantAfford;
        }
        if (!ComputerUtilAbility.isFullyTargetable(sa)) {
            return AiPlayDecision.TargetingFailed;
        }
        if (this.shouldWaitForLater(sa)) {
            return AiPlayDecision.AnotherTime;
        }
        return AiPlayDecision.WillPlay;
    }

    public GameStateEvaluator.Score evaluateSa(SimulationController controller, PhaseType phase, List<SpellAbility> saList, int saIndex) {
        GameStateEvaluator.Score lastScore;
        controller.evaluateSpellAbility(saList, saIndex);
        SpellAbility sa = saList.get(saIndex);
        Random origRandom = MyRandom.getRandom();
        long randomSeedToUse = origRandom.nextLong();
        GameStateEvaluator.Score bestScore = new GameStateEvaluator.Score(Integer.MIN_VALUE);
        SpellAbilityChoicesIterator choicesIterator = new SpellAbilityChoicesIterator(controller);
        do {
            MyRandom.setRandom(new Random(randomSeedToUse));
            GameSimulator simulator = new GameSimulator(controller, this.game, this.player, phase);
            simulator.setInterceptor(choicesIterator);
            lastScore = simulator.simulateSpellAbility(sa);
            ++this.numSimulations;
            if (lastScore.value <= bestScore.value) continue;
            bestScore = lastScore;
        } while (choicesIterator.advance(lastScore));
        controller.doneEvaluating(bestScore);
        MyRandom.setRandom(origRandom);
        return bestScore;
    }

    public List<AbilitySub> chooseModeForAbility(SpellAbility sa, List<AbilitySub> choices, int min2, int num, boolean allowRepeat) {
        if (this.interceptor != null) {
            return this.interceptor.chooseModesForAbility(sa, choices, min2, num, allowRepeat);
        }
        if (this.plan != null && this.plan.getSelectedDecision() != null && this.plan.getSelectedDecision().modes != null) {
            MultiTargetSelector selector;
            Plan.Decision decision = this.plan.getSelectedDecision();
            List<AbilitySub> plannedModes = SpellAbilityChoicesIterator.getModeCombination(choices, decision.modes);
            if (this.plan.getSelectedDecision().targets != null && !(selector = new MultiTargetSelector(sa, plannedModes)).selectTargets(decision.targets)) {
                this.printPlannedActionFailure(decision, "Bad targets for modes");
                return null;
            }
            return plannedModes;
        }
        return null;
    }

    private Card getPlannedChoice(CardCollection fetchList) {
        if (this.plan != null && this.plan.getSelectedDecision() != null) {
            String choice = this.plan.getSelectedDecisionNextChoice();
            for (Card c : fetchList) {
                if (!c.getName().equals(choice)) continue;
                this.print("  Planned choice: " + c);
                return c;
            }
            this.print("Failed to use planned choice (" + choice + "). Not found!");
        }
        return null;
    }

    public Card chooseCardToHiddenOriginChangeZone(ZoneType destination, List<ZoneType> origin, SpellAbility sa, CardCollection fetchList, Player player2, Player decider) {
        if (fetchList.size() >= 2) {
            if (this.interceptor != null) {
                return this.interceptor.chooseCard(fetchList);
            }
            Card card = this.getPlannedChoice(fetchList);
            if (card != null) {
                this.plan.advanceNextChoice();
                return card;
            }
        }
        if (sa.getApi() == ApiType.Learn) {
            return LearnAi.chooseCardToLearn(fetchList, decider, sa);
        }
        return ChangeZoneAi.chooseCardToHiddenOriginChangeZone(destination, origin, sa, fetchList, player2, decider);
    }

    public CardCollectionView chooseSacrificeType(String type, SpellAbility ability, boolean effect, int amount, CardCollectionView exclude) {
        if (amount == 1) {
            Card source = ability.getHostCard();
            CardCollection cardList = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), type.split(";"), source.getController(), source, (CardTraitBase)ability);
            if ((cardList = CardLists.filter((Iterable<Card>)cardList, CardPredicates.canBeSacrificedBy(ability, effect))).size() >= 2) {
                if (this.interceptor != null) {
                    return new CardCollection(this.interceptor.chooseCard(cardList));
                }
                Card card = this.getPlannedChoice(cardList);
                if (card != null) {
                    this.plan.advanceNextChoice();
                    return new CardCollection(card);
                }
            }
        }
        return ComputerUtil.chooseSacrificeType(this.player, type, ability, ability.getTargetCard(), effect, amount, exclude);
    }

    public int getNumSimulations() {
        return this.numSimulations;
    }
}

