/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCost;
import forge.ai.simulation.GameSimulator;
import forge.ai.simulation.GameStateEvaluator;
import forge.ai.simulation.MultiTargetSelector;
import forge.ai.simulation.SimulationController;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class SpellAbilityChoicesIterator {
    private final SimulationController controller;
    private Iterator<int[]> modeIterator;
    private int[] selectedModes;
    private GameStateEvaluator.Score bestScoreForMode = new GameStateEvaluator.Score(Integer.MIN_VALUE);
    private boolean advancedToNextMode;
    private ArrayList<GameStateEvaluator.Score> cachedTargetScores;
    private int nextTarget = 0;
    private GameStateEvaluator.Score bestScoreForTarget = new GameStateEvaluator.Score(Integer.MIN_VALUE);
    private boolean pushTarget = true;
    private final ArrayList<ChoicePoint> choicePoints = new ArrayList();
    private int incrementedCpIndex = 0;
    private int cpIndex = -1;
    private int evalDepth;
    private List<Integer> modesMap;

    public SpellAbilityChoicesIterator(SimulationController controller) {
        this.controller = controller;
    }

    public List<AbilitySub> chooseModesForAbility(SpellAbility sa, List<AbilitySub> choices, int min2, int num, boolean allowRepeat) {
        if (this.modeIterator == null) {
            this.modesMap = new ArrayList<Integer>();
            int origIndex = -1;
            for (AbilitySub sub : choices) {
                ++origIndex;
                if (!ComputerUtilAbility.isFullyTargetable(sub)) continue;
                this.modesMap.add(origIndex);
            }
            if (this.modesMap.isEmpty()) {
                return null;
            }
            this.modeIterator = !allowRepeat ? CombinatoricsUtils.combinationsIterator(this.modesMap.size(), num) : new AllowRepeatModesIterator(this.modesMap.size(), min2, num);
            this.selectedModes = this.remapModes(this.modeIterator.next());
            this.advancedToNextMode = true;
        }
        List<AbilitySub> result = SpellAbilityChoicesIterator.getModeCombination(choices, this.selectedModes);
        if (this.advancedToNextMode) {
            StringBuilder sb = new StringBuilder();
            for (AbilitySub sub : result) {
                if (sb.length() > 0) {
                    sb.append(" ");
                } else {
                    sb.append(sub.getHostCard().getName()).append(" -> ");
                }
                sb.append(sub);
            }
            this.controller.evaluateChosenModes(this.selectedModes, sb.toString());
            ++this.evalDepth;
            this.advancedToNextMode = false;
        }
        return result;
    }

    private int[] remapModes(int[] modes) {
        for (int i = 0; i < modes.length; ++i) {
            modes[i] = this.modesMap.get(modes[i]);
        }
        return modes;
    }

    public Card chooseCard(CardCollection fetchList) {
        ++this.cpIndex;
        if (this.cpIndex >= this.choicePoints.size()) {
            this.choicePoints.add(new ChoicePoint());
        }
        ChoicePoint cp = this.choicePoints.get(this.cpIndex);
        HashSet<String> uniqueCards = new HashSet<String>();
        for (Card card : fetchList) {
            if (!uniqueCards.add(card.getName()) || uniqueCards.size() != cp.nextChoice + 1) continue;
            cp.selectedChoice = card;
        }
        if (cp.selectedChoice == null) {
            throw new RuntimeException();
        }
        cp.numChoices = uniqueCards.size();
        if (this.cpIndex >= this.incrementedCpIndex) {
            this.controller.evaluateCardChoice(cp.selectedChoice);
            ++this.evalDepth;
        }
        return cp.selectedChoice;
    }

    public void chooseTargets(SpellAbility sa, GameSimulator simulator) {
        MultiTargetSelector selector = new MultiTargetSelector(sa, null);
        if (selector.hasPossibleTargets()) {
            if (this.cachedTargetScores == null) {
                this.cachedTargetScores = new ArrayList();
                this.nextTarget = -1;
                int i = 0;
                while (selector.selectNextTargets()) {
                    GameStateEvaluator.Score score = this.controller.shouldSkipTarget(sa, simulator);
                    this.cachedTargetScores.add(score);
                    if (score != null) {
                        this.controller.printState(score, sa, " - via estimate (skipped)", false);
                    } else if (this.nextTarget == -1) {
                        this.nextTarget = i;
                    }
                    ++i;
                }
                selector.reset();
                if (this.nextTarget == -1) {
                    this.nextTarget = 0;
                }
            }
            selector.selectTargetsByIndex(this.nextTarget);
            this.controller.setHostAndTarget(sa, simulator);
            if (this.pushTarget) {
                this.controller.evaluateTargetChoices(sa, selector.getLastSelectedTargets());
                ++this.evalDepth;
                this.pushTarget = false;
            }
        }
    }

    public boolean advance(GameStateEvaluator.Score lastScore) {
        this.cpIndex = -1;
        for (ChoicePoint cp : this.choicePoints) {
            if (lastScore.value <= cp.bestScoreForChoice.value) continue;
            cp.bestScoreForChoice = lastScore;
        }
        if (lastScore.value > this.bestScoreForTarget.value) {
            this.bestScoreForTarget = lastScore;
        }
        if (lastScore.value > this.bestScoreForMode.value) {
            this.bestScoreForMode = lastScore;
        }
        if (!this.choicePoints.isEmpty()) {
            int i;
            for (i = this.choicePoints.size() - 1; i >= 0; --i) {
                ChoicePoint cp;
                cp = this.choicePoints.get(i);
                if (cp.nextChoice + 1 >= cp.numChoices) continue;
                ++cp.nextChoice;
                this.incrementedCpIndex = i;
                for (int j = this.choicePoints.size() - 1; j >= i; --j) {
                    this.doneEvaluating(this.choicePoints.get((int)j).bestScoreForChoice);
                }
                this.choicePoints.subList(i + 1, this.choicePoints.size()).clear();
                return true;
            }
            for (i = this.choicePoints.size() - 1; i >= 0; --i) {
                this.doneEvaluating(this.choicePoints.get((int)i).bestScoreForChoice);
            }
            this.choicePoints.clear();
        }
        if (this.cachedTargetScores != null) {
            this.pushTarget = true;
            this.doneEvaluating(this.bestScoreForTarget);
            this.bestScoreForTarget = new GameStateEvaluator.Score(Integer.MIN_VALUE);
            while (this.nextTarget + 1 < this.cachedTargetScores.size()) {
                ++this.nextTarget;
                if (this.cachedTargetScores.get(this.nextTarget) != null) continue;
                return true;
            }
            this.nextTarget = -1;
            this.cachedTargetScores = null;
        }
        if (this.modeIterator != null) {
            this.doneEvaluating(this.bestScoreForMode);
            this.bestScoreForMode = new GameStateEvaluator.Score(Integer.MIN_VALUE);
            if (this.modeIterator.hasNext()) {
                this.selectedModes = this.remapModes(this.modeIterator.next());
                this.advancedToNextMode = true;
                return true;
            }
            this.modeIterator = null;
        }
        if (this.evalDepth != 0) {
            throw new RuntimeException("" + this.evalDepth);
        }
        return false;
    }

    private void doneEvaluating(GameStateEvaluator.Score bestScore) {
        this.controller.doneEvaluating(bestScore);
        --this.evalDepth;
    }

    public static List<AbilitySub> getModeCombination(List<AbilitySub> choices, int[] modeIndexes) {
        ArrayList<AbilitySub> modes = new ArrayList<AbilitySub>();
        for (int modeIndex : modeIndexes) {
            modes.add(choices.get(modeIndex));
        }
        return modes;
    }

    public void announceX(SpellAbility sa) {
        if (sa.costHasManaX()) {
            Integer x = ComputerUtilCost.getMaxXValue(sa, sa.getActivatingPlayer(), sa.isTrigger());
            sa.setXManaCostPaid(x);
            this.controller.getLastDecision().xMana = x;
        }
    }

    private static class AllowRepeatModesIterator
    implements Iterator<int[]> {
        private final int numChoices;
        private final int max;
        private int[] indexes;

        public AllowRepeatModesIterator(int numChoices, int min2, int max) {
            this.numChoices = numChoices;
            this.max = max;
            this.indexes = new int[min2];
        }

        @Override
        public boolean hasNext() {
            return this.indexes != null;
        }

        private int[] getNextIndexes() {
            for (int i = this.indexes.length - 1; i >= 0; --i) {
                if (this.indexes[i] >= this.numChoices - 1) continue;
                int[] nextIndexes = new int[this.indexes.length];
                System.arraycopy(this.indexes, 0, nextIndexes, 0, i);
                nextIndexes[i] = this.indexes[i] + 1;
                return nextIndexes;
            }
            if (this.indexes.length < this.max) {
                return new int[this.indexes.length + 1];
            }
            return null;
        }

        @Override
        public int[] next() {
            if (this.indexes == null) {
                throw new NoSuchElementException();
            }
            int[] result = this.indexes;
            this.indexes = this.getNextIndexes();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ChoicePoint {
        int numChoices = -1;
        int nextChoice = 0;
        Card selectedChoice;
        GameStateEvaluator.Score bestScoreForChoice = new GameStateEvaluator.Score(Integer.MIN_VALUE);

        private ChoicePoint() {
        }
    }
}

