/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import com.google.common.collect.ArrayListMultimap;
import forge.ai.ComputerUtilCard;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.combat.Combat;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PossibleTargetSelector {
    private final SpellAbility sa;
    private final SpellAbility targetingSa;
    private final int targetingSaIndex;
    private int maxTargets;
    private int nextTargetIndex;
    private final List<GameObject> validTargets = new ArrayList<GameObject>();

    public PossibleTargetSelector(SpellAbility sa, SpellAbility targetingSa, int targetingSaIndex) {
        this.sa = sa;
        this.targetingSa = targetingSa;
        this.targetingSaIndex = targetingSaIndex;
        this.reset();
    }

    public void reset() {
        this.nextTargetIndex = 0;
        this.validTargets.clear();
        this.generateValidTargets(this.sa.getHostCard().getController());
    }

    private void generateValidTargets(Player player) {
        if (this.targetingSa == null) {
            return;
        }
        this.sa.setActivatingPlayer(player, true);
        this.targetingSa.resetTargets();
        TargetRestrictions tgt = this.targetingSa.getTargetRestrictions();
        this.maxTargets = tgt.getMaxTargets(this.sa.getHostCard(), this.targetingSa);
        SimilarTargetSkipper skipper = new SimilarTargetSkipper();
        for (GameObject gameObject : tgt.getAllCandidates(this.targetingSa, true)) {
            if (this.maxTargets == 1 && skipper.shouldSkipTarget(gameObject)) continue;
            this.validTargets.add(gameObject);
        }
    }

    public boolean hasPossibleTargets() {
        return !this.validTargets.isEmpty();
    }

    private void selectTargetsByIndexImpl(int index) {
        int targetCount;
        this.targetingSa.resetTargets();
        while (this.targetingSa.getTargets().size() < this.maxTargets && index < this.validTargets.size()) {
            this.targetingSa.getTargets().add(this.validTargets.get(index++));
        }
        if (this.targetingSa.isDividedAsYouChoose() && (targetCount = this.targetingSa.getTargets().getTargetCards().size()) > 0) {
            String amountStr = this.targetingSa.getParam("CounterNum");
            int amount = AbilityUtils.calculateAmount(this.sa.getHostCard(), amountStr, this.targetingSa);
            int amountPerCard = amount / targetCount;
            int amountLeftOver = amount - amountPerCard * targetCount;
            for (GameObject target : this.targetingSa.getTargets()) {
                this.targetingSa.addDividedAllocation(target, amountPerCard + amountLeftOver);
                amountLeftOver = 0;
            }
        }
    }

    public Targets getLastSelectedTargets() {
        return new Targets(this.targetingSaIndex, this.validTargets.size(), this.nextTargetIndex - 1, this.targetingSa.getTargets().toString());
    }

    public boolean selectTargets(Targets targets) {
        if (targets.originalTargetCount != this.validTargets.size() || targets.targetingSaIndex != this.targetingSaIndex) {
            System.err.println("Expected: " + this.validTargets.size() + " " + this.targetingSaIndex + " got: " + targets.originalTargetCount + " " + targets.targetingSaIndex);
            return false;
        }
        this.selectTargetsByIndexImpl(targets.targetIndex);
        this.nextTargetIndex = targets.targetIndex + 1;
        return true;
    }

    public boolean selectNextTargets() {
        if (this.nextTargetIndex >= this.validTargets.size()) {
            return false;
        }
        this.selectTargetsByIndexImpl(this.nextTargetIndex);
        ++this.nextTargetIndex;
        return true;
    }

    private static class SimilarTargetSkipper {
        private final ArrayListMultimap<String, Card> validTargetsMap = ArrayListMultimap.create();
        private final HashMap<Card, String> cardTypeStrings = new HashMap();
        private HashMap<Card, Integer> creatureScores;

        private SimilarTargetSkipper() {
        }

        private int getCreatureScore(Card c) {
            if (this.creatureScores != null) {
                Integer score = this.creatureScores.get(c);
                if (score != null) {
                    return score;
                }
            } else {
                this.creatureScores = new HashMap();
            }
            int score = ComputerUtilCard.evaluateCreature(c);
            this.creatureScores.put(c, score);
            return score;
        }

        private String getTypeString(Card c) {
            String str = this.cardTypeStrings.get(c);
            if (str != null) {
                return str;
            }
            str = c.getType().toString();
            this.cardTypeStrings.put(c, str);
            return str;
        }

        public boolean shouldSkipTarget(GameObject o) {
            if (!(o instanceof Card)) {
                return false;
            }
            Card c = (Card)o;
            Combat combat = c.getGame().getCombat();
            for (Card existingTarget : this.validTargetsMap.get((Object)c.getName())) {
                if (c.getController() != c.getController() || c.getOwner() != existingTarget.getOwner() || c.getSpellAbilities().size() != existingTarget.getSpellAbilities().size() || !this.getTypeString(existingTarget).equals(this.getTypeString(c))) continue;
                if (c.isCreature()) {
                    if (!existingTarget.isCreature() || this.getCreatureScore(c) != this.getCreatureScore(existingTarget) || combat == null || combat.getDefenderByAttacker(c) != combat.getDefenderByAttacker(existingTarget) || combat.isBlocked(c) || combat.isBlocked(existingTarget) || combat.isBlocking(c) || !combat.isBlocking(existingTarget)) continue;
                    continue;
                }
                return true;
            }
            this.validTargetsMap.put((Object)c.getName(), (Object)c);
            return false;
        }
    }

    public static class Targets {
        final int targetingSaIndex;
        final int originalTargetCount;
        final int targetIndex;
        final String description;

        private Targets(int targetingSaIndex, int originalTargetCount, int targetIndex, String description) {
            this.targetingSaIndex = targetingSaIndex;
            this.originalTargetCount = originalTargetCount;
            this.targetIndex = targetIndex;
            this.description = description;
            if (targetIndex != -1 && (targetIndex < 0 || targetIndex >= originalTargetCount)) {
                throw new IllegalArgumentException("Invalid targetIndex=" + targetIndex);
            }
        }

        public String toString() {
            return this.description;
        }
    }
}

