/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import forge.LobbyPlayer;
import forge.ai.AIOption;
import forge.ai.LobbyPlayerAi;
import forge.ai.simulation.GameSimulator;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.GameRules;
import forge.game.GameSnapshot;
import forge.game.IEntityMap;
import forge.game.Match;
import forge.game.StaticEffect;
import forge.game.ability.effects.DetachedCardEffect;
import forge.game.card.Card;
import forge.game.card.CardCloneStates;
import forge.game.card.CardCopyService;
import forge.game.card.CounterType;
import forge.game.card.token.TokenInfo;
import forge.game.combat.Combat;
import forge.game.mana.Mana;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.RegisteredPlayer;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.PlayerZoneBattlefield;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GameCopier {
    private static final ZoneType[] ZONES = new ZoneType[]{ZoneType.Battlefield, ZoneType.Hand, ZoneType.Graveyard, ZoneType.Library, ZoneType.Exile, ZoneType.Stack, ZoneType.Command};
    private Game origGame;
    private BiMap<Player, Player> playerMap = HashBiMap.create();
    private BiMap<Card, Card> cardMap = HashBiMap.create();
    private CopiedGameObjectMap gameObjectMap;
    private GameSnapshot snapshot = null;
    private static PaperCard hidden_info_card = new PaperCard(CardRules.fromScript(Lists.newArrayList("Name:hidden", "Types:Artifact", "Oracle:")), "", CardRarity.Common);
    private static final boolean PRUNE_HIDDEN_INFO = false;
    private static final boolean USE_FROM_PAPER_CARD = true;

    public GameCopier(Game origGame) {
        this.origGame = origGame;
        if (origGame.EXPERIMENTAL_RESTORE_SNAPSHOT) {
            this.snapshot = new GameSnapshot(origGame);
        }
    }

    public Game getOriginalGame() {
        return this.origGame;
    }

    public Game getCopiedGame() {
        return this.gameObjectMap.getGame();
    }

    public Game makeCopy() {
        return this.makeCopy(null, null);
    }

    public Game makeCopy(PhaseType advanceToPhase, Player aiPlayer) {
        if (this.origGame.EXPERIMENTAL_RESTORE_SNAPSHOT) {
            return this.snapshot.makeCopy();
        }
        List<RegisteredPlayer> origPlayers = this.origGame.getMatch().getPlayers();
        ArrayList<RegisteredPlayer> newPlayers = new ArrayList<RegisteredPlayer>();
        for (RegisteredPlayer p : origPlayers) {
            newPlayers.add(this.clonePlayer(p));
        }
        GameRules currentRules = this.origGame.getRules();
        Match newMatch = new Match(currentRules, newPlayers, this.origGame.getView().getTitle());
        Game newGame = new Game(newPlayers, currentRules, newMatch);
        for (int i = 0; i < this.origGame.getPlayers().size(); ++i) {
            Player origPlayer = (Player)this.origGame.getPlayers().get(i);
            Player newPlayer = newGame.getPlayer(origPlayer.getId());
            newPlayer.setLife(origPlayer.getLife(), null);
            newPlayer.setLifeLostLastTurn(origPlayer.getLifeLostLastTurn());
            newPlayer.setLifeLostThisTurn(origPlayer.getLifeLostThisTurn());
            newPlayer.setLifeGainedThisTurn(origPlayer.getLifeGainedThisTurn());
            newPlayer.setCommitedCrimeThisTurn(origPlayer.getCommittedCrimeThisTurn());
            newPlayer.setLifeStartedThisTurnWith(origPlayer.getLifeStartedThisTurnWith());
            newPlayer.setDamageReceivedThisTurn(origPlayer.getDamageReceivedThisTurn());
            newPlayer.setActivateLoyaltyAbilityThisTurn(origPlayer.getActivateLoyaltyAbilityThisTurn());
            newPlayer.setLandsPlayedThisTurn(origPlayer.getLandsPlayedThisTurn());
            newPlayer.setCounters(Maps.newHashMap(origPlayer.getCounters()));
            newPlayer.setBlessing(origPlayer.hasBlessing());
            newPlayer.setRevolt(origPlayer.hasRevolt());
            newPlayer.setDescended(origPlayer.getDescended());
            newPlayer.setLibrarySearched(origPlayer.getLibrarySearched());
            newPlayer.setSpellsCastLastTurn(origPlayer.getSpellsCastLastTurn());
            for (int j = 0; j < origPlayer.getSpellsCastThisTurn(); ++j) {
                newPlayer.addSpellCastThisTurn();
            }
            newPlayer.setMaxHandSize(origPlayer.getMaxHandSize());
            newPlayer.setUnlimitedHandSize(origPlayer.isUnlimitedHandSize());
            for (Mana m4 : origPlayer.getManaPool()) {
                newPlayer.getManaPool().addMana(m4, false);
            }
            this.playerMap.put(origPlayer, newPlayer);
        }
        PhaseHandler origPhaseHandler = this.origGame.getPhaseHandler();
        Player newPlayerTurn = (Player)this.playerMap.get(origPhaseHandler.getPlayerTurn());
        newGame.getPhaseHandler().devModeSet(origPhaseHandler.getPhase(), newPlayerTurn, origPhaseHandler.getTurn());
        newGame.getTriggerHandler().suppressMode(TriggerType.ChangesZone);
        for (Player p : newGame.getPlayers()) {
            ((PlayerZoneBattlefield)p.getZone(ZoneType.Battlefield)).setTriggers(false);
        }
        this.copyGameState(newGame, aiPlayer);
        for (Player origPlayer : this.playerMap.keySet()) {
            Player newPlayer = (Player)this.playerMap.get(origPlayer);
            origPlayer.copyCommandersToSnapshot(newPlayer, this.gameObjectMap::map);
            ((PlayerZoneBattlefield)newPlayer.getZone(ZoneType.Battlefield)).setTriggers(true);
        }
        newGame.getTriggerHandler().clearSuppression(TriggerType.ChangesZone);
        for (Card c : newGame.getCardsInGame()) {
            Card origCard = (Card)this.reverseFind(c);
            if (origCard.hasRemembered()) {
                for (Object o : origCard.getRemembered()) {
                    if (o instanceof GameObject) {
                        if (o instanceof Card && ((Card)o).getZone() == null) continue;
                        c.addRemembered(this.find((GameObject)o));
                        continue;
                    }
                    System.err.println(c + " Remembered: " + o + "/" + o.getClass());
                    c.addRemembered(o);
                }
            }
            for (SpellAbility sa : c.getSpellAbilities()) {
                Player activatingPlayer = sa.getActivatingPlayer();
                if (activatingPlayer == null || activatingPlayer.getGame() == newGame) continue;
                sa.setActivatingPlayer(this.gameObjectMap.map(activatingPlayer), true);
            }
        }
        for (StaticEffect effect : this.origGame.getStaticEffects().getEffects()) {
            effect.removeMapped(this.gameObjectMap);
        }
        if (origPhaseHandler.getCombat() != null) {
            newGame.getPhaseHandler().setCombat(new Combat(origPhaseHandler.getCombat(), this.gameObjectMap));
        }
        newGame.getAction().checkStateEffects(true);
        newGame.getTriggerHandler().resetActiveTriggers();
        if (GameSimulator.COPY_STACK) {
            GameCopier.copyStack(this.origGame, newGame, this.gameObjectMap);
        }
        if (advanceToPhase != null) {
            newGame.getPhaseHandler().devAdvanceToPhase(advanceToPhase, () -> GameSimulator.resolveStack(newGame, aiPlayer.getWeakestOpponent()));
        }
        return newGame;
    }

    private static void copyStack(Game origGame, Game newGame, IEntityMap map) {
        for (SpellAbilityStackInstance origEntry : origGame.getStack()) {
            SpellAbility origSa = origEntry.getSpellAbility();
            Card origHostCard = origSa.getHostCard();
            Card newCard = map.map(origHostCard);
            SpellAbility newSa = null;
            if (origSa.isSpell()) {
                newSa = GameCopier.findSAInCard(origSa, newCard);
            }
            if (newSa == null) continue;
            newSa.setActivatingPlayer(map.map(origSa.getActivatingPlayer()), true);
            if (origSa.usesTargeting()) {
                for (GameObject o : origSa.getTargets()) {
                    newSa.getTargets().add(map.map(o));
                }
            }
            newGame.getStack().add(newSa);
        }
    }

    private RegisteredPlayer clonePlayer(RegisteredPlayer p) {
        RegisteredPlayer clone = new RegisteredPlayer(p.getDeck());
        LobbyPlayer lp = p.getPlayer();
        if (!(lp instanceof LobbyPlayerAi)) {
            lp = new LobbyPlayerAi(p.getPlayer().getName(), Sets.newHashSet(AIOption.USE_SIMULATION));
        }
        clone.setPlayer(lp);
        return clone;
    }

    private void copyGameState(Game newGame, Player aiPlayer) {
        newGame.EXPERIMENTAL_RESTORE_SNAPSHOT = this.origGame.EXPERIMENTAL_RESTORE_SNAPSHOT;
        newGame.setAge(this.origGame.getAge());
        if (this.origGame.getStartingPlayer() != null) {
            newGame.setStartingPlayer((Player)this.playerMap.get(this.origGame.getStartingPlayer()));
        }
        if (this.origGame.getMonarch() != null) {
            newGame.setMonarch((Player)this.playerMap.get(this.origGame.getMonarch()));
        }
        if (this.origGame.getMonarchBeginTurn() != null) {
            newGame.setMonarchBeginTurn((Player)this.playerMap.get(this.origGame.getMonarchBeginTurn()));
        }
        if (this.origGame.getHasInitiative() != null) {
            newGame.setHasInitiative((Player)this.playerMap.get(this.origGame.getHasInitiative()));
        }
        if (this.origGame.getDayTime() != null) {
            newGame.setDayTime(this.origGame.getDayTime());
        }
        for (ZoneType zone : ZONES) {
            for (Card card : this.origGame.getCardsIn(zone)) {
                this.addCard(newGame, zone, card, aiPlayer);
            }
        }
        this.gameObjectMap = new CopiedGameObjectMap(newGame);
        for (Card card : this.origGame.getCardsIn(ZoneType.Battlefield)) {
            Card otherCard = (Card)this.cardMap.get(card);
            otherCard.setGameTimestamp(card.getGameTimestamp());
            otherCard.setLayerTimestamp(card.getLayerTimestamp());
            otherCard.setSickness(card.hasSickness());
            otherCard.setState(card.getCurrentStateName(), false);
            if (card.isAttachedToEntity()) {
                GameEntity ge = this.gameObjectMap.map(card.getEntityAttachedTo());
                otherCard.setEntityAttachedTo(ge);
                ge.addAttachedCard(otherCard);
            }
            if (card.getCrewedByThisTurn() != null) {
                otherCard.setCrewedByThisTurn(card.getCrewedByThisTurn());
            }
            if (card.getCloneOrigin() != null) {
                otherCard.setCloneOrigin((Card)this.cardMap.get(card.getCloneOrigin()));
            }
            if (card.getHaunting() != null) {
                otherCard.setHaunting((Card)this.cardMap.get(card.getHaunting()));
            }
            if (card.getSaddledByThisTurn() != null) {
                otherCard.setSaddledByThisTurn(card.getSaddledByThisTurn());
            }
            if (card.getEffectSource() != null) {
                otherCard.setEffectSource((Card)this.cardMap.get(card.getEffectSource()));
            }
            if (card.isPaired()) {
                otherCard.setPairedWith((Card)this.cardMap.get(card.getPairedWith()));
            }
            if (card.getCopiedPermanent() == null) continue;
            otherCard.setCopiedPermanent(new CardCopyService(card.getCopiedPermanent()).copyCard(false));
        }
    }

    private Card createCardCopy(Game newGame, Player newOwner, Card c, Player aiPlayer) {
        if (c.isToken() && !c.isImmutable()) {
            Card result = new TokenInfo(c).makeOneToken(newOwner);
            new CardCopyService(c).copyCopiableCharacteristics(result, null, null);
            return result;
        }
        if (!c.isImmutable() && c.getPaperCard() != null) {
            Card newCard = Card.fromPaperCard(c.getPaperCard(), newOwner);
            newCard.setCommander(c.isCommander());
            return newCard;
        }
        Card newCard = c instanceof DetachedCardEffect ? new DetachedCardEffect((DetachedCardEffect)c, newGame, true) : new Card(newGame.nextCardId(), c.getPaperCard(), newGame);
        newCard.setOwner(newOwner);
        newCard.setName(c.getName());
        newCard.setCommander(c.isCommander());
        newCard.addType(c.getType());
        for (StaticAbility stAb : c.getStaticAbilities()) {
            newCard.addStaticAbility(stAb.copy(newCard, true));
        }
        for (SpellAbility sa : c.getSpellAbilities()) {
            SpellAbility saCopy = sa.copy(newCard, true);
            if (saCopy != null) {
                newCard.addSpellAbility(saCopy);
                continue;
            }
            System.err.println(sa.toString());
        }
        return newCard;
    }

    private void addCard(Game newGame, ZoneType zone, Card c, Player aiPlayer) {
        Player owner = (Player)this.playerMap.get(c.getOwner());
        Card newCard = this.createCardCopy(newGame, owner, c, aiPlayer);
        this.cardMap.put(c, newCard);
        Player zoneOwner = owner;
        if (zone == ZoneType.Battlefield) {
            zoneOwner = (Player)this.playerMap.get(c.getController());
            newCard.setController(zoneOwner, 0L);
            if (c.isBattle()) {
                newCard.setProtectingPlayer((Player)this.playerMap.get(c.getProtectingPlayer()));
            }
            newCard.setCameUnderControlSinceLastUpkeep(c.cameUnderControlSinceLastUpkeep());
            newCard.setPTTable(c.getSetPTTable());
            newCard.setPTCharacterDefiningTable(c.getSetPTCharacterDefiningTable());
            newCard.setPTBoost(c.getPTBoostTable());
            newCard.setDamage(c.getDamage());
            newCard.setDamageReceivedThisTurn(c.getDamageReceivedThisTurn());
            newCard.setChangedCardColors(c.getChangedCardColorsTable());
            newCard.setChangedCardColorsCharacterDefining(c.getChangedCardColorsCharacterDefiningTable());
            newCard.setChangedCardTypes(c.getChangedCardTypesTable());
            newCard.setChangedCardTypesCharacterDefining(c.getChangedCardTypesCharacterDefiningTable());
            newCard.setChangedCardKeywords(c.getChangedCardKeywords());
            newCard.setChangedCardNames(c.getChangedCardNames());
            for (Table.Cell<Long, Long, List<String>> cell : c.getHiddenExtrinsicKeywordsTable().cellSet()) {
                newCard.addHiddenExtrinsicKeywords(cell.getRowKey(), cell.getColumnKey(), (Iterable<String>)cell.getValue());
            }
            newCard.updateKeywordsCache(newCard.getCurrentState());
            if (c.isTapped()) {
                newCard.setTapped(true);
            }
            if (c.isFaceDown()) {
                newCard.turnFaceDown(true);
                if (c.isManifested()) {
                    newCard.setManifested(true);
                }
                if (c.isCloaked()) {
                    newCard.setCloaked(true);
                }
            }
            if (c.isMonstrous()) {
                newCard.setMonstrous(true);
            }
            if (c.isRenowned()) {
                newCard.setRenowned(true);
            }
            if (c.isSolved()) {
                newCard.setSolved(true);
            }
            if (c.isSaddled()) {
                newCard.setSaddled(true);
            }
            if (c.isSuspected()) {
                newCard.setSuspected(true);
            }
            if (c.isPlaneswalker()) {
                for (SpellAbility spellAbility : c.getAllSpellAbilities()) {
                    SpellAbility newSa;
                    int active = spellAbility.getActivationsThisTurn();
                    if (!spellAbility.isPwAbility() || active <= 0 || (newSa = GameCopier.findSAInCard(spellAbility, newCard)) == null) continue;
                    for (int i = 0; i < active; ++i) {
                        newCard.addAbilityActivated(newSa);
                    }
                }
            }
            newCard.setFlipped(c.isFlipped());
            for (Map.Entry entry : c.getCloneStates().entrySet()) {
                newCard.addCloneState(((CardCloneStates)entry.getValue()).copy(newCard, true), (Long)entry.getKey());
            }
            Map<CounterType, Integer> counters = c.getCounters();
            if (!counters.isEmpty()) {
                newCard.setCounters(Maps.newHashMap(counters));
            }
            if (c.hasChosenPlayer()) {
                newCard.setChosenPlayer((Player)this.playerMap.get(c.getChosenPlayer()));
            }
            if (c.hasChosenType()) {
                newCard.setChosenType(c.getChosenType());
            }
            if (c.hasChosenType2()) {
                newCard.setChosenType2(c.getChosenType2());
            }
            if (c.hasChosenColor()) {
                newCard.setChosenColors(Lists.newArrayList(c.getChosenColors()));
            }
            if (c.hasNamedCard()) {
                newCard.setNamedCards(Lists.newArrayList(c.getNamedCards()));
            }
            newCard.setSVars(c.getSVars());
            newCard.copyChangedSVarsFrom(c);
        }
        if (zone == ZoneType.Stack) {
            newGame.getStackZone().add(newCard);
        } else {
            zoneOwner.getZone(zone).add(newCard);
        }
    }

    private static SpellAbility findSAInCard(SpellAbility sa, Card c) {
        String saDesc = sa.getDescription();
        for (SpellAbility cardSa : c.getAllSpellAbilities()) {
            if (!saDesc.equals(cardSa.getDescription())) continue;
            return cardSa;
        }
        return null;
    }

    public GameObject find(GameObject o) {
        if (this.origGame.EXPERIMENTAL_RESTORE_SNAPSHOT) {
            return this.snapshot.find(o);
        }
        GameObject result = null;
        if (o instanceof Card) {
            result = (GameObject)this.cardMap.get(o);
            if (result != null) {
                return result;
            }
            System.out.println("Couldn't map " + o + "/" + System.identityHashCode(o));
        } else if (o instanceof Player && (result = (GameObject)this.playerMap.get(o)) != null) {
            return result;
        }
        if (o != null) {
            throw new RuntimeException("Couldn't map " + o + "/" + System.identityHashCode(o));
        }
        return result;
    }

    public GameObject reverseFind(GameObject o) {
        if (this.origGame.EXPERIMENTAL_RESTORE_SNAPSHOT) {
            return this.snapshot.reverseFind(o);
        }
        GameObject result = (GameObject)this.cardMap.inverse().get(o);
        if (result != null) {
            return result;
        }
        return (GameObject)this.playerMap.inverse().get(o);
    }

    private class CopiedGameObjectMap
    implements IEntityMap {
        private final Game copiedGame;

        public CopiedGameObjectMap(Game copiedGame) {
            this.copiedGame = copiedGame;
        }

        @Override
        public Game getGame() {
            return this.copiedGame;
        }

        @Override
        public GameObject map(GameObject o) {
            return GameCopier.this.find(o);
        }
    }
}

