/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.token.TokenInfo;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.CostPart;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TokenAi
extends SpellAbilityAi {
    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        Card source = sa.getHostCard();
        boolean pwMinus = false;
        boolean pwPlus = false;
        if (sa.isPwAbility()) {
            for (CostPart c : sa.getPayCosts().getCostParts()) {
                if (c instanceof CostRemoveCounter) {
                    pwMinus = true;
                    break;
                }
                if (!(c instanceof CostPutCounter) || c.convertAmount() <= 0) continue;
                pwPlus = true;
                break;
            }
        }
        String tokenAmount = sa.getParamOrDefault("TokenAmount", "1");
        Card actualToken = TokenAi.spawnToken(ai, sa);
        if (actualToken == null || actualToken.isCreature() && actualToken.getNetToughness() < 1) {
            AbilitySub sub = sa.getSubAbility();
            return pwPlus || sub != null && SpellApiToAi.Converter.get(sub.getApi()).chkAIDrawback(sub, ai);
        }
        String tokenPower = sa.getParamOrDefault("TokenPower", actualToken.getBasePowerString());
        String tokenToughness = sa.getParamOrDefault("TokenToughness", actualToken.getBaseToughnessString());
        if ("X".equals(tokenAmount) || "X".equals(tokenPower) || "X".equals(tokenToughness)) {
            int x = AbilityUtils.calculateAmount(sa.getHostCard(), tokenAmount, sa);
            if (source.getSVar("X").equals("Count$Converge")) {
                x = ComputerUtilMana.getConvergeCount(sa, ai);
            }
            if (sa.getSVar("X").equals("Count$xPaid")) {
                x = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                sa.getRootAbility().setXManaCostPaid(x);
            }
            if (x <= 0) {
                if ("RandomPT".equals(sa.getParam("AILogic"))) {
                    x = 1;
                } else {
                    return false;
                }
            }
        }
        if (this.canInterruptSacrifice(ai, sa, actualToken, tokenAmount)) {
            return true;
        }
        boolean haste = actualToken.hasKeyword(Keyword.HASTE);
        boolean oneShot = sa.getSubAbility() != null && sa.getSubAbility().getApi() == ApiType.DelayedTrigger;
        boolean isCreature = actualToken.isCreature();
        if (ph.getPhase().isBefore(PhaseType.MAIN2) && ph.isPlayerTurn(ai) && !haste && !sa.hasParam("ActivationPhases") && !ComputerUtil.castSpellInMain1(ai, sa)) {
            boolean buff = false;
            for (Card c : ai.getCardsIn(ZoneType.Battlefield)) {
                if (!isCreature || !"Creature".equals(c.getSVar("BuffedBy"))) continue;
                buff = true;
            }
            if (!buff && !pwMinus) {
                return false;
            }
        }
        if (!(!ph.isPlayerTurn(ai) && !ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) || sa.hasParam("ActivationPhases") || sa.hasParam("PlayerTurn") || TokenAi.isSorcerySpeed(sa, ai) || haste || pwMinus)) {
            return false;
        }
        return !ph.getPhase().isAfter(PhaseType.COMBAT_BEGIN) && ph.isPlayerTurn(ai) || !oneShot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        Player opp = ai.getWeakestOpponent();
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        Card actualToken = TokenAi.spawnToken(ai, sa);
        if (actualToken.getType().isLegendary() && ai.isCardInPlay(actualToken.getName())) {
            return false;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null) {
            sa.resetTargets();
            if (actualToken.getType().hasSubtype("Role")) {
                return this.tgtRoleAura(ai, sa, actualToken, false);
            }
            if (tgt.canOnlyTgtOpponent() || "Opponent".equals(sa.getParam("AITgts"))) {
                if (!sa.canTarget(opp)) return false;
                sa.getTargets().add(opp);
            } else if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            } else {
                CardCollection list = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
                CardCollection betterList = CardLists.filter((Iterable<Card>)list, c -> c.getLethalDamage() == 1);
                if (!betterList.isEmpty()) {
                    list = betterList;
                }
                if (!(betterList = CardLists.getNotKeyword((Iterable<Card>)list, Keyword.TRAMPLE)).isEmpty()) {
                    list = betterList;
                }
                if (list.isEmpty()) return false;
                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(list));
            }
        }
        double chance = 1.0;
        boolean alwaysFromPW = true;
        boolean alwaysOnOppAttack = true;
        if (ai.getController().isAI()) {
            AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
            chance = (double)aic.getIntProperty(AiProps.TOKEN_GENERATION_ABILITY_CHANCE) / 100.0;
            alwaysFromPW = aic.getBooleanProperty(AiProps.TOKEN_GENERATION_ALWAYS_IF_FROM_PLANESWALKER);
            alwaysOnOppAttack = aic.getBooleanProperty(AiProps.TOKEN_GENERATION_ALWAYS_IF_OPP_ATTACKS);
        }
        if (sa.isPwAbility() && alwaysFromPW) {
            return true;
        }
        if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_ATTACKERS) && game.getPhaseHandler().getPlayerTurn().isOpponentOf(ai) && game.getCombat() != null && !game.getCombat().getAttackers().isEmpty() && alwaysOnOppAttack) {
            Card attacker;
            Iterator iterator = game.getCombat().getAttackers().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!CombatUtil.canBlock(attacker = (Card)iterator.next(), actualToken));
            return true;
        }
        if (!((double)MyRandom.getRandom().nextFloat() <= chance)) return false;
        return true;
    }

    private boolean canInterruptSacrifice(Player ai, SpellAbility sa, Card token, String tokenAmount) {
        Game game = ai.getGame();
        if (game.getStack().isEmpty()) {
            return false;
        }
        SpellAbility topStack = game.getStack().peekAbility();
        if (topStack.getApi() != ApiType.Sacrifice) {
            return false;
        }
        int nTokens = AbilityUtils.calculateAmount(sa.getHostCard(), tokenAmount, sa);
        String valid = topStack.getParamOrDefault("SacValid", "Card.Self");
        String num = sa.getParamOrDefault("Amount", "1");
        int nToSac = AbilityUtils.calculateAmount(topStack.getHostCard(), num, topStack);
        CardCollection list = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), valid, ai.getWeakestOpponent(), topStack.getHostCard(), (CardTraitBase)sa);
        if (!(list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeSacrificedBy(topStack, true))).isEmpty() && nTokens > 0 && list.size() == nToSac) {
            ComputerUtilCard.sortByEvaluateCreature(list);
            list.add(token);
            list = CardLists.getValidCards((Iterable<Card>)list, valid, ai.getWeakestOpponent(), topStack.getHostCard(), (CardTraitBase)sa);
            list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeSacrificedBy(topStack, true));
            return ComputerUtilCard.evaluateCreature(token) < ComputerUtilCard.evaluateCreature((Card)list.get(false)) && list.contains(token);
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card actualToken = TokenAi.spawnToken(ai, sa);
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null) {
            sa.resetTargets();
            if (actualToken.getType().hasSubtype("Role")) {
                return this.tgtRoleAura(ai, sa, actualToken, mandatory);
            }
            if (tgt.canOnlyTgtOpponent()) {
                PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
                if (mandatory && targetableOpps.isEmpty()) {
                    return false;
                }
                Player opp = targetableOpps.min(PlayerPredicates.compareByLife());
                sa.getTargets().add(opp);
            } else {
                sa.getTargets().add(ai);
            }
        }
        String tokenPower = sa.getParamOrDefault("TokenPower", actualToken.getBasePowerString());
        String tokenToughness = sa.getParamOrDefault("TokenToughness", actualToken.getBaseToughnessString());
        String tokenAmount = sa.getParamOrDefault("TokenAmount", "1");
        Card source = sa.getHostCard();
        if ("X".equals(tokenAmount) || "X".equals(tokenPower) || "X".equals(tokenToughness)) {
            int x = AbilityUtils.calculateAmount(source, tokenAmount, sa);
            if (sa.getSVar("X").equals("Count$xPaid") && x == 0) {
                x = ComputerUtilCost.getMaxXValue(sa, ai, true);
                sa.setXManaCostPaid(x);
            }
            if (x <= 0 && !mandatory) {
                return false;
            }
        }
        if (mandatory) {
            return true;
        }
        if ("OnlyOnAlliedAttack".equals(sa.getParam("AILogic"))) {
            Combat combat = ai.getGame().getCombat();
            return combat != null && combat.getAttackingPlayer() != null && !combat.getAttackingPlayer().isOpponentOf(ai);
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    protected Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return (Player)ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return Iterables.getFirst(options, null);
    }

    @Override
    protected GameEntity chooseSingleAttackableEntity(Player ai, SpellAbility sa, Iterable<GameEntity> options, Map<String, Object> params) {
        if (params != null && params.containsKey("Attacker")) {
            return ComputerUtilCombat.addAttackerToCombat(sa, (Card)params.get("Attacker"), options);
        }
        return super.chooseSingleAttackableEntity(ai, sa, options, params);
    }

    public static Card spawnToken(Player ai, SpellAbility sa) {
        if (!sa.hasParam("TokenScript")) {
            throw new RuntimeException("Spell Ability has no TokenScript: " + sa);
        }
        Card result = TokenInfo.getProtoType(sa.getParam("TokenScript").split(",")[0], sa, ai);
        if (result == null) {
            throw new RuntimeException("don't find Token for TokenScript: " + sa.getParam("TokenScript"));
        }
        result.setLastKnownZone(ai.getZone(ZoneType.Battlefield));
        Game game = ai.getGame();
        ComputerUtilCard.applyStaticContPT(game, result, null);
        return result;
    }

    private boolean tgtRoleAura(Player ai, SpellAbility sa, Card tok, boolean mandatory) {
        boolean isCurse = "Curse".equals(sa.getParam("AILogic")) || tok.getFirstAttachSpell().getParamOrDefault("AILogic", "").equals("Curse");
        List<Card> tgts = CardUtil.getValidCardsToTarget(sa);
        CardCollection prefListSBA = CardLists.filter(tgts, c -> !Iterables.any(c.getAttachedCards(), att -> att.getController() == ai && att.getType().hasSubtype("Role")));
        CardCollection prefList = isCurse ? CardLists.filterControlledBy((Iterable<Card>)prefListSBA, ai.getOpponents()) : CardLists.filterControlledBy((Iterable<Card>)prefListSBA, ai.getYourTeam());
        if (prefList.isEmpty()) {
            if (mandatory) {
                if (sa.isTargetNumberValid()) {
                    return true;
                }
                if (!prefListSBA.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getWorstCreatureAI(prefListSBA));
                    return true;
                }
                if (!tgts.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getWorstCreatureAI(tgts));
                    return true;
                }
            }
        } else {
            sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(prefList));
            return true;
        }
        return false;
    }
}

