/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.CombatUtil;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public abstract class TapAiBase
extends SpellAbilityAi {
    private boolean tapTargetList(Player ai, SpellAbility sa, CardCollection tapList, boolean mandatory) {
        Card source = sa.getHostCard();
        tapList.removeAll(sa.getTargets().getTargetCards());
        if (tapList.isEmpty()) {
            return false;
        }
        while (sa.canAddMoreTarget()) {
            Card choice = null;
            if (tapList.isEmpty()) {
                if (!sa.isMinTargetChosen() || sa.isZeroTargets()) {
                    if (!mandatory) {
                        sa.resetTargets();
                    }
                    return false;
                }
                if (ComputerUtil.shouldCastLessThanMax(ai, source)) break;
                return false;
            }
            choice = ComputerUtilCard.getBestAI(tapList);
            if (choice == null) {
                if (!sa.isMinTargetChosen() || sa.isZeroTargets()) {
                    if (!mandatory) {
                        sa.resetTargets();
                    }
                    return false;
                }
                if (ComputerUtil.shouldCastLessThanMax(ai, source)) break;
                return false;
            }
            tapList.remove(choice);
            sa.getTargets().add(choice);
        }
        return true;
    }

    protected boolean tapPrefTargeting(Player ai, Card source, SpellAbility sa, boolean mandatory) {
        Game game = ai.getGame();
        CardCollection tapList = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
        tapList = CardLists.filter((Iterable<Card>)tapList, CardPredicates.Presets.CAN_TAP);
        if ((tapList = CardLists.filter((Iterable<Card>)tapList, c -> {
            if (c.isCreature()) {
                return true;
            }
            for (SpellAbility sa1 : c.getSpellAbilities()) {
                if (!sa1.isAbility() || !sa1.getPayCosts().hasTapCost()) continue;
                return true;
            }
            return false;
        })).isEmpty() && ComputerUtil.activateForCost(sa, ai)) {
            tapList = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
            tapList = CardLists.filter((Iterable<Card>)tapList, c -> {
                if (c.isCreature()) {
                    return true;
                }
                for (SpellAbility sa12 : c.getSpellAbilities()) {
                    if (!sa12.isAbility() || !sa12.getPayCosts().hasTapCost()) continue;
                    return true;
                }
                return false;
            });
        }
        if (!sa.isTrigger() || mandatory) {
            CardCollection toExclude = ComputerUtilAbility.getCardsTargetedWithApi(ai, tapList, sa, ApiType.Tap);
            tapList.removeAll(toExclude);
        }
        if (tapList.isEmpty()) {
            return false;
        }
        boolean goodTargets = false;
        while (sa.canAddMoreTarget()) {
            Card choice = null;
            if (tapList.isEmpty()) {
                if (!sa.isMinTargetChosen() || sa.isZeroTargets()) {
                    if (!mandatory) {
                        sa.resetTargets();
                    }
                    return false;
                }
                if (goodTargets || ComputerUtil.shouldCastLessThanMax(ai, source)) break;
                return false;
            }
            PhaseHandler phase = game.getPhaseHandler();
            Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
            Card primeTarget = ComputerUtil.getKilledByTargeting(sa, tapList);
            if (primeTarget != null) {
                choice = primeTarget;
                goodTargets = true;
            } else if (phase.isPlayerTurn(ai) && phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                CardCollection attackers;
                if (phase.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                    attackers = game.getCombat().getAttackers();
                } else {
                    attackers = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), c -> CombatUtil.canAttack(c, opp));
                    attackers.remove(source);
                }
                Predicate<Card> findBlockers = CardPredicates.possibleBlockerForAtLeastOne(attackers);
                CardCollection creatureList = CardLists.filter((Iterable<Card>)tapList, findBlockers);
                if (!attackers.isEmpty() && !creatureList.isEmpty()) {
                    choice = ComputerUtilCard.getBestCreatureAI(creatureList);
                } else if (sa.isTrigger() || ComputerUtil.castSpellInMain1(ai, sa)) {
                    choice = ComputerUtilCard.getMostExpensivePermanentAI(tapList);
                }
            } else if (phase.isPlayerTurn(opp) && phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                if (Iterables.any(tapList, CardPredicates.Presets.CREATURES)) {
                    CardCollection creatureList = CardLists.filter((Iterable<Card>)tapList, c -> c.isCreature() && CombatUtil.canAttack(c, opp));
                    choice = ComputerUtilCard.getBestCreatureAI(creatureList);
                } else {
                    choice = ComputerUtilCard.getMostExpensivePermanentAI(tapList);
                }
            } else {
                choice = ComputerUtilCard.getMostExpensivePermanentAI(tapList);
            }
            if (choice == null) {
                if (!sa.isMinTargetChosen() || sa.isZeroTargets()) {
                    if (!mandatory) {
                        sa.resetTargets();
                    }
                    return false;
                }
                if (ComputerUtil.shouldCastLessThanMax(ai, source)) break;
                return false;
            }
            tapList.remove(choice);
            sa.getTargets().add(choice);
        }
        return sa.getTargets().size() != 0;
    }

    protected boolean tapUnpreferredTargeting(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        CardCollection list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
        CardCollection tapList = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents());
        if (this.tapTargetList(ai, sa, tapList, mandatory)) {
            return true;
        }
        if (sa.isMinTargetChosen()) {
            return true;
        }
        String[] tappablePermanents = new String[]{"Enchantment", "Planeswalker"};
        tapList = CardLists.getValidCards((Iterable<Card>)list, tappablePermanents, source.getController(), source, (CardTraitBase)sa);
        if (this.tapTargetList(ai, sa, tapList, mandatory)) {
            return true;
        }
        tapList = CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.TAPPED);
        if (this.tapTargetList(ai, sa, tapList, mandatory)) {
            return true;
        }
        if (sa.isMinTargetChosen()) {
            return true;
        }
        tapList = list;
        return this.tapTargetList(ai, sa, tapList, mandatory);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
            CardCollection pDefined = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            return pDefined.isEmpty() || !((Card)pDefined.get(0)).isInPlay() || ((Card)pDefined.get(0)).isUntapped() && ((Card)pDefined.get(0)).getController() != ai;
        }
        sa.resetTargets();
        if (this.tapPrefTargeting(ai, source, sa, mandatory)) {
            return true;
        }
        if (mandatory) {
            return this.tapUnpreferredTargeting(ai, sa, mandatory);
        }
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        Card source = sa.getHostCard();
        boolean oppTargetsChoice = sa.hasParam("TargetingPlayer");
        if (oppTargetsChoice && sa.getActivatingPlayer().equals(ai) && !sa.isTrigger()) {
            Player targetingPlayer = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("TargetingPlayer"), sa).get(false);
            sa.setTargetingPlayer(targetingPlayer);
            sa.getTargets().clear();
            return targetingPlayer.getController().chooseTargetsFor(sa);
        }
        boolean randomReturn = true;
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!this.tapPrefTargeting(ai, source, sa, false)) {
                return false;
            }
        }
        return randomReturn;
    }
}

