/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiCardMemory;
import forge.ai.AiProps;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostPayLife;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Map;

public class SurveilAi
extends SpellAbilityAi {
    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            sa.getTargets().add(ai);
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.doTriggerAINoCost(ai, sa, false);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        if (sa.getPayCosts().hasTapCost() && (sa.getPayCosts().hasManaCost() || sa.getHostCard() != null && sa.getHostCard().isCreature()) && !SurveilAi.isSorcerySpeed(sa, ai)) {
            return ph.getNextTurn() == ai && ph.is(PhaseType.END_OF_TURN);
        }
        if (sa.getHostCard() != null && !sa.getHostCard().isPermanent() && !SurveilAi.isSorcerySpeed(sa, ai)) {
            return ph.getNextTurn() == ai && ph.is(PhaseType.END_OF_TURN);
        }
        if (ph.isPlayerTurn(ai)) {
            if (SurveilAi.isSorcerySpeed(sa, ai)) {
                return ph.is(PhaseType.MAIN1) || sa.isPwAbility();
            }
            return ph.is(PhaseType.UPKEEP);
        }
        return true;
    }

    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        Card source = sa.getHostCard();
        if ("Never".equals(aiLogic)) {
            return false;
        }
        if ("Once".equals(aiLogic)) {
            return !AiCardMemory.isRememberedCard(ai, source, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
        }
        return true;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        boolean randomReturn;
        if (ai.getCardsIn(ZoneType.Library).isEmpty()) {
            return false;
        }
        Cost cost = sa.getPayCosts();
        if (cost != null && cost.hasSpecificCostType(CostPayLife.class)) {
            int maxLife = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.SURVEIL_LIFEPERC_AFTER_PAYING_LIFE);
            if (!ComputerUtilCost.checkLifeCost(ai, cost, sa.getHostCard(), ai.getStartingLife() * maxLife / 100, sa)) {
                return false;
            }
        }
        double chance = 0.4;
        if (SurveilAi.isSorcerySpeed(sa, ai)) {
            chance = 0.667;
        }
        boolean bl = randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(chance, sa.getActivationsThisTurn() + 1);
        if (SurveilAi.playReusable(ai, sa)) {
            randomReturn = true;
        }
        if (randomReturn) {
            AiCardMemory.rememberCard(ai, sa.getHostCard(), AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
        }
        return randomReturn;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }
}

