/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.card.CardStateName;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardState;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.List;
import java.util.Map;

public class SetStateAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player aiPlayer, SpellAbility sa) {
        Card source = sa.getHostCard();
        String mode = sa.getParam("Mode");
        if ("TurnFaceUp".equals(mode) || "TurnFaceDown".equals(mode)) {
            return true;
        }
        if (!this.isSafeToTransformIntoLegendary(aiPlayer, source)) {
            return false;
        }
        if (sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, aiPlayer, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
        }
        return "Transform".equals(mode) || "Flip".equals(mode);
    }

    @Override
    protected boolean checkAiLogic(Player aiPlayer, SpellAbility sa, String aiLogic) {
        return super.checkAiLogic(aiPlayer, sa, aiLogic);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return !sa.getHostCard().isInAlternateState();
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        String mode = sa.getParam("Mode");
        Card source = sa.getHostCard();
        String logic = sa.getParamOrDefault("AILogic", "");
        if ("Transform".equals(mode)) {
            if (!sa.usesTargeting()) {
                if (!source.canTransform(sa)) {
                    return false;
                }
                return this.shouldTransformCard(source, ai, ph) || "Always".equals(logic);
            }
            sa.resetTargets();
            CardCollection list = CardLists.filter(CardUtil.getValidCardsToTarget(sa), CardPredicates.Presets.CREATURES, c -> c.canTransform(sa));
            if (list.isEmpty()) {
                return false;
            }
            for (Card c2 : list) {
                if (!this.shouldTransformCard(c2, ai, ph) && !"Always".equals(logic)) continue;
                sa.getTargets().add(c2);
                if (!sa.isMaxTargetChosen()) continue;
                break;
            }
            return sa.isMinTargetChosen();
        }
        if ("TurnFaceUp".equals(mode) || "TurnFaceDown".equals(mode)) {
            if (sa.usesTargeting()) {
                sa.resetTargets();
                List<Card> list = CardUtil.getValidCardsToTarget(sa);
                if (list.isEmpty()) {
                    return false;
                }
                for (Card c3 : list) {
                    if (!this.shouldTurnFace(c3, ai, ph, mode) && !"Always".equals(logic)) continue;
                    sa.getTargets().add(c3);
                    if (sa.canAddMoreTarget()) continue;
                    break;
                }
                return sa.isTargetNumberValid();
            }
            CardCollection list = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            if (list.isEmpty()) {
                return false;
            }
            return this.shouldTurnFace((Card)list.get(false), ai, ph, mode) || "Always".equals(logic);
        }
        return true;
    }

    private boolean shouldTransformCard(Card card, Player ai, PhaseHandler ph) {
        if (!card.hasAlternateState()) {
            System.err.println("Warning: SetState without ALTERNATE on " + card.getName() + ".");
            return false;
        }
        Card transformed = CardCopyService.getLKICopy(card);
        transformed.getCurrentState().copyFrom(card.getAlternateState(), true);
        transformed.updateStateForView();
        return this.compareCards(card, transformed, ai, ph);
    }

    private boolean shouldTurnFace(Card card, Player ai, PhaseHandler ph, String mode) {
        if (card.isFaceDown()) {
            if ("TurnFaceDown".equals(mode)) {
                return false;
            }
            if (card.getState(CardStateName.Original).hasIntrinsicKeyword("Hidden agenda") && card.isInZone(ZoneType.Command)) {
                String chosenName = card.getNamedCard();
                for (Card cast : ai.getGame().getStack().getSpellsCastThisTurn()) {
                    if (cast.getController() != ai || !cast.getName().equals(chosenName)) continue;
                    return true;
                }
                return false;
            }
            if (!card.getRules().getType().isPermanent() || !card.canBeTurnedFaceUp()) {
                return false;
            }
        } else {
            if ("TurnFaceUp".equals(mode)) {
                return false;
            }
            if (card.isTransformable() || card.isMeldable()) {
                return false;
            }
        }
        Card transformed = CardCopyService.getLKICopy(card);
        if (!card.isFaceDown()) {
            transformed.turnFaceDown(true);
        } else {
            transformed.forceTurnFaceUp();
        }
        transformed.updateStateForView();
        return this.compareCards(card, transformed, ai, ph);
    }

    private boolean compareCards(Card original, Card copy, Player ai, PhaseHandler ph) {
        int valueCard = ComputerUtilCard.evaluateCreature(original);
        int valueTransformed = ComputerUtilCard.evaluateCreature(copy);
        if (original.getController().isOpponentOf(ai)) {
            return copy.getNetToughness() < 1 || valueCard > valueTransformed;
        }
        if (copy.getNetToughness() < 1) {
            return false;
        }
        if (ph.isPlayerTurn(ai) && ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            boolean transformAttack = false;
            for (Player opp : ai.getOpponents()) {
                boolean attackTransformed;
                boolean attackCard = !ComputerUtilCard.canBeBlockedProfitably(opp, original, true);
                boolean bl = attackTransformed = !ComputerUtilCard.canBeBlockedProfitably(opp, copy, true);
                if (attackCard && attackTransformed) {
                    return valueCard <= valueTransformed;
                }
                if (!attackTransformed) continue;
                transformAttack = true;
            }
            if (transformAttack) {
                return true;
            }
        } else if (ph.isPlayerTurn(ai) && ph.getPhase().equals((Object)PhaseType.COMBAT_DECLARE_BLOCKERS) && ph.inCombat() && ph.getCombat().isUnblocked(original)) {
            return original.getNetPower() <= copy.getNetPower();
        }
        return valueCard <= valueTransformed;
    }

    private boolean isSafeToTransformIntoLegendary(Player aiPlayer, Card source) {
        if (!source.ignoreLegendRule()) {
            if (!source.hasAlternateState()) {
                System.err.println("Warning: SetState without ALTERNATE on " + source.getName() + ".");
                return false;
            }
            CardState other = source.getAlternateState();
            if (other != null && other.getType().isLegendary() && aiPlayer.isCardInPlay(other.getName())) {
                if (!other.getType().isCreature()) {
                    return false;
                }
                Card othercard = (Card)aiPlayer.getCardsIn(ZoneType.Battlefield, other.getName()).getFirst();
                if (othercard.getCounters(CounterEnumType.KI) >= source.getCounters(CounterEnumType.KI)) {
                    return ComputerUtilCard.isUselessCreature(aiPlayer, othercard);
                }
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return this.isSafeToTransformIntoLegendary(player, sa.getHostCard());
    }
}

