/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class SacrificeAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        return this.sacrificeTgtAI(ai, sa, false);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.sacrificeTgtAI(ai, sa, false);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        return this.sacrificeTgtAI(ai, sa, mandatory) || mandatory;
    }

    private boolean sacrificeTgtAI(Player ai, SpellAbility sa, boolean mandatory) {
        int amount;
        String num;
        Card source = sa.getHostCard();
        boolean destroy = sa.hasParam("Destroy");
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        String valid = sa.getParamOrDefault("SacValid", "Self");
        if (sa.usesTargeting()) {
            PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            if (targetableOpps.isEmpty()) {
                if (mandatory && sa.canTarget(ai)) {
                    sa.resetTargets();
                    sa.getTargets().add(ai);
                    return true;
                }
                return false;
            }
            Player opp = targetableOpps.max(PlayerPredicates.compareByLife());
            sa.resetTargets();
            sa.getTargets().add(opp);
            if (mandatory) {
                return true;
            }
            num = sa.getParamOrDefault("Amount", "1");
            amount = AbilityUtils.calculateAmount(source, num, sa);
            CardCollection list = CardLists.getValidCards((Iterable<Card>)opp.getCardsIn(ZoneType.Battlefield), valid, sa.getActivatingPlayer(), source, (CardTraitBase)sa);
            for (Card c : list) {
                if (!c.hasSVar("SacMe") || Integer.parseInt(c.getSVar("SacMe")) <= 3) continue;
                return false;
            }
            if (!destroy) {
                list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeSacrificedBy(sa, true));
            } else if (!CardLists.getKeyword((Iterable<Card>)list, Keyword.INDESTRUCTIBLE).isEmpty()) {
                return false;
            }
            if (list.isEmpty()) {
                return false;
            }
            if (num.equals("X") && sa.getSVar(num).equals("Count$xPaid")) {
                sa.setXManaCostPaid(Math.min(ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()), amount));
            }
            int half = amount / 2 + amount % 2;
            if (!sa.isTrigger() && list.size() < half) {
                return false;
            }
        }
        String defined = sa.getParamOrDefault("Defined", "You");
        String targeted = sa.getParamOrDefault("ValidTgts", "");
        if (!valid.equals("Self")) {
            if (defined.equals("Player") || targeted.equals("Player") || targeted.equals("Opponent") || (defined.equals("Player.Opponent") || defined.equals("Opponent")) && !sa.isTrigger()) {
                CardCollection humanList;
                num = sa.getParamOrDefault("Amount", "1");
                amount = AbilityUtils.calculateAmount(source, num, sa);
                if (num.equals("X") && sa.getSVar(num).equals("Count$xPaid")) {
                    amount = Math.min(ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()), amount);
                }
                return (humanList = CardLists.getValidCards((Iterable<Card>)ai.getStrongestOpponent().getCardsIn(ZoneType.Battlefield), valid, sa.getActivatingPlayer(), source, (CardTraitBase)sa)).size() >= amount;
            }
            if (defined.equals("You")) {
                CardCollection computerList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), valid, sa.getActivatingPlayer(), source, (CardTraitBase)sa);
                for (Card c : computerList) {
                    if ("Lethal".equals(aiLogic)) {
                        boolean isLethal = false;
                        for (Player opp : ai.getOpponents()) {
                            if (!opp.canLoseLife() || opp.cantLoseForZeroOrLessLife() || c.getNetPower() < opp.getLife()) continue;
                            isLethal = true;
                            break;
                        }
                        for (Card creature : ai.getOpponents().getCreaturesInPlay()) {
                            if (!creature.canBeDestroyed() || c.getNetPower() < creature.getNetToughness()) continue;
                            isLethal = true;
                            break;
                        }
                        return c.hasSVar("SacMe") || isLethal;
                    }
                    if (!c.hasSVar("SacMe") && ComputerUtilCard.evaluateCreature(c) > 135) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    public static boolean doSacOneEachLogic(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        sa.resetTargets();
        for (Player p : game.getPlayers()) {
            CardCollection targetable = CardLists.filter((Iterable<Card>)p.getCardsIn(ZoneType.Battlefield), CardPredicates.isTargetableBy(sa));
            if (targetable.isEmpty()) continue;
            CardCollection priorityTgts = new CardCollection();
            if (p.isOpponentOf(ai)) {
                priorityTgts.addAll(CardLists.filter((Iterable<Card>)targetable, CardPredicates.canBeSacrificedBy(sa, true)));
                if (!priorityTgts.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getBestAI(priorityTgts));
                    continue;
                }
                sa.getTargets().add(ComputerUtilCard.getBestAI(targetable));
                continue;
            }
            for (Card c : targetable) {
                if (!c.canBeSacrificedBy(sa, true) || !c.hasSVar("SacMe") && (!c.isCreature() || ComputerUtilCard.evaluateCreature(c) > 135) || c.equals(sa.getHostCard())) continue;
                priorityTgts.add(c);
            }
            if (!priorityTgts.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getWorstPermanentAI(priorityTgts, false, false, false, false));
                continue;
            }
            targetable.remove(sa.getHostCard());
            if (!targetable.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getWorstPermanentAI(targetable, true, true, true, false));
                continue;
            }
            sa.getTargets().add(sa.getHostCard());
        }
        return true;
    }
}

