/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.SpellAbilityAi;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.GameLossReason;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;

public class PoisonAi
extends SpellAbilityAi {
    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        return !ph.getPhase().isBefore(PhaseType.MAIN2) || sa.hasParam("ActivationPhases");
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (ComputerUtil.waitForBlocking(sa)) {
            return false;
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            return this.tgtPlayer(ai, sa, true);
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            return this.tgtPlayer(ai, sa, mandatory);
        }
        if (mandatory || !ai.canReceiveCounters(CounterType.get(CounterEnumType.POISON))) {
            return true;
        }
        PlayerCollection players = AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa);
        if (players.isEmpty()) {
            return false;
        }
        if (!players.contains(ai)) {
            return true;
        }
        Player max = players.max(PlayerPredicates.compareByPoison());
        return ai.getPoisonCounters() != max.getPoisonCounters();
    }

    private boolean tgtPlayer(Player ai, SpellAbility sa, boolean mandatory) {
        PlayerCollection tgts = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        if (!tgts.isEmpty()) {
            PlayerCollection betterTgts = tgts.filter(input -> {
                if (input.cantLoseCheck(GameLossReason.Poisoned)) {
                    return false;
                }
                return input.canReceiveCounters(CounterType.get(CounterEnumType.POISON));
            });
            if (!betterTgts.isEmpty()) {
                tgts = betterTgts;
            } else if (mandatory) {
                sa.getTargets().add((GameObject)tgts.getFirst());
                return true;
            }
        }
        if (tgts.isEmpty()) {
            if (mandatory) {
                if (ai.canBeTargetedBy(sa) && !ai.canReceiveCounters(CounterType.get(CounterEnumType.POISON))) {
                    sa.getTargets().add(ai);
                    return true;
                }
                PlayerCollection allies = ai.getAllies().filter(PlayerPredicates.isTargetableBy(sa));
                if (!allies.isEmpty()) {
                    PlayerCollection betterAllies = allies.filter(input -> {
                        if (input.cantLoseCheck(GameLossReason.Poisoned)) {
                            return true;
                        }
                        return !input.canReceiveCounters(CounterType.get(CounterEnumType.POISON));
                    });
                    if (!betterAllies.isEmpty()) {
                        allies = betterAllies;
                    }
                    Player min2 = allies.min(PlayerPredicates.compareByPoison());
                    sa.getTargets().add(min2);
                    return true;
                }
                if (ai.canBeTargetedBy(sa)) {
                    sa.getTargets().add(ai);
                    return true;
                }
            }
            return false;
        }
        Player max = tgts.max(PlayerPredicates.compareByPoison());
        sa.getTargets().add(max);
        return true;
    }
}

