/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiController;
import forge.ai.AiPlayDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.card.CardStateName;
import forge.card.CardTypeView;
import forge.game.Game;
import forge.game.GameType;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.SpellPermanent;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlayAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        String logic = sa.getParamOrDefault("AILogic", "");
        Game game = ai.getGame();
        Card source = sa.getHostCard();
        if (!game.getStack().isEmpty() && !"ReplaySpell".equals(logic)) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (game.getRules().hasAppliedVariant(GameType.MoJhoSto) && source.getName().equals("Jhoira of the Ghitu Avatar")) {
            AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
            int numLandsForJhoira = aic.getIntProperty(AiProps.MOJHOSTO_NUM_LANDS_TO_ACTIVATE_JHOIRA);
            int chanceToActivateInst = 100 - aic.getIntProperty(AiProps.MOJHOSTO_CHANCE_TO_USE_JHOIRA_COPY_INSTANT);
            if (ai.getLandsInPlay().size() < numLandsForJhoira) {
                return false;
            }
            return !"Instant".equals(sa.getParam("AnySupportedCard")) || !MyRandom.percentTrue(chanceToActivateInst);
        }
        CardCollection cards = PlayAi.getPlayableCards(sa, ai);
        if (cards.isEmpty()) {
            return false;
        }
        if ("ReplaySpell".equals(logic)) {
            return ComputerUtil.targetPlayableSpellCard(ai, cards, sa, sa.hasParam("WithoutManaCost"), false);
        }
        if (logic.startsWith("NeedsChosenCard")) {
            int minCMC = 0;
            if (sa.getPayCosts().getCostMana() != null) {
                minCMC = sa.getPayCosts().getTotalMana().getCMC();
            }
            return this.chooseSingleCard(ai, sa, cards = CardLists.filter(cards, CardPredicates.greaterCMC(minCMC)), sa.hasParam("Optional"), null, null) != null;
        }
        if ("WithTotalCMC".equals(logic)) {
            if (cards.size() < 3) {
                return false;
            }
            if (sa.costHasManaX()) {
                int amount = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                if (amount < ComputerUtilCard.getBestAI(cards).getCMC()) {
                    return false;
                }
                int totalCMC = 0;
                for (Card c : cards) {
                    totalCMC += c.getCMC();
                }
                if (amount > totalCMC) {
                    amount = totalCMC;
                }
                sa.setXManaCostPaid(amount);
            }
        }
        if (source != null && source.hasKeyword(Keyword.HIDEAWAY) && source.hasExiledCard()) {
            Card rem = (Card)source.getExiledCards().getFirst();
            CardTypeView t2 = rem.getState(CardStateName.Original).getType();
            return t2.isPermanent() && !t2.isLand();
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            if (!sa.hasParam("AILogic")) {
                return false;
            }
            if ("ReplaySpell".equals(sa.getParam("AILogic"))) {
                return ComputerUtil.targetPlayableSpellCard(ai, PlayAi.getPlayableCards(sa, ai), sa, sa.hasParam("WithoutManaCost"), mandatory);
            }
            return this.checkApiLogic(ai, sa);
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player ai, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CardStateName state;
        if (sa.hasParam("CastTransformed")) {
            state = CardStateName.Transformed;
            options.forEach(c -> c.changeToState(CardStateName.Transformed));
        } else {
            state = CardStateName.Original;
        }
        CardCollection tgtCards = CardLists.filter(options, c -> {
            for (SpellAbility s2 : AbilityUtils.getSpellsFromPlayEffect(c, ai, state, false)) {
                if (!sa.matchesValidParam("ValidSA", s2)) continue;
                if (s2.isLandAbility()) {
                    return true;
                }
                Spell spell = (Spell)s2;
                if (params != null && params.containsKey("CMCLimit")) {
                    Integer cmcLimit = (Integer)params.get("CMCLimit");
                    if (spell.getPayCosts().getTotalMana().getCMC() > cmcLimit) continue;
                }
                if (sa.hasParam("WithoutManaCost")) {
                    if (!(spell instanceof SpellPermanent) && spell.costHasManaX()) continue;
                    spell = (Spell)spell.copyWithNoManaCost();
                } else if (sa.hasParam("PlayCost")) {
                    Cost abCost = "ManaCost".equals(sa.getParam("PlayCost")) ? new Cost(c.getManaCost(), false) : new Cost(sa.getParam("PlayCost"), false);
                    spell = (Spell)spell.copyWithManaCostReplaced(spell.getActivatingPlayer(), abCost);
                }
                if (AiPlayDecision.WillPlay != ((PlayerControllerAi)ai.getController()).getAi().canPlayFromEffectAI(spell, !isOptional && !sa.hasParam("Optional"), true)) continue;
                return spell.isTargetNumberValid() && ComputerUtilCost.canPayCost(spell, ai, true);
            }
            return false;
        });
        if (sa.hasParam("CastTransformed")) {
            options.forEach(c -> c.changeToState(CardStateName.Original));
        }
        Card best = ComputerUtilCard.getBestAI(tgtCards);
        if (sa.usesTargeting() && !sa.isTargetNumberValid()) {
            sa.getTargets().add(best);
        }
        return best;
    }

    private static List<Card> getPlayableCards(SpellAbility sa, Player ai) {
        CardCollection cards = null;
        Card source = sa.getHostCard();
        if (sa.usesTargeting()) {
            cards = CardUtil.getValidCardsToTarget(sa);
        } else if (!sa.hasParam("Valid")) {
            cards = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
        }
        if (cards != null & sa.hasParam("ValidSA")) {
            String[] valid = sa.getParam("ValidSA").split(",");
            Iterator itr = cards.iterator();
            while (itr.hasNext()) {
                Card c = (Card)itr.next();
                if (Iterables.any(AbilityUtils.getBasicSpellsFromPlayEffect(c, ai), SpellAbilityPredicates.isValid(valid, ai, source, sa))) continue;
                itr.remove();
            }
        }
        if (sa.hasParam("ValidZone")) {
            cards = new CardCollection(AbilityUtils.filterListByType(ai.getGame().getCardsIn(ZoneType.listValueOf(sa.getParam("ValidZone"))), sa.getParam("Valid"), sa));
        }
        cards.remove(source);
        return cards;
    }
}

