/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilAbility;
import forge.ai.ability.PermanentAi;
import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class PermanentNoncreatureAi
extends PermanentAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (!super.checkApiLogic(ai, sa)) {
            return false;
        }
        Card host = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Game game = ai.getGame();
        if (host.hasSVar("OblivionRing")) {
            SpellAbility effectExile = AbilityFactory.getAbility(host.getSVar("TrigExile"), host);
            ZoneType origin = ZoneType.listValueOf(effectExile.getParamOrDefault("Origin", "Battlefield")).get(0);
            effectExile.setActivatingPlayer(ai, true);
            CardCollection targets = CardLists.getTargetableCards(game.getCardsIn(origin), effectExile);
            if (sourceName.equals("Suspension Field") || sourceName.equals("Detention Sphere")) {
                targets = CardLists.filterControlledBy((Iterable<Card>)targets, ai.getOpponents());
            }
            return !targets.isEmpty();
        }
        return true;
    }
}

