/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostSacrifice;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.util.collect.FCollection;

public class LifeLoseAi
extends SpellAbilityAi {
    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        PlayerCollection tgtPlayers = this.getPlayers(ai, sa);
        Card source = sa.getHostCard();
        String amountStr = sa.getParam("LifeAmount");
        int amount = 0;
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            SpellAbility root = sa.getRootAbility();
            if (root.getXManaCostPaid() != null) {
                amount = root.getXManaCostPaid();
            } else if (root.getPayCosts() != null && root.getPayCosts().hasXInAnyCostPart()) {
                int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                root.setXManaCostPaid(xPay);
                amount = xPay;
            }
        } else {
            amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        }
        if (tgtPlayers.contains(ai) && amount > 0 && amount + 3 > ai.getLife()) {
            return false;
        }
        if (sa.usesTargeting()) {
            return this.doTgt(ai, sa, false);
        }
        return true;
    }

    @Override
    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        String amountStr = sa.getParam("LifeAmount");
        int amount = 0;
        amount = amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid") ? ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()) : AbilityUtils.calculateAmount(source, amountStr, sa);
        if (!ComputerUtilCost.checkLifeCost(ai, cost, source, amount, sa)) {
            return false;
        }
        return super.willPayCosts(ai, sa, cost, source);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        String amountStr = sa.getParam("LifeAmount");
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        int amount = 0;
        if (sa.usesTargeting() && !this.doTgt(ai, sa, false)) {
            return false;
        }
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            amount = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(amount);
        } else {
            amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        }
        if (amount <= 0) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (ComputerUtil.playImmediately(ai, sa)) {
            return true;
        }
        PlayerCollection tgtPlayers = this.getPlayers(ai, sa);
        PlayerCollection filteredPlayer = tgtPlayers.filter(Predicates.and(PlayerPredicates.isOpponentOf(ai), PlayerPredicates.lifeLessOrEqualTo(amount)));
        if (!filteredPlayer.isEmpty()) {
            return true;
        }
        boolean isSacCost = false;
        if (sa.getPayCosts() != null && sa.getPayCosts().hasSpecificCostType(CostSacrifice.class)) {
            isSacCost = true;
        }
        if (!(!ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) || sa.hasParam("ActivationPhases") || ComputerUtil.castSpellInMain1(ai, sa) || aiLogic.contains("AnyPhase") || isSacCost)) {
            return false;
        }
        if (ComputerUtil.waitForBlocking(sa)) {
            return false;
        }
        return LifeLoseAi.isSorcerySpeed(sa, ai) || sa.hasParam("ActivationPhases") || LifeLoseAi.playReusable(ai, sa) || ComputerUtil.activateForCost(sa, ai);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting() && !this.doTgt(ai, sa, mandatory)) {
            return false;
        }
        Card source = sa.getHostCard();
        String amountStr = sa.getParam("LifeAmount");
        int amount = 0;
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, true);
            sa.setXManaCostPaid(xPay);
            amount = xPay;
        } else {
            amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        }
        FCollection<Player> tgtPlayers = sa.usesTargeting() && !sa.hasParam("Defined") ? new FCollection<Player>(sa.getTargets().getTargetPlayers()) : AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
        return mandatory || !tgtPlayers.contains(ai) || amount <= 0 || amount + 3 <= ai.getLife();
    }

    protected boolean doTgt(Player ai, SpellAbility sa, boolean mandatory) {
        sa.resetTargets();
        PlayerCollection opps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        if (!opps.isEmpty()) {
            for (Player opp : opps) {
                if (!opp.canLoseLife() || opp.cantLoseForZeroOrLessLife()) continue;
                sa.getTargets().add(opp);
                return true;
            }
        }
        if (mandatory) {
            if (!opps.isEmpty()) {
                sa.getTargets().add((GameObject)opps.getFirst());
                return true;
            }
            for (Player ally : ai.getAllies()) {
                if (!sa.canTarget(ally)) continue;
                sa.getTargets().add(ally);
                return true;
            }
            if (sa.canTarget(ai)) {
                sa.getTargets().add(ai);
                return true;
            }
        }
        return false;
    }

    protected PlayerCollection getPlayers(Player ai, SpellAbility sa) {
        PlayerCollection it = sa.usesTargeting() && !sa.hasParam("Defined") ? sa.getTargets().getTargetPlayers() : AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa);
        return new PlayerCollection(it);
    }
}

