/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.util.MyRandom;

public class FightAi
extends SpellAbilityAi {
    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        return super.checkAiLogic(ai, sa, aiLogic);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        sa.resetTargets();
        Card source = sa.getHostCard();
        if (sa.hasParam("Defined") && !sa.usesTargeting()) {
            return true;
        }
        CardCollection aiCreatures = ai.getCreaturesInPlay();
        aiCreatures = CardLists.getTargetableCards(aiCreatures, sa);
        aiCreatures = ComputerUtil.getSafeTargets(ai, sa, aiCreatures);
        CardCollection humCreatures = ai.getOpponents().getCreaturesInPlay();
        humCreatures = CardLists.getTargetableCards(humCreatures, sa);
        StaticAbilityMustTarget.filterMustTargetCards(ai, humCreatures, sa);
        if (humCreatures.isEmpty()) {
            return false;
        }
        if (sa.hasParam("Defined")) {
            CardCollection fighter1List = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            if ("ChosenAsTgt".equals(sa.getParam("AILogic")) && sa.getRootAbility().getTargetCard() != null && fighter1List.isEmpty()) {
                fighter1List.add(sa.getRootAbility().getTargetCard());
            }
            if (fighter1List.isEmpty()) {
                return false;
            }
            Card fighter1 = (Card)fighter1List.get(false);
            for (Card humanCreature : humCreatures) {
                if (!FightAi.canKill(fighter1, humanCreature, 0) || FightAi.canKill(humanCreature, fighter1, 0)) continue;
                sa.getTargets().add(humanCreature);
                return true;
            }
            return false;
        }
        if (sa.hasParam("TargetsFromDifferentZone")) {
            if (!humCreatures.isEmpty() || !aiCreatures.isEmpty()) {
                for (Card humanCreature : humCreatures) {
                    for (Card aiCreature : aiCreatures) {
                        if (!FightAi.canKill(aiCreature, humanCreature, 0) || FightAi.canKill(humanCreature, aiCreature, 0)) continue;
                        sa.getTargets().add(humanCreature);
                        sa.getTargets().add(aiCreature);
                        return true;
                    }
                }
            }
            return false;
        }
        for (Card creature1 : humCreatures) {
            for (Card creature2 : humCreatures) {
                if (creature1.equals(creature2) || sa.hasParam("TargetsWithoutSameCreatureType") && creature1.sharesCreatureTypeWith(creature2) || !FightAi.canKill(creature1, creature2, 0) || !FightAi.canKill(creature2, creature1, 0)) continue;
                sa.getTargets().add(creature1);
                sa.getTargets().add(creature2);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        if ("Always".equals(sa.getParam("AILogic"))) {
            return true;
        }
        return this.checkApiLogic(aiPlayer, sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (aiLogic.equals("Grothama")) {
            return mandatory ? true : SpecialCardAi.GrothamaAllDevouring.consider(ai, sa);
        }
        if (this.checkApiLogic(ai, sa)) {
            return true;
        }
        if (!mandatory) {
            return false;
        }
        Card source = sa.getHostCard();
        CardCollection humCreatures = ai.getOpponents().getCreaturesInPlay();
        if ((humCreatures = CardLists.getTargetableCards(humCreatures, sa)).isEmpty()) {
            return false;
        }
        if (sa.hasParam("Defined")) {
            Card aiCreature = (Card)AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa).get(false);
            for (Card humanCreature : humCreatures) {
                if (!FightAi.canKill(aiCreature, humanCreature, 0) || ComputerUtilCard.evaluateCreature(humanCreature) <= ComputerUtilCard.evaluateCreature(aiCreature)) continue;
                sa.getTargets().add(humanCreature);
                return true;
            }
            for (Card humanCreature : humCreatures) {
                if (FightAi.canKill(humanCreature, aiCreature, 0)) continue;
                sa.getTargets().add(humanCreature);
                return true;
            }
            sa.getTargets().add((GameObject)humCreatures.get(0));
            return true;
        }
        return true;
    }

    public static boolean canFightAi(Player ai, SpellAbility sa, int power, int toughness) {
        AbilitySub tgtFight;
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        for (tgtFight = sa.getSubAbility(); tgtFight != null && tgtFight.getApi() != ApiType.Fight && tgtFight.getApi() != ApiType.DealDamage && tgtFight.getApi() != ApiType.EachDamage; tgtFight = tgtFight.getSubAbility()) {
        }
        if (tgtFight == null) {
            System.out.println("Warning: couldn't find a Fight/DealDamage subability from FightAi.canFightAi for card " + source.toString());
            tgtFight = sa.getSubAbility();
        }
        boolean isChandrasIgnition = "Chandra's Ignition".equals(sourceName);
        if ("Savage Punch".equals(sourceName) && !ai.hasFerocious()) {
            power = 0;
            toughness = 0;
        }
        CardCollection aiCreatures = ai.getCreaturesInPlay();
        CardCollection humCreatures = ai.getOpponents().getCreaturesInPlay();
        if ("Time to Feed".equals(sourceName)) {
            aiCreatures = CardLists.getTargetableCards(aiCreatures, tgtFight);
            aiCreatures = ComputerUtil.getSafeTargets(ai, tgtFight, aiCreatures);
            humCreatures = CardLists.getTargetableCards(humCreatures, sa);
        } else {
            aiCreatures = CardLists.getTargetableCards(aiCreatures, sa);
            aiCreatures = ComputerUtil.getSafeTargets(ai, sa, aiCreatures);
            humCreatures = CardLists.getTargetableCards(humCreatures, tgtFight);
        }
        ComputerUtilCard.sortByEvaluateCreature(aiCreatures);
        ComputerUtilCard.sortByEvaluateCreature(humCreatures);
        if (humCreatures.isEmpty() || aiCreatures.isEmpty()) {
            return false;
        }
        for (Card humanCreature : humCreatures) {
            for (Card aiCreature : aiCreatures) {
                if (source.isSpell()) {
                    int bonus = FightAi.getSpellBonus(aiCreature);
                    power += bonus;
                    toughness += bonus;
                }
                if ("PowerDmg".equals(sa.getParam("AILogic"))) {
                    if ("2".equals(sa.getParam("TargetMax"))) {
                        CardCollection aiCreaturesByPower = new CardCollection(aiCreatures);
                        CardLists.sortByPowerDesc(aiCreaturesByPower);
                        Card maxPower = (Card)aiCreaturesByPower.getFirst();
                        if (maxPower != aiCreature) {
                            power += maxPower.getNetPower();
                        } else if ("2".equals(sa.getParam("TargetMin"))) continue;
                        if (!FightAi.canKill(aiCreature, humanCreature, power)) continue;
                        sa.getTargets().add(aiCreature);
                        sa.getTargets().add(maxPower);
                        if (!isChandrasIgnition) {
                            tgtFight.resetTargets();
                            tgtFight.getTargets().add(humanCreature);
                        }
                        return true;
                    }
                    if (!FightAi.canKill(aiCreature, humanCreature, power)) continue;
                    sa.getTargets().add(aiCreature);
                    if (!isChandrasIgnition) {
                        tgtFight.resetTargets();
                        tgtFight.getTargets().add(humanCreature);
                    }
                    return true;
                }
                if (!FightAi.shouldFight(aiCreature, humanCreature, power, toughness)) continue;
                if ("Time to Feed".equals(sourceName)) {
                    Card tmp = aiCreature;
                    aiCreature = humanCreature;
                    humanCreature = tmp;
                }
                sa.getTargets().add(aiCreature);
                tgtFight.resetTargets();
                tgtFight.getTargets().add(humanCreature);
                return true;
            }
        }
        return false;
    }

    private static int getSpellBonus(Card aiCreature) {
        for (Trigger t2 : aiCreature.getTriggers()) {
            SpellAbility sa;
            if (t2.getMode() != TriggerType.SpellCast || (sa = t2.ensureAbility()) == null) continue;
            if (ApiType.PutCounter.equals((Object)sa.getApi())) {
                if (!"Card.Self".equals(t2.getParam("TargetsValid")) || !"You".equals(t2.getParam("ValidActivatingPlayer"))) continue;
                if (!"Self".equals(sa.getParam("Defined")) || !"P1P1".equals(sa.getParam("CounterType"))) break;
                return AbilityUtils.calculateAmount(aiCreature, sa.getParam("CounterNum"), sa);
            }
            if (!ApiType.Pump.equals((Object)sa.getApi())) continue;
        }
        return 0;
    }

    private static boolean shouldFight(Card fighter, Card opponent, int pumpAttack, int pumpDefense) {
        if (FightAi.canKill(fighter, opponent, pumpAttack)) {
            if (!FightAi.canKill(opponent, fighter, -pumpDefense)) {
                return true;
            }
            if (MyRandom.getRandom().nextInt(20) < opponent.getCMC() - fighter.getCMC()) {
                return true;
            }
        }
        return false;
    }

    public static boolean canKill(Card fighter, Card opponent, int pumpAttack) {
        if (opponent.getSVar("Targeting").equals("Dies")) {
            return true;
        }
        int damage = fighter.getNetPower() + pumpAttack;
        if (damage <= 0 || opponent.getShieldCount() > 0 || ComputerUtil.canRegenerate(opponent.getController(), opponent)) {
            return false;
        }
        return ComputerUtilCombat.getEnoughDamageToKill(opponent, damage, fighter, false) <= damage;
    }
}

