/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Collections;
import java.util.Map;

public class DiscardAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        PlayerCollection players;
        boolean humanHasHand;
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Cost abCost = sa.getPayCosts();
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (!this.willPayCosts(ai, sa, abCost, source)) {
            return false;
        }
        if ("Chandra, Flamecaller".equals(sourceName)) {
            int hand = ai.getCardsIn(ZoneType.Hand).size();
            return (double)MyRandom.getRandom().nextFloat() < 1.0 / (double)(1 + hand);
        }
        if (aiLogic.equals("VolrathsShapeshifter")) {
            return SpecialCardAi.VolrathsShapeshifter.consider(ai, sa);
        }
        boolean bl = humanHasHand = ai.getWeakestOpponent().getCardsIn(ZoneType.Hand).size() > 0;
        if (sa.usesTargeting() ? !this.discardTargetAI(ai, sa) : (players = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa)).size() == 1 && players.get(0) != ai && !humanHasHand) {
            return false;
        }
        if (sa.hasParam("NumCards")) {
            if (sa.getParam("NumCards").equals("X") && sa.getSVar("X").equals("Count$xPaid")) {
                int cardsToDiscard = Math.min(ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()), ai.getWeakestOpponent().getCardsIn(ZoneType.Hand).size());
                if (cardsToDiscard < 1) {
                    return false;
                }
                sa.setXManaCostPaid(cardsToDiscard);
            } else if (AbilityUtils.calculateAmount(source, sa.getParam("NumCards"), sa) < 1) {
                return false;
            }
        }
        if (sa.hasParam("AnyNumber") && "DiscardUncastableAndExcess".equals(aiLogic)) {
            CardCollectionView inHand = ai.getCardsIn(ZoneType.Hand);
            int numLandsOTB = CardLists.count(ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS);
            int numDiscard = 0;
            int numOppInHand = 0;
            for (Player p : ai.getGame().getPlayers()) {
                if (p.getCardsIn(ZoneType.Hand).size() <= numOppInHand) continue;
                numOppInHand = p.getCardsIn(ZoneType.Hand).size();
            }
            for (Card c : inHand) {
                if (c.equals(source) || c.hasSVar("DoNotDiscardIfAble") || c.hasSVar("IsReanimatorCard")) continue;
                if (c.isCreature() && !ComputerUtilMana.hasEnoughManaSourcesToCast(c.getSpellPermanent(), ai)) {
                    ++numDiscard;
                }
                if ((!c.isLand() || numLandsOTB < 5) && (c.getFirstSpellAbility() == null || ComputerUtilMana.hasEnoughManaSourcesToCast(c.getFirstSpellAbility(), ai)) || numDiscard + 1 > numOppInHand) continue;
                ++numDiscard;
            }
            if (numDiscard == 0) {
                return false;
            }
        }
        if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !aiLogic.startsWith("AnyPhase")) {
            return false;
        }
        if (aiLogic.equals("AnyPhaseIfFavored") && ai.getGame().getCombat() != null && ai.getCardsIn(ZoneType.Hand).size() < ai.getGame().getCombat().getDefenderPlayerByAttacker(source).getCardsIn(ZoneType.Hand).size()) {
            return false;
        }
        if (ComputerUtil.waitForBlocking(sa)) {
            return false;
        }
        boolean randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.9, sa.getActivationsThisTurn());
        return randomReturn;
    }

    private boolean discardTargetAI(Player ai, SpellAbility sa) {
        PlayerCollection opps = ai.getOpponents();
        Collections.shuffle(opps);
        for (Player opp : opps) {
            if (opp.getCardsIn(ZoneType.Hand).isEmpty() && !ComputerUtil.activateForCost(sa, ai) || !opp.canDiscardBy(sa, true) || !sa.usesTargeting() || !sa.canTarget(opp)) continue;
            sa.resetTargets();
            sa.getTargets().add(opp);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            Player opp = targetableOpps.min(PlayerPredicates.compareByLife());
            if (this.discardTargetAI(ai, sa)) return true;
            if (mandatory && opp != null) {
                sa.getTargets().add(opp);
                return true;
            } else {
                if (!mandatory || !sa.canTarget(ai)) return false;
                sa.getTargets().add(ai);
            }
            return true;
        } else {
            PlayerCollection players;
            if (sa.hasParam("AILogic") && "AtLeast2".equals(sa.getParam("AILogic")) && ((players = AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa)).isEmpty() || ((Player)players.get(0)).getCardsIn(ZoneType.Hand).size() < 2)) {
                return false;
            }
            if (!"X".equals(sa.getParam("RevealNumber")) || !sa.getSVar("X").equals("Count$xPaid")) return true;
            int cardsToDiscard = Math.min(ComputerUtilCost.getMaxXValue(sa, ai, true), ai.getWeakestOpponent().getCardsIn(ZoneType.Hand).size());
            sa.setXManaCostPaid(cardsToDiscard);
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if (sa.usesTargeting()) {
            return this.discardTargetAI(ai, sa);
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        if (mode == PlayerActionConfirmMode.Random) {
            return true;
        }
        return super.confirmAction(player, sa, mode, message, params);
    }
}

