/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.ComputerUtil;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class DigMultipleAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        Card host = sa.getHostCard();
        Player libraryOwner = ai;
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!opp.canBeTargetedBy(sa)) {
                return false;
            }
            sa.getTargets().add(opp);
            libraryOwner = opp;
        }
        if (libraryOwner.getCardsIn(ZoneType.Library).isEmpty()) {
            return false;
        }
        if ("Never".equals(sa.getParam("AILogic"))) {
            return false;
        }
        if ("AtOppEOT".equals(sa.getParam("AILogic")) && (game.getPhaseHandler().getNextTurn() != ai || !game.getPhaseHandler().is(PhaseType.END_OF_TURN))) {
            return false;
        }
        if (sa.hasParam("DestinationZone2") && !"Library".equals(sa.getParam("DestinationZone2"))) {
            int numToDig = AbilityUtils.calculateAmount(host, sa.getParam("DigNum"), sa);
            if (libraryOwner == ai && ai.getCardsIn(ZoneType.Library).size() <= numToDig + 2) {
                return false;
            }
        }
        if (game.getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !sa.hasParam("DestinationZone") && !ComputerUtil.castSpellInMain1(ai, sa)) {
            return false;
        }
        if (DigMultipleAi.playReusable(ai, sa)) {
            return true;
        }
        if (!(game.getPhaseHandler().getNextTurn().equals(ai) && !game.getPhaseHandler().getPhase().isBefore(PhaseType.END_OF_TURN) || sa.hasParam("PlayerTurn") || DigMultipleAi.isSorcerySpeed(sa, ai) || ai.getCardsIn(ZoneType.Hand).size() <= 1 && !game.getPhaseHandler().getPhase().isBefore(PhaseType.DRAW) || ComputerUtil.activateForCost(sa, ai))) {
            return false;
        }
        return !ComputerUtil.preventRunAwayActivations(sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (mandatory && sa.canTarget(opp)) {
                sa.getTargets().add(opp);
            } else if (mandatory && sa.canTarget(ai)) {
                sa.getTargets().add(ai);
            }
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }
}

