/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialAiLogic;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.CostSacrifice;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.zone.ZoneType;

public class DestroyAi
extends SpellAbilityAi {
    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.checkApiLogic(ai, sa);
    }

    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        Card source = sa.getHostCard();
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (aiLogic.startsWith("MinLoyalty.")) {
                int minLoyalty = Integer.parseInt(aiLogic.substring(aiLogic.indexOf(".") + 1));
                if (source.getCounters(CounterEnumType.LOYALTY) < minLoyalty) {
                    return false;
                }
            } else {
                if ("Polymorph".equals(aiLogic)) {
                    CardCollection list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
                    if (list.isEmpty()) {
                        return false;
                    }
                    for (Card c : list) {
                        if (!c.hasKeyword(Keyword.INDESTRUCTIBLE)) continue;
                        sa.getTargets().add(c);
                        return true;
                    }
                    Card worst = ComputerUtilCard.getWorstAI(list);
                    if (worst.isCreature() && ComputerUtilCard.evaluateCreature(worst) >= 200) {
                        return false;
                    }
                    if (!worst.isCreature() && worst.getCMC() > 1) {
                        return false;
                    }
                    sa.getTargets().add(worst);
                    return true;
                }
                if ("Pongify".equals(aiLogic)) {
                    return SpecialAiLogic.doPongifyLogic(ai, sa);
                }
            }
        }
        return super.checkAiLogic(ai, sa, aiLogic);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph, String logic) {
        if ("AtOpponentsCombatOrAfter".equals(logic)) {
            if (ph.isPlayerTurn(ai) || ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                return false;
            }
        } else if ("AtEOT".equals(logic)) {
            if (!ph.is(PhaseType.END_OF_TURN)) {
                return false;
            }
        } else if ("AtEOTIfNotAttacking".equals(logic)) {
            if (!ph.is(PhaseType.END_OF_TURN) || !ai.getCreaturesAttackedThisTurn().isEmpty()) {
                return false;
            }
        } else if ("Pactivator".equals(logic)) {
            boolean havepact = false;
            havepact |= ai.isCardInPlay("Grave Pact");
            havepact |= ai.isCardInPlay("Butcher of Malakir");
            if ((havepact |= ai.isCardInPlay("Dictate of Erebos")) && !ph.isPlayerTurn(ai) && (ph.is(PhaseType.END_OF_TURN) || ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS)) && ai.getOpponents().getCreaturesInPlay().size() > 0) {
                CardCollection list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
                Card worst = ComputerUtilCard.getWorstAI(list);
                if (worst != null) {
                    sa.getTargets().add(worst);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean noRegen = sa.hasParam("NoRegen");
        String logic = sa.getParam("AILogic");
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (sa.usesTargeting()) {
            int maxTargets;
            if ("X".equals(sa.getTargetRestrictions().getMinTargets()) && sa.getSVar("X").equals("Count$xPaid")) {
                int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                sa.getRootAbility().setXManaCostPaid(xPay);
            }
            if (sa.hasParam("AILogic") && !sa.canAddMoreTarget() && sa.isTargetNumberValid()) {
                return true;
            }
            sa.resetTargets();
            if (sa.getRootAbility().costHasManaX()) {
                maxTargets = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                sa.getRootAbility().setXManaCostPaid(maxTargets);
                maxTargets = Math.min(maxTargets, sa.getMaxTargets());
            } else {
                maxTargets = sa.getMaxTargets();
            }
            if (maxTargets == 0) {
                return false;
            }
            if (sa.hasParam("TargetingPlayer")) {
                Player targetingPlayer = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("TargetingPlayer"), sa).get(false);
                sa.setTargetingPlayer(targetingPlayer);
                return targetingPlayer.getController().chooseTargetsFor(sa);
            }
            CardCollection list = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
            if ("FatalPush".equals(logic)) {
                int cmcMax = ai.hasRevolt() ? 4 : 2;
                list = CardLists.filter((Iterable<Card>)list, CardPredicates.lessCMC(cmcMax));
            }
            list = ComputerUtil.filterAITgts(sa, ai, list, true);
            if (CardLists.getNotType(list = CardLists.getNotKeyword((Iterable<Card>)list, Keyword.INDESTRUCTIBLE), "Creature").isEmpty()) {
                list = ComputerUtilCard.prioritizeCreaturesWorthRemovingNow(ai, list, false);
            }
            if (!DestroyAi.playReusable(ai, sa)) {
                list = CardLists.filter((Iterable<Card>)list, Predicates.not(CardPredicates.hasCounter(CounterEnumType.SHIELD, 1)));
                list = CardLists.filter((Iterable<Card>)list, c -> {
                    for (SpellAbility ability : c.getAllSpellAbilities()) {
                        if (!ability.isActivatedAbility()) continue;
                        Cost cost = ability.getPayCosts();
                        for (CostPart part : cost.getCostParts()) {
                            CostSacrifice sacCost;
                            if (!(part instanceof CostSacrifice) || !(sacCost = (CostSacrifice)part).payCostFromSource() || !ComputerUtilCost.canPayCost(ability, c.getController(), false)) continue;
                            return false;
                        }
                    }
                    if (c.hasSVar("SacMe")) {
                        return false;
                    }
                    return !c.hasKeyword(Keyword.UNDYING) || c.getCounters(CounterEnumType.P1P1) > 0;
                });
            }
            if (!noRegen) {
                list = CardLists.filter((Iterable<Card>)list, c -> c.getShieldCount() == 0 && !ComputerUtil.canRegenerate(ai, c));
            }
            if ((list = ComputerUtil.filterCreaturesThatWillDieThisTurn(ai, list, sa)).isEmpty()) {
                return false;
            }
            while (sa.getTargets().size() < maxTargets) {
                CardCollection originalList = new CardCollection(list);
                boolean mustTargetFiltered = StaticAbilityMustTarget.filterMustTargetCards(ai, list, sa);
                if (list.isEmpty()) {
                    if (!sa.isMinTargetChosen() || sa.isZeroTargets()) {
                        sa.resetTargets();
                        return false;
                    }
                    break;
                }
                Card choice = null;
                if (CardLists.getNotType(list, "Creature").isEmpty()) {
                    Card aiBest;
                    choice = ComputerUtilCard.getBestCreatureAI(list);
                    if ("OppDestroyYours".equals(logic) && ComputerUtilCard.evaluateCreature(aiBest = ComputerUtilCard.getBestCreatureAI(ai.getCreaturesInPlay())) > ComputerUtilCard.evaluateCreature(choice) - 40) {
                        return false;
                    }
                } else if (CardLists.getNotType(list, "Land").isEmpty()) {
                    choice = ComputerUtilCard.getBestLandAI(list);
                    if (("LandForLand".equals(logic) || "GhostQuarter".equals(logic)) && !this.doLandForLandRemovalLogic(sa, ai, choice, logic)) {
                        return false;
                    }
                } else {
                    choice = ComputerUtilCard.getMostExpensivePermanentAI(list);
                }
                if (!(sa.isTrigger() || sa.getMaxTargets() != 1 || choice != null && ComputerUtilCard.useRemovalNow(sa, choice, 0, ZoneType.Graveyard))) {
                    return false;
                }
                if (choice == null) {
                    if (!sa.isMinTargetChosen() || sa.isZeroTargets()) {
                        sa.resetTargets();
                        return false;
                    }
                    break;
                }
                if (choice.getOwner() == ai) {
                    for (Card aura : choice.getEnchantedBy()) {
                        SpellAbility sp = aura.getFirstSpellAbility();
                        if (sp == null || !"GainControl".equals(sp.getParam("AILogic")) || aura.getController() == ai || !sa.canTarget(aura)) continue;
                        list.remove(choice);
                        choice = aura;
                    }
                }
                if (mustTargetFiltered) {
                    list = originalList;
                }
                list.remove(choice);
                sa.getTargets().add(choice);
            }
        } else if (sa.hasParam("Defined")) {
            CardCollection list = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            if ("WillSkipTurn".equals(logic) && (source.getController().equals(ai) || ai.getCreaturesInPlay().size() < ai.getWeakestOpponent().getCreaturesInPlay().size() || !source.getGame().getPhaseHandler().isPlayerTurn(ai) || ai.getLife() <= 5)) {
                return false;
            }
            if ("Always".equals(logic)) {
                return true;
            }
            if (list.isEmpty() || !CardLists.filterControlledBy((Iterable<Card>)list, ai).isEmpty() || CardLists.getNotKeyword((Iterable<Card>)list, Keyword.INDESTRUCTIBLE).isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        boolean noRegen = sa.hasParam("NoRegen");
        if (sa.usesTargeting()) {
            Card c2;
            sa.resetTargets();
            CardCollection list = CardLists.getTargetableCards(ai.getGame().getCardsIn(ZoneType.Battlefield), sa);
            if (list.isEmpty() || list.size() < sa.getMinTargets()) {
                return false;
            }
            list = ComputerUtil.filterCreaturesThatWillDieThisTurn(ai, list, sa);
            CardCollection preferred = CardLists.getNotKeyword((Iterable<Card>)list, Keyword.INDESTRUCTIBLE);
            preferred = CardLists.filterControlledBy((Iterable<Card>)preferred, ai.getOpponents());
            if (CardLists.getNotType(preferred = CardLists.filter((Iterable<Card>)preferred, Predicates.not(CardPredicates.hasCounter(CounterEnumType.SHIELD, 1))), "Creature").isEmpty()) {
                preferred = ComputerUtilCard.prioritizeCreaturesWorthRemovingNow(ai, preferred, false);
            }
            if (!noRegen) {
                preferred = CardLists.filter((Iterable<Card>)preferred, c -> c.getShieldCount() == 0);
            }
            preferred = ComputerUtil.filterAITgts(sa, ai, preferred, true);
            list.removeAll(preferred);
            if (preferred.isEmpty() && !mandatory) {
                return false;
            }
            while (sa.canAddMoreTarget()) {
                if (preferred.isEmpty()) {
                    if (!sa.isMinTargetChosen()) {
                        if (mandatory) break;
                        sa.resetTargets();
                        return false;
                    }
                    return true;
                }
                c2 = ComputerUtilCard.getBestAI(preferred);
                sa.getTargets().add(c2);
                preferred.remove(c2);
            }
            while (!sa.isMinTargetChosen() && !list.isEmpty()) {
                c2 = CardLists.getNotType(list, "Creature").isEmpty() ? (!sa.getUniqueTargets().isEmpty() && sa.getParent().getApi() == ApiType.Destroy && sa.getUniqueTargets().get(0) instanceof Card ? (Card)sa.getUniqueTargets().get(0) : ComputerUtilCard.getWorstCreatureAI(list)) : ComputerUtilCard.getCheapestPermanentAI(list, sa, false);
                sa.getTargets().add(c2);
                list.remove(c2);
            }
            return sa.isTargetNumberValid();
        }
        return mandatory;
    }

    public boolean doLandForLandRemovalLogic(SpellAbility sa, Player ai, Card tgtLand, String logic) {
        boolean tempoCheck;
        if (tgtLand == null) {
            return false;
        }
        Player tgtPlayer = tgtLand.getController();
        int oppLandsOTB = tgtPlayer.getLandsInPlay().size();
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        int amountNoTempoCheck = aic.getIntProperty(AiProps.STRIPMINE_MIN_LANDS_OTB_FOR_NO_TEMPO_CHECK);
        int amountNoTimingCheck = aic.getIntProperty(AiProps.STRIPMINE_MIN_LANDS_FOR_NO_TIMING_CHECK);
        int amountLandsInHand = aic.getIntProperty(AiProps.STRIPMINE_MIN_LANDS_IN_HAND_TO_ACTIVATE);
        int amountLandsToManalock = aic.getIntProperty(AiProps.STRIPMINE_MAX_LANDS_TO_ATTEMPT_MANALOCKING);
        boolean highPriorityIfNoLandDrop = aic.getBooleanProperty(AiProps.STRIPMINE_HIGH_PRIORITY_ON_SKIPPED_LANDDROP);
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        boolean oppSkippedLandDrop = tgtPlayer.getLandsPlayedLastTurn() == 0 && ph.isPlayerTurn(ai) || tgtPlayer.getLandsPlayedThisTurn() == 0 && ph.isPlayerTurn(tgtPlayer) && ph.getPhase().isAfter(PhaseType.MAIN2);
        boolean canManaLock = oppLandsOTB <= amountLandsToManalock && oppSkippedLandDrop;
        CardCollection oppLands = tgtPlayer.getLandsInPlay();
        boolean canColorLock = (oppSkippedLandDrop || oppLands.size() > 3) && tgtLand.isBasicLand() && CardLists.count(oppLands, CardPredicates.nameEquals(tgtLand.getName())) == 1;
        boolean nonBasicTgt = !tgtLand.isBasicLand();
        int numLandsInHand = CardLists.count(ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS_PRODUCING_MANA);
        int numLandsOTB = CardLists.count(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA);
        boolean isHighPriority = highPriorityIfNoLandDrop && oppSkippedLandDrop;
        boolean timingCheck = canManaLock || canColorLock || nonBasicTgt;
        boolean bl = tempoCheck = numLandsOTB >= amountNoTempoCheck || (numLandsInHand >= amountLandsInHand || isHighPriority) && (numLandsInHand + numLandsOTB >= amountNoTimingCheck || timingCheck);
        if ("GhostQuarter".equals(logic)) {
            return tempoCheck && (numLandsOTB > oppLands.size() || numLandsOTB == oppLands.size() && numLandsInHand > 0);
        }
        return tempoCheck;
    }
}

