/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.List;

public class DamagePreventAi
extends SpellAbilityAi {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card hostCard = sa.getHostCard();
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        boolean chance = false;
        Cost cost = sa.getPayCosts();
        if (!this.willPayCosts(ai, sa, cost, hostCard)) {
            return false;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt == null) {
            FCollection<GameObject> objects = AbilityUtils.getDefinedObjects(hostCard, sa.getParam("Defined"), sa);
            if (!game.getStack().isEmpty()) {
                List<GameObject> threatenedObjects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa);
                for (Object e : objects) {
                    if (!threatenedObjects.contains(e)) continue;
                    chance = true;
                    break;
                }
            } else {
                PhaseHandler handler = game.getPhaseHandler();
                if (!handler.is(PhaseType.COMBAT_DECLARE_BLOCKERS)) return false;
                boolean flag = false;
                for (Object e : objects) {
                    Player p;
                    if (e instanceof Card) {
                        flag = flag || ComputerUtilCombat.combatantWouldBeDestroyed(ai, (Card)e, combat);
                        continue;
                    }
                    if (!(e instanceof Player) || handler.isPlayerTurn(p = (Player)e)) continue;
                    flag = flag || p == ai && (ComputerUtilCombat.wouldLoseLife(ai, combat) && sa.isAbility() || ComputerUtilCombat.lifeInDanger(ai, combat));
                }
                chance = flag;
            }
        } else if (!game.getStack().isEmpty()) {
            sa.resetTargets();
            TargetChoices tcs = sa.getTargets();
            List<GameObject> objects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa);
            if (objects.contains(ai) && sa.canTarget(ai)) {
                tcs.add(ai);
                chance = true;
            }
            ArrayList<Card> threatenedTargets = new ArrayList<Card>();
            CardCollection cardCollection = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
            for (Card c : cardCollection) {
                if (!objects.contains(c)) continue;
                threatenedTargets.add(c);
            }
            if (!threatenedTargets.isEmpty()) {
                tcs.add(ComputerUtilCard.getBestCreatureAI(threatenedTargets));
                chance = true;
            }
        } else if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            sa.resetTargets();
            TargetChoices tcs = sa.getTargets();
            if (sa.canTarget(ai) && ComputerUtilCombat.wouldLoseLife(ai, combat) && (ComputerUtilCombat.lifeInDanger(ai, combat) || sa.isAbility() || sa.isTrigger()) && ComputerUtilCombat.sumDamageIfUnblocked(combat.getAttackers(), ai, true) > ai.getPreventNextDamageTotalShields() && game.getPhaseHandler().getPlayerTurn().isOpponentOf(ai)) {
                tcs.add(ai);
                chance = true;
            } else {
                CardCollectionView targetables = ai.getCardsIn(ZoneType.Battlefield);
                targetables = CardLists.getValidCards((Iterable<Card>)targetables, tgt.getValidTgts(), ai, hostCard, (CardTraitBase)sa);
                if ((targetables = CardLists.getTargetableCards(targetables, sa)).isEmpty()) {
                    return false;
                }
                CardCollection combatants = CardLists.filter((Iterable<Card>)targetables, CardPredicates.Presets.CREATURES);
                ComputerUtilCard.sortByEvaluateCreature(combatants);
                for (Card card : combatants) {
                    if (!ComputerUtilCombat.combatantWouldBeDestroyed(ai, card, combat) || !sa.canAddMoreTarget()) continue;
                    tcs.add(card);
                    chance = true;
                }
            }
        }
        if (!sa.usesTargeting() || !sa.isDividedAsYouChoose() || sa.getTargets().isEmpty()) return chance;
        sa.addDividedAllocation((GameObject)sa.getTargets().get(0), AbilityUtils.calculateAmount(hostCard, sa.getParam("Amount"), sa));
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        boolean chance = false;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        chance = tgt == null ? true : this.preventDamageMandatoryTarget(ai, sa, mandatory);
        return chance;
    }

    private boolean preventDamageMandatoryTarget(Player ai, SpellAbility sa, boolean mandatory) {
        sa.resetTargets();
        Game game = ai.getGame();
        CardCollectionView targetables = game.getCardsIn(ZoneType.Battlefield);
        targetables = CardLists.getTargetableCards(targetables, sa);
        CardCollection compTargetables = CardLists.filterControlledBy((Iterable<Card>)targetables, ai);
        Card target = null;
        if (targetables.isEmpty()) {
            return false;
        }
        if (!mandatory && compTargetables.isEmpty()) {
            return false;
        }
        if (!compTargetables.isEmpty()) {
            CardCollection combatants = CardLists.filter((Iterable<Card>)compTargetables, CardPredicates.Presets.CREATURES);
            ComputerUtilCard.sortByEvaluateCreature(combatants);
            if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                Combat combat = game.getCombat();
                for (Card c : combatants) {
                    if (!ComputerUtilCombat.combatantWouldBeDestroyed(ai, c, combat)) continue;
                    target = c;
                    break;
                }
            }
            if (target == null) {
                target = (Card)combatants.get(false);
            }
        } else {
            target = ComputerUtilCard.getCheapestPermanentAI(targetables, sa, true);
        }
        sa.getTargets().add(target);
        if (sa.isDividedAsYouChoose()) {
            sa.addDividedAllocation(target, AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa));
        }
        return true;
    }
}

