/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.ability.DamageAiBase;
import forge.ai.ability.FightAi;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.cost.Cost;
import forge.game.cost.CostPartMana;
import forge.game.cost.CostPutCounter;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DamageDealAi
extends DamageAiBase {
    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        SpellAbility root = sa.getRootAbility();
        String damage = sa.getParam("NumDmg");
        Card source = sa.getHostCard();
        int dmg = AbilityUtils.calculateAmount(source, damage, sa);
        String logic = sa.getParam("AILogic");
        if ("MadSarkhanDigDmg".equals(logic)) {
            return SpecialCardAi.SarkhanTheMad.considerDig(ai, sa);
        }
        if (damage.equals("X")) {
            if (sa.getSVar(damage).equals("Count$ChosenNumber")) {
                int energy = ai.getCounters(CounterEnumType.ENERGY);
                for (SpellAbility s2 : source.getSpellAbilities()) {
                    if (!"PayEnergy".equals(s2.getParam("AILogic"))) continue;
                    energy += AbilityUtils.calculateAmount(source, s2.getParam("CounterNum"), sa);
                    break;
                }
                while (energy > 0) {
                    if (this.damageTargetAI(ai, sa, energy, false) && (dmg = ComputerUtilCombat.getEnoughDamageToKill(sa.getTargetCard(), energy, source, false, false)) <= energy && dmg >= 1) {
                        root.setSVar("EnergyToPay", "Number$" + dmg);
                        return true;
                    }
                    --energy;
                }
                return false;
            }
            if (sa.getSVar(damage).equals("Count$xPaid")) {
                if ("XLifeDrain".equals(logic)) {
                    return this.doXLifeDrainLogic(ai, sa);
                }
                dmg = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                sa.setXManaCostPaid(dmg);
            } else if (sa.getSVar(damage).equals("Count$CardsInYourHand") && source.isInZone(ZoneType.Hand)) {
                --dmg;
            }
        }
        return this.damageTargetAI(ai, sa, dmg, true);
    }

    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        String logic;
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        String damage = sa.getParam("NumDmg");
        int dmg = AbilityUtils.calculateAmount(source, damage, sa);
        if (damage.equals("X") || source.getSVar("X").equals("Count$xPaid") || sourceName.equals("Crater's Claws")) {
            if (sa.getSVar("X").equals("Count$xPaid") || sa.getSVar(damage).equals("Count$xPaid") || sourceName.equals("Crater's Claws")) {
                AiController aic;
                int holdChance;
                dmg = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                if (ai.getController().isAI() && MyRandom.percentTrue(holdChance = (aic = ((PlayerControllerAi)ai.getController()).getAi()).getIntProperty(AiProps.HOLD_X_DAMAGE_SPELLS_FOR_MORE_DAMAGE_CHANCE))) {
                    boolean isLethal;
                    int threshold = aic.getIntProperty(AiProps.HOLD_X_DAMAGE_SPELLS_THRESHOLD);
                    boolean inDanger = ComputerUtil.aiLifeInDanger(ai, false, 0);
                    boolean bl = isLethal = sa.getTargetRestrictions().canTgtPlayer() && dmg >= ai.getWeakestOpponent().getLife() && !ai.getWeakestOpponent().cantLoseForZeroOrLessLife();
                    if (dmg < threshold && ai.getGame().getPhaseHandler().getTurn() / 2 < threshold && !inDanger && !isLethal) {
                        return false;
                    }
                }
                sa.setXManaCostPaid(dmg);
            } else if (sa.getSVar(damage).contains("InYourHand") && source.isInZone(ZoneType.Hand)) {
                dmg = AbilityUtils.calculateAmount(source, damage, sa) - 1;
            } else if (sa.getSVar(damage).equals("TargetedPlayer$CardsInHand") && sa.getTargetRestrictions().canTgtPlayer()) {
                int maxDmg = 0;
                Player maxDamaged = null;
                for (Player p : ai.getOpponents()) {
                    if (!p.canBeTargetedBy(sa) || p.getCardsIn(ZoneType.Hand).size() <= maxDmg) continue;
                    maxDmg = p.getCardsIn(ZoneType.Hand).size();
                    maxDamaged = p;
                }
                if (maxDmg > 0 && maxDamaged != null) {
                    if (this.shouldTgtP(ai, sa, maxDmg, false)) {
                        sa.resetTargets();
                        sa.getTargets().add(maxDamaged);
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }
        if (sourceName.equals("Crater's Claws") && ai.hasFerocious()) {
            dmg += 2;
        }
        if ("DiscardLands".equals(logic = sa.getParamOrDefault("AILogic", ""))) {
            dmg = 2;
        } else if (logic.startsWith("ProcRaid.")) {
            if (ai.getGame().getPhaseHandler().isPlayerTurn(ai) && ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                for (Card potentialAtkr : ai.getCreaturesInPlay()) {
                    if (!ComputerUtilCard.doesCreatureAttackAI(ai, potentialAtkr)) continue;
                    return false;
                }
            }
            if (!ai.getCreaturesAttackedThisTurn().isEmpty()) {
                dmg = Integer.parseInt(logic.substring(logic.indexOf(".") + 1));
            }
        } else if ("WildHunt".equals(logic)) {
            CardCollection wolves = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), "Creature.Wolf+untapped+YouCtrl+Other", ai, source, (CardTraitBase)sa);
            dmg = Aggregates.sum(wolves, Card::getNetPower);
        } else {
            if ("Triskelion".equals(logic)) {
                int n = source.getCounters(CounterEnumType.P1P1);
                if (n > 0) {
                    if (ComputerUtil.playImmediately(ai, sa)) {
                        return this.damageTargetAI(ai, sa, n, true);
                    }
                    return ai.getGame().getStack().isEmpty() && this.damageTargetAI(ai, sa, n, false);
                }
                return false;
            }
            if ("NinThePainArtist".equals(logic)) {
                Card tgt;
                boolean doTarget;
                if (ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) && (doTarget = this.damageTargetAI(ai, sa, dmg, true)) && (tgt = sa.getTargetCard()) != null) {
                    return ai.getGame().getPhaseHandler().getPlayerTurn() == tgt.getController();
                }
                return false;
            }
        }
        if (sourceName.equals("Sorin, Grim Nemesis")) {
            for (int loyalty = source.getCounters(CounterEnumType.LOYALTY); loyalty > 0; --loyalty) {
                if (!this.damageTargetAI(ai, sa, loyalty, false) || (dmg = ComputerUtilCombat.getEnoughDamageToKill(sa.getTargetCard(), loyalty, source, false, false)) > loyalty || dmg < 1) continue;
                sa.setXManaCostPaid(dmg);
                return true;
            }
            return false;
        }
        if (dmg <= 0) {
            return false;
        }
        if (!ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkRemoveCounterCost(abCost, source, sa)) {
            return false;
        }
        if ("DiscardLands".equals(sa.getParam("AILogic")) && !ComputerUtilCost.checkDiscardCost(ai, abCost, source, sa)) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        Pair<SpellAbility, Integer> chainDmg = DamageDealAi.getDamagingSAToChain(ai, sa, damage);
        if (chainDmg != null) {
            int extraDmg = chainDmg.getValue();
            boolean willTargetIfChained = this.damageTargetAI(ai, sa, dmg + extraDmg, false);
            if (!willTargetIfChained) {
                return false;
            }
            if (willTargetIfChained && chainDmg.getKey().getApi() == ApiType.Pump && sa.getTargets().isTargetingAnyPlayer()) {
                sa.resetTargets();
                if (!this.damageTargetAI(ai, sa, dmg, false)) {
                    return false;
                }
            } else {
                AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
                aic.reserveManaSourcesForNextSpell(chainDmg.getKey(), sa);
            }
        } else if (!this.damageTargetAI(ai, sa, dmg, false)) {
            return false;
        }
        if ((damage.equals("X") && sa.getSVar(damage).equals("Count$xPaid") || sourceName.equals("Crater's Claws")) && sa.usesTargeting() && !sa.getTargets().isTargetingAnyPlayer() && !sa.isDividedAsYouChoose()) {
            int actualPay = dmg;
            boolean noPrevention = sa.hasParam("NoPrevention");
            for (Card c : sa.getTargets().getTargetCards()) {
                int adjDamage = ComputerUtilCombat.getEnoughDamageToKill(c, dmg, source, false, noPrevention);
                if (adjDamage >= actualPay) continue;
                actualPay = adjDamage;
            }
            if (sourceName.equals("Crater's Claws") && ai.hasFerocious()) {
                actualPay = actualPay > 2 ? actualPay - 2 : 0;
            }
            sa.setXManaCostPaid(actualPay);
        }
        if ("DiscardCMCX".equals(sa.getParam("AILogic"))) {
            int cmc = sa.getXManaCostPaid();
            return ai.getZone(ZoneType.Hand).contains(CardPredicates.hasCMC(cmc));
        }
        return true;
    }

    private Card dealDamageChooseTgtC(Player ai, SpellAbility sa, int d, boolean noPrevention, Player pl, boolean mandatory) {
        if (sa.isTrigger() || !ai.getGame().getStack().isEmpty()) {
            // empty if block
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Player activator = sa.getActivatingPlayer();
        Card source = sa.getHostCard();
        Game game = source.getGame();
        List<Card> hPlay = this.getTargetableCards(ai, sa, pl, tgt, activator, source, game);
        StaticAbilityMustTarget.filterMustTargetCards(ai, hPlay, sa);
        CardCollection killables = CardLists.filter(hPlay, c -> c.getSVar("Targeting").equals("Dies") || ComputerUtilCombat.getEnoughDamageToKill(c, d, source, false, noPrevention) <= d && !ComputerUtil.canRegenerate(ai, c) && !c.hasSVar("SacMe") && !ComputerUtilCard.hasActiveUndyingOrPersist(c));
        killables = ComputerUtil.filterAITgts(sa, ai, killables, true);
        killables = ComputerUtil.filterCreaturesThatWillDieThisTurn(ai, killables, sa);
        Card targetCard = null;
        if (pl.isOpponentOf(ai) && activator.equals(ai) && !killables.isEmpty()) {
            if (sa.getTargetRestrictions().canTgtPlaneswalker()) {
                targetCard = ComputerUtilCard.getBestPlaneswalkerAI(killables);
            }
            if (targetCard == null) {
                targetCard = ComputerUtilCard.getBestCreatureAI(killables);
            }
            return targetCard;
        }
        if (!mandatory) {
            return null;
        }
        hPlay = this.getTargetableCards(pl, sa, pl, tgt, activator, source, game);
        CardCollection controlledByOpps = CardLists.filterControlledBy(hPlay, ai.getOpponents());
        if (!hPlay.isEmpty()) {
            if (pl.isOpponentOf(ai) && activator.equals(ai)) {
                if (sa.getTargetRestrictions().canTgtPlaneswalker()) {
                    targetCard = ComputerUtilCard.getBestPlaneswalkerAI(controlledByOpps);
                }
                if (targetCard == null) {
                    targetCard = ComputerUtilCard.getBestCreatureAI(controlledByOpps);
                }
            }
            if (targetCard == null) {
                targetCard = ComputerUtilCard.getWorstCreatureAI(hPlay);
            }
            return targetCard;
        }
        return null;
    }

    private Card dealDamageChooseTgtPW(Player ai, SpellAbility sa, int d, boolean noPrevention, Player pl, boolean mandatory) {
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Player activator = sa.getActivatingPlayer();
        Card source = sa.getHostCard();
        Game game = source.getGame();
        CardCollection hPlay = CardLists.filter(this.getTargetableCards(ai, sa, pl, tgt, activator, source, game), CardPredicates.Presets.PLANESWALKERS);
        CardCollection killables = CardLists.filter((Iterable<Card>)hPlay, c -> c.getSVar("Targeting").equals("Dies") || ComputerUtilCombat.getEnoughDamageToKill(c, d, source, false, noPrevention) <= d && !ComputerUtil.canRegenerate(ai, c) && !c.hasSVar("SacMe"));
        killables = ComputerUtil.filterAITgts(sa, ai, killables, true);
        if (pl.isOpponentOf(ai) && activator.equals(ai) && !killables.isEmpty()) {
            return ComputerUtilCard.getBestPlaneswalkerAI(killables);
        }
        if (!hPlay.isEmpty() && pl.isOpponentOf(ai) && activator.equals(ai)) {
            Card pw = ComputerUtilCard.getBestPlaneswalkerToDamage(hPlay);
            return pw == null && mandatory ? (Card)hPlay.get(0) : pw;
        }
        return null;
    }

    private List<Card> getTargetableCards(Player ai, SpellAbility sa, Player pl, TargetRestrictions tgt, Player activator, Card source, Game game) {
        CardCollection hPlay = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), activator, source, (CardTraitBase)sa);
        if (activator.equals(ai)) {
            hPlay = CardLists.filterControlledBy((Iterable<Card>)hPlay, pl);
        }
        ArrayList<GameObject> objects = Lists.newArrayList(sa.getTargets());
        if (sa.hasParam("TargetUnique")) {
            objects.addAll(sa.getUniqueTargets());
        }
        for (Object e : objects) {
            if (!(e instanceof Card)) continue;
            hPlay.remove(e);
        }
        hPlay = CardLists.getTargetableCards(hPlay, sa);
        return hPlay;
    }

    private boolean damageTargetAI(Player ai, SpellAbility saMe, int dmg, boolean immediately) {
        TargetRestrictions tgt = saMe.getTargetRestrictions();
        if (tgt == null) {
            return this.damageChooseNontargeted(ai, saMe, dmg);
        }
        if (tgt.isRandomTarget()) {
            return false;
        }
        return this.damageChoosingTargets(ai, saMe, tgt, dmg, saMe.isMandatory(), immediately);
    }

    private boolean damageChoosingTargets(Player ai, SpellAbility sa, TargetRestrictions tgt, int dmg, boolean mandatory, boolean immediately) {
        Card source = sa.getHostCard();
        boolean noPrevention = sa.hasParam("NoPrevention");
        Game game = source.getGame();
        PhaseHandler phase = game.getPhaseHandler();
        boolean divided = sa.isDividedAsYouChoose();
        boolean oppTargetsChoice = sa.hasParam("TargetingPlayer");
        String logic = sa.getParamOrDefault("AILogic", "");
        PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player enemy = targetableOpps.min(PlayerPredicates.compareByLife());
        if (enemy == null) {
            enemy = ai.getWeakestOpponent();
        }
        if ("PowerDmg".equals(logic)) {
            if (tgt.canTgtCreatureAndPlayer() && this.shouldTgtP(ai, sa, dmg, noPrevention)) {
                sa.resetTargets();
                sa.getTargets().add(enemy);
            }
            return true;
        }
        if (tgt.getMaxTargets(source, sa) <= 0 && !logic.equals("AssumeAtLeastOneTarget")) {
            return false;
        }
        sa.resetTargets();
        TargetChoices tcs = sa.getTargets();
        if ("SelfDamage".equals(logic) && ai.getLife() <= Integer.parseInt(source.getSVar("SelfDamageAmount"))) {
            return false;
        }
        if ("ChoiceBurn".equals(logic)) {
            if (this.shouldTgtP(ai, sa, dmg, noPrevention)) {
                tcs.add(enemy);
                return true;
            }
            return false;
        }
        if ("Polukranos".equals(logic)) {
            int dmgTaken = 0;
            CardCollection humCreatures = enemy.getCreaturesInPlay();
            Card lastTgt = null;
            humCreatures = CardLists.getTargetableCards(humCreatures, sa);
            ComputerUtilCard.sortByEvaluateCreature(humCreatures);
            for (Card humanCreature : humCreatures) {
                if (FightAi.canKill(humanCreature, source, dmgTaken)) continue;
                int assignedDamage = ComputerUtilCombat.getEnoughDamageToKill(humanCreature, dmg, source, false, noPrevention);
                if (assignedDamage <= dmg && humanCreature.getShieldCount() == 0 && !ComputerUtil.canRegenerate(humanCreature.getController(), humanCreature)) {
                    tcs.add(humanCreature);
                    sa.addDividedAllocation(humanCreature, assignedDamage);
                    lastTgt = humanCreature;
                    dmg -= assignedDamage;
                }
                dmgTaken += humanCreature.getNetPower();
                if (dmg != 0) continue;
                return true;
            }
            if (dmg > 0 && lastTgt != null) {
                sa.addDividedAllocation(lastTgt, sa.getDividedValue(lastTgt) + dmg);
                dmg = 0;
                return true;
            }
            for (Card humanCreature : humCreatures) {
                if (FightAi.canKill(humanCreature, source, 0)) continue;
                tcs.add(humanCreature);
                sa.addDividedAllocation(humanCreature, dmg);
                dmg = 0;
                return true;
            }
        }
        immediately = immediately || ComputerUtil.playImmediately(ai, sa);
        int totalTargetedSoFar = -1;
        while (sa.canAddMoreTarget() && totalTargetedSoFar != tcs.size()) {
            boolean isPWAbility;
            Object c;
            totalTargetedSoFar = tcs.size();
            if (oppTargetsChoice && sa.getActivatingPlayer().equals(ai) && !sa.isTrigger()) {
                Player targetingPlayer = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("TargetingPlayer"), sa).get(false);
                sa.setTargetingPlayer(targetingPlayer);
                return targetingPlayer.getController().chooseTargetsFor(sa);
            }
            if (tgt.canTgtPlaneswalker() && (c = this.dealDamageChooseTgtPW(ai, sa, dmg, noPrevention, enemy, false)) != null && !this.shouldTgtP(ai, sa, dmg, noPrevention)) {
                tcs.add((GameObject)c);
                if (!divided) continue;
                int assignedDamage = ComputerUtilCombat.getEnoughDamageToKill((Card)c, dmg, source, false, noPrevention);
                assignedDamage = Math.min(dmg, assignedDamage);
                sa.addDividedAllocation((GameObject)c, assignedDamage);
                if ((dmg -= assignedDamage) > 0) continue;
                break;
            }
            if (tgt.canTgtCreatureAndPlayer()) {
                boolean freePing;
                c = null;
                if (this.shouldTgtP(ai, sa, dmg, noPrevention)) {
                    tcs.add(enemy);
                    if (!divided) continue;
                    sa.addDividedAllocation(enemy, dmg);
                    break;
                }
                if ("RoundedDown".equals(sa.getParam("DivideEvenly"))) {
                    dmg = dmg * sa.getTargets().size() / (sa.getTargets().size() + 1);
                }
                if ((c = this.dealDamageChooseTgtC(ai, sa, dmg, noPrevention, enemy, false)) != null) {
                    if (sa.isSpell() && !divided && !immediately && tgt.getMaxTargets(source, sa) == 1 && !ComputerUtilCard.useRemovalNow(sa, (Card)c, dmg, ZoneType.Graveyard)) {
                        return false;
                    }
                    tcs.add((GameObject)c);
                    if (!divided) continue;
                    int assignedDamage = ComputerUtilCombat.getEnoughDamageToKill((Card)c, dmg, source, false, noPrevention);
                    if (assignedDamage <= dmg) {
                        sa.addDividedAllocation((GameObject)c, assignedDamage);
                    }
                    if ((dmg -= assignedDamage) > 0) continue;
                    break;
                }
                Cost abCost = sa.getPayCosts();
                boolean bl = freePing = immediately || abCost == null || sa.getTargets().size() > 0;
                if (!source.isSpell()) {
                    if (phase.is(PhaseType.END_OF_TURN) && sa.isAbility() && abCost.isReusuableResource() && phase.getNextTurn().equals(ai)) {
                        freePing = true;
                    }
                    if (phase.is(PhaseType.MAIN2) && sa.isAbility() && (sa.isPwAbility() || source.hasSVar("EndOfTurnLeavePlay"))) {
                        freePing = true;
                    }
                }
                if (freePing && sa.canTarget(enemy) && !this.avoidTargetP(ai, sa)) {
                    tcs.add(enemy);
                    if (divided) {
                        sa.addDividedAllocation(enemy, dmg);
                        break;
                    }
                }
            } else if (tgt.canTgtCreature() || tgt.canTgtPlaneswalker()) {
                c = this.dealDamageChooseTgtC(ai, sa, dmg, noPrevention, enemy, mandatory);
                if (c != null) {
                    if (!(immediately || tgt.getMaxTargets(source, sa) != 1 || divided || ComputerUtilCard.useRemovalNow(sa, (Card)c, dmg, ZoneType.Graveyard))) {
                        return false;
                    }
                    tcs.add((GameObject)c);
                    if (!divided) continue;
                    Card nextTarget = this.dealDamageChooseTgtC(ai, sa, dmg, noPrevention, enemy, mandatory);
                    boolean dump = false;
                    if (nextTarget != null && nextTarget.getController().equals(ai)) {
                        dump = true;
                    }
                    int assignedDamage = dump ? dmg : ComputerUtilCombat.getEnoughDamageToKill((Card)c, dmg, source, false, noPrevention);
                    sa.addDividedAllocation((GameObject)c, Math.min(assignedDamage, dmg));
                    if ((dmg -= assignedDamage) > 0) continue;
                    break;
                }
            } else if ("OppAtTenLife".equals(logic)) {
                for (Player p : ai.getOpponents()) {
                    if (!sa.canTarget(p) || p.getLife() != 10) continue;
                    tcs.add(p);
                    return true;
                }
                return false;
            }
            if (!sa.canTarget(enemy) || !sa.canAddMoreTarget() || !(phase.is(PhaseType.END_OF_TURN) && phase.getNextTurn().equals(ai) || DamageDealAi.isSorcerySpeed(sa, ai) && phase.is(PhaseType.MAIN2) || "BurnCreatures".equals(logic) && !enemy.getCreaturesInPlay().isEmpty()) && !immediately) continue;
            boolean pingAfterAttack = "PingAfterAttack".equals(logic) && phase.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && phase.isPlayerTurn(ai);
            boolean bl = isPWAbility = sa.isPwAbility() && sa.getPayCosts().hasSpecificCostType(CostPutCounter.class);
            if (!isPWAbility && (!pingAfterAttack || this.avoidTargetP(ai, sa)) && !this.shouldTgtP(ai, sa, dmg, noPrevention)) continue;
            tcs.add(enemy);
            if (!divided) continue;
            sa.addDividedAllocation(enemy, dmg);
            break;
        }
        int minTgts = tgt.getMinTargets(source, sa);
        if (tcs.size() < minTgts || tcs.size() == 0) {
            if (mandatory) {
                List<GameEntity> allTgtEntities = sa.getTargetRestrictions().getAllCandidates(sa, true);
                for (GameEntity ent : allTgtEntities) {
                    if (ent instanceof Player && ((Player)ent).isOpponentOf(ai) || ent instanceof Card && ((Card)ent).getController().isOpponentOf(ai)) {
                        tcs.add(ent);
                    }
                    if (tcs.size() != minTgts) continue;
                    return true;
                }
                return this.damageChooseRequiredTargets(ai, sa, tgt, dmg);
            }
            sa.resetTargets();
            return false;
        }
        if ("OpponentGainLife".equals(logic) && tcs.size() == 1 && tcs.contains(enemy) && ComputerUtil.lifegainPositive(enemy, source)) {
            sa.resetTargets();
            return false;
        }
        return true;
    }

    private boolean damageChooseNontargeted(Player ai, SpellAbility saMe, int dmg) {
        FCollection<GameEntity> objects = AbilityUtils.getDefinedEntities(saMe.getHostCard(), saMe.getParam("Defined"), (CardTraitBase)saMe);
        boolean urgent = false;
        boolean positive = false;
        for (GameEntity o : objects) {
            Player p;
            int restDamage;
            if (o instanceof Card) {
                Card c = (Card)o;
                restDamage = ComputerUtilCombat.predictDamageTo(c, dmg, saMe.getHostCard(), false);
                if (!c.hasKeyword(Keyword.INDESTRUCTIBLE) && ComputerUtilCombat.getDamageToKill(c, false) <= restDamage) {
                    if (c.getController().equals(ai)) {
                        return false;
                    }
                    urgent = true;
                }
                if (!(c.getController().isOpponentOf(ai) ^ c.getName().equals("Stuffy Doll"))) continue;
                positive = true;
                continue;
            }
            if (!(o instanceof Player) || (restDamage = ComputerUtilCombat.predictDamageTo(p = (Player)o, dmg, saMe.getHostCard(), false)) <= 0 || !p.canLoseLife()) continue;
            if (!p.isOpponentOf(ai) && restDamage + 3 >= p.getLife()) {
                return false;
            }
            if (!p.isOpponentOf(ai)) continue;
            positive = true;
            if (p.getLife() - 3 > restDamage) continue;
            urgent = true;
        }
        if ("Atarka's Command".equals(ComputerUtilAbility.getAbilitySourceName(saMe))) {
            return positive;
        }
        if (!positive && !(saMe instanceof AbilitySub)) {
            return false;
        }
        return urgent || DamageDealAi.playReusable(ai, saMe);
    }

    private boolean damageChooseRequiredTargets(Player ai, SpellAbility sa, TargetRestrictions tgt, int dmg) {
        boolean noPrevention = sa.hasParam("NoPrevention");
        boolean divided = sa.isDividedAsYouChoose();
        PlayerCollection opps = ai.getOpponents();
        while (sa.canAddMoreTarget()) {
            Card c;
            Card c2;
            if (tgt.canTgtPlaneswalker() && (c2 = this.dealDamageChooseTgtPW(ai, sa, dmg, noPrevention, ai, true)) != null) {
                sa.getTargets().add(c2);
                if (!divided) continue;
                sa.addDividedAllocation(c2, dmg);
                break;
            }
            if (tgt.canTgtCreature() && (c2 = this.dealDamageChooseTgtC(ai, sa, dmg, noPrevention, ai, true)) != null) {
                sa.getTargets().add(c2);
                if (!divided) continue;
                sa.addDividedAllocation(c2, dmg);
                break;
            }
            if (!opps.isEmpty()) {
                Player opp = (Player)opps.getFirst();
                opps.remove(opp);
                if (!sa.canTarget(opp) || !sa.getTargets().add(opp) || !divided) continue;
                sa.addDividedAllocation(opp, dmg);
                break;
            }
            CardCollection indestructible = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.Presets.CREATURES, CardPredicates.Presets.PLANESWALKERS, CardPredicates.hasKeyword(Keyword.INDESTRUCTIBLE), CardPredicates.isTargetableBy(sa)));
            if (!indestructible.isEmpty()) {
                c = ComputerUtilCard.getWorstPermanentAI(indestructible, false, false, false, false);
                sa.getTargets().add(c);
                if (!divided) continue;
                sa.addDividedAllocation(c, dmg);
                break;
            }
            if (tgt.canTgtPlaneswalker() && (c = ComputerUtilCard.getWorstPlaneswalkerToDamage(CardLists.filter(ai.getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.Presets.PLANESWALKERS), CardPredicates.isTargetableBy(sa)))) != null) {
                sa.getTargets().add(c);
                if (!divided) continue;
                sa.addDividedAllocation(c, dmg);
                break;
            }
            if (sa.canTarget(ai) && sa.getTargets().add(ai)) {
                if (!divided) continue;
                sa.addDividedAllocation(ai, dmg);
                break;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        String damage = sa.getParam("NumDmg");
        int dmg = AbilityUtils.calculateAmount(source, damage, sa);
        if (sa.hasParam("Remove")) {
            return true;
        }
        if (damage.equals("X") && sa.getSVar(damage).equals("Count$xPaid")) {
            dmg = ComputerUtilCost.getMaxXValue(sa, ai, true);
            sa.setXManaCostPaid(dmg);
        }
        if (!sa.usesTargeting()) {
            return mandatory || this.damageChooseNontargeted(ai, sa, dmg);
        }
        if (!this.damageChoosingTargets(ai, sa, sa.getTargetRestrictions(), dmg, mandatory, true) && !mandatory) {
            return false;
        }
        if (damage.equals("X") && sa.getSVar(damage).equals("Count$xPaid") && !sa.isDividedAsYouChoose()) {
            int actualPay = 0;
            boolean noPrevention = sa.hasParam("NoPrevention");
            if (!sa.getTargets().isTargetingAnyCard()) {
                actualPay = dmg;
            }
            for (Card c : sa.getTargets().getTargetCards()) {
                int adjDamage = ComputerUtilCombat.getEnoughDamageToKill(c, dmg, source, false, noPrevention);
                if (adjDamage <= actualPay) continue;
                actualPay = adjDamage;
            }
            sa.setXManaCostPaid(actualPay);
        }
        return true;
    }

    private boolean doXLifeDrainLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        SpellAbility saTgt = sa.getRootAbility();
        Player opponent = ai.getWeakestOpponent();
        int dmg = ComputerUtilMana.determineLeftoverMana(sa, ai, MagicColor.toShortString(saTgt.getParam("XColor")), false);
        while (!ComputerUtilMana.canPayManaCost(sa, ai, dmg, false) && dmg > 0) {
            System.out.println("Warning: AI could not pay mana cost for a XLifeDrain logic spell. Reducing X value to " + --dmg);
        }
        if ("Soul Burn".equals(sourceName)) {
            HashMap<String, Integer> xByColor = Maps.newHashMap();
            xByColor.put("B", dmg - ComputerUtilMana.determineLeftoverMana(sa, ai, "R", false));
            source.setXManaCostPaidByColor(xByColor);
        }
        if (dmg < 3 && dmg < opponent.getLife()) {
            return false;
        }
        CardCollection creatures = ai.getOpponents().getCreaturesInPlay();
        Card tgtCreature = null;
        for (Card c : creatures) {
            int power = c.getNetPower();
            int toughness = c.getNetToughness();
            boolean canDie = !ComputerUtilCombat.combatantCantBeDestroyed(c.getController(), c);
            if (!canDie || toughness > dmg || (toughness != dmg || toughness < 3) && power < 5) continue;
            tgtCreature = c;
            break;
        }
        saTgt.resetTargets();
        saTgt.getTargets().add(tgtCreature != null && dmg < opponent.getLife() ? tgtCreature : opponent);
        saTgt.setXManaCostPaid(dmg);
        return true;
    }

    public static Pair<SpellAbility, Integer> getDamagingSAToChain(Player ai, SpellAbility sa, String damage) {
        if (!ai.getController().isAI()) {
            return null;
        }
        if (((PlayerControllerAi)ai.getController()).getAi().usesSimulation()) {
            return null;
        }
        Game game = ai.getGame();
        int chance = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.CHANCE_TO_CHAIN_TWO_DAMAGE_SPELLS);
        if (chance > 0 && (ComputerUtilCombat.lifeInDanger(ai, game.getCombat()) || ComputerUtil.aiLifeInDanger(ai, true, 0))) {
            chance = 100;
        }
        if (!MyRandom.percentTrue(chance)) {
            return null;
        }
        if (sa.getSubAbility() != null || sa.getParent() != null) {
            return null;
        }
        if (sa.isDividedAsYouChoose()) {
            return null;
        }
        if (StringUtils.isNumeric(damage) || damage.startsWith("-") && StringUtils.isNumeric(damage.substring(1))) {
            CardCollection cards = new CardCollection();
            cards.addAll(ai.getCardsIn(ZoneType.Hand));
            cards.addAll(ai.getCardsIn(ZoneType.Battlefield));
            cards.addAll(ai.getCardsActivatableInExternalZones(true));
            for (Card c : cards) {
                if (c.getZone().getPlayer() != null && c.getZone().getPlayer() != ai && c.mayPlay(ai).isEmpty()) continue;
                for (SpellAbility ab : c.getSpellAbilities()) {
                    ManaCost costAb;
                    ManaCost costSa;
                    ManaCost total;
                    SpellAbility combinedAb;
                    if (ab.equals(sa) || ab.getSubAbility() != null || !ab.canPlay() || !ab.getPayCosts().hasNoManaCost() && !ab.getPayCosts().hasOnlySpecificCostType(CostPartMana.class)) continue;
                    String dmgDef = "";
                    if (ab.getApi() == ApiType.DealDamage) {
                        dmgDef = ab.getParamOrDefault("NumDmg", "0");
                    } else if (ab.getApi() == ApiType.Pump) {
                        dmgDef = ab.getParamOrDefault("NumDef", "0");
                        if (!dmgDef.startsWith("-")) continue;
                        dmgDef = dmgDef.substring(1);
                    }
                    if (!StringUtils.isNumeric(dmgDef) || !sa.usesTargeting() || !ab.usesTargeting()) continue;
                    TargetRestrictions tgtSa = sa.getTargetRestrictions();
                    TargetRestrictions tgtAb = sa.getTargetRestrictions();
                    String[] validTgtsSa = tgtSa.getValidTgts();
                    String[] validTgtsAb = tgtAb.getValidTgts();
                    if (!Arrays.asList(validTgtsSa).containsAll(Arrays.asList(validTgtsAb)) || !ComputerUtilMana.canPayManaCost(combinedAb = ab.copyWithDefinedCost(new Cost(total = ManaCost.combine(costSa = sa.getPayCosts().getTotalMana(), costAb = ab.getPayCosts().getTotalMana()), false)), ai, 0, false)) continue;
                    return Pair.of(ab, Integer.parseInt(dmgDef));
                }
            }
        }
        return null;
    }
}

