/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicate;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class DamageAllAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        if ((double)MyRandom.getRandom().nextFloat() > Math.pow(0.9, sa.getActivationsThisTurn())) {
            return false;
        }
        Cost abCost = sa.getPayCosts();
        if (abCost != null && !ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
            return false;
        }
        if (!ai.getGame().getStack().isEmpty()) {
            return false;
        }
        int x = -1;
        String damage = sa.getParam("NumDmg");
        int dmg = AbilityUtils.calculateAmount(source, damage, sa);
        if (damage.equals("X") && sa.getSVar(damage).equals("Count$Converge")) {
            dmg = ComputerUtilMana.getConvergeCount(sa, ai);
        }
        if (damage.equals("X") && sa.getSVar(damage).equals("Count$xPaid")) {
            x = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
        }
        if (x == -1) {
            if (this.determineOppToKill(ai, sa, source, dmg) != null) {
                return true;
            }
            return this.evaluateDamageAll(ai, sa, source, dmg) > 0;
        }
        int best = -1;
        int best_x = -1;
        Player bestOpp = this.determineOppToKill(ai, sa, source, x);
        if (bestOpp != null) {
            best_x = bestOpp.getLife();
        } else {
            for (int i = 0; i <= x; ++i) {
                int value = this.evaluateDamageAll(ai, sa, source, i);
                if (value <= best) continue;
                best = value;
                best_x = i;
            }
        }
        if (best_x > 0) {
            if (sa.getSVar(damage).equals("Count$xPaid")) {
                sa.setXManaCostPaid(best_x);
            }
            return true;
        }
        return false;
    }

    private Player determineOppToKill(Player ai, SpellAbility sa, Card source, int x) {
        String validP = sa.getParamOrDefault("ValidPlayers", "");
        int aiLife = ai.getLife();
        Player bestOpp = null;
        for (int dmg = 1; !(dmg > x || validP.equals("Player") && aiLife <= ComputerUtilCombat.predictDamageTo(ai, dmg, source, false)); ++dmg) {
            for (Player opp : ai.getOpponents()) {
                if (!validP.equals("Player") && !validP.contains("Opponent") || opp.getLife() > ComputerUtilCombat.predictDamageTo(opp, dmg, source, false)) continue;
                bestOpp = opp;
            }
        }
        return bestOpp;
    }

    private int evaluateDamageAll(Player ai, SpellAbility sa, Card source, int dmg) {
        String validP;
        Player opp = ai.getWeakestOpponent();
        CardCollection humanList = this.getKillableCreatures(sa, opp, dmg);
        CardCollection computerList = this.getKillableCreatures(sa, ai, dmg);
        if (sa.usesTargeting() && sa.canTarget(opp)) {
            sa.resetTargets();
            sa.getTargets().add(opp);
            computerList.clear();
        }
        if ((validP = sa.getParamOrDefault("ValidPlayers", "")).equals("Player") && ai.getLife() <= ComputerUtilCombat.predictDamageTo(ai, dmg, source, false)) {
            return -1;
        }
        int minGain = 200;
        if (sa.getPayCosts().isReusuableResource()) {
            if (computerList.isEmpty()) {
                minGain = 10;
                if (validP.equals("Player") && ComputerUtilCombat.predictDamageTo(opp, dmg, source, false) > 0 && (!"DmgAllCreaturesAndPlayers".equals(sa.getParam("AILogic")) || ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) && ai.getGame().getNonactivePlayers().contains(ai))) {
                    if (ComputerUtilCombat.predictDamageTo(ai, dmg, source, false) < 1) {
                        return 1;
                    }
                    if (ai.getLife() > ComputerUtilCombat.predictDamageTo(ai, dmg, source, false) * ((opp.getLife() + ComputerUtilCombat.predictDamageTo(opp, dmg, source, false) - 1) / ComputerUtilCombat.predictDamageTo(opp, dmg, source, false))) {
                        if (opp.getLife() < 10 && ComputerUtilCombat.predictDamageTo(opp, dmg, source, false) >= 1) {
                            return 1;
                        }
                        if (opp.getLife() <= 2 * ComputerUtilCombat.predictDamageTo(opp, dmg, source, false)) {
                            return 1;
                        }
                    }
                }
            } else {
                minGain = 100;
            }
        } else if (sa.getSubAbility() != null && ai.getGame().getPhaseHandler().is(PhaseType.MAIN1) && computerList.isEmpty() && opp.getCreaturesInPlay().size() > 1 && !ai.getCreaturesInPlay().isEmpty()) {
            minGain = 126;
        }
        return ComputerUtilCard.evaluateCreatureList(humanList) - ComputerUtilCard.evaluateCreatureList(computerList) - minGain;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        int dmg;
        Card source = sa.getHostCard();
        String validP = sa.getParamOrDefault("ValidPlayers", "");
        String damage = sa.getParam("NumDmg");
        if (damage.equals("X") && sa.getSVar(damage).equals("Count$xPaid")) {
            dmg = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(dmg);
        } else {
            dmg = AbilityUtils.calculateAmount(source, damage, sa);
        }
        Player enemy = ai.getWeakestOpponent();
        CardCollection humanList = this.getKillableCreatures(sa, enemy, dmg);
        CardCollection computerList = this.getKillableCreatures(sa, ai, dmg);
        if (sa.usesTargeting() && sa.canTarget(enemy)) {
            sa.resetTargets();
            sa.getTargets().add(enemy);
            computerList.clear();
        }
        if (validP.equals("Player") && ai.getLife() <= ComputerUtilCombat.predictDamageTo(ai, dmg, source, false)) {
            return false;
        }
        if ((validP.equals("Player") || validP.equals("Opponent") || validP.contains("Targeted")) && enemy.getLife() <= ComputerUtilCombat.predictDamageTo(enemy, dmg, source, false)) {
            return true;
        }
        return computerList.isEmpty() || ComputerUtilCard.evaluateCreatureList(computerList) <= ComputerUtilCard.evaluateCreatureList(humanList);
    }

    private CardCollection getKillableCreatures(SpellAbility sa, Player player, int dmg) {
        Card source = sa.getHostCard();
        String validC = sa.getParamOrDefault("ValidCards", "");
        CardCollection list = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), validC, source.getController(), source, (CardTraitBase)sa);
        Predicate filterKillable = c -> ComputerUtilCombat.predictDamageTo(c, dmg, source, false) >= ComputerUtilCombat.getDamageToKill(c, false);
        list = CardLists.getNotKeyword((Iterable<Card>)list, Keyword.INDESTRUCTIBLE);
        list = CardLists.filter((Iterable<Card>)list, filterKillable);
        return list;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        int dmg;
        Card source = sa.getHostCard();
        String validP = sa.getParamOrDefault("ValidPlayers", "");
        String damage = sa.getParam("NumDmg");
        if (damage.equals("X") && sa.getSVar(damage).equals("Count$xPaid") && sa.getPayCosts() != null && sa.getPayCosts().hasXInAnyCostPart()) {
            dmg = ComputerUtilCost.getMaxXValue(sa, ai, true);
            sa.setXManaCostPaid(dmg);
        } else {
            dmg = AbilityUtils.calculateAmount(source, damage, sa);
        }
        Player enemy = ai.getWeakestOpponent();
        CardCollection humanList = this.getKillableCreatures(sa, enemy, dmg);
        CardCollection computerList = this.getKillableCreatures(sa, ai, dmg);
        if (sa.usesTargeting() && sa.canTarget(enemy)) {
            sa.resetTargets();
            sa.getTargets().add(enemy);
            computerList.clear();
        }
        if (mandatory) {
            return true;
        }
        if (validP.equals("Player") && ai.getLife() <= ComputerUtilCombat.predictDamageTo(ai, dmg, source, false)) {
            return false;
        }
        if ((validP.equals("Player") || validP.contains("Opponent") || validP.contains("Targeted")) && enemy.getLife() <= ComputerUtilCombat.predictDamageTo(enemy, dmg, source, false)) {
            return true;
        }
        return computerList.isEmpty() || ComputerUtilCard.evaluateCreatureList(computerList) + 50 < ComputerUtilCard.evaluateCreatureList(humanList);
    }
}

