/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public abstract class DamageAiBase
extends SpellAbilityAi {
    protected boolean avoidTargetP(Player comp, SpellAbility sa) {
        Player enemy = comp.getWeakestOpponent();
        Card hostcard = sa.getHostCard();
        boolean lifelink = hostcard.hasKeyword(Keyword.LIFELINK);
        if (!lifelink) {
            for (Card ench : hostcard.getEnchantedBy()) {
                if (!ench.hasSVar("LikeLifeLink") || !"True".equals(ench.getSVar("LikeLifeLink"))) continue;
                lifelink = true;
            }
        }
        if ("SelfDamage".equals(sa.getParam("AILogic")) && (double)comp.getLife() * 0.75 < (double)enemy.getLife()) {
            return !lifelink;
        }
        return false;
    }

    protected boolean shouldTgtP(Player comp, SpellAbility sa, int d, boolean noPrevention) {
        int restDamage = d;
        Game game = comp.getGame();
        Player enemy = comp.getWeakestOpponent();
        boolean dmgByCardsInHand = false;
        Card hostcard = sa.getHostCard();
        if ("X".equals(sa.getParam("NumDmg")) && hostcard != null && sa.hasSVar(sa.getParam("NumDmg")) && sa.getSVar(sa.getParam("NumDmg")).equals("TargetedPlayer$CardsInHand")) {
            dmgByCardsInHand = true;
        }
        if ("Blood Oath".equals(hostcard.getName())) {
            dmgByCardsInHand = true;
        }
        if (!sa.canTarget(enemy)) {
            return false;
        }
        if (sa.getTargets() != null && sa.getTargets().contains(enemy)) {
            return false;
        }
        if ("OpponentGainLife".equals(sa.getParam("AILogic")) && ComputerUtil.lifegainPositive(enemy, hostcard)) {
            return false;
        }
        for (Trigger trig : hostcard.getTriggers()) {
            if (trig.getMode() != TriggerType.DamageDone || !"Opponent".equals(trig.getParam("ValidTarget")) || "True".equals(trig.getParam("CombatDamage"))) continue;
            return true;
        }
        if (this.avoidTargetP(comp, sa)) {
            return false;
        }
        if (!enemy.canLoseLife()) {
            return false;
        }
        restDamage = !noPrevention ? ComputerUtilCombat.predictDamageTo(enemy, restDamage, hostcard, false) : enemy.staticReplaceDamage(restDamage, hostcard, false);
        if (restDamage == 0) {
            return false;
        }
        CardCollectionView hand = comp.getCardsIn(ZoneType.Hand);
        if (enemy.getLife() - restDamage < 5) {
            return true;
        }
        if (sa.isSpell()) {
            PhaseHandler phase = game.getPhaseHandler();
            if ((phase.is(PhaseType.END_OF_TURN) || phase.is(PhaseType.MAIN2)) && phase.isPlayerTurn(comp) && hand.size() > comp.getMaxHandSize()) {
                return true;
            }
            if (hand.size() > 2) {
                float value = 0.0f;
                if (DamageAiBase.isSorcerySpeed(sa, comp)) {
                    if (phase.isPlayerTurn(comp) && phase.is(PhaseType.MAIN2)) {
                        value = 1.0f * (float)restDamage / (float)enemy.getLife();
                    }
                } else if (phase.isPlayerTurn(enemy)) {
                    if (dmgByCardsInHand && phase.is(PhaseType.DRAW) && enemy.getCardsIn(ZoneType.Hand).size() > 3) {
                        value = 1.0f;
                    } else if (phase.is(PhaseType.END_OF_TURN) || dmgByCardsInHand && phase.getPhase().isAfter(PhaseType.UPKEEP)) {
                        value = 1.5f * (float)restDamage / (float)enemy.getLife();
                    }
                }
                if (value > 0.0f) {
                    for (int i = 3; i < hand.size(); ++i) {
                        value *= 1.1f;
                    }
                }
                if (value < 0.2f) {
                    return false;
                }
                float chance = MyRandom.getRandom().nextFloat();
                return chance < value;
            }
        }
        return false;
    }
}

